/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.dao;

import com.centit.framework.jdbc.dao.BaseDaoImpl;
import com.centit.framework.jdbc.dao.DatabaseOptUtils;
import com.centit.framework.model.basedata.UserUnit;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.algorithm.UuidOpt;
import com.centit.support.database.jsonmaptable.GeneralJsonObjectDao;
import com.centit.support.database.orm.OrmDaoUtils;
import com.centit.support.database.utils.PageDesc;
import com.centit.support.database.utils.QueryAndNamedParams;
import com.centit.support.database.utils.QueryAndParams;
import com.centit.support.database.utils.QueryUtils;
import java.io.Serializable;
import java.sql.Connection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository(value="userUnitDao")
public class UserUnitDao
extends BaseDaoImpl<UserUnit, String> {
    public Map<String, String> getFilterField() {
        HashMap<String, String> filterField = new HashMap<String, String>(20);
        filterField.put("unitCode", "EQUAL");
        filterField.put("userStation", "EQUAL");
        filterField.put("userRank", "EQUAL");
        filterField.put("userCode", "EQUAL");
        filterField.put("isPrimary", "EQUAL");
        filterField.put("unitName", "LIKE");
        filterField.put("topUnit", "EQUAL");
        filterField.put("relType", "EQUAL");
        filterField.put("(like)userName", "user_code in (select us.USER_CODE from f_userinfo us where us.USER_NAME like :userName)");
        filterField.put("isValid", "user_code in (select us.USER_CODE from f_userinfo us where us.IS_VALID = :isValid)");
        filterField.put("userType", "user_code in (select us.USER_CODE from f_userinfo us where us.user_type = :userType)");
        filterField.put("(STARTWITH)unitPath", "UNIT_CODE IN (select UNIT_CODE from f_unitinfo where UNIT_PATH like :unitPath)]");
        filterField.put("ORDER_BY", "userOrder asc");
        return filterField;
    }

    public List<UserUnit> listObjectsAll(Map<String, Object> filterMap) {
        return this.listObjectsByProperties(filterMap);
    }

    public UserUnit getObjectById(String userUnitId) {
        return (UserUnit)super.getObjectById((Object)userUnitId);
    }

    public void updateUserUnit(UserUnit userUnit) {
        super.updateObject((Serializable)userUnit);
    }

    @Transactional
    public void deleteObjectById(String userUnitId) {
        super.deleteObjectById((Object)userUnitId);
    }

    @Transactional
    public void deleteObjectForceById(String id) {
        super.deleteObjectForceById((Object)id);
    }

    @Transactional
    public List<UserUnit> listUserUnitsByUserCode(String userId) {
        List ls = this.listObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"userCode", userId}));
        return ls;
    }

    @Transactional
    public List<UserUnit> listUserUnitsByUserCode(String unitCode, String userCode) {
        String sql = "select a.* from F_USERUNIT a join F_UNITINFO b on (a.UNIT_CODE = b.UNIT_CODE) where a.USER_CODE =? and b.TOP_UNIT = ?";
        return (List)this.getJdbcTemplate().execute(conn -> OrmDaoUtils.queryObjectsByParamsSql((Connection)conn, (String)sql, (Object[])new Object[]{userCode, unitCode}, UserUnit.class));
    }

    @Transactional
    public List<UserUnit> listObjectByUserUnit(String userCode, String unitCode) {
        List ls = this.listObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"userCode", userCode, "unitCode", unitCode}));
        return ls;
    }

    @Transactional
    public void deleteUserUnitByUser(String userCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userCode", userCode);
        super.deleteObjectsByProperties(map);
    }

    @Transactional
    public void deleteUserUnitByUnit(String unitCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("unitCode", unitCode);
        super.deleteObjectsByProperties(map);
    }

    @Transactional
    public UserUnit getPrimaryUnitByUserId(String userId, String topUnit) {
        List list = null;
        list = StringUtils.isBlank((CharSequence)topUnit) || "all".equals(topUnit) ? super.listObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"userCode", userId, "relType", "T"})) : super.listObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"userCode", userId, "relType", "T", "topUnit", topUnit}));
        if (list != null && list.size() > 0) {
            return (UserUnit)list.get(0);
        }
        return null;
    }

    @Transactional
    public List<UserUnit> listUnitUsersByUnitCode(String unitCode) {
        return this.listObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"unitCode", unitCode}));
    }

    @Transactional
    public List<UserUnit> listUserUnitsByRoleAndUnit(String roleType, String roleCode, String unitCode) {
        List ls = null;
        if (unitCode != null && !"".equals(unitCode)) {
            if ("gw".equals(roleType)) {
                ls = this.listObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"unitCode", unitCode, "userStation", roleCode}));
            } else if ("xz".equals(roleType)) {
                ls = this.listObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"unitCode", unitCode, "userRank", roleCode}));
            }
        } else if ("gw".equals(roleType)) {
            ls = this.listObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"userStation", roleCode}));
        } else if ("xz".equals(roleType)) {
            ls = this.listObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"userRank", roleCode}));
        }
        return ls;
    }

    public String getNextKey() {
        return UuidOpt.getUuidAsString22();
    }

    public List<UserUnit> querySubUserUnits(Map<String, Object> filterDescMap, PageDesc pageDesc) {
        String sql = "select count(*) FROM F_USERUNIT WHERE 1=1 [:(STARTWITH)unitPath | and UNIT_CODE IN (select UNIT_CODE from f_unitinfo where UNIT_PATH like :unitPath)][:(like)userName | and USER_CODE in (select USER_CODE from f_userinfo where USER_NAME like :userName or LOGIN_NAME like :userName)][:isValid | and USER_CODE in (select us.USER_CODE from f_userinfo us where us.IS_VALID = :isValid)][:userCode | and USER_CODE = :userCode][:relType | and rel_type = :relType][:unitIsValid | and UNIT_CODE IN (select UNIT_CODE from f_unitinfo where IS_VALID = :unitIsValid)]";
        QueryAndNamedParams qap = QueryUtils.translateQuery((String)sql, filterDescMap);
        Integer rowCount = (Integer)this.jdbcTemplate.execute(conn -> OrmDaoUtils.fetchObjectsCount((Connection)conn, (String)qap.getQuery(), (Map)qap.getParams()));
        pageDesc.setTotalRows(rowCount);
        sql = "select USER_UNIT_ID, UNIT_CODE, USER_CODE, REL_TYPE, USER_STATION, USER_RANK, RANK_MEMO, USER_ORDER, UPDATE_DATE, CREATE_DATE, CREATOR, UPDATOR FROM F_USERUNIT WHERE 1=1 [:(STARTWITH)unitPath | and UNIT_CODE IN (select UNIT_CODE from f_unitinfo where UNIT_PATH like :unitPath)][:(like)userName | and USER_CODE in (select USER_CODE from f_userinfo where USER_NAME like :userName or LOGIN_NAME like :userName)][:isValid | and USER_CODE in (select us.USER_CODE from f_userinfo us where us.IS_VALID = :isValid)][:userCode | and USER_CODE = :userCode][:relType | and rel_type = :relType][:unitIsValid | and UNIT_CODE IN (select UNIT_CODE from f_unitinfo where IS_VALID = :unitIsValid)]";
        String selfOrderBy = GeneralJsonObjectDao.fetchSelfOrderSql((String)sql, filterDescMap);
        if (StringUtils.isNotBlank((CharSequence)selfOrderBy)) {
            sql = QueryUtils.removeOrderBy((String)sql) + " order by " + selfOrderBy;
        }
        QueryAndNamedParams qap2 = QueryUtils.translateQuery((String)sql, filterDescMap);
        return (List)this.jdbcTemplate.execute(conn -> OrmDaoUtils.queryObjectsByNamedParamsSql((Connection)conn, (String)qap2.getQuery(), (Map)qap2.getParams(), (Class)this.getPoClass(), (int)pageDesc.getRowStart(), (int)pageDesc.getPageSize()));
    }

    public int countUserByTopUnit(String topUnit) {
        String sql = " SELECT COUNT(DISTINCT USER_CODE) COUNT FROM F_USERUNIT A JOIN F_UNITINFO B ON ( A.UNIT_CODE = B.UNIT_CODE )  WHERE 1=1 [ :topUnit | AND B.TOP_UNIT = :topUnit ] ";
        HashMap params = StringUtils.isBlank((CharSequence)topUnit) ? new HashMap() : CollectionsOpt.createHashMap((Object[])new Object[]{"topUnit", topUnit});
        QueryAndParams queryAndParams = QueryAndParams.createFromQueryAndNamedParams((QueryAndNamedParams)QueryUtils.translateQuery((String)sql, params));
        logger.info("sql: {},\u53c2\u6570\uff1a{}", (Object)queryAndParams.getQuery(), (Object)topUnit);
        return NumberBaseOpt.castObjectToInteger((Object)DatabaseOptUtils.getScalarObjectQuery((BaseDaoImpl)this, (String)queryAndParams.getQuery(), (Object[])queryAndParams.getParams()));
    }
}

