/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.dao;

import com.centit.framework.jdbc.dao.BaseDaoImpl;
import com.centit.framework.jdbc.dao.DatabaseOptUtils;
import com.centit.framework.model.basedata.RoleInfo;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.database.orm.OrmDaoUtils;
import java.io.Serializable;
import java.sql.Connection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository(value="roleInfoDao")
public class RoleInfoDao
extends BaseDaoImpl<RoleInfo, String> {
    public Map<String, String> getFilterField() {
        HashMap<String, String> filterField = new HashMap<String, String>();
        filterField.put("roleCode", "LIKE");
        filterField.put("publicUnitRole", "(ROLE_TYPE='P' or (ROLE_TYPE='D' and UNIT_CODE = :publicUnitRole))");
        filterField.put("NP_ALL", "(ROLE_TYPE='F' or ROLE_TYPE='G' or ROLE_TYPE='P')");
        filterField.put("NP_GLOBAL", "(ROLE_TYPE='G' or ROLE_TYPE='P')");
        filterField.put("NP_OWNER", "(ROLE_TYPE='D' or ROLE_TYPE='S')");
        filterField.put("roleName", "LIKE");
        filterField.put("ROLEDESC", "LIKE");
        filterField.put("isValid", "EQUAL");
        filterField.put("roleType", "EQUAL");
        filterField.put("unitCode", "EQUAL");
        filterField.put("ownerCode", "UNIT_CODE = :ownerCode");
        filterField.put("roleNameEq", "ROLE_NAME = :roleNameEq");
        filterField.put("(date)createDateBeg", "CREATE_DATE>= :createDateBeg");
        filterField.put("(nextday)createDateEnd", "CREATE_DATE< :createDateEnd");
        filterField.put("unitRole", "(ROLE_TYPE='D' and UNIT_CODE = :unitRole)");
        filterField.put("subSystemRole", "(ROLE_TYPE='S' and OS_ID = :subSystemRole)");
        filterField.put("topUnit", "(ROLE_TYPE='G' or UNIT_CODE = :topUnit)");
        filterField.put("osRole", "(ROLE_TYPE <> 'S' or OS_ID = :osRole)");
        return filterField;
    }

    public List<RoleInfo> listObjectsAll() {
        return super.listObjects();
    }

    @Transactional
    public void deleteObjectById(String roleCode) {
        super.deleteObjectById((Object)roleCode);
    }

    public RoleInfo getObjectById(String roleCode) {
        return (RoleInfo)super.getObjectById((Object)roleCode);
    }

    public RoleInfo getRoleByCodeOrName(String roleCodeOrName) {
        List roles = this.listObjectsByFilter(" where IS_VALID ='T' and ( ROLE_CODE= ? or ((ROLE_TYPE='G' or ROLE_TYPE='P') and ROLE_NAME =?))", new Object[]{roleCodeOrName, roleCodeOrName});
        if (roles != null && roles.size() > 0) {
            return (RoleInfo)roles.get(0);
        }
        return null;
    }

    @Transactional
    public List<Object> listRoleOptMethods(String rolecode) {
        String hql = "select def.OPT_NAME as def_optname, def.OPT_CODE as def_optcode from F_OPTDEF def, F_ROLEPOWER pow  where def.OPT_CODE = pow.OPT_CODE and pow.ROLE_CODE = ? ";
        return DatabaseOptUtils.listObjectsBySqlAsJson((BaseDaoImpl)this, (String)hql, (Object[])new Object[]{rolecode});
    }

    @Transactional
    public List<RoleInfo> search(String key, String[] field) {
        HashMap<String, String> filter = new HashMap<String, String>(field.length * 2);
        for (String f : field) {
            filter.put(f, key);
        }
        return this.listObjectsByProperties(filter);
    }

    public RoleInfo getObjectByProperty(String propertyName, Object propertyValue) {
        if (StringUtils.isBlank((CharSequence)propertyName) || propertyValue == null) {
            return null;
        }
        return (RoleInfo)super.getObjectByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{propertyName, propertyValue}));
    }

    @Transactional
    public void updateRole(RoleInfo roleInfo) {
        super.updateObject((Serializable)roleInfo);
    }

    @Transactional
    public List<RoleInfo> listAllRoleByUnit(String topUnit) {
        return super.listObjectsByFilter(" where ROLE_TYPE = 'G' or UNIT_CODE = ?", new Object[]{topUnit});
    }

    public List<RoleInfo> listRoleInfoByOptCode(String optCode) {
        String sql = " SELECT B.ROLE_CODE, B.ROLE_NAME, B.ROLE_TYPE, B.UNIT_CODE, B.ROLE_DESC, B.UPDATE_DATE, B.CREATE_DATE, B.CREATOR, B.UPDATOR  FROM F_ROLEPOWER A JOIN F_ROLEINFO B ON A.ROLE_CODE = B.ROLE_CODE WHERE A.OPT_CODE = ?  ";
        return (List)this.getJdbcTemplate().execute(conn -> OrmDaoUtils.queryObjectsByParamsSql((Connection)conn, (String)sql, (Object[])new Object[]{optCode}, RoleInfo.class));
    }
}

