/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.security;

import com.centit.support.file.PropertiesReader;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.SecurityConfig;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.access.intercept.FilterInvocationSecurityMetadataSource;

public class HostIpSecurityMetadataSource
implements FilterInvocationSecurityMetadataSource {
    public static final String LOCAL_HOST_IP = "127.0.0.1";
    private String appHome;
    private Map<String, Collection<ConfigAttribute>> hostIpAttributes = null;

    public void setAppHome(String appHome) {
        this.appHome = appHome;
    }

    public boolean supports(Class<?> clazz) {
        return FilterInvocation.class.isAssignableFrom(clazz);
    }

    public Collection<ConfigAttribute> getAllConfigAttributes() {
        return null;
    }

    public Collection<ConfigAttribute> getHostConfigAttributes(String urlIp) {
        if (this.hostIpAttributes == null) {
            this.loadConfigAttributes();
        }
        return this.hostIpAttributes.get(urlIp);
    }

    private void loadConfigAttributes() {
        Set<Map.Entry<Object, Object>> hostset;
        if (this.hostIpAttributes != null) {
            this.hostIpAttributes.clear();
        } else {
            this.hostIpAttributes = new HashMap<String, Collection<ConfigAttribute>>();
        }
        Properties hosts = PropertiesReader.getFilePathProperties((String)(this.appHome + "/config/host_white_list.properties"));
        if (hosts != null && (hostset = hosts.entrySet()) != null) {
            for (Map.Entry<Object, Object> dd : hostset) {
                HashSet<SecurityConfig> httpServerRole = new HashSet<SecurityConfig>();
                httpServerRole.add(new SecurityConfig(dd.getValue().toString()));
                this.hostIpAttributes.put(dd.getKey().toString(), httpServerRole);
            }
        }
        if (this.hostIpAttributes.size() < 1) {
            HashSet<SecurityConfig> httpServerRole = new HashSet<SecurityConfig>();
            httpServerRole.add(new SecurityConfig("localHost"));
            this.hostIpAttributes.put(LOCAL_HOST_IP, httpServerRole);
        }
    }

    public Collection<ConfigAttribute> getAttributes(Object object) throws IllegalArgumentException {
        if (object == null || !this.supports(object.getClass())) {
            throw new IllegalArgumentException("\u5bf9\u4e0d\u8d77,\u76ee\u6807\u5bf9\u8c61\u4e0d\u662f\u7c7b\u578b");
        }
        if (this.hostIpAttributes == null) {
            this.loadConfigAttributes();
        }
        FilterInvocation fi = (FilterInvocation)object;
        HttpServletRequest request = fi.getHttpRequest();
        String urlIp = request.getRemoteHost();
        return this.hostIpAttributes.get(urlIp);
    }
}

