/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.hibernate.listener;

import com.centit.framework.components.OperationLogCenter;
import com.centit.framework.core.common.WebOptUtils;
import com.centit.framework.core.po.EntityWithTimestamp;
import com.centit.framework.filter.RequestThreadLocal;
import com.centit.framework.security.model.CentitUserDetails;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.event.spi.PostDeleteEvent;
import org.hibernate.event.spi.PostDeleteEventListener;
import org.hibernate.event.spi.PostInsertEvent;
import org.hibernate.event.spi.PostInsertEventListener;
import org.hibernate.event.spi.PostUpdateEvent;
import org.hibernate.event.spi.PostUpdateEventListener;
import org.hibernate.event.spi.PreInsertEvent;
import org.hibernate.event.spi.PreInsertEventListener;
import org.hibernate.event.spi.PreUpdateEvent;
import org.hibernate.event.spi.PreUpdateEventListener;
import org.hibernate.persister.entity.EntityPersister;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class PoDataChangesListener
implements PreInsertEventListener,
PreUpdateEventListener,
PostInsertEventListener,
PostUpdateEventListener,
PostDeleteEventListener {
    private static final long serialVersionUID = -1992903736066173748L;
    private static Log logger = LogFactory.getLog(PoDataChangesListener.class);
    private List<String> listeners;

    public void setListeners(List<String> listeners) {
        this.listeners = listeners;
    }

    public boolean onPreInsert(PreInsertEvent event) {
        if (event.getEntity() instanceof EntityWithTimestamp) {
            EntityWithTimestamp baseEntity = (EntityWithTimestamp)event.getEntity();
            baseEntity.setLastModifyDate(new Date());
        }
        return false;
    }

    public boolean onPreUpdate(PreUpdateEvent event) {
        if (event.getEntity() instanceof EntityWithTimestamp) {
            EntityWithTimestamp baseEntity = (EntityWithTimestamp)event.getEntity();
            baseEntity.setLastModifyDate(new Date());
        }
        return false;
    }

    public void onPostUpdate(PostUpdateEvent event) {
        this.saveOptLog(event.getEntity(), event.getId(), event.getPersister().getPropertyNames(), event.getState(), event.getOldState(), "create");
    }

    public void onPostInsert(PostInsertEvent event) {
        this.saveOptLog(event.getEntity(), event.getId(), event.getPersister().getPropertyNames(), event.getState(), null, "update");
    }

    public void onPostDelete(PostDeleteEvent event) {
        this.saveOptLog(event.getEntity(), event.getId(), null, null, null, "delete");
    }

    public void saveOptLog(Object object, Serializable id, String[] propertyNames, Object[] states, Object[] oldState, String type) {
        if (CollectionUtils.isEmpty(this.listeners)) {
            return;
        }
        for (String clazzName : this.listeners) {
            String optContent;
            clazzName = StringUtils.trimAllWhitespace((String)clazzName);
            Class<?> clazz = null;
            try {
                clazz = Class.forName(clazzName);
            }
            catch (ClassNotFoundException e) {
                String message = "spring-hibernate.xml\u4e2d\u914d\u7f6ePoDataChangesListener\u7684listeners\u5c5e\u6027value\u503cclass=" + clazzName + "\u4e0d\u5b58\u5728";
                System.err.println(message);
                logger.error((Object)message);
                return;
            }
            if (!object.getClass().isAssignableFrom(clazz)) continue;
            StringBuilder values = new StringBuilder("{");
            StringBuilder oldvalues = new StringBuilder("{");
            if ("delete".equals(type)) {
                optContent = "\u5220\u9664 " + ClassUtils.getShortName(clazz);
            } else {
                optContent = "\u4fee\u6539 " + ClassUtils.getShortName(clazz);
                for (int i = 0; i < states.length; ++i) {
                    String propertyName = propertyNames[i];
                    String newvalue = String.valueOf(states[i]);
                    if (ArrayUtils.isNotEmpty((Object[])oldState)) {
                        String oldvalue = String.valueOf(oldState[i]);
                        oldvalues.append("[\u5b57\u6bb5 = " + propertyName + " \u539f\u503c = " + oldvalue + "] ");
                    }
                    values.append("[\u5b57\u6bb5 = " + propertyName + " \u65b0\u503c = " + newvalue + "] ");
                }
            }
            values.append("}");
            oldvalues.append("}");
            OperationLogCenter.logUpdateObject((String)this.getUserCode(), (String)ClassUtils.getShortName(clazz), (String)String.valueOf(id), (String)type, (String)optContent, (Object)values.toString(), (Object)oldvalues.toString());
        }
    }

    private String getUserCode() {
        CentitUserDetails loginUser = WebOptUtils.getLoginUser((HttpServletRequest)RequestThreadLocal.getHttpThreadWrapper().getRequest());
        return loginUser == null ? "" : loginUser.getUserCode();
    }

    public boolean requiresPostCommitHanding(EntityPersister persister) {
        return false;
    }
}

