/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.hibernate.dao;

import com.centit.framework.common.SysParametersUtils;
import com.centit.framework.hibernate.dao.BaseDaoImpl;
import com.centit.support.database.ddl.DB2DDLOperations;
import com.centit.support.database.ddl.DDLOperations;
import com.centit.support.database.ddl.MySqlDDLOperations;
import com.centit.support.database.ddl.OracleDDLOperations;
import com.centit.support.database.ddl.SqlSvrDDLOperations;
import com.centit.support.database.metadata.TableField;
import com.centit.support.database.metadata.TableInfo;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import org.hibernate.jdbc.Work;

public class DDLOperationsWork
implements DDLOperations {
    private BaseDaoImpl<?, ?> baseDao;

    public DDLOperationsWork() {
    }

    public DDLOperationsWork(BaseDaoImpl<?, ?> baseDao) {
        this.baseDao = baseDao;
    }

    public void setBaseDao(BaseDaoImpl<?, ?> baseDao) {
        this.baseDao = baseDao;
    }

    public static DDLOperations createDDLOpt() {
        String dialectName = SysParametersUtils.getStringValue((String)"jdbc.dialect");
        if (dialectName.indexOf("Oracle") >= 0) {
            return new OracleDDLOperations();
        }
        if (dialectName.indexOf("DB2") >= 0) {
            return new DB2DDLOperations();
        }
        if (dialectName.indexOf("SQLServer") >= 0) {
            return new SqlSvrDDLOperations();
        }
        if (dialectName.indexOf("MySQL") >= 0) {
            return new MySqlDDLOperations();
        }
        return new OracleDDLOperations();
    }

    private DDLOperations createDDLOpt(Connection connection) {
        String dialectName = SysParametersUtils.getStringValue((String)"jdbc.dialect");
        if (dialectName.indexOf("Oracle") >= 0) {
            return new OracleDDLOperations(connection);
        }
        if (dialectName.indexOf("DB2") >= 0) {
            return new DB2DDLOperations(connection);
        }
        if (dialectName.indexOf("SQLServer") >= 0) {
            return new SqlSvrDDLOperations(connection);
        }
        if (dialectName.indexOf("MySQL") >= 0) {
            return new MySqlDDLOperations(connection);
        }
        return new OracleDDLOperations(connection);
    }

    public void createSequence(final String sequenceName) throws SQLException {
        this.baseDao.getCurrentSession().doWork(new Work(){

            public void execute(Connection connection) throws SQLException {
                DDLOperations ddlOpt = DDLOperationsWork.this.createDDLOpt(connection);
                ddlOpt.createSequence(sequenceName);
            }
        });
    }

    public void createTable(final TableInfo tableInfo) throws SQLException {
        this.baseDao.getCurrentSession().doWork(new Work(){

            public void execute(Connection connection) throws SQLException {
                DDLOperations ddlOpt = DDLOperationsWork.this.createDDLOpt(connection);
                ddlOpt.createTable(tableInfo);
            }
        });
    }

    public void dropTable(final String tableCode) throws SQLException {
        this.baseDao.getCurrentSession().doWork(new Work(){

            public void execute(Connection connection) throws SQLException {
                DDLOperations ddlOpt = DDLOperationsWork.this.createDDLOpt(connection);
                ddlOpt.dropTable(tableCode);
            }
        });
    }

    public void addColumn(final String tableCode, final TableField column) throws SQLException {
        this.baseDao.getCurrentSession().doWork(new Work(){

            public void execute(Connection connection) throws SQLException {
                DDLOperations ddlOpt = DDLOperationsWork.this.createDDLOpt(connection);
                ddlOpt.addColumn(tableCode, column);
            }
        });
    }

    public void modifyColumn(final String tableCode, final TableField oldColumn, final TableField column) throws SQLException {
        this.baseDao.getCurrentSession().doWork(new Work(){

            public void execute(Connection connection) throws SQLException {
                DDLOperations ddlOpt = DDLOperationsWork.this.createDDLOpt(connection);
                ddlOpt.modifyColumn(tableCode, oldColumn, column);
            }
        });
    }

    public void dropColumn(final String tableCode, final String columnCode) throws SQLException {
        this.baseDao.getCurrentSession().doWork(new Work(){

            public void execute(Connection connection) throws SQLException {
                DDLOperations ddlOpt = DDLOperationsWork.this.createDDLOpt(connection);
                ddlOpt.dropColumn(tableCode, columnCode);
            }
        });
    }

    public void renameColumn(final String tableCode, final String columnCode, final TableField column) throws SQLException {
        this.baseDao.getCurrentSession().doWork(new Work(){

            public void execute(Connection connection) throws SQLException {
                DDLOperations ddlOpt = DDLOperationsWork.this.createDDLOpt(connection);
                ddlOpt.renameColumn(tableCode, columnCode, column);
            }
        });
    }

    public void reconfigurationColumn(final String tableCode, final String columnCode, final TableField column) throws SQLException {
        this.baseDao.getCurrentSession().doWork(new Work(){

            public void execute(Connection connection) throws SQLException {
                DDLOperations ddlOpt = DDLOperationsWork.this.createDDLOpt(connection);
                ddlOpt.reconfigurationColumn(tableCode, columnCode, column);
            }
        });
    }

    public String makeCreateSequenceSql(String sequenceName) {
        return DDLOperationsWork.createDDLOpt().makeCreateSequenceSql(sequenceName);
    }

    public String makeCreateTableSql(TableInfo tableInfo) {
        return DDLOperationsWork.createDDLOpt().makeCreateTableSql(tableInfo);
    }

    public String makeDropTableSql(String tableCode) {
        return DDLOperationsWork.createDDLOpt().makeDropTableSql(tableCode);
    }

    public String makeAddColumnSql(String tableCode, TableField column) {
        return DDLOperationsWork.createDDLOpt().makeAddColumnSql(tableCode, column);
    }

    public String makeModifyColumnSql(String tableCode, TableField oldColumn, TableField column) {
        return DDLOperationsWork.createDDLOpt().makeModifyColumnSql(tableCode, oldColumn, column);
    }

    public String makeDropColumnSql(String tableCode, String columnCode) {
        return DDLOperationsWork.createDDLOpt().makeDropColumnSql(tableCode, columnCode);
    }

    public String makeRenameColumnSql(String tableCode, String columnCode, TableField column) {
        return DDLOperationsWork.createDDLOpt().makeRenameColumnSql(tableCode, columnCode, column);
    }

    public List<String> makeReconfigurationColumnSqls(String tableCode, String columnCode, TableField column) {
        return DDLOperationsWork.createDDLOpt().makeReconfigurationColumnSqls(tableCode, columnCode, column);
    }
}

