/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.hibernate.dao;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.centit.framework.common.SysParametersUtils;
import com.centit.framework.hibernate.dao.BaseDaoImpl;
import com.centit.support.database.jsonmaptable.DB2JsonObjectDao;
import com.centit.support.database.jsonmaptable.JsonObjectDao;
import com.centit.support.database.jsonmaptable.MySqlJsonObjectDao;
import com.centit.support.database.jsonmaptable.OracleJsonObjectDao;
import com.centit.support.database.jsonmaptable.SqlSvrJsonObjectDao;
import com.centit.support.database.metadata.TableInfo;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.hibernate.jdbc.ReturningWork;
import org.hibernate.jdbc.Work;

public class JsonObjectWork
implements JsonObjectDao {
    private TableInfo tableInfo;
    private BaseDaoImpl<?, ?> baseDao;

    public JsonObjectWork() {
    }

    public JsonObjectWork(TableInfo tableInfo) {
        this.tableInfo = tableInfo;
    }

    public JsonObjectWork(BaseDaoImpl<?, ?> baseDao, TableInfo tableInfo) {
        this.tableInfo = tableInfo;
        this.baseDao = baseDao;
    }

    public void setBaseDao(BaseDaoImpl<?, ?> baseDao) {
        this.baseDao = baseDao;
    }

    public void setTableInfo(TableInfo tableInfo) {
        this.tableInfo = tableInfo;
    }

    private JsonObjectDao createDao(Connection connection) {
        String dialectName = SysParametersUtils.getStringValue((String)"jdbc.dialect");
        if (dialectName.indexOf("Oracle") >= 0) {
            return new OracleJsonObjectDao(connection, this.tableInfo);
        }
        if (dialectName.indexOf("DB2") >= 0) {
            return new DB2JsonObjectDao(connection, this.tableInfo);
        }
        if (dialectName.indexOf("SQLServer") >= 0) {
            return new SqlSvrJsonObjectDao(connection, this.tableInfo);
        }
        if (dialectName.indexOf("MySQL") >= 0) {
            return new MySqlJsonObjectDao(connection, this.tableInfo);
        }
        return new OracleJsonObjectDao(connection, this.tableInfo);
    }

    public TableInfo getTableInfo() {
        return this.tableInfo;
    }

    public JSONObject getObjectById(final Object keyValue) throws SQLException, IOException {
        return (JSONObject)this.baseDao.getCurrentSession().doReturningWork((ReturningWork)new ReturningWork<JSONObject>(){

            public JSONObject execute(Connection connection) throws SQLException {
                JsonObjectDao dao = JsonObjectWork.this.createDao(connection);
                try {
                    return dao.getObjectById(keyValue);
                }
                catch (IOException e) {
                    return null;
                }
            }
        });
    }

    public JSONObject getObjectById(final Map<String, Object> keyValues) throws SQLException, IOException {
        return (JSONObject)this.baseDao.getCurrentSession().doReturningWork((ReturningWork)new ReturningWork<JSONObject>(){

            public JSONObject execute(Connection connection) throws SQLException {
                JsonObjectDao dao = JsonObjectWork.this.createDao(connection);
                try {
                    return dao.getObjectById(keyValues);
                }
                catch (IOException e) {
                    return null;
                }
            }
        });
    }

    public JSONObject getObjectByProperties(final Map<String, Object> properties) throws SQLException, IOException {
        return (JSONObject)this.baseDao.getCurrentSession().doReturningWork((ReturningWork)new ReturningWork<JSONObject>(){

            public JSONObject execute(Connection connection) throws SQLException {
                JsonObjectDao dao = JsonObjectWork.this.createDao(connection);
                try {
                    return dao.getObjectByProperties(properties);
                }
                catch (IOException e) {
                    return null;
                }
            }
        });
    }

    public JSONArray listObjectsByProperties(final Map<String, Object> properties) throws SQLException, IOException {
        return (JSONArray)this.baseDao.getCurrentSession().doReturningWork((ReturningWork)new ReturningWork<JSONArray>(){

            public JSONArray execute(Connection connection) throws SQLException {
                JsonObjectDao dao = JsonObjectWork.this.createDao(connection);
                try {
                    return dao.listObjectsByProperties(properties);
                }
                catch (IOException e) {
                    return null;
                }
            }
        });
    }

    public JSONArray listObjectsByProperties(final Map<String, Object> properties, final int startPos, final int maxSize) throws SQLException, IOException {
        return (JSONArray)this.baseDao.getCurrentSession().doReturningWork((ReturningWork)new ReturningWork<JSONArray>(){

            public JSONArray execute(Connection connection) throws SQLException {
                JsonObjectDao dao = JsonObjectWork.this.createDao(connection);
                try {
                    return dao.listObjectsByProperties(properties, startPos, maxSize);
                }
                catch (IOException e) {
                    return null;
                }
            }
        });
    }

    public Long fetchObjectsCount(final Map<String, Object> properties) throws SQLException, IOException {
        return (Long)this.baseDao.getCurrentSession().doReturningWork((ReturningWork)new ReturningWork<Long>(){

            public Long execute(Connection connection) throws SQLException {
                JsonObjectDao dao = JsonObjectWork.this.createDao(connection);
                try {
                    return dao.fetchObjectsCount(properties);
                }
                catch (IOException e) {
                    return null;
                }
            }
        });
    }

    public void saveNewObject(final Map<String, Object> object) throws SQLException {
        this.baseDao.getCurrentSession().doWork(new Work(){

            public void execute(Connection connection) throws SQLException {
                JsonObjectDao dao = JsonObjectWork.this.createDao(connection);
                dao.saveNewObject(object);
            }
        });
    }

    public void updateObject(final Map<String, Object> object) throws SQLException {
        this.baseDao.getCurrentSession().doWork(new Work(){

            public void execute(Connection connection) throws SQLException {
                JsonObjectDao dao = JsonObjectWork.this.createDao(connection);
                dao.updateObject(object);
            }
        });
    }

    public void mergeObject(final Map<String, Object> object) throws SQLException, IOException {
        this.baseDao.getCurrentSession().doWork(new Work(){

            public void execute(Connection connection) throws SQLException {
                JsonObjectDao dao = JsonObjectWork.this.createDao(connection);
                try {
                    dao.mergeObject(object);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void updateObjectsByProperties(final Map<String, Object> fieldValues, final Map<String, Object> properties) throws SQLException {
        this.baseDao.getCurrentSession().doWork(new Work(){

            public void execute(Connection connection) throws SQLException {
                JsonObjectDao dao = JsonObjectWork.this.createDao(connection);
                dao.updateObjectsByProperties(fieldValues, properties);
            }
        });
    }

    public void deleteObjectById(final Object keyValue) throws SQLException {
        this.baseDao.getCurrentSession().doWork(new Work(){

            public void execute(Connection connection) throws SQLException {
                JsonObjectDao dao = JsonObjectWork.this.createDao(connection);
                dao.deleteObjectById(keyValue);
            }
        });
    }

    public void deleteObjectById(final Map<String, Object> keyValues) throws SQLException {
        this.baseDao.getCurrentSession().doWork(new Work(){

            public void execute(Connection connection) throws SQLException {
                JsonObjectDao dao = JsonObjectWork.this.createDao(connection);
                dao.deleteObjectById(keyValues);
            }
        });
    }

    public void deleteObjectsByProperties(final Map<String, Object> properties) throws SQLException {
        this.baseDao.getCurrentSession().doWork(new Work(){

            public void execute(Connection connection) throws SQLException {
                JsonObjectDao dao = JsonObjectWork.this.createDao(connection);
                dao.deleteObjectsByProperties(properties);
            }
        });
    }

    public void insertObjectsAsTabulation(final JSONArray objects) throws SQLException {
        this.baseDao.getCurrentSession().doWork(new Work(){

            public void execute(Connection connection) throws SQLException {
                JsonObjectDao dao = JsonObjectWork.this.createDao(connection);
                dao.insertObjectsAsTabulation(objects);
            }
        });
    }

    public void deleteObjects(final JSONArray objects) throws SQLException {
        this.baseDao.getCurrentSession().doWork(new Work(){

            public void execute(Connection connection) throws SQLException {
                JsonObjectDao dao = JsonObjectWork.this.createDao(connection);
                dao.deleteObjects(objects);
            }
        });
    }

    public void deleteObjectsAsTabulation(final String propertyName, final Object propertyValue) throws SQLException {
        this.baseDao.getCurrentSession().doWork(new Work(){

            public void execute(Connection connection) throws SQLException {
                JsonObjectDao dao = JsonObjectWork.this.createDao(connection);
                dao.deleteObjectsAsTabulation(propertyName, propertyValue);
            }
        });
    }

    public void deleteObjectsAsTabulation(final Map<String, Object> properties) throws SQLException {
        this.baseDao.getCurrentSession().doWork(new Work(){

            public void execute(Connection connection) throws SQLException {
                JsonObjectDao dao = JsonObjectWork.this.createDao(connection);
                dao.deleteObjectsAsTabulation(properties);
            }
        });
    }

    public void replaceObjectsAsTabulation(final JSONArray newObjects, final JSONArray dbObjects) throws SQLException {
        this.baseDao.getCurrentSession().doWork(new Work(){

            public void execute(Connection connection) throws SQLException {
                JsonObjectDao dao = JsonObjectWork.this.createDao(connection);
                dao.replaceObjectsAsTabulation(newObjects, dbObjects);
            }
        });
    }

    public void replaceObjectsAsTabulation(final JSONArray newObjects, final String propertyName, final Object propertyValue) throws SQLException, IOException {
        this.baseDao.getCurrentSession().doWork(new Work(){

            public void execute(Connection connection) throws SQLException {
                JsonObjectDao dao = JsonObjectWork.this.createDao(connection);
                try {
                    dao.replaceObjectsAsTabulation(newObjects, propertyName, propertyValue);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void replaceObjectsAsTabulation(final JSONArray newObjects, final Map<String, Object> properties) throws SQLException, IOException {
        this.baseDao.getCurrentSession().doWork(new Work(){

            public void execute(Connection connection) throws SQLException {
                JsonObjectDao dao = JsonObjectWork.this.createDao(connection);
                try {
                    dao.replaceObjectsAsTabulation(newObjects, properties);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public Long getSequenceNextValue(final String sequenceName) throws SQLException, IOException {
        return (Long)this.baseDao.getCurrentSession().doReturningWork((ReturningWork)new ReturningWork<Long>(){

            public Long execute(Connection connection) throws SQLException {
                JsonObjectDao dao = JsonObjectWork.this.createDao(connection);
                try {
                    return dao.getSequenceNextValue(sequenceName);
                }
                catch (IOException e) {
                    return null;
                }
            }
        });
    }

    public List<Object[]> findObjectsBySql(final String sSql, final Object[] values) throws SQLException, IOException {
        return (List)this.baseDao.getCurrentSession().doReturningWork((ReturningWork)new ReturningWork<List<Object[]>>(){

            public List<Object[]> execute(Connection connection) throws SQLException {
                JsonObjectDao dao = JsonObjectWork.this.createDao(connection);
                try {
                    return dao.findObjectsBySql(sSql, values);
                }
                catch (IOException e) {
                    return null;
                }
            }
        });
    }

    public List<Object[]> findObjectsBySql(final String sSql, final Object[] values, final int pageNo, final int pageSize) throws SQLException, IOException {
        return (List)this.baseDao.getCurrentSession().doReturningWork((ReturningWork)new ReturningWork<List<Object[]>>(){

            public List<Object[]> execute(Connection connection) throws SQLException {
                JsonObjectDao dao = JsonObjectWork.this.createDao(connection);
                try {
                    return dao.findObjectsBySql(sSql, values, pageNo, pageSize);
                }
                catch (IOException e) {
                    return null;
                }
            }
        });
    }

    public List<Object[]> findObjectsByNamedSql(final String sSql, final Map<String, Object> values) throws SQLException, IOException {
        return (List)this.baseDao.getCurrentSession().doReturningWork((ReturningWork)new ReturningWork<List<Object[]>>(){

            public List<Object[]> execute(Connection connection) throws SQLException {
                JsonObjectDao dao = JsonObjectWork.this.createDao(connection);
                try {
                    return dao.findObjectsByNamedSql(sSql, values);
                }
                catch (IOException e) {
                    return null;
                }
            }
        });
    }

    public List<Object[]> findObjectsByNamedSql(final String sSql, final Map<String, Object> values, final int pageNo, final int pageSize) throws SQLException, IOException {
        return (List)this.baseDao.getCurrentSession().doReturningWork((ReturningWork)new ReturningWork<List<Object[]>>(){

            public List<Object[]> execute(Connection connection) throws SQLException {
                JsonObjectDao dao = JsonObjectWork.this.createDao(connection);
                try {
                    return dao.findObjectsByNamedSql(sSql, values, pageNo, pageSize);
                }
                catch (IOException e) {
                    return null;
                }
            }
        });
    }

    public JSONArray findObjectsAsJSON(final String sSql, final Object[] values, final String[] fieldnames) throws SQLException, IOException {
        return (JSONArray)this.baseDao.getCurrentSession().doReturningWork((ReturningWork)new ReturningWork<JSONArray>(){

            public JSONArray execute(Connection connection) throws SQLException {
                JsonObjectDao dao = JsonObjectWork.this.createDao(connection);
                try {
                    return dao.findObjectsAsJSON(sSql, values, fieldnames);
                }
                catch (IOException e) {
                    return null;
                }
            }
        });
    }

    public JSONArray findObjectsAsJSON(final String sSql, final Object[] values, final String[] fieldnames, final int pageNo, final int pageSize) throws SQLException, IOException {
        return (JSONArray)this.baseDao.getCurrentSession().doReturningWork((ReturningWork)new ReturningWork<JSONArray>(){

            public JSONArray execute(Connection connection) throws SQLException {
                JsonObjectDao dao = JsonObjectWork.this.createDao(connection);
                try {
                    return dao.findObjectsAsJSON(sSql, values, fieldnames, pageNo, pageSize);
                }
                catch (IOException e) {
                    return null;
                }
            }
        });
    }

    public JSONArray findObjectsByNamedSqlAsJSON(final String sSql, final Map<String, Object> values, final String[] fieldnames) throws SQLException, IOException {
        return (JSONArray)this.baseDao.getCurrentSession().doReturningWork((ReturningWork)new ReturningWork<JSONArray>(){

            public JSONArray execute(Connection connection) throws SQLException {
                JsonObjectDao dao = JsonObjectWork.this.createDao(connection);
                try {
                    return dao.findObjectsByNamedSqlAsJSON(sSql, values, fieldnames);
                }
                catch (IOException e) {
                    return null;
                }
            }
        });
    }

    public JSONArray findObjectsByNamedSqlAsJSON(final String sSql, final Map<String, Object> values, final String[] fieldnames, final int pageNo, final int pageSize) throws SQLException, IOException {
        return (JSONArray)this.baseDao.getCurrentSession().doReturningWork((ReturningWork)new ReturningWork<JSONArray>(){

            public JSONArray execute(Connection connection) throws SQLException {
                JsonObjectDao dao = JsonObjectWork.this.createDao(connection);
                try {
                    return dao.findObjectsByNamedSqlAsJSON(sSql, values, fieldnames, pageNo, pageSize);
                }
                catch (IOException e) {
                    return null;
                }
            }
        });
    }

    public void doExecuteSql(final String sSql) throws SQLException {
        this.baseDao.getCurrentSession().doWork(new Work(){

            public void execute(Connection connection) throws SQLException {
                JsonObjectDao dao = JsonObjectWork.this.createDao(connection);
                dao.doExecuteSql(sSql);
            }
        });
    }

    public void doExecuteSql(final String sSql, final Object[] values) throws SQLException {
        this.baseDao.getCurrentSession().doWork(new Work(){

            public void execute(Connection connection) throws SQLException {
                JsonObjectDao dao = JsonObjectWork.this.createDao(connection);
                dao.doExecuteSql(sSql, values);
            }
        });
    }

    public void doExecuteNamedSql(final String sSql, final Map<String, Object> values) throws SQLException {
        this.baseDao.getCurrentSession().doWork(new Work(){

            public void execute(Connection connection) throws SQLException {
                JsonObjectDao dao = JsonObjectWork.this.createDao(connection);
                dao.doExecuteNamedSql(sSql, values);
            }
        });
    }
}

