/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.model.basedata;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.annotation.JSONField;
import com.centit.framework.core.dao.DictionaryMap;
import com.centit.framework.model.basedata.OptDataScope;
import com.centit.framework.model.basedata.OptMethod;
import com.centit.support.database.orm.GeneratorCondition;
import com.centit.support.database.orm.GeneratorType;
import com.centit.support.database.orm.ValueGenerator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.Range;
import org.springframework.util.CollectionUtils;

@Entity
@Table(name="F_OPTINFO")
@ApiModel(value="\u4e1a\u52a1\u83dc\u5355\u5bf9\u8c61", description="\u4e1a\u52a1\u83dc\u5355\u5bf9\u8c61 OptInfo")
public class OptInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String OPT_INFO_FORM_CODE_COMMON = "C";
    public static final String OPT_INFO_FORM_CODE_COMMON_NAME = "\u901a\u7528\u6a21\u5757";
    public static final String OPT_INFO_FORM_CODE_PAGE_ENTER = "A";
    public static final String OPT_INFO_FORM_CODE_PAGE_ENTER_NAME = "\u5e94\u7528\u5165\u53e3\u9875\u9762";
    public static final String OPT_INFO_IN_TOOLBAR_NO = "N";
    public static final String OPT_INFO_OPT_TYPE_COMMON = "O";
    public static final String OPT_INFO_FORM_CODE_ITEM = "I";
    @Id
    @Column(name="OPT_ID")
    @ValueGenerator(strategy=GeneratorType.UUID22)
    @ApiModelProperty(value="\u4e1a\u52a1\u83dc\u5355\u7f16\u53f7", name="optId", required=true)
    private String optId;
    @Column(name="OS_ID")
    @Length(max=32)
    @ApiModelProperty(value="\u5e94\u7528\u7cfb\u7edfID", name="osId", required=true)
    private @Length(max=32) String osId;
    @OrderBy
    @Column(name="PRE_OPT_ID")
    @Length(max=32)
    private @Length(max=32) String preOptId;
    @Column(name="OPT_NAME")
    @Length(max=256)
    @ApiModelProperty(value="\u4e1a\u52a1\u83dc\u5355\u540d\u79f0\uff0c\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e256", name="optName", required=true)
    private @Length(max=256) String optName;
    @Column(name="OPT_TYPE")
    @Length(max=1)
    @ApiModelProperty(value="\u4e1a\u52a1\u7c7b\u522b S:\u5b9e\u65bd\u4e1a\u52a1, O:\u666e\u901a\u4e1a\u52a1, W:\u6d41\u7a0b\u4e1a\u52a1, I:\u9879\u76ee\u4e1a\u52a1, C:\u901a\u7528\u6a21\u5757, A:\u5e94\u7528\u5165\u53e3\u9875\u9762", name="optType")
    @DictionaryMap(fieldName={"optTypeText"}, value={"OptType"})
    private @Length(max=1) String optType;
    @Column(name="FORM_CODE")
    @Length(max=32)
    @ApiModelProperty(value="\u4e1a\u52a1\u7c7b\u522b O:\u666e\u901a\u4e1a\u52a1C:\u901a\u7528\u6a21\u5757A:\u5e94\u7528\u5165\u53e3\u9875\u9762", name="formCode")
    private @Length(max=32) String formCode;
    @Column(name="OPT_ROUTE")
    @Length(max=256)
    private @Length(max=256) String optRoute;
    @Column(name="OPT_URL")
    @Length(max=256)
    private @Length(max=256) String optUrl;
    @Column(name="IS_IN_TOOLBAR")
    private String isInToolbar;
    @Column(name="IMG_INDEX")
    @Range(max=100000L)
    private @Range(max=100000L) Long imgIndex;
    @Column(name="TOP_OPT_ID")
    @Length(max=32)
    private @Length(max=32) String topOptId;
    @Column(name="PAGE_TYPE")
    @Length(max=1)
    @ApiModelProperty(value="\u9875\u9762\u6253\u5f00\u65b9\u5f0f D: DIV I\uff1a iFrame", name="pageType", required=true)
    private @Length(max=1) String pageType;
    @OrderBy
    @Column(name="ORDER_IND")
    @Range(max=100000L)
    private @Range(max=100000L) Long orderInd;
    @Column(name="ICON")
    @Length(max=512)
    private @Length(max=512) String icon;
    @Column(name="HEIGHT")
    @Range(max=100000L)
    private @Range(max=100000L) Long height;
    @Column(name="WIDTH")
    @Range(max=100000L)
    private @Range(max=100000L) Long width;
    @Column(name="CREATE_DATE", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    protected Date createDate;
    @Column(name="CREATOR")
    @Length(max=32)
    private @Length(max=32) String creator;
    @Column(name="UPDATOR")
    @Length(max=32)
    private @Length(max=32) String updator;
    @Column(name="UPDATE_DATE")
    @ValueGenerator(strategy=GeneratorType.FUNCTION, condition=GeneratorCondition.ALWAYS, value="today()")
    private Date updateDate;
    @Column(name="DOC_ID")
    @Length(max=32)
    private @Length(max=32) String docId;
    @Column(name="SOURCE_ID")
    @Length(max=32)
    @JSONField(serialize=false)
    private @Length(max=32) String sourceId;
    @Transient
    private List<OptInfo> children;
    @Transient
    private String state;
    @Transient
    private List<OptMethod> optMethods;
    @Transient
    private List<OptDataScope> dataScopes;

    public List<OptDataScope> getDataScopes() {
        if (null == this.dataScopes) {
            this.dataScopes = new ArrayList<OptDataScope>();
        }
        return this.dataScopes;
    }

    public String getLocalOptName() {
        String lang = "";
        if (this.optName == null) {
            return null;
        }
        if (this.optName.startsWith("{") && this.optName.endsWith("}")) {
            JSONObject jsonData = JSON.parseObject((String)this.optName);
            String sRet = null;
            if (lang == null) {
                sRet = jsonData.getString("zh_CN");
            } else {
                sRet = jsonData.getString(lang);
                if (sRet == null) {
                    sRet = jsonData.getString("zh_CN");
                }
            }
            return sRet;
        }
        return this.optName;
    }

    public String getOptUrl() {
        if (this.optUrl == null) {
            return "...";
        }
        return this.optUrl;
    }

    public void copy(OptInfo other) {
        this.preOptId = other.getPreOptId();
        this.optName = other.getOptName();
        this.formCode = other.getFormCode();
        this.optUrl = other.getOptUrl();
        this.isInToolbar = other.getIsInToolbar();
        this.imgIndex = other.getImgIndex();
        this.topOptId = other.getTopOptId();
        this.optType = other.getOptType();
        this.orderInd = other.getOrderInd();
        this.pageType = other.getPageType();
        this.icon = other.getIcon();
        this.height = other.getHeight();
        this.width = other.getWidth();
        this.optRoute = other.getOptRoute();
        this.creator = other.creator;
        this.updator = other.updator;
        this.updateDate = other.updateDate;
        this.state = other.getState();
        this.createDate = other.getCreateDate();
        this.osId = other.getOsId();
        this.docId = other.getDocId();
    }

    public void addChild(OptInfo child) {
        if (this.children == null) {
            this.children = new ArrayList<OptInfo>();
        }
        this.children.add(child);
    }

    public List<OptMethod> getOptMethods() {
        if (null == this.optMethods) {
            this.optMethods = new ArrayList<OptMethod>();
        }
        return this.optMethods;
    }

    public void addOptMethod(OptMethod optDef) {
        this.getOptMethods().add(optDef);
    }

    public void addAllOptMethods(List<OptMethod> optDefs) {
        this.getOptMethods().clear();
        if (CollectionUtils.isEmpty(optDefs)) {
            return;
        }
        for (OptMethod optDef : optDefs) {
            optDef.setOptId(this.optId);
        }
        this.getOptMethods().addAll(optDefs);
    }

    public void addAllDataScopes(List<OptDataScope> dataScopeByOptID) {
        this.getDataScopes().clear();
        if (CollectionUtils.isEmpty(dataScopeByOptID)) {
            return;
        }
        for (OptDataScope dataScope : dataScopeByOptID) {
            dataScope.setOptId(this.optId);
        }
        this.getDataScopes().addAll(dataScopeByOptID);
    }

    public String getOptId() {
        return this.optId;
    }

    public String getOsId() {
        return this.osId;
    }

    public String getPreOptId() {
        return this.preOptId;
    }

    public String getOptName() {
        return this.optName;
    }

    public String getOptType() {
        return this.optType;
    }

    public String getFormCode() {
        return this.formCode;
    }

    public String getOptRoute() {
        return this.optRoute;
    }

    public String getIsInToolbar() {
        return this.isInToolbar;
    }

    public Long getImgIndex() {
        return this.imgIndex;
    }

    public String getTopOptId() {
        return this.topOptId;
    }

    public String getPageType() {
        return this.pageType;
    }

    public Long getOrderInd() {
        return this.orderInd;
    }

    public String getIcon() {
        return this.icon;
    }

    public Long getHeight() {
        return this.height;
    }

    public Long getWidth() {
        return this.width;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public String getCreator() {
        return this.creator;
    }

    public String getUpdator() {
        return this.updator;
    }

    public Date getUpdateDate() {
        return this.updateDate;
    }

    public String getDocId() {
        return this.docId;
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public List<OptInfo> getChildren() {
        return this.children;
    }

    public String getState() {
        return this.state;
    }

    public void setOptId(String optId) {
        this.optId = optId;
    }

    public void setOsId(String osId) {
        this.osId = osId;
    }

    public void setPreOptId(String preOptId) {
        this.preOptId = preOptId;
    }

    public void setOptName(String optName) {
        this.optName = optName;
    }

    public void setOptType(String optType) {
        this.optType = optType;
    }

    public void setFormCode(String formCode) {
        this.formCode = formCode;
    }

    public void setOptRoute(String optRoute) {
        this.optRoute = optRoute;
    }

    public void setOptUrl(String optUrl) {
        this.optUrl = optUrl;
    }

    public void setIsInToolbar(String isInToolbar) {
        this.isInToolbar = isInToolbar;
    }

    public void setImgIndex(Long imgIndex) {
        this.imgIndex = imgIndex;
    }

    public void setTopOptId(String topOptId) {
        this.topOptId = topOptId;
    }

    public void setPageType(String pageType) {
        this.pageType = pageType;
    }

    public void setOrderInd(Long orderInd) {
        this.orderInd = orderInd;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public void setHeight(Long height) {
        this.height = height;
    }

    public void setWidth(Long width) {
        this.width = width;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public void setUpdator(String updator) {
        this.updator = updator;
    }

    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    public void setDocId(String docId) {
        this.docId = docId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public void setChildren(List<OptInfo> children) {
        this.children = children;
    }

    public void setState(String state) {
        this.state = state;
    }

    public void setOptMethods(List<OptMethod> optMethods) {
        this.optMethods = optMethods;
    }

    public void setDataScopes(List<OptDataScope> dataScopes) {
        this.dataScopes = dataScopes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OptInfo)) {
            return false;
        }
        OptInfo other = (OptInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$imgIndex = this.getImgIndex();
        Long other$imgIndex = other.getImgIndex();
        if (this$imgIndex == null ? other$imgIndex != null : !((Object)this$imgIndex).equals(other$imgIndex)) {
            return false;
        }
        Long this$orderInd = this.getOrderInd();
        Long other$orderInd = other.getOrderInd();
        if (this$orderInd == null ? other$orderInd != null : !((Object)this$orderInd).equals(other$orderInd)) {
            return false;
        }
        Long this$height = this.getHeight();
        Long other$height = other.getHeight();
        if (this$height == null ? other$height != null : !((Object)this$height).equals(other$height)) {
            return false;
        }
        Long this$width = this.getWidth();
        Long other$width = other.getWidth();
        if (this$width == null ? other$width != null : !((Object)this$width).equals(other$width)) {
            return false;
        }
        String this$optId = this.getOptId();
        String other$optId = other.getOptId();
        if (this$optId == null ? other$optId != null : !this$optId.equals(other$optId)) {
            return false;
        }
        String this$osId = this.getOsId();
        String other$osId = other.getOsId();
        if (this$osId == null ? other$osId != null : !this$osId.equals(other$osId)) {
            return false;
        }
        String this$preOptId = this.getPreOptId();
        String other$preOptId = other.getPreOptId();
        if (this$preOptId == null ? other$preOptId != null : !this$preOptId.equals(other$preOptId)) {
            return false;
        }
        String this$optName = this.getOptName();
        String other$optName = other.getOptName();
        if (this$optName == null ? other$optName != null : !this$optName.equals(other$optName)) {
            return false;
        }
        String this$optType = this.getOptType();
        String other$optType = other.getOptType();
        if (this$optType == null ? other$optType != null : !this$optType.equals(other$optType)) {
            return false;
        }
        String this$formCode = this.getFormCode();
        String other$formCode = other.getFormCode();
        if (this$formCode == null ? other$formCode != null : !this$formCode.equals(other$formCode)) {
            return false;
        }
        String this$optRoute = this.getOptRoute();
        String other$optRoute = other.getOptRoute();
        if (this$optRoute == null ? other$optRoute != null : !this$optRoute.equals(other$optRoute)) {
            return false;
        }
        String this$optUrl = this.getOptUrl();
        String other$optUrl = other.getOptUrl();
        if (this$optUrl == null ? other$optUrl != null : !this$optUrl.equals(other$optUrl)) {
            return false;
        }
        String this$isInToolbar = this.getIsInToolbar();
        String other$isInToolbar = other.getIsInToolbar();
        if (this$isInToolbar == null ? other$isInToolbar != null : !this$isInToolbar.equals(other$isInToolbar)) {
            return false;
        }
        String this$topOptId = this.getTopOptId();
        String other$topOptId = other.getTopOptId();
        if (this$topOptId == null ? other$topOptId != null : !this$topOptId.equals(other$topOptId)) {
            return false;
        }
        String this$pageType = this.getPageType();
        String other$pageType = other.getPageType();
        if (this$pageType == null ? other$pageType != null : !this$pageType.equals(other$pageType)) {
            return false;
        }
        String this$icon = this.getIcon();
        String other$icon = other.getIcon();
        if (this$icon == null ? other$icon != null : !this$icon.equals(other$icon)) {
            return false;
        }
        Date this$createDate = this.getCreateDate();
        Date other$createDate = other.getCreateDate();
        if (this$createDate == null ? other$createDate != null : !((Object)this$createDate).equals(other$createDate)) {
            return false;
        }
        String this$creator = this.getCreator();
        String other$creator = other.getCreator();
        if (this$creator == null ? other$creator != null : !this$creator.equals(other$creator)) {
            return false;
        }
        String this$updator = this.getUpdator();
        String other$updator = other.getUpdator();
        if (this$updator == null ? other$updator != null : !this$updator.equals(other$updator)) {
            return false;
        }
        Date this$updateDate = this.getUpdateDate();
        Date other$updateDate = other.getUpdateDate();
        if (this$updateDate == null ? other$updateDate != null : !((Object)this$updateDate).equals(other$updateDate)) {
            return false;
        }
        String this$docId = this.getDocId();
        String other$docId = other.getDocId();
        if (this$docId == null ? other$docId != null : !this$docId.equals(other$docId)) {
            return false;
        }
        String this$sourceId = this.getSourceId();
        String other$sourceId = other.getSourceId();
        if (this$sourceId == null ? other$sourceId != null : !this$sourceId.equals(other$sourceId)) {
            return false;
        }
        List<OptInfo> this$children = this.getChildren();
        List<OptInfo> other$children = other.getChildren();
        if (this$children == null ? other$children != null : !((Object)this$children).equals(other$children)) {
            return false;
        }
        String this$state = this.getState();
        String other$state = other.getState();
        if (this$state == null ? other$state != null : !this$state.equals(other$state)) {
            return false;
        }
        List<OptMethod> this$optMethods = this.getOptMethods();
        List<OptMethod> other$optMethods = other.getOptMethods();
        if (this$optMethods == null ? other$optMethods != null : !((Object)this$optMethods).equals(other$optMethods)) {
            return false;
        }
        List<OptDataScope> this$dataScopes = this.getDataScopes();
        List<OptDataScope> other$dataScopes = other.getDataScopes();
        return !(this$dataScopes == null ? other$dataScopes != null : !((Object)this$dataScopes).equals(other$dataScopes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OptInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $imgIndex = this.getImgIndex();
        result = result * 59 + ($imgIndex == null ? 43 : ((Object)$imgIndex).hashCode());
        Long $orderInd = this.getOrderInd();
        result = result * 59 + ($orderInd == null ? 43 : ((Object)$orderInd).hashCode());
        Long $height = this.getHeight();
        result = result * 59 + ($height == null ? 43 : ((Object)$height).hashCode());
        Long $width = this.getWidth();
        result = result * 59 + ($width == null ? 43 : ((Object)$width).hashCode());
        String $optId = this.getOptId();
        result = result * 59 + ($optId == null ? 43 : $optId.hashCode());
        String $osId = this.getOsId();
        result = result * 59 + ($osId == null ? 43 : $osId.hashCode());
        String $preOptId = this.getPreOptId();
        result = result * 59 + ($preOptId == null ? 43 : $preOptId.hashCode());
        String $optName = this.getOptName();
        result = result * 59 + ($optName == null ? 43 : $optName.hashCode());
        String $optType = this.getOptType();
        result = result * 59 + ($optType == null ? 43 : $optType.hashCode());
        String $formCode = this.getFormCode();
        result = result * 59 + ($formCode == null ? 43 : $formCode.hashCode());
        String $optRoute = this.getOptRoute();
        result = result * 59 + ($optRoute == null ? 43 : $optRoute.hashCode());
        String $optUrl = this.getOptUrl();
        result = result * 59 + ($optUrl == null ? 43 : $optUrl.hashCode());
        String $isInToolbar = this.getIsInToolbar();
        result = result * 59 + ($isInToolbar == null ? 43 : $isInToolbar.hashCode());
        String $topOptId = this.getTopOptId();
        result = result * 59 + ($topOptId == null ? 43 : $topOptId.hashCode());
        String $pageType = this.getPageType();
        result = result * 59 + ($pageType == null ? 43 : $pageType.hashCode());
        String $icon = this.getIcon();
        result = result * 59 + ($icon == null ? 43 : $icon.hashCode());
        Date $createDate = this.getCreateDate();
        result = result * 59 + ($createDate == null ? 43 : ((Object)$createDate).hashCode());
        String $creator = this.getCreator();
        result = result * 59 + ($creator == null ? 43 : $creator.hashCode());
        String $updator = this.getUpdator();
        result = result * 59 + ($updator == null ? 43 : $updator.hashCode());
        Date $updateDate = this.getUpdateDate();
        result = result * 59 + ($updateDate == null ? 43 : ((Object)$updateDate).hashCode());
        String $docId = this.getDocId();
        result = result * 59 + ($docId == null ? 43 : $docId.hashCode());
        String $sourceId = this.getSourceId();
        result = result * 59 + ($sourceId == null ? 43 : $sourceId.hashCode());
        List<OptInfo> $children = this.getChildren();
        result = result * 59 + ($children == null ? 43 : ((Object)$children).hashCode());
        String $state = this.getState();
        result = result * 59 + ($state == null ? 43 : $state.hashCode());
        List<OptMethod> $optMethods = this.getOptMethods();
        result = result * 59 + ($optMethods == null ? 43 : ((Object)$optMethods).hashCode());
        List<OptDataScope> $dataScopes = this.getDataScopes();
        result = result * 59 + ($dataScopes == null ? 43 : ((Object)$dataScopes).hashCode());
        return result;
    }

    public String toString() {
        return "OptInfo(optId=" + this.getOptId() + ", osId=" + this.getOsId() + ", preOptId=" + this.getPreOptId() + ", optName=" + this.getOptName() + ", optType=" + this.getOptType() + ", formCode=" + this.getFormCode() + ", optRoute=" + this.getOptRoute() + ", optUrl=" + this.getOptUrl() + ", isInToolbar=" + this.getIsInToolbar() + ", imgIndex=" + this.getImgIndex() + ", topOptId=" + this.getTopOptId() + ", pageType=" + this.getPageType() + ", orderInd=" + this.getOrderInd() + ", icon=" + this.getIcon() + ", height=" + this.getHeight() + ", width=" + this.getWidth() + ", createDate=" + this.getCreateDate() + ", creator=" + this.getCreator() + ", updator=" + this.getUpdator() + ", updateDate=" + this.getUpdateDate() + ", docId=" + this.getDocId() + ", sourceId=" + this.getSourceId() + ", children=" + this.getChildren() + ", state=" + this.getState() + ", optMethods=" + this.getOptMethods() + ", dataScopes=" + this.getDataScopes() + ")";
    }
}

