/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.core.service.impl;

import com.centit.framework.components.CodeRepositoryUtil;
import com.centit.framework.model.basedata.UnitInfo;
import com.centit.framework.model.basedata.UserInfo;
import com.centit.framework.model.basedata.UserRole;
import com.centit.framework.model.basedata.UserUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class CurrentUserContext {
    public UserInfo userInfo;
    public String currentUnit;
    public String topUnit;

    public CurrentUserContext(UserInfo userInfo, String topUnit, String currentUnit) {
        this.userInfo = userInfo;
        this.topUnit = topUnit;
        this.currentUnit = StringUtils.isBlank((CharSequence)currentUnit) ? userInfo.getPrimaryUnit() : currentUnit;
    }

    public UnitInfo getCurrentUnit() {
        return CodeRepositoryUtil.getUnitInfoByCode((String)this.topUnit, (String)this.currentUnit);
    }

    public UnitInfo getPrimaryUnit() {
        return CodeRepositoryUtil.getUnitInfoByCode((String)this.topUnit, (String)this.userInfo.getPrimaryUnit());
    }

    public List<UserUnit> listUserUnits() {
        return CodeRepositoryUtil.listUserUnits((String)this.topUnit, (String)this.userInfo.getUserCode());
    }

    public Map<String, List<UserUnit>> getRankUnitsMap() {
        List<UserUnit> userUnits = this.listUserUnits();
        HashMap<String, List<UserUnit>> rankUnits = new HashMap<String, List<UserUnit>>(5);
        for (UserUnit uu : userUnits) {
            ArrayList<UserUnit> rankUnit = (ArrayList<UserUnit>)rankUnits.get(uu.getUserRank());
            if (rankUnit == null) {
                rankUnit = new ArrayList<UserUnit>(4);
            }
            rankUnit.add(uu);
            rankUnits.put(uu.getUserRank(), rankUnit);
        }
        return rankUnits;
    }

    public Map<String, List<UserUnit>> getStationUnitsMap() {
        List<UserUnit> userUnits = this.listUserUnits();
        HashMap<String, List<UserUnit>> stationUnits = new HashMap<String, List<UserUnit>>(5);
        for (UserUnit uu : userUnits) {
            ArrayList<UserUnit> stationUnit = (ArrayList<UserUnit>)stationUnits.get(uu.getUserStation());
            if (stationUnit == null) {
                stationUnit = new ArrayList<UserUnit>(4);
            }
            stationUnit.add(uu);
            stationUnits.put(uu.getUserStation(), stationUnit);
        }
        return stationUnits;
    }

    public List<UserRole> listUserRoles() {
        return CodeRepositoryUtil.listUserRoles((String)this.topUnit, (String)this.userInfo.getUserCode());
    }

    public List<UnitInfo> listSubUnits() {
        return CodeRepositoryUtil.getSubUnits((String)this.topUnit, (String)this.currentUnit);
    }

    public List<UnitInfo> listAllSubUnits() {
        List allSubUnits = CodeRepositoryUtil.getAllSubUnits((String)this.topUnit, (String)this.currentUnit);
        allSubUnits.add(CodeRepositoryUtil.getUnitInfoByCode((String)this.topUnit, (String)this.currentUnit));
        return allSubUnits;
    }
}

