/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.core.dao;

import com.centit.framework.components.SysUnitFilterEngine;
import com.centit.framework.components.SysUserFilterEngine;
import com.centit.framework.model.adapter.UserUnitVariableTranslate;
import com.centit.support.algorithm.BooleanBaseOpt;
import com.centit.support.algorithm.ReflectionOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.common.LeftRightPair;
import com.centit.support.compiler.Lexer;
import com.centit.support.compiler.VariableFormula;
import com.centit.support.database.orm.JpaMetadata;
import com.centit.support.database.orm.TableMapInfo;
import com.centit.support.database.utils.FieldType;
import com.centit.support.database.utils.QueryAndNamedParams;
import com.centit.support.database.utils.QueryUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutableTriple;

public class DataPowerFilter
implements UserUnitVariableTranslate {
    private Map<String, Object> sourceData;
    private String topUnit;

    public DataPowerFilter(String topUnit) {
        this.topUnit = topUnit;
    }

    public void setSourceDatas(Map<String, Object> sourceData) {
        this.sourceData = sourceData;
    }

    public Map<String, Object> getSourceData() {
        return this.sourceData;
    }

    public void addSourceData(String name, Supplier<?> supplier) {
        if (supplier == null) {
            return;
        }
        if (this.sourceData == null) {
            this.sourceData = new HashMap<String, Object>();
        }
        this.sourceData.put(name, supplier);
    }

    public void addSourceData(String name, Object data) {
        if (data == null) {
            return;
        }
        if (this.sourceData == null) {
            this.sourceData = new HashMap<String, Object>();
        }
        this.sourceData.put(name, data);
    }

    public void addSourceData(Object data) {
        if (data == null) {
            return;
        }
        if (this.sourceData == null) {
            this.sourceData = new HashMap<String, Object>();
        }
        if (data instanceof Map) {
            Map objMap = (Map)data;
            this.sourceData.putAll(objMap);
        } else {
            this.sourceData.put(data.getClass().getSimpleName(), data);
        }
    }

    public Set<String> getUsersVariable(String s) {
        HashSet<String> retSet = new HashSet<String>(20);
        Object obj = this.getVarValue(s);
        if (obj instanceof Object[]) {
            Object[] objs = (Object[])obj;
            if (objs.length > 0) {
                for (int i = 0; i < objs.length; ++i) {
                    retSet.add(StringBaseOpt.objectToString((Object)objs[i]));
                }
            }
        } else if (obj instanceof Collection) {
            Collection valueList = (Collection)obj;
            for (Object ov : valueList) {
                retSet.add(StringBaseOpt.objectToString(ov));
            }
        } else {
            retSet.add(StringBaseOpt.objectToString((Object)obj));
        }
        return retSet;
    }

    public Set<String> getUnitsVariable(String s) {
        return this.getUsersVariable(s);
    }

    public Object getVarValue(String labelName) {
        return ReflectionOpt.attainExpressionValue(this.sourceData, (String)labelName);
    }

    public DataPowerFilterTranslater getPowerFilterTranslater() {
        return new DataPowerFilterTranslater(false, this);
    }

    public DataPowerFilterTranslater getPowerFilterTranslater(boolean jointSql) {
        return new DataPowerFilterTranslater(jointSql, this);
    }

    public QueryAndNamedParams translateQuery(String queryStatement, Collection<String> filters, boolean jointSql, boolean isUnion) {
        return QueryUtils.translateQuery((String)queryStatement, filters, (boolean)isUnion, (QueryUtils.IFilterTranslater)new DataPowerFilterTranslater(jointSql, this));
    }

    public QueryAndNamedParams translateQuery(String queryStatement, Collection<String> filters) {
        return this.translateQuery(queryStatement, filters, false, true);
    }

    public QueryAndNamedParams translateQueryFilter(Map<String, String> tableMap, Collection<String> filters, boolean jointSql, boolean isUnion) {
        DataPowerFilterTranslater translater = new DataPowerFilterTranslater(jointSql, this);
        translater.setTableAlias(tableMap);
        return QueryUtils.translateQueryFilter(filters, (QueryUtils.IFilterTranslater)translater, (boolean)isUnion);
    }

    public QueryAndNamedParams translateQueryFilter(Map<String, String> tableMap, Collection<String> filters) {
        return this.translateQueryFilter(tableMap, filters, false, true);
    }

    private static boolean matchTableAndObjectName(String tableName, String objectName) {
        return tableName.equalsIgnoreCase(objectName) || objectName.equalsIgnoreCase(FieldType.mapClassName((String)tableName)) || tableName.equalsIgnoreCase(FieldType.mapClassName((String)objectName));
    }

    public int checkObjectFilter(Object obj, String tableName, String filter) {
        DataPowerFilterTranslater translater = this.getPowerFilterTranslater();
        String poClassName = tableName;
        if (StringUtils.isBlank((CharSequence)tableName)) {
            TableMapInfo tif = JpaMetadata.obtainMapInfoFromClass(obj.getClass());
            poClassName = tif != null ? tif.getTableName() : obj.getClass().getSimpleName();
        }
        Lexer varMorp = new Lexer();
        varMorp.setFormula(filter);
        StringBuilder checkStatement = new StringBuilder();
        String sWord = varMorp.getAWord();
        int prePos = 0;
        boolean hasFetchField = false;
        while (sWord != null && !"".equals(sWord)) {
            int curPos;
            if ("[".equals(sWord)) {
                curPos = varMorp.getCurrPos();
                if (curPos - 1 > prePos) {
                    checkStatement.append(filter.substring(prePos, curPos - 1));
                }
                varMorp.seekTo(']');
                prePos = varMorp.getCurrPos();
                String columnDesc = filter.substring(curPos, prePos - 1).trim();
                int n = columnDesc.indexOf(46);
                if (n < 0) {
                    return 0;
                }
                String tempClassName = columnDesc.substring(0, n);
                if (!DataPowerFilter.matchTableAndObjectName(poClassName, tempClassName)) {
                    return 0;
                }
                String columnName = columnDesc.substring(n + 1);
                Object fieldValue = ReflectionOpt.attainExpressionValue((Object)obj, (String)FieldType.mapPropName((String)columnName));
                if (fieldValue == null) {
                    fieldValue = ReflectionOpt.attainExpressionValue((Object)obj, (String)columnName);
                }
                if (fieldValue != null) {
                    checkStatement.append(QueryUtils.buildObjectStringForQuery((Object)fieldValue));
                    hasFetchField = true;
                }
            } else if ("{".equals(sWord)) {
                curPos = varMorp.getCurrPos();
                if (curPos - 1 > prePos) {
                    checkStatement.append(filter.substring(prePos, curPos - 1));
                }
                varMorp.seekTo('}');
                prePos = varMorp.getCurrPos();
                String valueDesc = filter.substring(curPos, prePos - 1).trim();
                ImmutableTriple paramMeta = QueryUtils.parseParameter((String)valueDesc);
                String paramName = StringUtils.isBlank((CharSequence)((CharSequence)paramMeta.left)) ? (String)paramMeta.middle : (String)paramMeta.left;
                Object fieldValue = translater.mapParamFormula(paramName);
                checkStatement.append(QueryUtils.buildObjectStringForQuery((Object)fieldValue));
            }
            sWord = varMorp.getAWord();
        }
        checkStatement.append(filter.substring(prePos));
        String formula = checkStatement.toString();
        if (StringUtils.isBlank((CharSequence)formula)) {
            return 0;
        }
        Boolean checkRet = BooleanBaseOpt.castObjectToBoolean((Object)VariableFormula.calculate((String)checkStatement.toString()));
        if (checkRet == null) {
            return hasFetchField ? -1 : 0;
        }
        return checkRet != false ? 1 : -1;
    }

    public int checkObjectFilter(Object obj, String filter) {
        return this.checkObjectFilter(obj, null, filter);
    }

    public boolean checkObject(Object obj, String tableName, Collection<String> filters) {
        if (filters == null) {
            return true;
        }
        int nFalse = 0;
        for (String filter : filters) {
            int nRes = this.checkObjectFilter(obj, tableName, filter);
            if (nRes == 1) {
                return true;
            }
            if (nRes != -1) continue;
            ++nFalse;
        }
        return nFalse == 0;
    }

    public boolean checkObject(Object obj, Collection<String> filters) {
        return this.checkObject(obj, null, filters);
    }

    protected static class DataPowerFilterTranslater
    implements QueryUtils.IFilterTranslater {
        private Map<String, String> tableAlias = null;
        private boolean jointSql;
        private DataPowerFilter dataPowerFilter;

        public DataPowerFilterTranslater(boolean jointSql, DataPowerFilter dataPowerFilter) {
            this.jointSql = jointSql;
            this.dataPowerFilter = dataPowerFilter;
        }

        public void setTableAlias(Map<String, String> tableAlias) {
            this.tableAlias = tableAlias;
        }

        public String translateColumn(String columnDesc) {
            String columnName;
            if (this.tableAlias == null || columnDesc == null || this.tableAlias.size() == 0) {
                return null;
            }
            int n = columnDesc.indexOf(46);
            String poClassName = n < 0 ? "*" : columnDesc.substring(0, n);
            String string = columnName = n < 0 ? columnDesc : columnDesc.substring(n + 1);
            if (this.tableAlias.containsKey(poClassName)) {
                String alias = this.tableAlias.get(poClassName);
                return StringUtils.isBlank((CharSequence)alias) ? columnName : alias + '.' + columnName;
            }
            if ("*".equals(poClassName) && this.tableAlias.size() == 1) {
                String alias = this.tableAlias.values().iterator().next();
                return StringUtils.isBlank((CharSequence)alias) ? columnName : alias + '.' + columnName;
            }
            return null;
        }

        public Object mapParamFormula(String paramName) {
            if (StringUtils.isBlank((CharSequence)paramName)) {
                return null;
            }
            if (paramName.contains("(")) {
                String formula = StringEscapeUtils.unescapeHtml4((String)paramName).trim();
                if (formula.startsWith("*")) {
                    return SysUserFilterEngine.calcSystemOperators((String)formula.substring(1), (String)this.dataPowerFilter.topUnit, null, null, null, (UserUnitVariableTranslate)this.dataPowerFilter);
                }
                return SysUnitFilterEngine.calcSystemUnitsByExp((String)formula, (String)this.dataPowerFilter.topUnit, null, (UserUnitVariableTranslate)this.dataPowerFilter);
            }
            return this.dataPowerFilter.getVarValue(paramName);
        }

        public LeftRightPair<String, Object> translateParam(String paramName) {
            Object obj = this.mapParamFormula(paramName);
            if (obj == null) {
                return null;
            }
            if (obj instanceof String && StringUtils.isBlank((CharSequence)((String)obj))) {
                return null;
            }
            if (this.jointSql) {
                return new LeftRightPair((Object)QueryUtils.buildObjectStringForQuery((Object)obj), null);
            }
            return new LeftRightPair((Object)paramName, obj);
        }

        public String getVarValue(String varName) {
            Object res = this.mapParamFormula(varName);
            if (res == null) {
                return null;
            }
            return StringBaseOpt.objectToString((Object)res);
        }
    }
}

