/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.core.config;

import com.centit.framework.core.dao.ExtendedQueryPool;
import com.centit.framework.flyway.plugin.FlywayExt;
import com.centit.support.algorithm.StringRegularOpt;
import com.centit.support.database.utils.DBType;
import com.centit.support.database.utils.QueryLogUtils;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.dom4j.DocumentException;
import org.flywaydb.core.Flyway;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.Environment;

public class DataSourceConfig
implements EnvironmentAware {
    protected Logger logger = LoggerFactory.getLogger(DataSourceConfig.class);
    protected Environment env;

    @Resource
    public void setEnvironment(Environment environment) {
        if (environment != null) {
            this.env = environment;
        }
    }

    @Bean(destroyMethod="close")
    public BasicDataSource dataSource() {
        BasicDataSource dataSource = new BasicDataSource();
        dataSource.setDriverClassName(this.env.getProperty("jdbc.driver"));
        dataSource.setUrl(this.env.getProperty("jdbc.url"));
        dataSource.setUsername(this.env.getProperty("jdbc.user"));
        dataSource.setPassword(this.env.getProperty("jdbc.password"));
        dataSource.setMaxTotal(((Integer)this.env.getProperty("jdbc.maxActive", Integer.class)).intValue());
        dataSource.setMaxIdle(((Integer)this.env.getProperty("jdbc.maxIdle", Integer.class)).intValue());
        dataSource.setMaxWaitMillis((long)((Integer)this.env.getProperty("jdbc.maxWait", Integer.class)).intValue());
        dataSource.setDefaultAutoCommit((Boolean)this.env.getProperty("jdbc.defaultAutoCommit", Boolean.class));
        dataSource.setRemoveAbandonedTimeout(((Integer)this.env.getProperty("jdbc.removeAbandonedTimeout", Integer.class)).intValue());
        if (StringRegularOpt.isTrue((String)this.env.getProperty("jdbc.show.sql"))) {
            QueryLogUtils.setJdbcShowSql((boolean)true);
        }
        DBType dbType = DBType.mapDBType((String)this.env.getProperty("jdbc.url"));
        try {
            ExtendedQueryPool.loadResourceExtendedSqlMap((DBType)dbType);
        }
        catch (DocumentException e) {
            this.logger.error(e.getMessage());
        }
        try {
            ExtendedQueryPool.loadExtendedSqlMaps((String)(this.env.getProperty("app.home", ".") + "/sqlscript"), (DBType)dbType);
        }
        catch (IOException | DocumentException e) {
            this.logger.error(e.getMessage());
        }
        return dataSource;
    }

    @Bean
    public Flyway flyway(DataSource dataSource) throws SQLException {
        String flywayEnable = this.env.getProperty("flyway.enable");
        if (StringRegularOpt.isTrue((String)flywayEnable)) {
            DBType dbType = DBType.mapDBType((Connection)dataSource.getConnection());
            Object flywayMigration = dbType.isMadeInChina() ? new FlywayExt() : new Flyway();
            flywayMigration.setDataSource(dataSource);
            flywayMigration.setBaselineOnMigrate(true);
            flywayMigration.setLocations(this.env.getProperty("flyway.sql.dir").concat(",com.centit.framework.system.update").split(","));
            flywayMigration.migrate();
            return flywayMigration;
        }
        return null;
    }
}

