/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.tenant.service.impl;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.centit.framework.common.ResponseData;
import com.centit.framework.common.WebOptUtils;
import com.centit.framework.components.CodeRepositoryCache;
import com.centit.framework.components.CodeRepositoryUtil;
import com.centit.framework.core.dao.PageQueryResult;
import com.centit.framework.filter.RequestThreadLocal;
import com.centit.framework.model.adapter.PlatformEnvironment;
import com.centit.framework.model.basedata.DataCatalog;
import com.centit.framework.model.basedata.DataDictionary;
import com.centit.framework.model.basedata.DataDictionaryId;
import com.centit.framework.model.basedata.RoleInfo;
import com.centit.framework.model.basedata.UnitInfo;
import com.centit.framework.model.basedata.UserInfo;
import com.centit.framework.model.basedata.UserRole;
import com.centit.framework.model.basedata.UserRoleId;
import com.centit.framework.model.basedata.UserUnit;
import com.centit.framework.model.basedata.WorkGroup;
import com.centit.framework.model.basedata.WorkGroupParameter;
import com.centit.framework.model.security.CentitPasswordEncoder;
import com.centit.framework.model.security.CentitUserDetails;
import com.centit.framework.system.dao.DataCatalogDao;
import com.centit.framework.system.dao.DataDictionaryDao;
import com.centit.framework.system.dao.RoleInfoDao;
import com.centit.framework.system.dao.UnitInfoDao;
import com.centit.framework.system.dao.UserInfoDao;
import com.centit.framework.system.dao.UserRoleDao;
import com.centit.framework.system.dao.UserUnitDao;
import com.centit.framework.system.dao.WorkGroupDao;
import com.centit.framework.system.service.SysUnitManager;
import com.centit.framework.system.service.SysUserManager;
import com.centit.framework.system.service.WorkGroupManager;
import com.centit.framework.tenant.dao.TenantBusinessLogDao;
import com.centit.framework.tenant.dao.TenantInfoDao;
import com.centit.framework.tenant.dao.TenantMemberApplyDao;
import com.centit.framework.tenant.po.TenantBusinessLog;
import com.centit.framework.tenant.po.TenantInfo;
import com.centit.framework.tenant.po.TenantMemberApply;
import com.centit.framework.tenant.service.TenantPowerManage;
import com.centit.framework.tenant.service.TenantService;
import com.centit.framework.tenant.vo.PageListTenantInfoQo;
import com.centit.framework.tenant.vo.TenantMemberApplyVo;
import com.centit.framework.tenant.vo.TenantMemberQo;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.algorithm.UuidOpt;
import com.centit.support.common.ObjectException;
import com.centit.support.database.utils.PageDesc;
import com.centit.support.security.DesensitizeOptUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service
public class TenantServiceImpl
implements TenantService {
    protected Logger logger = LoggerFactory.getLogger(TenantService.class);
    @Value(value="${app.tenant.resource.database_number_limit:20}")
    private int databaseNumberLimit;
    @Value(value="${app.tenant.resource.data_space_limit:1}")
    private int dataSpaceLimit;
    @Value(value="${app.tenant.resource.file_space_limit:1}")
    private int fileSpaceLimit;
    @Value(value="${app.tenant.resource.os_number_limit:5}")
    private int osNumberLimit;
    @Value(value="${app.tenant.resource.user_number_limit:100}")
    private int userNumberLimit;
    @Value(value="${app.tenant.resource.unit_number_limit:20}")
    private int unitNumberLimit;
    @Autowired
    private UserInfoDao userInfoDao;
    @Autowired
    private CentitPasswordEncoder passwordEncoder;
    @Autowired
    private TenantInfoDao tenantInfoDao;
    @Autowired
    private UnitInfoDao unitInfoDao;
    @Autowired
    private UserUnitDao userUnitDao;
    @Autowired
    private TenantMemberApplyDao tenantMemberApplyDao;
    @Autowired
    private TenantBusinessLogDao tenantBusinessLogDao;
    @Autowired
    private WorkGroupDao workGroupDao;
    @Autowired
    private WorkGroupManager workGroupManager;
    @Autowired
    private TenantPowerManage tenantPowerManage;
    @Autowired
    private PlatformEnvironment platformEnvironment;
    @Autowired
    private RoleInfoDao roleInfoDao;
    @Autowired
    private UserRoleDao userRoleDao;
    @Autowired
    private DataCatalogDao dataCatalogDao;
    @Autowired
    private DataDictionaryDao dataDictionaryDao;
    @Autowired
    private SysUnitManager sysUnitManager;
    @Autowired
    private SysUserManager sysUserManager;
    @Value(value="${login.password.minLength:8}")
    private int passwordMinLength;
    @Value(value="${login.password.strength:3}")
    private int passwordStrength;

    @Override
    @Transactional
    public ResponseData registerUserAccount(UserInfo userInfo) {
        String userPwd = userInfo.getUserPwd();
        String regCellPhone = userInfo.getRegCellPhone();
        String loginName = userInfo.getLoginName();
        String userName = userInfo.getUserName();
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{userPwd, regCellPhone, loginName, userName})) {
            return ResponseData.makeErrorMessage((String)"\u767b\u5f55\u540d,\u5bc6\u7801,\u624b\u673a\u53f7\uff0c\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (this.checkUserAccountHasExist(userInfo)) {
            return ResponseData.makeErrorMessage((String)"\u8d26\u53f7\u4fe1\u606f\u5df2\u5b58\u5728\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u6ce8\u518c!");
        }
        userInfo.setUserPin(this.passwordEncoder.createPassword(userPwd, (Object)""));
        userInfo.setCreateDate(this.nowDate());
        userInfo.setUserCode(null);
        userInfo.setIsValid("W");
        userInfo.setUserType("U");
        userInfo.setTopUnit("");
        userInfo.setUserOrder(Long.valueOf(1L));
        userInfo.setUserPwd(null);
        this.userInfoDao.saveNewObject((Serializable)userInfo);
        return ResponseData.makeSuccessResponse((String)"\u6ce8\u518c\u6210\u529f!");
    }

    @Override
    @Transactional
    public ResponseData applyAddTenant(TenantInfo tenantInfo) {
        int tenantCount;
        if (!this.tenantPowerManage.userIsSystemAdmin() && (tenantCount = this.tenantInfoDao.countObjectByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"ownUser", tenantInfo.getOwnUser(), "isAvailable", "T"}))) > 0) {
            return ResponseData.makeErrorMessage((String)"\u60a8\u5df2\u7ecf\u62e5\u6709\u4e00\u4e2a\u79df\u6237\uff0c\u4e0d\u80fd\u518d\u6b21\u7533\u8bf7!");
        }
        this.saveTenantInfo(tenantInfo);
        TenantInfo newTenantInfo = new TenantInfo();
        this.initTenant(newTenantInfo, tenantInfo);
        this.batchEvictCache(newTenantInfo.getTopUnit(), "UserInfo", "UnitInfo", "UnitUser", "UserUnit", "UserRole", "DataDictionary");
        return ResponseData.makeSuccessResponse((String)"\u79df\u6237\u7533\u8bf7\u6210\u529f!");
    }

    @Override
    @Transactional
    public ResponseData applyJoinTenant(TenantMemberApply tenantMemberApply) {
        UserInfo userInfo = this.userInfoDao.getUserByCode(tenantMemberApply.getUserCode());
        if (null == userInfo) {
            return ResponseData.makeErrorMessage((String)"\u7528\u6237\u4fe1\u606f\u4e0d\u5b58\u5728!");
        }
        TenantInfo tenantInfo = (TenantInfo)this.tenantInfoDao.getObjectById(tenantMemberApply.getTopUnit());
        if (null == tenantInfo || !"T".equals(tenantInfo.getIsAvailable())) {
            return ResponseData.makeErrorMessage((String)"\u79df\u6237\u4fe1\u606f\u4e0d\u5b58\u5728,\u6216\u79df\u6237\u72b6\u6001\u4e0d\u53ef\u7528!");
        }
        tenantMemberApply.setApplyTime(this.nowDate());
        String userCode = WebOptUtils.getCurrentUserCode((HttpServletRequest)RequestThreadLocal.getLocalThreadWrapperRequest());
        if ("1".equals(tenantMemberApply.getApplyType())) {
            if (!StringUtils.equals((CharSequence)userCode, (CharSequence)tenantMemberApply.getUserCode())) {
                throw new ObjectException(702, "\u7533\u8bf7\u4fe1\u606f\u6709\u8bef");
            }
            tenantMemberApply.setUnitCode(null);
        }
        if ("2".equals(tenantMemberApply.getApplyType())) {
            if (!this.tenantPowerManage.userIsTenantAdmin(userCode, tenantMemberApply.getTopUnit())) {
                throw new ObjectException(702, "\u9080\u8bf7\u4fe1\u606f\u6709\u8bef");
            }
            if (this.tenantPowerManage.userNumberLimitIsOver(tenantInfo.getTopUnit())) {
                return ResponseData.makeErrorMessage((String)"\u7528\u6237\u6570\u91cf\u8fbe\u5230\u4e0a\u9650!");
            }
        }
        this.tenantMemberApplyDao.saveTenantMemberApply(tenantMemberApply);
        return ResponseData.makeSuccessResponse((String)"\u7533\u8bf7\u6210\u529f,\u7b49\u5f85\u5bf9\u65b9\u540c\u610f!");
    }

    @Override
    public ResponseData userApplyJoinTenant(TenantMemberApply tenantMemberApply) {
        UserInfo userInfo = CodeRepositoryUtil.getUserInfoByCode((String)tenantMemberApply.getTopUnit(), (String)tenantMemberApply.getUserCode());
        if (Objects.nonNull(userInfo)) {
            return ResponseData.makeErrorMessage((String)"\u60a8\u5df2\u7ecf\u662f\u6539\u79df\u6237\u6210\u5458\uff0c\u65e0\u9700\u91cd\u590d\u7533\u8bf7");
        }
        TenantInfo tenantInfo = (TenantInfo)this.tenantInfoDao.getObjectById(tenantMemberApply.getTopUnit());
        if (null == tenantInfo || !"T".equals(tenantInfo.getIsAvailable())) {
            return ResponseData.makeErrorMessage((String)"\u79df\u6237\u4fe1\u606f\u4e0d\u5b58\u5728,\u6216\u79df\u6237\u72b6\u6001\u4e0d\u53ef\u7528!");
        }
        tenantMemberApply.setApplyTime(this.nowDate());
        tenantMemberApply.setApplyType("1");
        tenantMemberApply.setUnitCode(null);
        this.tenantMemberApplyDao.saveTenantMemberApply(tenantMemberApply);
        return ResponseData.makeSuccessResponse((String)"\u7533\u8bf7\u6210\u529f,\u7b49\u5f85\u5bf9\u65b9\u540c\u610f!");
    }

    @Override
    public ResponseData adminApplyUserJoinTenant(TenantMemberApply tenantMemberApply) {
        boolean isTenantAdmin = this.tenantPowerManage.userIsTenantAdmin(tenantMemberApply.getInviterUserCode(), tenantMemberApply.getTopUnit());
        if (!isTenantAdmin) {
            return ResponseData.makeErrorMessage((int)401, (String)"\u60a8\u6ca1\u6709\u9080\u8bf7\u6743\u9650");
        }
        UserInfo userInfo = CodeRepositoryUtil.getUserInfoByCode((String)tenantMemberApply.getTopUnit(), (String)tenantMemberApply.getUserCode());
        if (Objects.nonNull(userInfo)) {
            return ResponseData.makeErrorMessage((String)"\u7528\u6237\u5df2\u7ecf\u662f\u672c\u79df\u6237\u6210\u5458\uff0c\u65e0\u9700\u91cd\u590d\u9080\u8bf7!");
        }
        if (Objects.isNull(this.userInfoDao.getUserByCode(tenantMemberApply.getUserCode()))) {
            return ResponseData.makeErrorMessage((String)"\u7528\u6237\u4fe1\u606f\u4e0d\u5b58\u5728!");
        }
        tenantMemberApply.setApplyTime(this.nowDate());
        tenantMemberApply.setApplyType("2");
        if (this.tenantPowerManage.userNumberLimitIsOver(tenantMemberApply.getTopUnit())) {
            return ResponseData.makeErrorMessage((String)"\u7528\u6237\u6570\u91cf\u8fbe\u5230\u4e0a\u9650!");
        }
        this.tenantMemberApplyDao.saveTenantMemberApply(tenantMemberApply);
        return ResponseData.makeSuccessResponse((String)"\u7533\u8bf7\u6210\u529f,\u7b49\u5f85\u5bf9\u65b9\u540c\u610f!");
    }

    @Override
    public PageQueryResult listApplyInfo(Map<String, Object> parameters, PageDesc pageDesc) {
        List tenantMemberApplies;
        if (!ObjectUtils.anyNotNull((Object[])new Object[]{parameters.get("applyState"), parameters.get("applyState_in")})) {
            throw new ObjectException("\u7f3a\u5c11\u53c2\u6570applyState;");
        }
        if (!ObjectUtils.anyNotNull((Object[])new Object[]{parameters.get("userCode"), parameters.get("topUnit"), parameters.get("unitCode")})) {
            throw new ObjectException("\u7f3a\u5c11\u53c2\u6570userCode\u6216topUnit\u6216unitCode;");
        }
        if (null != parameters.get("applyState_in")) {
            parameters.put("applyState_in", MapUtils.getString(parameters, (Object)"applyState_in").split(","));
        }
        if (CollectionUtils.sizeIsEmpty((Object)(tenantMemberApplies = this.tenantMemberApplyDao.listObjectsByProperties(parameters, pageDesc)))) {
            return PageQueryResult.createResult(Collections.emptyList(), (PageDesc)pageDesc);
        }
        return PageQueryResult.createResult((Collection)this.formatMemberApply(tenantMemberApplies), (PageDesc)pageDesc);
    }

    @Override
    @Transactional
    public ResponseData adminCheckTenant(TenantInfo tenantInfo) {
        if (!this.tenantPowerManage.userIsSystemMember()) {
            return ResponseData.makeResponseData((Object)"\u60a8\u4e0d\u662f\u7cfb\u7edf\u7528\u6237\uff0c\u65e0\u6cd5\u5ba1\u6838");
        }
        if (StringUtils.isBlank((CharSequence)tenantInfo.getTopUnit())) {
            return ResponseData.makeErrorMessage((String)"topUnit\u5b57\u6bb5\u5c5e\u6027\u4e3a\u7a7a");
        }
        if (!StringUtils.equalsAny((CharSequence)tenantInfo.getIsAvailable(), (CharSequence[])new CharSequence[]{"T", "F"})) {
            return ResponseData.makeErrorMessage((String)"isAvailable\u5b57\u6bb5\u5c5e\u6027\u6709\u8bef");
        }
        TenantInfo oldTenantInfo = (TenantInfo)this.tenantInfoDao.getObjectById(tenantInfo.getTopUnit());
        if (null == oldTenantInfo) {
            return ResponseData.makeErrorMessage((String)"\u79df\u6237\u4e0d\u5b58\u5728!");
        }
        oldTenantInfo.setMemo(tenantInfo.getMemo());
        oldTenantInfo.setIsAvailable(tenantInfo.getIsAvailable());
        oldTenantInfo.setUpdateTime(this.nowDate());
        if ("F".equals(tenantInfo.getIsAvailable())) {
            oldTenantInfo.setPassTime(null);
            this.tenantInfoDao.updateObject(oldTenantInfo);
        }
        if ("T".equals(tenantInfo.getIsAvailable())) {
            this.initTenant(tenantInfo, oldTenantInfo);
        }
        return ResponseData.makeSuccessResponse();
    }

    @Override
    @Transactional
    public ResponseData agreeJoin(TenantMemberApplyVo tenantMemberApplyVo) {
        if (StringUtils.isBlank((CharSequence)tenantMemberApplyVo.getUserCode())) {
            return ResponseData.makeErrorMessage((int)500, (String)"userCode\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String applyState = tenantMemberApplyVo.getApplyState();
        if (!StringUtils.equalsAny((CharSequence)applyState, (CharSequence[])new CharSequence[]{"3", "4"})) {
            return ResponseData.makeErrorMessage((int)500, (String)"applyState\u5c5e\u6027\u503c\u6709\u8bef");
        }
        UserInfo userInfo = CodeRepositoryUtil.getUserInfoByCode((String)tenantMemberApplyVo.getTopUnit(), (String)tenantMemberApplyVo.getUserCode());
        if (Objects.nonNull(userInfo)) {
            return ResponseData.makeErrorMessage((String)"\u7528\u6237\u5df2\u52a0\u5165\u79df\u6237\uff0c\u65e0\u9700\u91cd\u590d\u5ba1\u6838!");
        }
        TenantMemberApply tenantMemberApply = new TenantMemberApply();
        BeanUtils.copyProperties((Object)tenantMemberApplyVo, (Object)tenantMemberApply);
        this.tenantMemberApplyDao.updateObject(tenantMemberApply);
        if (tenantMemberApply.getApplyState().equals("3")) {
            if (this.tenantPowerManage.userNumberLimitIsOver(tenantMemberApplyVo.getTopUnit())) {
                return ResponseData.makeErrorMessage((String)"\u7528\u6237\u6570\u91cf\u8fbe\u5230\u4e0a\u9650!");
            }
            this.saveTenantUserUnit(tenantMemberApply);
            CodeRepositoryCache.evictCache((String)"UserInfo", (String)tenantMemberApplyVo.getTopUnit());
            CodeRepositoryCache.evictCache((String)"UserUnit", (String)tenantMemberApplyVo.getTopUnit());
        }
        return ResponseData.makeSuccessResponse();
    }

    @Override
    @Transactional
    public ResponseData updateUserInfo(UserInfo userinfo) {
        if (StringUtils.isBlank((CharSequence)userinfo.getUserCode())) {
            return ResponseData.makeErrorMessage((int)302, (String)"userCode\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!userinfo.getUserCode().equals(WebOptUtils.getCurrentUserCode((HttpServletRequest)((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest()))) {
            return ResponseData.makeErrorMessage((String)"\u65e0\u6743\u9650\u4fee\u6539\u5176\u4ed6\u4eba\u7684\u7528\u6237\u4fe1\u606f");
        }
        UserInfo oldUserByCode = this.userInfoDao.getUserByCode(userinfo.getUserCode());
        if (null == oldUserByCode) {
            return ResponseData.makeErrorMessage((String)"\u7528\u6237\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        userinfo.setRegEmail(null);
        userinfo.setRegCellPhone(null);
        userinfo.setUpdateDate(this.nowDate());
        userinfo.setUpdator(userinfo.getUserCode());
        userinfo.setCreateDate(oldUserByCode.getCreateDate());
        if (StringUtils.isNotBlank((CharSequence)userinfo.getUserPwd())) {
            userinfo.setUserPin(this.passwordEncoder.createPassword(userinfo.getUserPwd(), (Object)""));
        } else {
            userinfo.setUserPwd(null);
            userinfo.setUserPin(null);
        }
        this.userInfoDao.updateUser(userinfo);
        this.reloadAuthentication(userinfo.getUserCode());
        CodeRepositoryCache.evictCache((String)"UserInfo");
        return ResponseData.makeSuccessResponse();
    }

    @Override
    @Transactional
    public ResponseData quitTenant(String topUnit, String userCode) {
        if (this.tenantInfoDao.userIsOwner(topUnit, userCode)) {
            return ResponseData.makeErrorMessage((String)"\u79df\u6237\u6240\u6709\u8005\u4e0d\u5141\u8bb8\u9000\u51fa\u79df\u6237");
        }
        this.removeTenantMemberRelation(topUnit, userCode);
        CodeRepositoryCache.evictCache((String)"UserUnit", (String)topUnit);
        CodeRepositoryCache.evictCache((String)"UserInfo", (String)topUnit);
        return ResponseData.makeSuccessResponse((String)"\u5df2\u9000\u51fa\u8be5\u673a\u6784!");
    }

    @Override
    @Transactional
    public ResponseData removeTenantMember(String topUnit, String userCode) {
        if (!this.isTenantManger(topUnit)) {
            return ResponseData.makeErrorMessage((String)"\u8be5\u7528\u6237\u6ca1\u6709\u64cd\u4f5c\u6743\u9650!");
        }
        if (!this.tenantPowerManage.userIsTenantMember(userCode, topUnit)) {
            return ResponseData.makeErrorMessage((String)"\u8be5\u7528\u6237\u4e0d\u5728\u79df\u6237\u5185!");
        }
        if (this.isTenantManger(userCode, topUnit)) {
            return ResponseData.makeErrorMessage((String)"\u7ba1\u7406\u5458\u6216\u79df\u6237\u6240\u6709\u8005\u4e0d\u5141\u8bb8\u88ab\u79fb\u9664\u79df\u6237!");
        }
        this.removeTenantMemberRelation(topUnit, userCode);
        this.batchEvictCache(topUnit, "UserInfo", "UserUnit", "UnitUser", "UserRoles");
        return ResponseData.makeSuccessResponse((String)"\u79fb\u9664\u6210\u529f!");
    }

    private boolean isTenantManger(String topUnit) {
        return this.tenantPowerManage.userIsTenantAdmin(topUnit) || this.tenantPowerManage.userIsTenantOwner(topUnit);
    }

    private boolean isTenantManger(String userCode, String topUnit) {
        return this.tenantPowerManage.userIsTenantAdmin(userCode, topUnit) || this.tenantPowerManage.userIsTenantOwner(userCode, topUnit);
    }

    private void removeUserUnit(String topUnit, String userCode) {
        HashMap<String, String> paraMap = new HashMap<String, String>();
        paraMap.put("topUnit", topUnit);
        paraMap.put("userCode", userCode);
        this.userUnitDao.deleteObjectsByProperties(paraMap);
    }

    private void removeWorkGroup(String groupId, String userCode) {
        HashMap<String, String> paraMap = new HashMap<String, String>();
        paraMap.put("groupId", groupId);
        paraMap.put("userCode", userCode);
        this.workGroupDao.deleteObjectsByProperties(paraMap);
    }

    private void removeTenantMemberRelation(String unitCode, String userCode) {
        this.removeUserUnit(unitCode, userCode);
        this.removeWorkGroup(unitCode, userCode);
        this.removeUserRole(unitCode, userCode);
        this.updateUserInfoAfterRemoveTenantUser(unitCode, userCode);
    }

    private void updateUserInfoAfterRemoveTenantUser(String unitCode, String userCode) {
        List userUnits = this.userUnitDao.listObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"userCode", userCode}));
        Set topUnits = userUnits.stream().filter(userUnit -> StringUtils.isNotBlank((CharSequence)userUnit.getTopUnit()) && !unitCode.equals(userUnit.getTopUnit())).map(UserUnit::getTopUnit).collect(Collectors.toSet());
        UserInfo userInfo = this.userInfoDao.getUserByCode(userCode);
        if (CollectionUtils.sizeIsEmpty(topUnits)) {
            userInfo.setIsValid("W");
        }
        if (null != userInfo.getTopUnit() && userInfo.getTopUnit().equals(unitCode)) {
            userInfo.setTopUnit("");
            userInfo.setPrimaryUnit("");
        }
        userInfo.setUserCode(userCode);
        this.userInfoDao.updateObject((Serializable)userInfo);
    }

    private void removeUserRole(String unitCode, String userCode) {
        List roleInfos = this.roleInfoDao.listAllRoleByUnit(unitCode);
        if (CollectionUtils.sizeIsEmpty((Object)roleInfos)) {
            return;
        }
        List roleCodes = roleInfos.stream().map(RoleInfo::getRoleCode).collect(Collectors.toList());
        this.userRoleDao.deleteObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"userCode", userCode, "roleCode_in", CollectionsOpt.listToArray(roleCodes)}));
    }

    @Override
    @Transactional
    public ResponseData businessTenant(TenantBusinessLog tenantBusinessLog) {
        if (!this.tenantPowerManage.userIsTenantOwner(tenantBusinessLog.getTopUnit())) {
            return ResponseData.makeSuccessResponse((String)"\u65e0\u6743\u8f6c\u8ba9\u8be5\u79df\u6237!");
        }
        tenantBusinessLog.setAssignorUserCode(WebOptUtils.getCurrentUserCode((HttpServletRequest)RequestThreadLocal.getLocalThreadWrapperRequest()));
        String assignorUserCode = tenantBusinessLog.getAssignorUserCode();
        String assigneeUserCode = tenantBusinessLog.getAssigneeUserCode();
        List userCodes = CollectionsOpt.createList((Object[])new String[]{assignorUserCode, assigneeUserCode});
        List<UserInfo> userInfos = this.getUserInfosByUserCodes(userCodes);
        UserInfo assigneeUserInfo = this.getUserInfoByUserCode(userInfos, assigneeUserCode);
        if (null == assigneeUserInfo) {
            return ResponseData.makeSuccessResponse((String)"\u53d7\u8ba9\u4eba\u4fe1\u606f\u6709\u8bef!");
        }
        tenantBusinessLog.setAssigneeUserName(assigneeUserInfo.getUserName());
        UserInfo user = this.getUserInfoByUserCode(userInfos, assignorUserCode);
        if (null != user) {
            tenantBusinessLog.setAssignorUserName(user.getUserName());
        }
        tenantBusinessLog.setApplyBusinessTime(this.nowDate());
        tenantBusinessLog.setSuccessBusinessTime(this.nowDate());
        tenantBusinessLog.setBusinessState("T");
        tenantBusinessLog.setBusinessId(null);
        this.tenantBusinessLogDao.saveNewObject(tenantBusinessLog);
        TenantInfo dbTenantInfo = (TenantInfo)this.tenantInfoDao.getObjectById(tenantBusinessLog.getTopUnit());
        if (null == dbTenantInfo) {
            return ResponseData.makeErrorMessage((String)"\u79df\u6237\u4fe1\u606f\u4e0d\u5b58\u5728!");
        }
        dbTenantInfo.setOwnUser(tenantBusinessLog.getAssigneeUserCode());
        this.tenantInfoDao.updateObject(dbTenantInfo);
        WorkGroupParameter workGroupParameter = new WorkGroupParameter(dbTenantInfo.getTopUnit(), tenantBusinessLog.getAssigneeUserCode(), "ZHGLY");
        WorkGroup workGroup = new WorkGroup();
        workGroup.setWorkGroupParameter(workGroupParameter);
        this.updateWorkGroupRole(workGroup);
        return ResponseData.makeSuccessResponse((String)"\u8f6c\u8ba9\u7533\u8bf7\u63d0\u4ea4\u6210\u529f!");
    }

    @Override
    @Transactional
    public ResponseData adminCheckTenantBusiness(TenantBusinessLog tenantBusinessLog) {
        if (StringUtils.isBlank((CharSequence)tenantBusinessLog.getBusinessId())) {
            return ResponseData.makeErrorMessage((String)"businessId\u5b57\u6bb5\u5c5e\u6027\u503c\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        String businessState = tenantBusinessLog.getBusinessState();
        if (!StringUtils.equalsAny((CharSequence)businessState, (CharSequence[])new CharSequence[]{"T", "F"})) {
            return ResponseData.makeErrorMessage((String)"businessState\u5b57\u6bb5\u5c5e\u6027\u503c\u6709\u8bef");
        }
        this.tenantBusinessLogDao.updateObject(tenantBusinessLog);
        if ("T".equals(businessState)) {
            TenantInfo tenantInfo = new TenantInfo();
            tenantInfo.setTopUnit(tenantBusinessLog.getTopUnit());
            tenantInfo.setOwnUser(tenantBusinessLog.getAssigneeUserCode());
            this.tenantInfoDao.updateObject(tenantInfo);
            WorkGroupParameter groupParameter = new WorkGroupParameter(tenantInfo.getTopUnit(), tenantInfo.getOwnUser(), "ZHGLY");
            WorkGroup workGroup = new WorkGroup();
            workGroup.setWorkGroupParameter(groupParameter);
            this.updateWorkGroupRole(workGroup);
        }
        return ResponseData.makeSuccessResponse();
    }

    @Override
    public PageQueryResult pageListTenantApply(PageListTenantInfoQo tenantInfo, PageDesc pageDesc) {
        if (this.tenantPowerManage.userIsSystemMember()) {
            tenantInfo.setOwnUser(null);
        } else {
            tenantInfo.setOwnUser(WebOptUtils.getCurrentUserCode((HttpServletRequest)RequestThreadLocal.getLocalThreadWrapperRequest()));
        }
        List<TenantInfo> tenantInfos = this.tenantInfoDao.listObjectsByProperties(tenantInfo, pageDesc);
        return PageQueryResult.createResult((Collection)this.translateTenantInfos(tenantInfos), (PageDesc)pageDesc);
    }

    @Override
    public PageQueryResult pageListTenantMember(Map<String, Object> params, PageDesc pageDesc) {
        String topUnit = MapUtils.getString(params, (Object)"topUnit");
        if (StringUtils.isBlank((CharSequence)topUnit)) {
            throw new ObjectException("topUnit \u4e0d\u80fd\u4e3a\u7a7a");
        }
        JSONArray userInfoJsonArray = this.userInfoDao.listUsersWithUnit(params, pageDesc);
        if (userInfoJsonArray.size() == 0) {
            return PageQueryResult.createJSONArrayResult((JSONArray)userInfoJsonArray, (PageDesc)pageDesc);
        }
        return PageQueryResult.createResult((Collection)userInfoJsonArray, (PageDesc)pageDesc);
    }

    @Override
    @Transactional
    public ResponseData assignTenantRole(TenantMemberQo tenantMemberQo) {
        String checkString = this.optTenantRoleCheck(tenantMemberQo);
        if (StringUtils.isNotBlank((CharSequence)checkString)) {
            return ResponseData.makeErrorMessage((String)checkString);
        }
        if (!StringUtils.equals((CharSequence)tenantMemberQo.getRoleCode(), (CharSequence)"ZHGLY")) {
            return ResponseData.makeErrorMessage((String)"\u89d2\u8272\u4ee3\u7801\u6709\u8bef!");
        }
        this.updateWorkGroupRole(tenantMemberQo, tenantMemberQo.getTopUnit());
        return ResponseData.makeSuccessResponse((String)"\u64cd\u4f5c\u6210\u529f!");
    }

    @Override
    @Transactional
    public ResponseData deleteTenantRole(TenantMemberQo tenantMemberQo) {
        String checkString = this.optTenantRoleCheck(tenantMemberQo);
        if (StringUtils.isNotBlank((CharSequence)checkString)) {
            return ResponseData.makeErrorMessage((String)checkString);
        }
        boolean memberIsTenantOwner = this.tenantPowerManage.userIsTenantOwner(tenantMemberQo.getMemberUserCode(), tenantMemberQo.getTopUnit());
        if (memberIsTenantOwner) {
            return ResponseData.makeErrorMessage((String)"\u79df\u6237\u6240\u6709\u8005\u7684\u7ba1\u7406\u5458\u89d2\u8272\u4e0d\u5141\u8bb8\u88ab\u5220\u9664!");
        }
        WorkGroup workGroup = new WorkGroup();
        WorkGroupParameter workGroupParameter = new WorkGroupParameter(tenantMemberQo.getTopUnit(), tenantMemberQo.getMemberUserCode(), tenantMemberQo.getRoleCode());
        workGroup.setWorkGroupParameter(workGroupParameter);
        this.workGroupDao.deleteObject((Serializable)workGroup);
        return ResponseData.makeSuccessResponse((String)"\u5220\u9664\u6210\u529f!");
    }

    private String optTenantRoleCheck(TenantMemberQo tenantMemberQo) {
        boolean userHasPower;
        boolean check = StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{tenantMemberQo.getRoleCode(), tenantMemberQo.getMemberUserCode(), tenantMemberQo.getTopUnit()});
        if (check) {
            return "\u53c2\u6570roleCode,topUnit,memberUserCode\u4e0d\u80fd\u4e3a\u7a7a!";
        }
        String topUnit = tenantMemberQo.getTopUnit();
        boolean bl = userHasPower = this.tenantPowerManage.userIsTenantOwner(topUnit) || this.tenantPowerManage.userIsTenantAdmin(topUnit);
        if (!userHasPower) {
            return "\u5f53\u524d\u4eba\u5458\u6ca1\u6709\u64cd\u4f5c\u6743\u9650!";
        }
        return null;
    }

    @Override
    public JSONArray userTenants(String userCode) {
        List<TenantInfo> tenantInfos = this.tenantInfoDao.listUserTenant(CollectionsOpt.createHashMap((Object[])new Object[]{"userCode", userCode}));
        if (CollectionUtils.sizeIsEmpty(tenantInfos)) {
            return new JSONArray();
        }
        return this.formatTenants(userCode, tenantInfos);
    }

    @Override
    public PageQueryResult pageListTenants(Map<String, Object> filterMap, PageDesc pageDesc) {
        JSONArray jsonArray = this.tenantInfoDao.listTenantInfoWithOwnUserName(filterMap, pageDesc);
        return PageQueryResult.createResult((Collection)jsonArray, (PageDesc)pageDesc);
    }

    @Override
    public List<UserInfo> searchUsers(Map<String, Object> paramMap) {
        String userName = MapUtils.getString(paramMap, (Object)"userName");
        String regCellPhone = MapUtils.getString(paramMap, (Object)"regCellPhone");
        String loginName = MapUtils.getString(paramMap, (Object)"loginName");
        String email = MapUtils.getString(paramMap, (Object)"regEmail");
        if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{userName, regCellPhone, loginName, email})) {
            throw new ObjectException(611, "\u7528\u6237\u540d\u3001\u767b\u5f55\u540d\u3001\u7535\u8bdd\u548cEMail\u81f3\u5c11\u8f93\u5165\u4e00\u4e2a\u53c2\u6570\u3002");
        }
        paramMap.remove("unitCode");
        return this.userInfoDao.listObjectsByProperties(paramMap);
    }

    @Override
    public ResponseData findUsers(Map<String, Object> paramMap) {
        String unitCode = MapUtils.getString(paramMap, (Object)"unitCode");
        String userName = MapUtils.getString(paramMap, (Object)"userName");
        String regCellPhone = MapUtils.getString(paramMap, (Object)"regCellPhone");
        String userCode = MapUtils.getString(paramMap, (Object)"userCode");
        String email = MapUtils.getString(paramMap, (Object)"regEmail");
        String loginName = MapUtils.getString(paramMap, (Object)"loginName");
        if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{userName, regCellPhone, userCode, email, loginName})) {
            return ResponseData.makeResponseData((Object)"");
        }
        if (StringUtils.isBlank((CharSequence)unitCode)) {
            return ResponseData.makeErrorMessage((String)"unitCode\u4e0d\u80fd\u4e3a\u7a7a");
        }
        paramMap.remove("unitCode");
        List<UserInfo> userInfos = this.userInfoDao.listObjectsByProperties(paramMap);
        if (CollectionUtils.sizeIsEmpty((Object)userInfos)) {
            return ResponseData.makeResponseData((Object)CollectionUtils.emptyCollection());
        }
        Set userInfoUserCodes = userInfos.stream().map(UserInfo::getUserCode).collect(Collectors.toSet());
        Map filterMap = CollectionsOpt.createHashMap((Object[])new Object[]{"userCode_in", CollectionsOpt.listToArray(userInfoUserCodes), "topUnit", unitCode, "applyState_in", TenantMemberApplyDao.NOT_APPROVE_ARRAY});
        List alreadyApply = this.tenantMemberApplyDao.listObjectsByProperties(filterMap);
        List applyUserCodes = alreadyApply.stream().map(TenantMemberApply::getUserCode).collect(Collectors.toList());
        List userUnits = this.userUnitDao.listObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"topUnit", unitCode}));
        userInfos = userInfos.stream().filter(userInfo -> null == this.getUserUnitByUserCode(userUnits, userInfo.getUserCode()) && !applyUserCodes.contains(userInfo.getUserCode())).collect(Collectors.toList());
        userInfos.forEach(userInfo -> {
            userInfo.setUserPwd(null);
            userInfo.setUserPin(null);
            userInfo.setRegCellPhone(DesensitizeOptUtils.phone((String)userInfo.getRegCellPhone()));
        });
        return ResponseData.makeResponseData(userInfos);
    }

    @Override
    @Transactional
    public ResponseData cancelApply(Map<String, Object> parameters) {
        TenantMemberApply tenantMemberApply = (TenantMemberApply)this.tenantMemberApplyDao.getObjectByProperties(parameters);
        if (null != tenantMemberApply && StringUtils.equalsAny((CharSequence)tenantMemberApply.getApplyState(), (CharSequence[])new CharSequence[]{"1", "2"})) {
            this.tenantMemberApplyDao.deleteObject(tenantMemberApply);
        }
        return ResponseData.makeSuccessResponse();
    }

    @Override
    @Transactional
    public ResponseData deleteTenant(Map<String, Object> parameters) {
        String topUnit = MapUtils.getString(parameters, (Object)"topUnit");
        if (!this.tenantPowerManage.userIsTenantOwner(topUnit)) {
            return ResponseData.makeErrorMessage((String)"\u53ea\u6709\u79df\u6237\u6240\u6709\u8005\u624d\u80fd\u6ce8\u9500\u79df\u6237");
        }
        this.tenantInfoDao.deleteObjectById(topUnit);
        this.unitInfoDao.deleteObjectById(topUnit);
        this.userRoleDao.deleteObjectById(new UserRoleId(MapUtils.getString(parameters, (Object)"userCode"), "sysadmin"));
        this.userUnitDao.deleteObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"topUnit", topUnit}));
        this.workGroupDao.deleteObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"groupId", topUnit}));
        List dataCatalogs = this.dataCatalogDao.listDataCatalogByUnit(topUnit);
        if (!CollectionUtils.sizeIsEmpty((Object)dataCatalogs)) {
            List dataCatalogIds = dataCatalogs.stream().map(DataCatalog::getCatalogCode).collect(Collectors.toList());
            this.dataCatalogDao.deleteObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"topUnit", topUnit}));
            this.dataDictionaryDao.deleteObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"catalogCode_in", CollectionsOpt.listToArray(dataCatalogIds)}));
        }
        this.reloadAuthentication(MapUtils.getString(parameters, (Object)"userCode"));
        this.batchEvictCache(topUnit, "UnitInfo", "UserUnit", "DataDictionary");
        return ResponseData.makeSuccessResponse();
    }

    @Override
    @Transactional
    public ResponseData updateTenant(TenantInfo tenantInfo) {
        if (StringUtils.isBlank((CharSequence)tenantInfo.getTopUnit())) {
            return ResponseData.makeErrorMessage((String)"topUnit \u4e0d\u80fd\u4e3a\u7a7a!");
        }
        boolean isSystemAdmin = this.tenantPowerManage.userIsSystemAdmin();
        TenantInfo dbTenant = (TenantInfo)this.tenantInfoDao.getObjectById(tenantInfo);
        if (isSystemAdmin) {
            this.tenantInfoDao.updateObject(tenantInfo);
        }
        boolean isTenantManage = this.tenantPowerManage.userIsTenantAdmin(tenantInfo.getTopUnit()) || this.tenantPowerManage.userIsTenantOwner(tenantInfo.getTopUnit());
        String oldUnitName = dbTenant.getUnitName();
        if (isTenantManage && !dbTenant.getUnitName().equals(tenantInfo.getUnitName())) {
            dbTenant.setUnitName(tenantInfo.getUnitName());
            this.tenantInfoDao.updateObject(dbTenant);
        }
        if ((isSystemAdmin || isTenantManage) && !oldUnitName.equals(tenantInfo.getUnitName())) {
            UnitInfo unitInfo = this.unitInfoDao.getObjectById(tenantInfo.getTopUnit());
            unitInfo.setUnitName(tenantInfo.getUnitName());
            this.unitInfoDao.updateUnit(unitInfo);
            CodeRepositoryCache.evictCache((String)"UnitInfo", (String)tenantInfo.getTopUnit());
        }
        return ResponseData.makeSuccessResponse((String)"\u4fee\u6539\u6210\u529f!");
    }

    @Override
    @Transactional
    public ResponseData addTenantUnit(UnitInfo unitInfo) {
        Map filterMap;
        List unitInfos;
        if (WebOptUtils.isTenant && this.tenantPowerManage.unitNumberLimitIsOver(unitInfo.getTopUnit())) {
            return ResponseData.makeErrorMessage((String)"\u5355\u4f4d\u6570\u91cf\u8fbe\u5230\u4e0a\u9650!");
        }
        if (this.sysUnitManager.hasSameName(unitInfo)) {
            return ResponseData.makeErrorMessage((int)702, (String)String.format("\u673a\u6784\u540d%s\u5df2\u5b58\u5728\uff0c\u8bf7\u66f4\u6362\uff01", unitInfo.getUnitName()));
        }
        if (StringUtils.isNotBlank((CharSequence)unitInfo.getDepNo()) && (unitInfos = this.sysUnitManager.listObjects(filterMap = CollectionsOpt.createHashMap((Object[])new Object[]{"depNo", unitInfo.getDepNo(), "topUnit", unitInfo.getTopUnit()}))) != null && unitInfos.size() > 0) {
            return ResponseData.makeErrorMessage((int)702, (String)String.format("\u673a\u6784\u7f16\u7801%s\u5df2\u5b58\u5728\uff0c\u8bf7\u66f4\u6362\uff01", unitInfo.getDepNo()));
        }
        if (unitInfo.getUnitOrder() == null || unitInfo.getUnitOrder() == 0L) {
            while (!this.sysUnitManager.isUniqueOrder(unitInfo)) {
                unitInfo.setUnitOrder(Long.valueOf(unitInfo.getUnitOrder() + 1L));
            }
        }
        this.sysUnitManager.saveNewUnitInfo(unitInfo);
        return ResponseData.makeResponseData((Object)unitInfo);
    }

    @Override
    @Transactional
    public ResponseData addTenantUser(UserInfo userInfo, UserUnit userUnit) {
        if (WebOptUtils.isTenant && this.tenantPowerManage.userNumberLimitIsOver(userUnit.getTopUnit())) {
            return ResponseData.makeErrorMessage((String)"\u7528\u6237\u6570\u91cf\u8fbe\u5230\u4e0a\u9650!");
        }
        UserInfo dbUserInfo = this.sysUserManager.loadUserByLoginname(userInfo.getLoginName());
        if (null != dbUserInfo) {
            return ResponseData.makeErrorMessage((int)702, (String)String.format("\u767b\u5f55\u540d%s\u5df2\u5b58\u5728\uff0c\u8bf7\u66f4\u6362\uff01", userInfo.getLoginName()));
        }
        if (CentitPasswordEncoder.checkPasswordStrength((String)userInfo.getUserPwd(), (int)this.passwordMinLength) < this.passwordStrength) {
            throw new ObjectException("\u7528\u6237\u5bc6\u7801\u5f3a\u5ea6\u592a\u4f4e\uff0c\u8bf7\u8f93\u5165\u7b26\u5408\u8981\u6c42\u7684\u5bc6\u7801\uff01");
        }
        if (null != userInfo.getUserRoles()) {
            userInfo.getUserRoles().forEach(userRole -> userRole.setUserCode(userInfo.getUserCode()));
        }
        if (null == userInfo.getUserOrder()) {
            userInfo.setUserOrder(Long.valueOf(1L));
        }
        userUnit.setUserOrder(userInfo.getUserOrder());
        this.sysUserManager.saveNewUserInfo(userInfo, userUnit);
        return ResponseData.makeResponseData((Object)userInfo);
    }

    private JSONArray formatTenants(String userCode, List<TenantInfo> tenantInfos) {
        JSONArray tenantJsonArrays;
        Set topUnitCodes = tenantInfos.stream().map(TenantInfo::getTopUnit).collect(Collectors.toSet());
        ArrayList<WorkGroup> workGroups = new ArrayList();
        if (CollectionUtils.isNotEmpty(topUnitCodes)) {
            workGroups = this.listWorkGroupByUserCodeAndTopUnit(userCode, (String[])CollectionsOpt.listToArray(topUnitCodes));
        }
        if (CollectionUtils.isEmpty((Collection)(tenantJsonArrays = (JSONArray)JSON.toJSON(tenantInfos)))) {
            return tenantJsonArrays;
        }
        for (Object tenantJson : tenantJsonArrays) {
            this.extendTenantsAttribute(userCode, workGroups, (JSONObject)tenantJson);
        }
        return tenantJsonArrays;
    }

    private void extendTenantsAttribute(String userCode, List<WorkGroup> workGroups, JSONObject tenantJson) {
        tenantJson.put((Object)"isOwner", (Object)(MapUtils.getString((Map)tenantJson, (Object)"ownUser").equals(userCode) ? "T" : "F"));
        String topUnit = MapUtils.getString((Map)tenantJson, (Object)"topUnit");
        WorkGroup workGroup = this.getWorkGroupByUserCodeAndTopUnit(userCode, topUnit, workGroups);
        String roleCode = null != workGroup ? workGroup.getWorkGroupParameter().getRoleCode() : "";
        tenantJson.put((Object)"roleCode", (Object)roleCode);
        tenantJson.put((Object)"roleName", (Object)this.translateTenantRole(roleCode));
        boolean isAdmin = MapUtils.getString((Map)tenantJson, (Object)"roleCode", (String)"").equals("ZHGLY") || MapUtils.getString((Map)tenantJson, (Object)"isOwner").equals("T");
        tenantJson.put((Object)"isAdmin", (Object)isAdmin);
        tenantJson.put((Object)"deptMobile", (Object)this.getDeptMobile(topUnit, userCode));
        this.extendTenantsUserRanks((Map)tenantJson, CodeRepositoryUtil.listUserUnits((String)topUnit, (String)userCode));
    }

    private JSONArray getDeptMobile(String topUnit, String userCode) {
        JSONArray jsonArray = new JSONArray();
        List iUserUnitList = CodeRepositoryUtil.listUserUnits((String)topUnit, (String)userCode);
        for (UserUnit userUnit : iUserUnitList) {
            JSONObject jsonObject = JSONObject.from((Object)userUnit);
            jsonObject.put((Object)"unitName", (Object)CodeRepositoryUtil.getValue((String)"unitCode", (String)userUnit.getUnitCode(), (String)topUnit, (String)"zh_CN"));
            jsonObject.put((Object)"userRankText", (Object)CodeRepositoryUtil.getValue((String)"RankType", (String)userUnit.getUserRank(), (String)topUnit, (String)"zh_CN"));
            jsonArray.add((Object)jsonObject);
        }
        return jsonArray;
    }

    private String translateTenantRole(String roleCode) {
        if ("ZHGLY".equals(roleCode)) {
            return "\u7ba1\u7406\u5458";
        }
        return "\u7ec4\u5458";
    }

    private void extendTenantsUserRanks(Map tenantJson, List<UserUnit> userUnits) {
        String topUnit = MapUtils.getString((Map)tenantJson, (Object)"topUnit");
        if (CollectionUtils.sizeIsEmpty(userUnits)) {
            tenantJson.put("deptTree", null);
            return;
        }
        List<UnitInfo> simpleUnitInfos = this.listParentUnitInfo(userUnits, topUnit);
        tenantJson.put("deptTree", this.sortUnitInfosAsTreeAttachUserRank(simpleUnitInfos, userUnits));
    }

    private List<UnitInfo> listParentUnitInfo(List<UserUnit> userUnits, String topUnit) {
        ArrayList<UnitInfo> unitInfos = new ArrayList<UnitInfo>();
        HashSet<String> unitCods = new HashSet<String>();
        block0: for (UserUnit userUnit : userUnits) {
            UnitInfo unitInfo;
            String unitCode = userUnit.getUnitCode();
            while (null != (unitInfo = CodeRepositoryUtil.getUnitInfoByCode((String)topUnit, (String)unitCode))) {
                if (StringUtils.isBlank((CharSequence)unitInfo.getParentUnit()) || unitInfo.getUnitCode().equals(unitInfo.getParentUnit()) || "0".equals(unitInfo.getParentUnit())) {
                    if (!unitCods.add(unitInfo.getUnitCode())) continue block0;
                    unitInfos.add(unitInfo);
                    continue block0;
                }
                if (unitCods.add(unitInfo.getUnitCode())) {
                    unitInfos.add(unitInfo);
                }
                if (StringUtils.isBlank((CharSequence)unitInfo.getParentUnit())) continue block0;
                unitCode = unitInfo.getParentUnit();
            }
        }
        return unitInfos;
    }

    private JSONObject appendUserRank(JSONObject unitInfoJsonObject, List<UserUnit> userUnits) {
        if (unitInfoJsonObject == null) {
            return null;
        }
        List userUnitMatch = userUnits.stream().filter(un -> unitInfoJsonObject.getString("unitCode").equals(un.getUnitCode())).collect(Collectors.toList());
        if (CollectionUtils.sizeIsEmpty(userUnitMatch)) {
            return unitInfoJsonObject;
        }
        ArrayList<HashMap<String, Object>> userRankList = new ArrayList<HashMap<String, Object>>();
        for (UserUnit unitMatch : userUnitMatch) {
            if (this.findMapListKeyIndex(userRankList, "userRank", unitMatch.getUserRank()) != -1) continue;
            HashMap<String, String> userRankMap = new HashMap<String, String>();
            userRankMap.put("userUnitId", unitMatch.getUserUnitId());
            DataDictionary rankTypeDic = CodeRepositoryUtil.getDataPiece((String)"RankType", (String)unitMatch.getUserRank(), (String)unitMatch.getTopUnit());
            userRankMap.put("userRank", unitMatch.getUserRank());
            userRankMap.put("userRankText", null == rankTypeDic ? "" : rankTypeDic.getDataValue());
            userRankList.add(userRankMap);
        }
        unitInfoJsonObject.put((Object)"userRankList", userRankList);
        return unitInfoJsonObject;
    }

    private int findMapListKeyIndex(List<HashMap<String, Object>> mapList, String key, String value) {
        for (int i = 0; i < mapList.size(); ++i) {
            if (value == null || !value.equals(MapUtils.getString((Map)mapList.get(i), (Object)key))) continue;
            return i;
        }
        return -1;
    }

    private WorkGroup getWorkGroupByUserCodeAndTopUnit(String userCode, String topUnit, List<WorkGroup> workGroups) {
        if (CollectionUtils.sizeIsEmpty(workGroups)) {
            return null;
        }
        for (WorkGroup workGroup : workGroups) {
            WorkGroupParameter workGroupParameter = workGroup.getWorkGroupParameter();
            if (!userCode.equals(workGroupParameter.getUserCode()) || !topUnit.equals(workGroupParameter.getGroupId())) continue;
            return workGroup;
        }
        return null;
    }

    private void updateWorkGroupRole(TenantMemberQo tenantMemberQo, String topUnit) {
        WorkGroup workGroup = new WorkGroup();
        WorkGroupParameter workGroupParameter = new WorkGroupParameter();
        workGroupParameter.setGroupId(topUnit);
        workGroupParameter.setUserCode(tenantMemberQo.getMemberUserCode());
        workGroupParameter.setRoleCode(tenantMemberQo.getRoleCode());
        workGroup.setWorkGroupParameter(workGroupParameter);
        workGroup.setUpdateDate(this.nowDate());
        workGroup.setUpdator(WebOptUtils.getCurrentUserCode((HttpServletRequest)RequestThreadLocal.getLocalThreadWrapperRequest()));
        this.updateWorkGroupRole(workGroup);
    }

    private void updateWorkGroupRole(WorkGroup workGroup) {
        Map hashMap = CollectionsOpt.createHashMap((Object[])new Object[]{"groupId", workGroup.getWorkGroupParameter().getGroupId(), "userCode", workGroup.getWorkGroupParameter().getUserCode()});
        List workGroups = this.workGroupDao.listObjectsByProperties(hashMap);
        if (workGroups.size() > 1) {
            throw new ObjectException("\u68c0\u6d4b\u5230\u8be5\u4eba\u5458\u5728\u4e00\u4e2a\u79df\u6237\u4e2d\u7684\u89d2\u8272\u4e2a\u6570\u5927\u4e8e\u4e00\u4e2a\uff0c\u64cd\u4f5c\u505c\u6b62!");
        }
        if (workGroups.size() == 1) {
            WorkGroupParameter workGroupParameter = ((WorkGroup)workGroups.get(0)).getWorkGroupParameter();
            workGroup.getWorkGroupParameter().setRoleCode(workGroupParameter.getRoleCode());
            this.workGroupManager.updateWorkGroup(workGroup);
        }
        if (workGroups.size() == 0) {
            workGroup.setCreator(WebOptUtils.getCurrentUserCode((HttpServletRequest)RequestThreadLocal.getLocalThreadWrapperRequest()));
            workGroup.setAuthTime(this.nowDate());
            this.workGroupDao.saveNewObject((Serializable)workGroup);
        }
    }

    private Date nowDate() {
        return new Date(System.currentTimeMillis());
    }

    private boolean checkUserAccountHasExist(UserInfo userInfo) {
        UserInfo oldUserInfo;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("g0_loginName", userInfo.getLoginName());
        map.put("g1_userName", userInfo.getUserName());
        if (StringUtils.isNotBlank((CharSequence)userInfo.getRegEmail())) {
            map.put("g2_regEmail", userInfo.getRegEmail());
        }
        if (StringUtils.isNotBlank((CharSequence)userInfo.getRegCellPhone())) {
            map.put("g3_regCellPhone", userInfo.getRegCellPhone());
        }
        if (StringUtils.isNotBlank((CharSequence)userInfo.getIdCardNo())) {
            map.put("g4_idCardNo", userInfo.getIdCardNo());
        }
        return null != (oldUserInfo = (UserInfo)this.userInfoDao.getObjectByProperties(map));
    }

    private void saveUserUnitByTenantAndUnit(TenantInfo tenantInfo, UnitInfo unitInfo) {
        UserUnit userUnit = new UserUnit();
        userUnit.setUserUnitId(UuidOpt.getUuidAsString32());
        userUnit.setUserCode(tenantInfo.getOwnUser());
        userUnit.setUserOrder(Long.valueOf(1L));
        userUnit.setUnitCode(unitInfo.getUnitCode());
        userUnit.setTopUnit(unitInfo.getTopUnit());
        userUnit.setCreateDate(unitInfo.getCreateDate());
        userUnit.setCreator(tenantInfo.getOwnUser());
        userUnit.setRelType("T");
        this.userUnitDao.saveNewObject((Serializable)userUnit);
    }

    private UnitInfo saveUnitInfoByTenantInfo(TenantInfo tenantInfo) {
        UnitInfo unitInfo = new UnitInfo();
        unitInfo.setCreateDate(tenantInfo.getCreateTime());
        unitInfo.setCreator(tenantInfo.getCreator());
        unitInfo.setIsValid("T");
        unitInfo.setTopUnit(tenantInfo.getTopUnit());
        unitInfo.setUnitCode(tenantInfo.getTopUnit());
        unitInfo.setUnitWord(tenantInfo.getTopUnit());
        unitInfo.setUnitManager(tenantInfo.getCreator());
        unitInfo.setUnitName(tenantInfo.getUnitName());
        unitInfo.setUnitShortName(tenantInfo.getUnitName());
        unitInfo.setUnitOrder(Long.valueOf(1L));
        unitInfo.setUnitType("T");
        unitInfo.setUnitPath("/" + tenantInfo.getTopUnit());
        this.unitInfoDao.saveNewObject((Serializable)unitInfo);
        return unitInfo;
    }

    private TenantInfo saveTenantInfo(TenantInfo tenantInfo) {
        Date currentDate = this.nowDate();
        tenantInfo.setPassTime(null);
        tenantInfo.setMemo(null);
        tenantInfo.setIsAvailable(null);
        tenantInfo.setApplyTime(currentDate);
        tenantInfo.setCreateTime(currentDate);
        tenantInfo.setTopUnit(null);
        tenantInfo.setDataSpaceLimit(0);
        tenantInfo.setFileSpaceLimit(0);
        tenantInfo.setDatabaseNumberLimit(0);
        tenantInfo.setOsNumberLimit(0);
        this.tenantInfoDao.saveNewObject(tenantInfo);
        return tenantInfo;
    }

    private void saveTenantUserUnit(TenantMemberApply tenantMemberApply) {
        List userUnits;
        UserInfo userInfo = (UserInfo)this.userInfoDao.getObjectById((Object)CollectionsOpt.createHashMap((Object[])new Object[]{"userCode", tenantMemberApply.getUserCode()}));
        userInfo.setIsValid("T");
        this.userInfoDao.updateObject((Serializable)userInfo);
        TenantMemberApply oldTenantMemberApply = (TenantMemberApply)this.tenantMemberApplyDao.getObjectById(tenantMemberApply);
        if (StringUtils.isBlank((CharSequence)oldTenantMemberApply.getUnitCode())) {
            oldTenantMemberApply.setUnitCode(oldTenantMemberApply.getTopUnit());
        }
        if ((userUnits = this.userUnitDao.listObjectByUserUnit(oldTenantMemberApply.getUserCode(), oldTenantMemberApply.getUnitCode())).size() == 0) {
            UserUnit userUnit = new UserUnit();
            userUnit.setRelType("T");
            userUnit.setUserCode(oldTenantMemberApply.getUserCode());
            userUnit.setUnitCode(oldTenantMemberApply.getUnitCode());
            userUnit.setTopUnit(oldTenantMemberApply.getTopUnit());
            userUnit.setUserOrder(Long.valueOf(1L));
            userUnit.setCreator(oldTenantMemberApply.getInviterUserCode());
            this.userUnitDao.saveNewObject((Serializable)userUnit);
        }
    }

    private JSONArray formatMemberApply(List<TenantMemberApply> tenantMemberApplies) {
        HashSet<String> topUnitCodes = new HashSet<String>();
        HashSet<String> userCodes = new HashSet<String>();
        for (TenantMemberApply tenantMemberApply : tenantMemberApplies) {
            topUnitCodes.add(tenantMemberApply.getTopUnit());
            userCodes.add(tenantMemberApply.getUserCode());
            userCodes.add(tenantMemberApply.getInviterUserCode());
        }
        List<UnitInfo> unitInfos = this.getUnitInfosByUnitCodes(new ArrayList<String>(topUnitCodes));
        List<UserInfo> userInfos = this.getUserInfosByUserCodes(new ArrayList<String>(userCodes));
        JSONArray memberJsonArray = (JSONArray)JSON.toJSON(tenantMemberApplies);
        for (Object member : memberJsonArray) {
            JSONObject jsonMember = (JSONObject)member;
            UnitInfo unitInfo = this.getUnitInfoByUnitCode(unitInfos, jsonMember.getString("topUnit"));
            UserInfo userInfo = this.getUserInfoByUserCode(userInfos, jsonMember.getString("userCode"));
            UserInfo inviterUserInfo = this.getUserInfoByUserCode(userInfos, jsonMember.getString("inviterUserCode"));
            if (null != unitInfo) {
                jsonMember.put((Object)"unitName", (Object)unitInfo.getUnitName());
            }
            if (null != userInfo) {
                jsonMember.put((Object)"userName", (Object)userInfo.getUserName());
                jsonMember.put((Object)"loginName", (Object)userInfo.getLoginName());
            }
            if (null == inviterUserInfo) continue;
            jsonMember.put((Object)"inviterUserName", (Object)inviterUserInfo.getUserName());
        }
        return memberJsonArray;
    }

    private List<UnitInfo> getUnitInfosByUnitCodes(List<String> topUnitCodes) {
        HashMap<String, Object[]> topUnitParamMap = new HashMap<String, Object[]>();
        topUnitParamMap.put("unitCode_in", CollectionsOpt.listToArray(topUnitCodes));
        return this.unitInfoDao.listObjectsByProperties(topUnitParamMap);
    }

    private List<UserInfo> getUserInfosByUserCodes(List<String> userCodes) {
        HashMap<String, Object[]> userCodeParamMap = new HashMap<String, Object[]>();
        userCodeParamMap.put("userCode_in", CollectionsOpt.listToArray(userCodes));
        return this.userInfoDao.listObjectsByProperties(userCodeParamMap);
    }

    private UnitInfo getUnitInfoByUnitCode(List<UnitInfo> unitInfos, String topUnit) {
        for (UnitInfo unitInfo : unitInfos) {
            if (!topUnit.equals(unitInfo.getUnitCode())) continue;
            return unitInfo;
        }
        return null;
    }

    private UserUnit getUserUnitByUserCode(List<UserUnit> userUnits, String userCode) {
        for (UserUnit userUnit : userUnits) {
            if (!userCode.equals(userUnit.getUserCode())) continue;
            return userUnit;
        }
        return null;
    }

    private UserInfo getUserInfoByUserCode(List<UserInfo> userInfos, String userCode) {
        for (UserInfo userInfo : userInfos) {
            if (!userCode.equals(userInfo.getUserCode())) continue;
            return userInfo;
        }
        return null;
    }

    private List<WorkGroup> listWorkGroupByUserCodeAndTopUnit(String userCode, String ... topUnits) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (null != topUnits && topUnits.length > 0) {
            map.put("groupId_in", topUnits);
        }
        map.put("userCode", userCode);
        return this.workGroupDao.listObjectsByProperties(map);
    }

    private void saveTenantOwnerToWorkGroup(TenantInfo tenantInfo) {
        WorkGroup workGroup = new WorkGroup();
        WorkGroupParameter workGroupParameter = new WorkGroupParameter();
        workGroupParameter.setRoleCode("ZHGLY");
        workGroupParameter.setGroupId(tenantInfo.getTopUnit());
        workGroupParameter.setUserCode(tenantInfo.getOwnUser());
        workGroup.setWorkGroupParameter(workGroupParameter);
        workGroup.setCreator(WebOptUtils.getCurrentUserCode((HttpServletRequest)((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest()));
        workGroup.setIsValid("T");
        this.workGroupManager.createWorkGroup(workGroup);
    }

    private void saveTenantRelationData(TenantInfo oldTenantInfo) {
        UnitInfo unitInfo = this.saveUnitInfoByTenantInfo(oldTenantInfo);
        this.saveUserUnitByTenantAndUnit(oldTenantInfo, unitInfo);
        this.saveTenantOwnerToWorkGroup(oldTenantInfo);
        this.saveUserRole(oldTenantInfo.getOwnUser(), "sysadmin");
        this.initTenantDictionary(oldTenantInfo.getTopUnit(), oldTenantInfo.getOwnUser());
    }

    private void saveUserRole(String userCode, String roleCode) {
        List userRoles = this.userRoleDao.listObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"userCode", userCode, "roleCode", roleCode}));
        if (!CollectionUtils.sizeIsEmpty((Object)userRoles)) {
            return;
        }
        UserRole userRole = new UserRole();
        UserRoleId userRoleId = new UserRoleId();
        userRoleId.setRoleCode(roleCode);
        userRoleId.setUserCode(userCode);
        userRole.setId(userRoleId);
        userRole.setObtainDate(new Date(System.currentTimeMillis()));
        userRole.setCreator(WebOptUtils.getCurrentUserCode((HttpServletRequest)RequestThreadLocal.getLocalThreadWrapperRequest()));
        this.userRoleDao.saveNewObject((Serializable)userRole);
    }

    private void initTenantDictionary(String topUnitCode, String userCode) {
        DataCatalog userTypeDataCatalog = this.defaultDataCatalog(userCode, topUnitCode, "-UT", "\u7528\u6237\u7c7b\u578b");
        this.dataCatalogDao.saveNewObject((Serializable)userTypeDataCatalog);
        String[][] userTypeElements = new String[][]{{userTypeDataCatalog.getCatalogCode(), "U", "\u666e\u901a\u7528\u6237"}};
        this.batchSaveDataDictionary(userTypeElements);
        DataCatalog unitTypeDataCatalog = this.defaultDataCatalog(userCode, topUnitCode, "-DT", "\u673a\u6784\u7c7b\u522b");
        this.dataCatalogDao.saveNewObject((Serializable)unitTypeDataCatalog);
        String unitTypeCatalogCode = unitTypeDataCatalog.getCatalogCode();
        String[][] unitTypeElements = new String[][]{{unitTypeCatalogCode, "A", "\u4e00\u822c\u673a\u6784"}, {unitTypeCatalogCode, "I", "\u9879\u76ee\u7ec4"}, {unitTypeCatalogCode, "O", "\u4e1a\u52a1\u673a\u6784"}};
        this.batchSaveDataDictionary(unitTypeElements);
        DataCatalog rankTypeDataCatalog = this.defaultDataCatalog(userCode, topUnitCode, "-RT", "\u804c\u4f4d");
        this.dataCatalogDao.saveNewObject((Serializable)rankTypeDataCatalog);
        String rankTypeCatalogCode = rankTypeDataCatalog.getCatalogCode();
        String[][] rankTypeElements = new String[][]{{rankTypeCatalogCode, "CM", "\u8463\u4e8b\u957f"}, {rankTypeCatalogCode, "DM", "\u90e8\u95e8\u7ecf\u7406"}, {rankTypeCatalogCode, "FG", "\u5206\u7ba1\u9ad8\u5c42"}, {rankTypeCatalogCode, "GM", "\u603b\u7ecf\u7406"}, {rankTypeCatalogCode, "PM", "\u526f\u603b\u7ecf\u7406"}, {rankTypeCatalogCode, "YG", "\u666e\u901a\u5458\u5de5"}};
        this.batchSaveDataDictionary(rankTypeElements);
        DataCatalog stationTypeDataCatalog = this.defaultDataCatalog(userCode, topUnitCode, "-ST", "\u7528\u6237\u5c97\u4f4d");
        this.dataCatalogDao.saveNewObject((Serializable)stationTypeDataCatalog);
        String[][] stationTypeElements = new String[][]{{stationTypeDataCatalog.getCatalogCode(), "PT", "\u666e\u901a\u5c97\u4f4d"}, {stationTypeDataCatalog.getCatalogCode(), "LD", "\u9886\u5bfc\u5c97\u4f4d"}};
        this.batchSaveDataDictionary(stationTypeElements);
        DataCatalog postRankDataCatalog = this.defaultDataCatalog(userCode, topUnitCode, "-PR", "\u804c\u7ea7");
        this.dataCatalogDao.saveNewObject((Serializable)postRankDataCatalog);
        String[][] postRankElements = new String[][]{{postRankDataCatalog.getCatalogCode(), "ZJ", "\u4e13\u5bb6"}, {postRankDataCatalog.getCatalogCode(), "GCS", "\u5de5\u7a0b\u5e08"}};
        this.batchSaveDataDictionary(postRankElements);
    }

    private DataCatalog defaultDataCatalog(String createUser, String topUnitCode, String catalogCodeSuffix, String catalogName) {
        DataCatalog dataCatalog = new DataCatalog();
        dataCatalog.setCreator(createUser);
        dataCatalog.setCatalogName(catalogName);
        dataCatalog.setTopUnit(topUnitCode);
        dataCatalog.setCatalogCode(topUnitCode + catalogCodeSuffix);
        dataCatalog.setCatalogType("L");
        dataCatalog.setCatalogStyle("S");
        return dataCatalog;
    }

    private void batchSaveDataDictionary(String[] ... elements) {
        if (null == elements || elements.length == 0) {
            return;
        }
        for (int i = 0; i < elements.length; ++i) {
            DataDictionary dataDictionary = this.defaultDataDictionary(elements[i][0], elements[i][1], elements[i][2]);
            dataDictionary.setDataOrder(Integer.valueOf(i));
            this.dataDictionaryDao.saveNewObject((Serializable)dataDictionary);
        }
    }

    private DataDictionary defaultDataDictionary(String catalogCode, String dataCode, String dataValue) {
        DataDictionary dataDictionary = new DataDictionary();
        DataDictionaryId dataDictionaryId = new DataDictionaryId();
        dataDictionaryId.setCatalogCode(catalogCode);
        dataDictionaryId.setDataCode(dataCode);
        dataDictionary.setId(dataDictionaryId);
        dataDictionary.setDataValue(dataValue);
        dataDictionary.setDataStyle("S");
        dataDictionary.setDataTag("T");
        return dataDictionary;
    }

    private void saveTenantDefaultResourcesAttribute(TenantInfo tenantInfo, TenantInfo oldTenantInfo) {
        if (null == tenantInfo.getDatabaseNumberLimit() || tenantInfo.getDatabaseNumberLimit() == 0) {
            oldTenantInfo.setDatabaseNumberLimit(this.databaseNumberLimit);
        }
        if (null == tenantInfo.getOsNumberLimit() || tenantInfo.getOsNumberLimit() == 0) {
            oldTenantInfo.setOsNumberLimit(this.osNumberLimit);
        }
        if (null == tenantInfo.getDataSpaceLimit() || tenantInfo.getDataSpaceLimit() == 0) {
            oldTenantInfo.setDataSpaceLimit(this.dataSpaceLimit);
        }
        if (null == tenantInfo.getFileSpaceLimit() || tenantInfo.getFileSpaceLimit() == 0) {
            oldTenantInfo.setFileSpaceLimit(this.fileSpaceLimit);
        }
        if (null == tenantInfo.getUserNumberLimit() || tenantInfo.getUserNumberLimit() == 0) {
            oldTenantInfo.setUserNumberLimit(this.userNumberLimit);
        }
        if (null == tenantInfo.getUnitNumberLimit() || tenantInfo.getUnitNumberLimit() == 0) {
            oldTenantInfo.setUnitNumberLimit(this.unitNumberLimit);
        }
        oldTenantInfo.setPassTime(this.nowDate());
    }

    private void initTenant(TenantInfo newTenantInfo, TenantInfo oldTenantInfo) {
        UserInfo userInfo = this.userInfoDao.getUserByCode(oldTenantInfo.getOwnUser());
        if (StringUtils.isBlank((CharSequence)userInfo.getTopUnit())) {
            userInfo.setIsValid("T");
            userInfo.setTopUnit(oldTenantInfo.getTopUnit());
            userInfo.setPrimaryUnit(oldTenantInfo.getTopUnit());
            this.userInfoDao.updateUser(userInfo);
        }
        this.saveTenantDefaultResourcesAttribute(newTenantInfo, oldTenantInfo);
        oldTenantInfo.setIsAvailable("T");
        this.tenantInfoDao.updateObject(oldTenantInfo);
        this.saveTenantRelationData(oldTenantInfo);
    }

    private void batchEvictCache(String topUnit, String ... cacheNames) {
        for (String cacheName : cacheNames) {
            if (StringUtils.isNotBlank((CharSequence)topUnit)) {
                CodeRepositoryCache.evictCache((String)cacheName, (String)topUnit);
                continue;
            }
            CodeRepositoryCache.evictCache((String)cacheName);
        }
    }

    private JSONObject sortUnitInfosAsTreeAttachUserRank(List<UnitInfo> listObjects, List<UserUnit> userUnits) {
        JSONArray unitInfoJsonArray = (JSONArray)JSON.toJSON(listObjects);
        block0: for (JSONObject unitInfoJsonObject : unitInfoJsonArray) {
            String parentUnit = unitInfoJsonObject.getString("parentUnit");
            if (StringBaseOpt.isNvl((String)parentUnit) || "0".equals(parentUnit)) continue;
            for (Object o : unitInfoJsonArray) {
                JSONObject opt = (JSONObject)o;
                if (!opt.getString("unitCode").equals(parentUnit)) continue;
                JSONArray children = opt.getJSONArray("children");
                JSONObject jsonObject = this.appendUserRank(unitInfoJsonObject, userUnits);
                unitInfoJsonObject.put((Object)"userRankList", (Object)jsonObject.getJSONArray("userRankList"));
                children.add((Object)unitInfoJsonObject);
                continue block0;
            }
        }
        for (Object o : unitInfoJsonArray) {
            JSONObject opt = (JSONObject)o;
            String parentUnit = opt.getString("parentUnit");
            if (!StringBaseOpt.isNvl((String)parentUnit) && !"0".equals(parentUnit)) continue;
            JSONObject jsonObject = this.appendUserRank(opt, userUnits);
            opt.put((Object)"userRankList", (Object)jsonObject.getJSONArray("userRankList"));
            return opt;
        }
        return null;
    }

    private void reloadAuthentication(String userCode) {
        CentitUserDetails centitUserDetails = this.platformEnvironment.loadUserDetailsByUserCode(userCode);
        centitUserDetails.setLoginIp(this.getUserIp());
        SecurityContextHolder.getContext().setAuthentication((Authentication)centitUserDetails);
    }

    private String getUserIp() {
        Object principal = SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        if (principal instanceof CentitUserDetails) {
            CentitUserDetails userDetails = (CentitUserDetails)principal;
            return userDetails.getLoginIp();
        }
        return "";
    }

    private JSONArray translateTenantInfos(List<TenantInfo> tenantInfos) {
        JSONArray jsonArray = new JSONArray();
        for (TenantInfo tenantInfo : tenantInfos) {
            Map userRepo = CodeRepositoryUtil.getUserRepo((String)tenantInfo.getTopUnit());
            UserInfo ownUserInfo = (UserInfo)userRepo.get(tenantInfo.getOwnUser());
            JSONObject jsonObject = JSONObject.from((Object)tenantInfo);
            jsonObject.put((Object)"ownUserName", (Object)(null == ownUserInfo ? "" : ownUserInfo.getUserName()));
            jsonArray.add((Object)jsonObject);
        }
        return jsonArray;
    }
}

