/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.tenant.controller;

import com.alibaba.fastjson2.JSONObject;
import com.aliyun.dysmsapi20170525.Client;
import com.aliyun.dysmsapi20170525.models.SendSmsRequest;
import com.aliyun.dysmsapi20170525.models.SendSmsResponseBody;
import com.aliyun.teaopenapi.models.Config;
import com.centit.framework.common.ResponseData;
import com.centit.framework.components.CodeRepositoryCache;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.model.adapter.NotificationCenter;
import com.centit.framework.model.adapter.PlatformEnvironment;
import com.centit.framework.model.basedata.NoticeMessage;
import com.centit.framework.model.basedata.UserInfo;
import com.centit.framework.model.security.CentitUserDetails;
import com.centit.framework.system.dao.UserInfoDao;
import com.centit.support.security.SecurityOptUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/vateCode"})
@Api(value="\u90ae\u7bb1\u3001\u624b\u673a\u53f7\u9a8c\u8bc1\u7801\u63a5\u53e3", tags={"\u90ae\u7bb1\u3001\u624b\u673a\u53f7\u9a8c\u8bc1\u7801\u63a5\u53e3"})
public class VateCodeController
extends BaseController {
    @Value(value="${third.services.aliyun.access.key:}")
    private String accessKeyId;
    @Value(value="${third.services.aliyun.access.secret:}")
    private String accessKeySecret;
    @Autowired
    private NotificationCenter notificationCenter;
    @Autowired
    private UserInfoDao userInfoDao;
    @Autowired
    private PlatformEnvironment platformEnvironment;
    @Autowired(required=false)
    private RedisTemplate<String, JSONObject> redisTemplate;
    private static Pattern pattern = Pattern.compile("[0-9]*");

    @ApiOperation(value="\u9a8c\u8bc1\u552f\u4e00\u6027", notes="\u9a8c\u8bc1\u552f\u4e00\u6027")
    @RequestMapping(value={"/checkOnly"}, method={RequestMethod.POST})
    @WrapUpResponseBody
    public ResponseData checkOnly(@RequestParam(value="loginname") String loginname, HttpServletRequest request) throws Exception {
        UserInfo userInfo;
        String msg = "";
        Matcher isNum = pattern.matcher(loginname);
        if (loginname.indexOf(64) > 0) {
            msg = "\u90ae\u4ef6";
            userInfo = this.userInfoDao.getUserByRegEmail(loginname);
        } else if (loginname.length() == 11 && isNum.matches()) {
            msg = "\u624b\u673a\u53f7";
            userInfo = this.userInfoDao.getUserByRegCellPhone(loginname);
        } else {
            msg = "\u8d26\u53f7";
            userInfo = this.userInfoDao.getUserByLoginName(loginname);
        }
        if (userInfo != null) {
            return ResponseData.makeErrorMessage((String)("\u6b64" + msg + "\u5df2\u88ab\u4f7f\u7528\uff01"));
        }
        return ResponseData.successResponse;
    }

    @ApiOperation(value="\u83b7\u53d6Email\u9a8c\u8bc1\u7801", notes="\u83b7\u53d6Email\u9a8c\u8bc1\u7801")
    @RequestMapping(value={"/getEmailCode"}, method={RequestMethod.POST})
    @WrapUpResponseBody
    public ResponseData getEmailCode(@RequestParam(value="email") String email, HttpServletRequest request) {
        UserInfo userInfo;
        JSONObject jsonObject = (JSONObject)this.redisTemplate.boundValueOps((Object)email).get();
        HashMap<String, Object> bodyMap = new HashMap<String, Object>();
        if (jsonObject != null) {
            Long createTime = jsonObject.getLong("createTime");
            if (System.currentTimeMillis() - createTime < 60000L) {
                bodyMap.put("Message", "\u9a8c\u8bc1\u7801\u53d1\u9001\u65f6\u95f4\u5c0f\u4e8e1\u5206\u949f\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002");
                bodyMap.put("Code", 500);
                return ResponseData.makeResponseData(bodyMap);
            }
            this.redisTemplate.delete((Object)email);
        }
        if ((userInfo = this.userInfoDao.getUserByRegEmail(email)) != null) {
            return ResponseData.makeErrorMessage((String)"\u6b64\u90ae\u7bb1\u5df2\u88ab\u4f7f\u7528\uff01");
        }
        return this.sendEmail(email, request);
    }

    @ApiOperation(value="\u83b7\u53d6\u624b\u673a\u9a8c\u8bc1\u7801", notes="\u83b7\u53d6\u624b\u673a\u9a8c\u8bc1\u7801")
    @RequestMapping(value={"/getPhoneCode"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> getPhoneCode(@RequestParam(value="userCode", required=false) String userCode, @RequestParam(value="phone") String phone, HttpServletRequest request, HttpServletResponse response) throws Exception {
        UserInfo userInfo;
        HashMap<String, Object> result = new HashMap<String, Object>();
        JSONObject jsonObject = (JSONObject)this.redisTemplate.boundValueOps((Object)phone).get();
        HashMap<String, HashMap<String, Object>> map = new HashMap<String, HashMap<String, Object>>();
        HashMap<String, Object> bodyMap = new HashMap<String, Object>();
        if (jsonObject != null) {
            Long createTime = jsonObject.getLong("createTime");
            if (System.currentTimeMillis() - createTime < 60000L) {
                bodyMap.put("Message", "\u9a8c\u8bc1\u7801\u53d1\u9001\u65f6\u95f4\u5c0f\u4e8e1\u5206\u949f\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002");
                bodyMap.put("Code", 500);
                map.put("body", bodyMap);
                return bodyMap;
            }
            this.redisTemplate.delete((Object)phone);
        }
        if (phone != null && !phone.equals("") && (userInfo = this.userInfoDao.getUserByRegCellPhone(phone)) != null) {
            bodyMap.put("Message", "\u6b64\u624b\u673a\u53f7\u5df2\u88ab\u4f7f\u7528");
            bodyMap.put("Code", 500);
            map.put("body", bodyMap);
            return bodyMap;
        }
        SendSmsResponseBody s = this.sendPhone(phone, userCode, request, result);
        if (s != null && s.getCode() != null && s.getCode().equals("OK")) {
            s.setCode("0");
        }
        result.put("code", s.getCode());
        result.put("message", s.getMessage());
        result.put("x-auth-token", request.getSession().getId());
        return result;
    }

    @ApiOperation(value="\u6821\u9a8c\u548c\u66f4\u65b0", notes="\u6821\u9a8c\u548c\u66f4\u65b0")
    @RequestMapping(value={"/checkCode"}, method={RequestMethod.POST})
    @WrapUpResponseBody
    public ResponseData checkCode(@RequestParam(value="userCode", required=false) String userCode, @RequestParam(value="key") String key, @RequestParam(value="code") String code, HttpServletRequest request) {
        try {
            UserInfo user;
            if (code == null) {
                return ResponseData.makeErrorMessage((int)500, (String)"\u8bf7\u8f93\u5165\u9a8c\u8bc1\u7801\uff01");
            }
            JSONObject json = (JSONObject)this.redisTemplate.boundValueOps((Object)key).get();
            if (json == null) {
                json = JSONObject.parseObject((String)request.getHeader("verifyCode"));
            }
            if (json == null) {
                return ResponseData.makeErrorMessage((int)500, (String)"\u672a\u53d1\u9001\u9a8c\u8bc1\u7801\uff01");
            }
            String verifyCode = json.getString("verifyCode");
            Long createTime = json.getLong("createTime");
            String email = json.getString("email");
            String phone = json.getString("phone");
            if (!verifyCode.equals(code)) {
                return ResponseData.makeErrorMessage((int)500, (String)"\u9a8c\u8bc1\u7801\u9519\u8bef\uff01");
            }
            if (System.currentTimeMillis() - createTime > 300000L) {
                return ResponseData.makeErrorMessage((int)500, (String)"\u9a8c\u8bc1\u7801\u5df2\u8fc7\u671f\uff01");
            }
            if (StringUtils.isNotBlank((CharSequence)userCode) && (user = this.userInfoDao.getUserByCode(userCode)) != null) {
                if (StringUtils.isNotBlank((CharSequence)email)) {
                    user.setRegEmail(email);
                    this.logger.info("\u7528\u6237:{}\u4fee\u6539\u7528\u6237\u4fe1\u606f\u90ae\u7bb1", (Object)userCode);
                } else if (StringUtils.isNotBlank((CharSequence)phone)) {
                    user.setRegCellPhone(phone);
                    this.logger.info("\u7528\u6237:{}\u4fee\u6539\u7528\u6237\u4fe1\u606f\u624b\u673a", (Object)userCode);
                }
                this.userInfoDao.updateUser(user);
                this.reloadAuthentication(user.getUserCode());
                CodeRepositoryCache.evictCache((String)"UserInfo");
            }
            this.redisTemplate.delete((Object)key);
            return ResponseData.makeSuccessResponse();
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResponseData.errorResponse;
        }
    }

    @ApiOperation(value="\u627e\u56de\u5bc6\u7801(\u53d1\u9001\u9a8c\u8bc1\u7801 \u624b\u673a/\u90ae\u7bb1)", notes="\u627e\u56de\u5bc6\u7801(\u53d1\u9001\u9a8c\u8bc1\u7801 \u624b\u673a/\u90ae\u7bb1)")
    @RequestMapping(value={"/findPwd"}, method={RequestMethod.POST})
    @WrapUpResponseBody
    public ResponseData findPwd(@RequestParam(value="loginname") String loginname, HttpServletRequest request) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            if (loginname.indexOf(64) > 0) {
                UserInfo userInfo = this.userInfoDao.getUserByRegEmail(loginname);
                if (userInfo == null) {
                    return ResponseData.makeErrorMessage((String)"\u7528\u6237\u4e0d\u5b58\u5728");
                }
                this.sendEmail(loginname, request);
            } else {
                UserInfo userInfo = this.userInfoDao.getUserByRegCellPhone(loginname);
                if (userInfo == null) {
                    return ResponseData.makeErrorMessage((String)"\u7528\u6237\u4e0d\u5b58\u5728");
                }
                this.sendPhone(loginname, "", request, result);
            }
            result.put("x-auth-token", request.getSession().getId());
            return ResponseData.makeResponseData(result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResponseData.errorResponse;
        }
    }

    @ApiOperation(value="\u6821\u9a8c\u5e76\u8fd4\u56de\u7528\u6237\u4fe1\u606f", notes="\u6821\u9a8c\u5e76\u8fd4\u56de\u7528\u6237\u4fe1\u606f")
    @RequestMapping(value={"/checkCodeUser"}, method={RequestMethod.POST})
    @WrapUpResponseBody
    public ResponseData checkCodeUser(@RequestParam(value="key") String key, @RequestParam(value="code") String code, HttpServletRequest request) {
        try {
            if (code == null) {
                return ResponseData.makeErrorMessage((int)500, (String)"\u8bf7\u8f93\u5165\u9a8c\u8bc1\u7801\uff01");
            }
            JSONObject json = (JSONObject)this.redisTemplate.boundValueOps((Object)key).get();
            if (json == null) {
                json = JSONObject.parseObject((String)request.getHeader("verifyCode"));
            }
            if (json == null) {
                return ResponseData.makeErrorMessage((int)500, (String)"\u672a\u53d1\u9001\u9a8c\u8bc1\u7801\uff01");
            }
            String verifyCode = json.getString("verifyCode");
            Long createTime = json.getLong("createTime");
            String email = json.getString("email");
            String phone = json.getString("phone");
            if (!verifyCode.equals(code)) {
                return ResponseData.makeErrorMessage((int)500, (String)"\u9a8c\u8bc1\u7801\u9519\u8bef\uff01");
            }
            if (System.currentTimeMillis() - createTime > 300000L) {
                return ResponseData.makeErrorMessage((int)500, (String)"\u9a8c\u8bc1\u7801\u5df2\u8fc7\u671f\uff01");
            }
            UserInfo userInfo = new UserInfo();
            if (StringUtils.isNotBlank((CharSequence)email)) {
                userInfo = this.userInfoDao.getUserByRegEmail(email);
            } else if (StringUtils.isNotBlank((CharSequence)phone)) {
                userInfo = this.userInfoDao.getUserByRegCellPhone(phone);
            }
            this.redisTemplate.delete((Object)key);
            return ResponseData.makeResponseData((Object)userInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResponseData.errorResponse;
        }
    }

    public ResponseData sendEmail(String email, HttpServletRequest request) {
        String verifyCode = String.valueOf(new Random().nextInt(899999) + 100000);
        String message = "\u60a8\u7684\u9a8c\u8bc1\u7801\u4e3a:" + verifyCode + "\uff0c\u8be5\u7801\u6709\u6548\u671f\u4e3a5\u5206\u949f\uff0c\u8be5\u7801\u53ea\u80fd\u4f7f\u7528\u4e00\u6b21!";
        ArrayList<String> sendMessageUser = new ArrayList<String>();
        sendMessageUser.add(email);
        JSONObject json = new JSONObject();
        json.put((Object)"email", (Object)email);
        json.put((Object)"verifyCode", (Object)verifyCode);
        json.put((Object)"createTime", (Object)System.currentTimeMillis());
        ResponseData result = this.notificationCenter.sendMessage("system", sendMessageUser, NoticeMessage.create().operation("email").method("post").subject("\u60a8\u6709\u65b0\u90ae\u4ef6").content(message));
        if (result.getCode() == 0) {
            this.redisTemplate.boundValueOps((Object)email).set((Object)json);
        }
        return result;
    }

    public SendSmsResponseBody sendPhone(String phone, String userCode, HttpServletRequest request, Map<String, Object> map) throws Exception {
        String verifyCode = String.valueOf(new Random().nextInt(899999) + 100000);
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"code", (Object)verifyCode);
        if (userCode != null && !userCode.equals("")) {
            UserInfo userInfo = this.userInfoDao.getUserByCode(userCode);
            if (userInfo != null) {
                jSONObject.put((Object)"product", (Object)("\u7528\u6237" + userInfo.getUserName()));
            } else {
                jSONObject.put((Object)"product", (Object)"\u7528\u6237");
            }
        } else {
            jSONObject.put((Object)"product", (Object)"\u7528\u6237");
        }
        Client client = this.createClient();
        SendSmsRequest sendSmsRequest = new SendSmsRequest().setSignName("\u8eab\u4efd\u9a8c\u8bc1").setTemplateCode("SMS_65920066").setPhoneNumbers(phone).setTemplateParam(jSONObject.toString());
        JSONObject json = new JSONObject();
        json.put((Object)"phone", (Object)phone);
        json.put((Object)"verifyCode", (Object)verifyCode);
        json.put((Object)"createTime", (Object)System.currentTimeMillis());
        json.put((Object)"IP", (Object)InetAddress.getLocalHost().getHostAddress());
        SendSmsResponseBody result = client.sendSms(sendSmsRequest).getBody();
        if (result.getCode().equals("OK")) {
            this.redisTemplate.boundValueOps((Object)phone).set((Object)json);
        }
        return result;
    }

    private Client createClient() throws Exception {
        Config config = new Config().setAccessKeyId(SecurityOptUtils.decodeSecurityString((String)this.accessKeyId)).setAccessKeySecret(SecurityOptUtils.decodeSecurityString((String)this.accessKeySecret));
        config.endpoint = "dysmsapi.aliyuncs.com";
        return new Client(config);
    }

    private void reloadAuthentication(String userCode) {
        CentitUserDetails centitUserDetails = this.platformEnvironment.loadUserDetailsByUserCode(userCode);
        centitUserDetails.setLoginIp(this.getUserIp());
        SecurityContextHolder.getContext().setAuthentication((Authentication)centitUserDetails);
    }

    private String getUserIp() {
        Object principal = SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        if (principal instanceof CentitUserDetails) {
            CentitUserDetails userDetails = (CentitUserDetails)principal;
            return userDetails.getLoginIp();
        }
        return "";
    }
}

