/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.tenant.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.centit.framework.common.ResponseData;
import com.centit.framework.common.WebOptUtils;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.core.dao.PageQueryResult;
import com.centit.framework.model.adapter.PlatformEnvironment;
import com.centit.framework.operationlog.RecordOperationLog;
import com.centit.framework.security.model.CentitUserDetails;
import com.centit.framework.system.po.UnitInfo;
import com.centit.framework.system.po.UserInfo;
import com.centit.framework.system.po.UserUnit;
import com.centit.framework.tenant.po.TenantBusinessLog;
import com.centit.framework.tenant.po.TenantInfo;
import com.centit.framework.tenant.po.TenantMemberApply;
import com.centit.framework.tenant.service.TenantPowerManage;
import com.centit.framework.tenant.service.TenantService;
import com.centit.framework.tenant.vo.PageListTenantInfoQo;
import com.centit.framework.tenant.vo.TenantMemberApplyVo;
import com.centit.framework.tenant.vo.TenantMemberQo;
import com.centit.framework.users.config.WxAppConfig;
import com.centit.framework.users.service.UserPlatService;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.common.ObjectException;
import com.centit.support.common.ParamName;
import com.centit.support.database.utils.PageDesc;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/tenant"})
@Api(tags={"\u79df\u6237\u7ba1\u7406\u63a5\u53e3"}, value="\u79df\u6237\u7ba1\u7406\u63a5\u53e3")
public class TenanController
extends BaseController {
    @Autowired
    private TenantService tenantService;
    @Autowired
    private TenantPowerManage tenantPowerManage;
    @Autowired
    protected PlatformEnvironment platformEnvironment;
    @Autowired
    private WxAppConfig wxAppConfig;
    @Autowired
    private UserPlatService userPlatService;

    public String getOptId() {
        return "TENANMAG";
    }

    @ApiOperation(value="\u6ce8\u518c\u7528\u6237\u8d26\u53f7", notes="\u6ce8\u518c\u7528\u6237\u8d26\u53f7,\u8bf7\u6c42\u4f53(\u7528\u6237\u57fa\u672c\u4fe1\u606f)")
    @RequestMapping(value={"/registerUserAccount"}, method={RequestMethod.POST})
    @WrapUpResponseBody
    public ResponseData registerUserAccount(@RequestBody @Validated UserInfo userInfo) {
        try {
            return this.tenantService.registerUserAccount(userInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("\u7528\u6237\u6ce8\u518c\u5931\u8d25,\u9519\u8bef\u539f\u56e0{},\u7528\u6237\u540d\u6570\u636e\uff1a{}", (Object)e, (Object)userInfo.toString());
            return ResponseData.makeErrorMessage((String)"\u7528\u6237\u6ce8\u518c\u5931\u8d25!");
        }
    }

    @ApiOperation(value="\u7528\u6237\u7533\u8bf7\u65b0\u5efa\u79df\u6237,\u76ee\u524d\u79df\u6237\u7533\u8bf7\u540e\u4e0d\u9700\u8981\u7ba1\u7406\u5458\u518d\u6b21\u5ba1\u6838", notes="\u7528\u6237\u7533\u8bf7\u65b0\u5efa\u79df\u6237,\u8bf7\u6c42\u4f53(\u79df\u6237\u57fa\u672c\u4fe1\u606f)")
    @RequestMapping(value={"/applyAddTenant"}, method={RequestMethod.POST})
    @WrapUpResponseBody
    public ResponseData applyAddTenant(@RequestBody @Validated TenantInfo tenantInfo, HttpServletRequest request) {
        String userCode = WebOptUtils.getCurrentUserCode((HttpServletRequest)request);
        if (StringUtils.isBlank((CharSequence)userCode)) {
            throw new ObjectException(302, "\u60a8\u672a\u767b\u5f55!");
        }
        tenantInfo.setCreator(userCode);
        if (this.tenantPowerManage.userIsSystemMember()) {
            if (StringUtils.isBlank((CharSequence)tenantInfo.getOwnUser())) {
                throw new ObjectException("ownUser\u4e0d\u80fd\u4e3a\u7a7a");
            }
        } else {
            tenantInfo.setOwnUser(userCode);
        }
        try {
            return this.tenantService.applyAddTenant(tenantInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("\u7528\u6237\u7533\u8bf7\u65b0\u5efa\u79df\u6237\u5931\u8d25,\u9519\u8bef\u539f\u56e0{},\u7528\u6237\u540d\u6570\u636e\uff1a{}", (Object)e, (Object)tenantInfo.toString());
            return ResponseData.makeErrorMessage((String)"\u7528\u6237\u7533\u8bf7\u65b0\u5efa\u79df\u6237\u5931\u8d25!");
        }
    }

    @ApiOperation(value="\u7533\u8bf7\u52a0\u5165\u79df\u6237", notes="\u53ef\u4ee5\u662f\u7528\u6237\u4e3b\u52a8\u7533\u8bf7\uff0c\u4e5f\u53ef\u4ee5\u662f\u7ba1\u7406\u5458\u9080\u8bf7,\u8bf7\u6c42\u4f53(\u79df\u6237\u6210\u5458\u7533\u8bf7\u4fe1\u606f)\uff0c***\u5e9f\u5f03\u63a5\u53e3")
    @RequestMapping(value={"/applyJoinTenant"}, method={RequestMethod.POST})
    @WrapUpResponseBody
    public ResponseData applyJoinTenant(@RequestBody @Validated TenantMemberApply tenantMemberApply) {
        try {
            return this.tenantService.applyJoinTenant(tenantMemberApply);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("\u6210\u5458\u7533\u8bf7\u5931\u8d25,\u9519\u8bef\u539f\u56e0{},\u7533\u8bf7\u6570\u636e\uff1a{}", (Object)e, (Object)tenantMemberApply.toString());
            return ResponseData.makeErrorMessage((String)"\u6210\u5458\u7533\u8bf7\u5931\u8d25!");
        }
    }

    @ApiOperation(value="\u7528\u6237\u7533\u8bf7\u52a0\u5165\u79df\u6237", notes="\u7528\u6237\u7533\u8bf7\u52a0\u5165\u79df\u6237")
    @ApiImplicitParams(value={@ApiImplicitParam(name="topUnit", value="\u79df\u6237id", paramType="String", dataTypeClass=String.class)})
    @RequestMapping(value={"/userApplyJoinTenant"}, method={RequestMethod.POST})
    @WrapUpResponseBody
    public ResponseData userApplyJoinTenant(@RequestBody TenantMemberApply tenantMemberApply, HttpServletRequest request) {
        String userCode = WebOptUtils.getCurrentUserCode((HttpServletRequest)request);
        if (StringUtils.isBlank((CharSequence)userCode)) {
            return ResponseData.makeErrorMessage((int)302, (String)"\u60a8\u672a\u767b\u5f55!");
        }
        if (StringUtils.isBlank((CharSequence)tenantMemberApply.getTopUnit())) {
            return ResponseData.makeErrorMessage((int)701, (String)"topUnit\u4e0d\u80fd\u4e3a\u7a7a");
        }
        tenantMemberApply.setUserCode(userCode);
        tenantMemberApply.setInviterUserCode(userCode);
        try {
            return this.tenantService.userApplyJoinTenant(tenantMemberApply);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("\u7528\u6237\u7533\u8bf7\u52a0\u5165\u79df\u6237\u5931\u8d25,\u9519\u8bef\u539f\u56e0{},\u7533\u8bf7\u6570\u636e\uff1a{}", (Object)e, (Object)tenantMemberApply.toString());
            return ResponseData.makeErrorMessage((String)"\u7528\u6237\u7533\u8bf7\u52a0\u5165\u79df\u6237\u5931\u8d25!");
        }
    }

    @ApiOperation(value="\u7ba1\u7406\u5458\u9080\u8bf7\u7528\u6237\u52a0\u5165\u79df\u6237", notes="\u7ba1\u7406\u5458\u9080\u8bf7\u7528\u6237\u52a0\u5165\u79df\u6237")
    @ApiImplicitParams(value={@ApiImplicitParam(name="unitCode", value="\u90e8\u95e8code\uff0c\u975e\u5fc5\u586b\uff0c\u4f20\u5165\u4e4b\u540e\uff0c\u9080\u8bf7\u4eba\u4f1a\u88ab\u5206\u914d\u5230\u6539\u90e8\u95e8\uff0c\u4e0d\u4f20\u5219\u4f1a\u5206\u914d\u5230\u9876\u7ea7\u673a\u6784", paramType="String", dataTypeClass=String.class), @ApiImplicitParam(name="userCode", value="\u7528\u6237code", paramType="String", dataTypeClass=String.class)})
    @RequestMapping(value={"/adminApplyUserJoinTenant"}, method={RequestMethod.POST})
    @WrapUpResponseBody
    public ResponseData adminApplyUserJoinTenant(@RequestBody TenantMemberApply tenantMemberApply, HttpServletRequest request) {
        if (StringUtils.isBlank((CharSequence)tenantMemberApply.getUserCode())) {
            return ResponseData.makeErrorMessage((int)701, (String)"userCode\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String currentUserCode = WebOptUtils.getCurrentUserCode((HttpServletRequest)request);
        if (StringUtils.isBlank((CharSequence)currentUserCode)) {
            return ResponseData.makeErrorMessage((int)302, (String)"\u60a8\u672a\u767b\u5f55!");
        }
        tenantMemberApply.setTopUnit(WebOptUtils.getCurrentTopUnit((HttpServletRequest)request));
        tenantMemberApply.setInviterUserCode(currentUserCode);
        try {
            return this.tenantService.adminApplyUserJoinTenant(tenantMemberApply);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("\u7ba1\u7406\u5458\u9080\u8bf7\u7528\u6237\u52a0\u5165\u79df\u6237\u5931\u8d25,\u9519\u8bef\u539f\u56e0{},\u7533\u8bf7\u6570\u636e\uff1a{}", (Object)e, (Object)tenantMemberApply.toString());
            return ResponseData.makeErrorMessage((String)"\u7ba1\u7406\u5458\u9080\u8bf7\u7528\u6237\u52a0\u5165\u79df\u6237\u5931\u8d25!");
        }
    }

    @ApiOperation(value="\u5217\u51fa\u7533\u8bf7\u4fe1\u606f", notes="\u53ef\u4ee5\u662f\u7ba1\u7406\u5458\u9080\u8bf7\u7684\u4fe1\u606f\uff0c\u4e5f\u53ef\u4ee5\u662f\u7528\u6237\u4e3b\u52a8\u7533\u8bf7\u7684\u4fe1\u606f\u3002\u79df\u6237\u4e3b\u52a8\u9080\u8bf7\u7528\u6237\u52a0\u5165\uff0c\u79df\u6237\u67e5\u770b\u672a\u5ba1\u6279\u7684\u7528\u6237\u5217\u8868 applyType:2,topUnit= topUnit,applyState_in=[1,2]")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applyType", value="1:\u7528\u6237\u4e3b\u52a8\u7533\u8bf72:\u79df\u6237\u4e3b\u52a8\u9080\u8bf7", paramType="String", dataTypeClass=String.class), @ApiImplicitParam(name="userCode/topUnit", value="\u7528\u6237\u4ee3\u7801\u6216\u673a\u6784\u4ee3\u7801[userCode=][topUnit=][unitCode=](topUnit\u548cunitCode\u4f20\u5165\u4efb\u610f\u4e00\u4e2a\u5373\u53ef)", paramType="String", dataTypeClass=String.class), @ApiImplicitParam(name="applyState", value="\u5ba1\u6279\u7c7b\u578b \u672a\u5ba1\u6279\uff1aapplyState_in=1,2,\u5df2\u5ba1\u6279\uff1aapplyState_in=3,4,\u5ba1\u6279\u901a\u8fc7\uff1aapplyState=3,\u4e0d\u540c\u610f\uff1aapplyState=4", paramType="String", dataTypeClass=String.class), @ApiImplicitParam(name="pageDesc", value="\u5206\u9875\u5bf9\u8c61", paramType="body", dataTypeClass=PageDesc.class)})
    @RequestMapping(value={"/listApplyInfo"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public PageQueryResult listApplyInfo(HttpServletRequest httpServletRequest, PageDesc pageDesc) {
        return this.tenantService.listApplyInfo(TenanController.collectRequestParameters((HttpServletRequest)httpServletRequest), pageDesc);
    }

    @ApiOperation(value="\u64a4\u9500\u7533\u8bf7", notes="\u7528\u6237\u6216\u8005\u79df\u6237\u64a4\u9500\u7533\u8bf7\u6216\u9080\u8bf7 ***\u5e9f\u5f03\u63a5\u53e3")
    @ApiImplicitParams(value={@ApiImplicitParam(name="topUnit", value="\u79df\u6237id", paramType="String", dataTypeClass=String.class), @ApiImplicitParam(name="userCode", value="\u7528\u6237code", paramType="String", dataTypeClass=String.class)})
    @RequestMapping(value={"/cancelApply"}, method={RequestMethod.PUT})
    @WrapUpResponseBody
    public ResponseData cancelApply(HttpServletRequest request) {
        Map parameters = TenanController.collectRequestParameters((HttpServletRequest)request);
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{MapUtils.getString((Map)parameters, (Object)"topUnit"), MapUtils.getString((Map)parameters, (Object)"userCode")})) {
            return ResponseData.makeErrorMessage((String)"topUnit\u6216userCode\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.tenantService.cancelApply(parameters);
    }

    @ApiOperation(value="\u7528\u6237\u64a4\u9500\u7533\u8bf7", notes="\u7528\u6237\u64a4\u9500\u7533\u8bf7")
    @ApiImplicitParams(value={@ApiImplicitParam(name="topUnit", value="\u79df\u6237id", paramType="String", dataTypeClass=String.class)})
    @RequestMapping(value={"/userCancelApply"}, method={RequestMethod.PUT})
    @WrapUpResponseBody
    public ResponseData userCancelApply(@RequestBody TenantMemberApply tenantMemberApply, HttpServletRequest request) {
        String topUnit = tenantMemberApply.getTopUnit();
        if (StringUtils.isBlank((CharSequence)topUnit)) {
            return ResponseData.makeErrorMessage((String)"topUnit\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String currentUserCode = WebOptUtils.getCurrentUserCode((HttpServletRequest)request);
        if (StringUtils.isBlank((CharSequence)currentUserCode)) {
            throw new ObjectException(302, "\u60a8\u8fd8\u672a\u767b\u5f55!");
        }
        Map parameters = CollectionsOpt.createHashMap((Object[])new Object[]{"userCode", currentUserCode, "topUnit", topUnit});
        return this.tenantService.cancelApply(parameters);
    }

    @ApiOperation(value="\u79df\u6237\u64a4\u9500\u9080\u8bf7", notes="\u79df\u6237\u64a4\u9500\u9080\u8bf7")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userCode", value="\u7528\u6237code", paramType="String", dataTypeClass=String.class)})
    @RequestMapping(value={"/adminCancelApply"}, method={RequestMethod.PUT})
    @WrapUpResponseBody
    public ResponseData adminCancelApply(@RequestBody TenantMemberApply tenantMemberApply, HttpServletRequest request) {
        String userCode = tenantMemberApply.getUserCode();
        if (StringUtils.isBlank((CharSequence)userCode)) {
            return ResponseData.makeErrorMessage((String)"userCode\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String topUnit = WebOptUtils.getCurrentTopUnit((HttpServletRequest)request);
        if (!this.tenantPowerManage.userIsTenantAdmin(topUnit)) {
            throw new ObjectException(401, "\u60a8\u6ca1\u6709\u64cd\u4f5c\u6743\u9650!");
        }
        Map parameters = CollectionsOpt.createHashMap((Object[])new Object[]{"userCode", userCode, "topUnit", topUnit});
        return this.tenantService.cancelApply(parameters);
    }

    @ApiOperation(value="\u6ce8\u9500\u79df\u6237", notes="\u6ce8\u9500\u79df\u6237\uff0c\u53ea\u6709\u79df\u6237\u6240\u6709\u8005\u624d\u53ef\u4ee5\u64cd\u4f5c")
    @RequestMapping(value={"/deleteTenant"}, method={RequestMethod.PUT})
    @WrapUpResponseBody
    public ResponseData deleteTenant(HttpServletRequest request) {
        Map parameters = TenanController.collectRequestParameters((HttpServletRequest)request);
        if (StringUtils.isBlank((CharSequence)MapUtils.getString((Map)parameters, (Object)"topUnit"))) {
            return ResponseData.makeErrorMessage((String)"topUnit\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String userCode = WebOptUtils.getCurrentUserCode((HttpServletRequest)request);
        if (StringUtils.isBlank((CharSequence)userCode)) {
            throw new ObjectException(302, "\u60a8\u672a\u767b\u5f55");
        }
        parameters.put("userCode", userCode);
        this.logger.info("\u7528\u6237:{}\u6ce8\u9500\u79df\u6237{}\u4fe1\u606f", (Object)userCode, (Object)MapUtils.getString((Map)parameters, (Object)"topUnit"));
        return this.tenantService.deleteTenant(parameters);
    }

    @ApiOperation(value="\u540c\u610f\u52a0\u5165\u79df\u6237", notes="\u53ef\u4ee5\u662f\u5e73\u53f0\u7ba1\u7406\u5458\u5ba1\u6838\u7528\u6237\u7684\u52a0\u5165,\u4e5f\u53ef\u4ee5\u662f\u666e\u901a\u7528\u6237\u540c\u610f\u7ba1\u7406\u5458\u7684\u9080\u8bf7 ***\u5e9f\u5f03\u63a5\u53e3")
    @RequestMapping(value={"/agreeJoin"}, method={RequestMethod.POST})
    @WrapUpResponseBody
    public ResponseData agreeJoin(@RequestBody @Validated TenantMemberApplyVo tenantMemberApply, HttpServletRequest request) {
        if (StringUtils.isBlank((CharSequence)WebOptUtils.getCurrentUserCode((HttpServletRequest)request))) {
            throw new ObjectException(302, "\u60a8\u672a\u767b\u5f55!");
        }
        if (StringUtils.isBlank((CharSequence)tenantMemberApply.getTopUnit())) {
            throw new ObjectException(500, "topUnit\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        return this.tenantService.agreeJoin(tenantMemberApply);
    }

    @ApiOperation(value="\u7528\u6237\u540c\u610f\u52a0\u5165\u79df\u6237", notes="\u7528\u6237\u540c\u610f\u52a0\u5165\u79df\u6237")
    @ApiImplicitParams(value={@ApiImplicitParam(name="topUnit", value="\u79df\u6237id", paramType="String", dataTypeClass=String.class), @ApiImplicitParam(name="applyState", value="\u7533\u8bf7\u72b6\u6001 3\uff1a\u540c\u610f\u52a0\u5165 4\uff1a\u4e0d\u540c\u610f\u52a0\u5165", paramType="String", dataTypeClass=String.class)})
    @RequestMapping(value={"/userAgreeJoin"}, method={RequestMethod.PUT})
    @WrapUpResponseBody
    public ResponseData userAgreeJoin(@RequestBody TenantMemberApplyVo tenantMemberApply, HttpServletRequest request) {
        String userCode = WebOptUtils.getCurrentUserCode((HttpServletRequest)request);
        if (StringUtils.isBlank((CharSequence)userCode)) {
            throw new ObjectException(302, "\u60a8\u672a\u767b\u5f55!");
        }
        if (StringUtils.isBlank((CharSequence)tenantMemberApply.getTopUnit())) {
            throw new ObjectException(500, "topUnit\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        tenantMemberApply.setUserCode(userCode);
        return this.tenantService.agreeJoin(tenantMemberApply);
    }

    @ApiOperation(value="\u7ba1\u7406\u5458\u540c\u610f\u7528\u6237\u52a0\u5165\u79df\u6237", notes="\u7ba1\u7406\u5458\u540c\u610f\u7528\u6237\u52a0\u5165\u79df\u6237")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applyState", value="\u662f\u5426\u901a\u8fc7 3\uff1a\u901a\u8fc7 4\uff1a\u4e0d\u901a\u8fc7", paramType="String", dataTypeClass=String.class), @ApiImplicitParam(name="userCode", value="\u7528\u6237code", paramType="String", dataTypeClass=String.class)})
    @RequestMapping(value={"/adminAgreeJoin"}, method={RequestMethod.PUT})
    @WrapUpResponseBody
    public ResponseData adminAgreeJoin(@RequestBody TenantMemberApplyVo tenantMemberApply, HttpServletRequest request) {
        if (StringUtils.isBlank((CharSequence)WebOptUtils.getCurrentUserCode((HttpServletRequest)request))) {
            return ResponseData.makeErrorMessage((int)302, (String)"\u60a8\u672a\u767b\u5f55!");
        }
        String topUnit = WebOptUtils.getCurrentTopUnit((HttpServletRequest)request);
        if (StringUtils.isBlank((CharSequence)topUnit) || !this.tenantPowerManage.userIsTenantAdmin(topUnit)) {
            return ResponseData.makeErrorMessage((int)401, (String)"\u60a8\u6ca1\u6709\u6743\u9650\u64cd\u4f5c!");
        }
        tenantMemberApply.setTopUnit(topUnit);
        return this.tenantService.agreeJoin(tenantMemberApply);
    }

    @ApiOperation(value="\u5e73\u53f0\u7ba1\u7406\u5458\u5ba1\u6838\u79df\u6237", notes="\u5e73\u53f0\u7ba1\u7406\u5458\u5ba1\u6838\u79df\u6237\uff0c\u8bf7\u6c42\u4f53(\u79df\u6237\u4fe1\u606f)---\u6682\u65f6\u6ca1\u7528\u5230")
    @RequestMapping(value={"/adminCheckTenant"}, method={RequestMethod.POST})
    @WrapUpResponseBody
    public ResponseData adminCheckTenant(@RequestBody TenantInfo tenantInfo, HttpServletRequest request) {
        String userCode = WebOptUtils.getCurrentUserCode((HttpServletRequest)request);
        if (StringUtils.isBlank((CharSequence)userCode)) {
            throw new ObjectException(302, "\u60a8\u672a\u767b\u5f55");
        }
        tenantInfo.setUpdator(userCode);
        return this.tenantService.adminCheckTenant(tenantInfo);
    }

    @ApiOperation(value="\u66f4\u65b0\u7528\u6237\u57fa\u672c\u4fe1\u606f", notes="\u66f4\u65b0\u7528\u6237\u57fa\u672c\u4fe1\u606f\uff0c\u8bf7\u6c42\u4f53(\u7528\u6237\u4fe1\u606f)")
    @RequestMapping(value={"/updateUserInfo"}, method={RequestMethod.PUT})
    @WrapUpResponseBody
    public ResponseData updateUserInfo(@RequestBody UserInfo userInfo) {
        try {
            return this.tenantService.updateUserInfo(userInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("\u66f4\u65b0\u4eba\u5458\u4fe1\u606f\u5931\u8d25\u3002\u5931\u8d25\u539f\u56e0\uff1a{},\u5165\u53c2\uff1a{}", (Object)e, (Object)userInfo.toString());
            return ResponseData.errorResponse;
        }
    }

    @ApiOperation(value="\u9000\u51fa\u79df\u6237", notes="\u9000\u51fa\u79df\u6237\uff0c\u8bf7\u6c42\u793a\u4f8b\uff1a{\"topUnit\":\"f0c0368da826434bbb158ed2ef0b1726\"}")
    @RequestMapping(value={"/quitTenant"}, method={RequestMethod.PUT})
    @WrapUpResponseBody
    public ResponseData quitTenant(@RequestBody Map<String, Object> paraMaps, HttpServletRequest request) {
        String topUnit = MapUtils.getString(paraMaps, (Object)"topUnit");
        if (StringUtils.isBlank((CharSequence)topUnit)) {
            return ResponseData.makeErrorMessage((String)"\u53c2\u6570topUnit\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String userCode = WebOptUtils.getCurrentUserCode((HttpServletRequest)request);
        if (StringUtils.isBlank((CharSequence)userCode)) {
            return ResponseData.makeErrorMessage((int)302, (String)"\u5f53\u524d\u7528\u6237\u672a\u767b\u5f55");
        }
        try {
            return this.tenantService.quitTenant(topUnit, userCode);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("\u9000\u51fa\u79df\u6237\u5931\u8d25\u3002\u5931\u8d25\u539f\u56e0\uff1a{},\u5165\u53c2\uff1auserCode={},topUnit={}", new Object[]{e, userCode, topUnit});
            return ResponseData.errorResponse;
        }
    }

    @ApiOperation(value="\u628a\u6210\u5458\u79fb\u9664\u79df\u6237", notes="\u628a\u6210\u5458\u79fb\u9664\u79df\u6237\uff0c\u8bf7\u6c42\u793a\u4f8b\uff1a{\"userCode\":\"U6n6uge0\",\"topUnit\":\"f0c0368da826434bbb158ed2ef0b1726\"}")
    @RequestMapping(value={"/removeTenantMember"}, method={RequestMethod.PUT})
    @WrapUpResponseBody
    public ResponseData removeTenantMember(@RequestBody Map<String, Object> paraMaps) {
        String topUnit = MapUtils.getString(paraMaps, (Object)"topUnit");
        String userCode = MapUtils.getString(paraMaps, (Object)"userCode");
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{topUnit, userCode})) {
            return ResponseData.makeErrorMessage((String)"\u53c2\u6570topUnit,userCode\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            return this.tenantService.removeTenantMember(topUnit, userCode);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("\u79fb\u9664\u79df\u6237\u5931\u8d25\u3002\u5931\u8d25\u539f\u56e0\uff1a{},\u5165\u53c2\uff1auserCode={},topUnit={}", new Object[]{e, userCode, topUnit});
            return ResponseData.errorResponse;
        }
    }

    @ApiOperation(value="\u79df\u6237\u8f6c\u8ba9\u7533\u8bf7", notes="\u79df\u6237\u8f6c\u8ba9\u7533\u8bf7\uff0c\u8bf7\u6c42\u4f53(\u79df\u6237\u8f6c\u8ba9\u8bb0\u5f55\u4fe1\u606f)")
    @RequestMapping(value={"/businessTenant"}, method={RequestMethod.POST})
    @WrapUpResponseBody
    public ResponseData businessTenant(@RequestBody @Validated TenantBusinessLog tenantBusinessLog) {
        try {
            return this.tenantService.businessTenant(tenantBusinessLog);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("\u79df\u6237\u8f6c\u8ba9\u7533\u8bf7\u5931\u8d25\u3002\u5931\u8d25\u539f\u56e0\uff1a{},\u5165\u53c2\uff1atenantBusinessLog={}", (Object)e, (Object)tenantBusinessLog.toString());
            return ResponseData.makeErrorMessage((String)"\u79df\u6237\u8f6c\u8ba9\u7533\u8bf7\u5931\u8d25");
        }
    }

    @ApiOperation(value="\u5206\u9875\u5c55\u793a\u79df\u6237\u5217\u8868", notes="\u5206\u9875\u5c55\u793a\u79df\u6237\u5217\u8868")
    @RequestMapping(value={"/pageListTenantApply"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public PageQueryResult pageListTenantApply(PageListTenantInfoQo tenantInfo, PageDesc pageDesc) {
        return this.tenantService.pageListTenantApply(tenantInfo, pageDesc);
    }

    @ApiOperation(value="\u5206\u9875\u5c55\u793a\u79df\u6237\u6210\u5458\u5217\u8868", notes="\u5206\u9875\u5c55\u793a\u79df\u6237\u6210\u5458\u5217\u8868")
    @RequestMapping(value={"/pageListTenantMember"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public PageQueryResult<Object> pageListTenantMember(HttpServletRequest request, PageDesc pageDesc) {
        Map parameters = TenanController.collectRequestParameters((HttpServletRequest)request);
        return this.tenantService.pageListTenantMember(parameters, pageDesc);
    }

    @ApiOperation(value="\u8bbe\u7f6e\u79df\u6237\u6210\u5458\u89d2\u8272", notes="\u8bbe\u7f6e\u79df\u6237\u6210\u5458\u89d2\u8272")
    @RequestMapping(value={"/assignTenantRole"}, method={RequestMethod.POST})
    @WrapUpResponseBody
    public ResponseData assignTenantRole(@RequestBody TenantMemberQo tenantMemberQo) {
        try {
            return this.tenantService.assignTenantRole(tenantMemberQo);
        }
        catch (ObjectException obe) {
            return ResponseData.makeErrorMessage((int)obe.getExceptionCode(), (String)obe.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("\u8bbe\u7f6e\u79df\u6237\u6210\u5458\u89d2\u8272\u51fa\u9519\uff0c\u9519\u8bef\u539f\u56e0:{},\u5165\u53c2:{}", (Object)e, (Object)tenantMemberQo.toString());
            return ResponseData.makeErrorMessage((String)"\u8bbe\u7f6e\u79df\u6237\u6210\u5458\u89d2\u8272\u51fa\u9519");
        }
    }

    @ApiOperation(value="\u79fb\u9664\u79df\u6237\u6210\u5458\u89d2\u8272", notes="\u79fb\u9664\u79df\u6237\u6210\u5458\u89d2\u8272")
    @RequestMapping(value={"/deleteTenantRole"}, method={RequestMethod.DELETE})
    @WrapUpResponseBody
    public ResponseData deleteTenantRole(TenantMemberQo tenantMemberQo) {
        try {
            return this.tenantService.deleteTenantRole(tenantMemberQo);
        }
        catch (ObjectException obe) {
            return ResponseData.makeErrorMessage((int)obe.getExceptionCode(), (String)obe.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("\u5220\u9664\u79df\u6237\u6210\u5458\u89d2\u8272\u51fa\u9519\uff0c\u9519\u8bef\u539f\u56e0:{},\u5165\u53c2:{}", (Object)e, (Object)tenantMemberQo.toString());
            return ResponseData.makeErrorMessage((String)"\u5220\u9664\u79df\u6237\u6210\u5458\u89d2\u8272\u51fa\u9519");
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u6240\u5728\u79df\u6237", notes="\u83b7\u53d6\u7528\u6237\u6240\u5728\u79df\u6237")
    @RequestMapping(value={"/userTenants"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public ResponseData userTenants(HttpServletRequest request) {
        String userCode = WebOptUtils.getCurrentUserCode((HttpServletRequest)request);
        if (StringUtils.isBlank((CharSequence)userCode)) {
            throw new ObjectException(302, "\u60a8\u672a\u767b\u5f55!");
        }
        try {
            JSONArray userTenants = this.tenantService.userTenants(userCode);
            return ResponseData.makeResponseData((Object)userTenants);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("\u83b7\u53d6\u7528\u6237\u6240\u5728\u79df\u6237\u51fa\u9519\uff0c\u9519\u8bef\u539f\u56e0:{},\u5165\u53c2:{}", (Object)e, (Object)userCode);
            return ResponseData.makeErrorMessage((String)"\u83b7\u53d6\u7528\u6237\u6240\u5728\u79df\u6237\u51fa\u9519");
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u79df\u6237\u4fe1\u606f", notes="\u6839\u636eunitName\u7cbe\u786e\u67e5\u8be2\u79df\u6237\u4fe1\u606f")
    @RequestMapping(value={"/pageListTenants"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public PageQueryResult pageListTenants(PageDesc pageDesc, HttpServletRequest request) {
        Map map = TenanController.collectRequestParameters((HttpServletRequest)request);
        if (StringUtils.isBlank((CharSequence)MapUtils.getString((Map)map, (Object)"unitName"))) {
            JSONArray jsonArray = new JSONArray();
            return PageQueryResult.createResult((Collection)jsonArray, (PageDesc)pageDesc);
        }
        if (StringUtils.isNotBlank((CharSequence)MapUtils.getString((Map)map, (Object)"otherTenant"))) {
            map.put("userCode", WebOptUtils.getCurrentUserCode((HttpServletRequest)request));
        }
        return this.tenantService.pageListTenants(map, pageDesc);
    }

    @ApiOperation(value="\u67e5\u8be2\u7528\u6237\u4fe1\u606f", notes="\u67e5\u8be2\u79df\u6237\u4fe1\u606f\uff0c\u53ea\u80fd\u6839\u636euserCode\uff0cuserName\uff0cregCellPhone\u7cbe\u786e\u67e5\u627e\uff0cunitCode:\u5fc5\u4f20 \u5f53\u524d\u7528\u6237\u6240\u5728\u79df\u6237topUnit")
    @RequestMapping(value={"/findUsers"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public ResponseData findUsers(HttpServletRequest request) {
        Map paramMap = TenanController.collectRequestParameters((HttpServletRequest)request);
        return this.tenantService.findUsers(paramMap);
    }

    @ApiOperation(value="\u4fee\u6539\u79df\u6237\u4fe1\u606f", notes="\u4fee\u6539\u79df\u6237\u4fe1\u606f")
    @RequestMapping(value={"/updateTenant"}, method={RequestMethod.PUT})
    @WrapUpResponseBody
    public ResponseData updateTenant(@RequestBody TenantInfo tenantInfo) {
        return this.tenantService.updateTenant(tenantInfo);
    }

    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u767b\u5f55\u4fe1\u606f", notes="\u662f\u5bf9/mainframe/currentuser\u63a5\u53e3\u7684\u6269\u5c55")
    @RequestMapping(value={"/currentuser"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public Object getCurrentUser(HttpServletRequest request) {
        Object ud = WebOptUtils.getLoginUser((HttpServletRequest)request);
        if (ud == null) {
            throw new ObjectException(302, "\u7528\u6237\u6ca1\u6709\u767b\u5f55\u6216\u8005\u8d85\u65f6\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55\uff01");
        }
        String userCode = "";
        if (ud instanceof CentitUserDetails) {
            CentitUserDetails centitUserDetails = (CentitUserDetails)ud;
            JSONObject userInfo = centitUserDetails.getUserInfo();
            userCode = userInfo.getString("userCode");
            String topUnitCode = centitUserDetails.getTopUnitCode();
            String tenantRole = "";
            if (StringUtils.isNotBlank((CharSequence)topUnitCode)) {
                tenantRole = this.tenantPowerManage.userTenantRole(topUnitCode);
            }
            userInfo.put("tenantRole", (Object)tenantRole);
        }
        JSONObject jsonObject = (JSONObject)JSON.toJSON((Object)ud);
        JSONArray userTenants = this.tenantService.userTenants(userCode);
        jsonObject.put("userTenants", (Object)userTenants);
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        paramsMap.put("userCode", userCode);
        List userPlats = this.userPlatService.listObjects(paramsMap, null);
        jsonObject.put("userPlats", userPlats != null && userPlats.size() > 0 ? userPlats : new ArrayList());
        return jsonObject;
    }

    @ApiOperation(value="\u65b0\u5efa\u673a\u6784", notes="\u65b0\u5efa\u4e00\u4e2a\u673a\u6784\u3002")
    @ApiImplicitParam(name="unitInfo", value="json\u683c\u5f0f\uff0c\u673a\u6784\u4fe1\u606f\u5bf9\u8c61", paramType="body", dataTypeClass=UnitInfo.class)
    @RequestMapping(value={"/addTenantUnit"}, method={RequestMethod.POST})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{loginIp},\u7528\u6237{loginUser.userName}\u65b0\u589e\u673a\u6784", tag="{ui.unitCode}:{ui.unitName}")
    @WrapUpResponseBody
    public ResponseData addTenantUnit(@ParamName(value="ui") @Valid UnitInfo unitInfo, HttpServletRequest request) {
        if (WebOptUtils.isTenant) {
            String topUnit = WebOptUtils.getCurrentTopUnit((HttpServletRequest)request);
            if (StringUtils.isBlank((CharSequence)topUnit)) {
                throw new ObjectException("topUnit\u4e0d\u80fd\u4e3a\u7a7a!");
            }
            unitInfo.setTopUnit(topUnit);
        }
        return this.tenantService.addTenantUnit(unitInfo);
    }

    @ApiOperation(value="\u65b0\u589e\u7528\u6237", notes="\u65b0\u589e\u7528\u6237\u3002")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userInfo", value="json\u683c\u5f0f\uff0c\u7528\u6237\u5bf9\u8c61\u4fe1\u606f", paramType="body", dataTypeClass=UserInfo.class), @ApiImplicitParam(name="userUnit", value="json\u683c\u5f0f\uff0c\u7528\u6237\u673a\u6784\u5bf9\u8c61\u4fe1\u606f", paramType="body", dataTypeClass=UserUnit.class)})
    @RequestMapping(value={"/addTenantUser"}, method={RequestMethod.POST})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{loginIp},\u7528\u6237{loginUser.userName}\u65b0\u589e\u7528\u6237", tag="{us.userCode}")
    @WrapUpResponseBody
    public ResponseData addTenantUser(@ParamName(value="us") @Valid UserInfo userInfo, UserUnit userUnit, HttpServletRequest request) {
        String userCode = WebOptUtils.getCurrentUserCode((HttpServletRequest)request);
        if (null == userUnit || StringUtils.isBlank((CharSequence)userUnit.getTopUnit())) {
            return ResponseData.makeErrorMessage((String)"topUnit\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        userUnit.setCreator(userCode);
        return this.tenantService.addTenantUser(userInfo, userUnit);
    }
}

