package com.centit.framework.tenant.service;

import com.alibaba.fastjson.JSONArray;
import com.centit.framework.common.ResponseData;
import com.centit.framework.core.dao.PageQueryResult;
import com.centit.framework.system.po.UnitInfo;
import com.centit.framework.system.po.UserUnit;
import com.centit.framework.system.po.UserInfo;
import com.centit.framework.tenant.vo.PageListTenantInfoQo;
import com.centit.framework.tenant.vo.TenantMemberApplyVo;
import com.centit.framework.tenant.vo.TenantMemberQo;
import com.centit.framework.tenant.po.TenantBusinessLog;
import com.centit.framework.tenant.po.TenantInfo;
import com.centit.framework.tenant.po.TenantMemberApply;
import com.centit.support.database.utils.PageDesc;

import java.util.Map;

public interface TenantService {


    /**
     * 用户注册
     * @param userinfo
     * @return
     */
    ResponseData registerUserAccount(UserInfo userinfo) ;

    /**
     * 用户新建租户
     * 1.新建租户
     * 2.根据租户信息创建租户单位
     * 3.把租户所有人与机构信息绑定
     * 4.给租户所有人创建机构管理的最高权限（最高权限怎么设置）
     * @param tenantInfo
     * @return
     */
    ResponseData applyAddTenant(TenantInfo tenantInfo);

    /**
     * 申请加入租户
     * 可以是用户主动申请，也可以是管理员邀请
     * @param tenantMemberApply
     * @return
     */
    ResponseData applyJoinTenant(TenantMemberApply tenantMemberApply);


    /**
     * 列出申请信息
     * 可以是管理员邀请的信息，也可以是用户主动申请的信息
     * @param parameters 需要包含key
     * code（用户代码或机构代码）
     * codeType（代码类型，1：用户代码2：机构代码）
     * approveType（审批类型， 1待审批 2已审批）
     * @param pageDesc
     * @return
     */
    PageQueryResult listApplyInfo(Map<String,Object> parameters, PageDesc pageDesc);

    /**
     * 平台管理员审核租户
     * @param tenantInfo
     * @return
     */
    ResponseData adminCheckTenant(TenantInfo tenantInfo);

    /**
     * 同意加入
     * 可以是平台管理员审核用户的加入
     * 也可以是普通用户同意管理员的邀请
     * @param tenantMemberApplyVo
     * @return
     */
    ResponseData agreeJoin(TenantMemberApplyVo tenantMemberApplyVo);

    /**
     * 更新用户信息
     * @param userInfo
     * @return
     */
    ResponseData updateUserInfo(UserInfo userInfo);

    /**
     * 退出租户
     * @param topUnit
     * @return
     */
    ResponseData quitTenant(String topUnit,String userCode);

    /**
     * 移除租户内的成员
     * @param topUnit
     * @param userCode
     * @return
     */
    ResponseData removeTenantMember(String topUnit,String userCode);

    /**
     * 转让租户
     * @param tenantBusinessLog
     * @return
     */
    ResponseData businessTenant(TenantBusinessLog tenantBusinessLog);


    /**
     * 平台审核租户转让
     * 租户所有者交易租户，不需要平台审核
     * @param tenantBusinessLog
     * @return
     */
    @Deprecated
    ResponseData adminCheckTenantBusiness(TenantBusinessLog tenantBusinessLog);

    /**
     * 分页列出租户列表
     * 1.可以是已经审核通过的
     * 2.也可以是待审核的
     * 3.也可以是审核不通过的
     * @param tenantInfo
     * @return
     */
    PageQueryResult<TenantInfo> pageListTenantApply(PageListTenantInfoQo tenantInfo, PageDesc pageDesc);


    /**
     * 展示该机构下的人员
     * @param params 请求参数
     * @param pageDesc 分页参数
     * @return
     */
    PageQueryResult pageListTenantMember(Map<String,Object> params, PageDesc pageDesc);

    /**
     * 租户所有者或平台管理员分配管理员权限
     * @param tenantMemberQo
     * @return
     */
    ResponseData assignTenantRole(TenantMemberQo tenantMemberQo);


    /**
     * 删除租户成员角色
     * @param tenantMemberQo
     * @return
     */
    ResponseData deleteTenantRole(TenantMemberQo tenantMemberQo);


    /**
     * 用户所在租户
     * @param userCode 用户code
     * @return
     */
    JSONArray userTenants(String userCode);


    /**
     * 根据unitName 模糊查询租户信息
     * @param filerMap
     * @param pageDesc
     * @return
     */
    PageQueryResult pageListTenants(Map<String,Object> filerMap , PageDesc pageDesc);

    /**
     * 精确查找用户
     * @param paramMap 用户信息
     *                 只能根据userCode，userName，regCellPhone精确查找
     *                 unitCode:必要 当前用户所在租户code
     * @return 查找userinfo结果
     */
    ResponseData findUsers(Map<String,Object> paramMap);


    /**
     *取消加入租户申请
     * @param parameters userCode topUnit 必传
     * @return
     */
    ResponseData cancelApply(Map<String, Object> parameters);

    /**
     * 注销租户申请
     * @param parameters topUnit必传
     * @return
     */
    ResponseData deleteTenant(Map<String, Object> parameters);

    /**
     * 更新租户信息，为系统管理员和租户所有者，租户管理员使用
     * @param tenantInfo
     * @return
     */
    ResponseData updateTenant(TenantInfo tenantInfo);

    /**
     * 创建单位 是对 com.centit.framework.system.service.SysUnitManager#saveNewUnitInfo(com.centit.framework.system.po.UnitInfo)
     * 接口的再次封装
     * @param unitInfo
     * @return
     */
    ResponseData addTenantUnit(UnitInfo unitInfo);

    /**
     * 新增用户 是对 com.centit.framework.system.controller.UserInfoController#create(com.centit.framework.system.po.UserInfo, com.centit.framework.system.po.UserUnit, javax.servlet.http.HttpServletRequest)
     * 接口的再次封装
     * @param userInfo 用户信息
     * @param userUnit 用户单位信息
     * @return
     */
    ResponseData addTenantUser(UserInfo userInfo, UserUnit userUnit);


}
