/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.ip.service.impl;

import com.centit.framework.ip.po.DatabaseInfo;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.common.CachedObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class DatabaseInfoMap
implements Map<String, String> {
    private CachedObject<List<DatabaseInfo>> databaseInfoCache;

    public DatabaseInfoMap(CachedObject<List<DatabaseInfo>> databaseInfoCache) {
        this.databaseInfoCache = databaseInfoCache;
    }

    @Override
    public int size() {
        List dbInfos = (List)this.databaseInfoCache.getCachedTarget();
        if (dbInfos == null) {
            return 0;
        }
        return dbInfos.size();
    }

    @Override
    public boolean isEmpty() {
        List dbInfos = (List)this.databaseInfoCache.getCachedTarget();
        if (dbInfos == null) {
            return true;
        }
        return dbInfos.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        List dbInfos = (List)this.databaseInfoCache.getCachedTarget();
        if (dbInfos == null) {
            return false;
        }
        for (DatabaseInfo dbi : dbInfos) {
            if (!StringUtils.equals((CharSequence)dbi.getDatabaseCode(), (CharSequence)StringBaseOpt.castObjectToString((Object)key))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        List dbInfos = (List)this.databaseInfoCache.getCachedTarget();
        if (dbInfos == null) {
            return false;
        }
        for (DatabaseInfo dbi : dbInfos) {
            if (!StringUtils.equals((CharSequence)dbi.getDatabaseName(), (CharSequence)StringBaseOpt.castObjectToString((Object)value))) continue;
            return true;
        }
        return false;
    }

    @Override
    public String get(Object key) {
        List dbInfos = (List)this.databaseInfoCache.getCachedTarget();
        if (dbInfos == null) {
            return null;
        }
        for (DatabaseInfo dbi : dbInfos) {
            if (!StringUtils.equals((CharSequence)dbi.getDatabaseCode(), (CharSequence)StringBaseOpt.castObjectToString((Object)key))) continue;
            return dbi.getDatabaseName();
        }
        return null;
    }

    @Override
    public String put(String key, String value) {
        return null;
    }

    @Override
    public String remove(Object key) {
        return null;
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> m) {
    }

    @Override
    public void clear() {
    }

    @Override
    public Set<String> keySet() {
        List dbInfos = (List)this.databaseInfoCache.getCachedTarget();
        if (dbInfos == null) {
            return null;
        }
        HashSet<String> keys = new HashSet<String>();
        for (DatabaseInfo dbi : dbInfos) {
            keys.add(dbi.getDatabaseCode());
        }
        return keys;
    }

    @Override
    public Collection<String> values() {
        List dbInfos = (List)this.databaseInfoCache.getCachedTarget();
        if (dbInfos == null) {
            return null;
        }
        ArrayList<String> values = new ArrayList<String>();
        for (DatabaseInfo dbi : dbInfos) {
            values.add(dbi.getDatabaseName());
        }
        return values;
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        List dbInfos = (List)this.databaseInfoCache.getCachedTarget();
        if (dbInfos == null) {
            return null;
        }
        HashSet<Map.Entry<String, String>> entries = new HashSet<Map.Entry<String, String>>();
        for (DatabaseInfo dbi : dbInfos) {
            entries.add((Map.Entry<String, String>)new ImmutablePair((Object)dbi.getDatabaseCode(), (Object)dbi.getDatabaseName()));
        }
        return entries;
    }
}

