/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.ip.po;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.centit.framework.core.dao.DictionaryMap;
import com.centit.support.database.metadata.IDatabaseInfo;
import com.centit.support.database.orm.GeneratorCondition;
import com.centit.support.database.orm.GeneratorTime;
import com.centit.support.database.orm.GeneratorType;
import com.centit.support.database.orm.ValueGenerator;
import com.centit.support.security.AESSecurityUtils;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="F_DATABASE_INFO")
@ApiModel(value="\u6570\u636e\u5e93\u4fe1\u606f\u5bf9\u8c61", description="\u6570\u636e\u5e93\u4fe1\u606f\u5bf9\u8c61 DatabaseInfo")
public class DatabaseInfo
implements IDatabaseInfo,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String DESKEY = "0123456789abcdefghijklmnopqrstuvwxyzABCDEF";
    @Id
    @Column(name="DATABASE_CODE")
    @ValueGenerator(strategy=GeneratorType.UUID22)
    private String databaseCode;
    @Column(name="OS_ID")
    @ApiModelProperty(value="\u7cfb\u7edf\u4ee3\u7801", name="osId")
    @DictionaryMap(value={"osInfo"}, fieldName={"osName"}, isExpression=false)
    private String osId;
    @Column(name="DATABASE_NAME")
    @ApiModelProperty(value="\u6570\u636e\u5e93\u540d", name="databaseName")
    private String databaseName;
    @Column(name="DATABASE_URL")
    @Length(max=1000, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    @ApiModelProperty(value="\u6570\u636e\u5e93\u5730\u5740", name="databaseUrl")
    private @Length(max=1000, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String databaseUrl;
    @Column(name="USERNAME")
    @Length(max=100, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    @ApiModelProperty(value="\u6570\u636e\u5e93\u7528\u6237\u540d", name="username")
    private @Length(max=100, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String username;
    @Column(name="PASSWORD")
    @Length(max=100, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    @ApiModelProperty(value="\u6570\u636e\u5e93\u5bc6\u7801", name="password")
    private @Length(max=100, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String password;
    @Column(name="DATABASE_DESC")
    @Length(max=100, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    @ApiModelProperty(value="\u6570\u636e\u5e93\u63cf\u8ff0\u4fe1\u606f", name="databaseDesc")
    private @Length(max=100, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String databaseDesc;
    @ValueGenerator(strategy=GeneratorType.FUNCTION, value="today()", condition=GeneratorCondition.ALWAYS, occasion=GeneratorTime.ALWAYS)
    @Column(name="LAST_MODIFY_DATE")
    private Date lastModifyDate;
    @Column(name="CREATED")
    @DictionaryMap(fieldName={"createUserName"}, value={"userCode"})
    private String created;
    @ValueGenerator(strategy=GeneratorType.FUNCTION, value="today()")
    @Column(name="CREATE_TIME")
    private Date createTime;
    @ApiModelProperty(value="\u6269\u5c55\u5c5e\u6027\uff0cjson\u683c\u5f0f\uff0cclob\u5b57\u6bb5")
    private JSONObject extProps;

    public DatabaseInfo() {
    }

    public DatabaseInfo(String databaseCode, String databaseName) {
        this.databaseCode = databaseCode;
        this.databaseName = databaseName;
    }

    public DatabaseInfo(String databaseCode, String databaseName, String databaseUrl, String username, String password, String dataDesc) {
        this.databaseCode = databaseCode;
        this.databaseName = databaseName;
        this.databaseUrl = databaseUrl;
        this.username = username;
        this.password = password;
        this.databaseDesc = dataDesc;
    }

    public void setPassword(String password) {
        this.password = password.startsWith("cipher:") ? password : "cipher:" + AESSecurityUtils.encryptAndBase64((String)password, (String)DESKEY);
    }

    @JSONField(serialize=false)
    public String getClearPassword() {
        return AESSecurityUtils.decryptBase64String((String)this.getPassword().substring(7), (String)DESKEY);
    }

    public String getDatabaseCode() {
        return this.databaseCode;
    }

    public String getOsId() {
        return this.osId;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getDatabaseUrl() {
        return this.databaseUrl;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getDatabaseDesc() {
        return this.databaseDesc;
    }

    public Date getLastModifyDate() {
        return this.lastModifyDate;
    }

    public String getCreated() {
        return this.created;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public JSONObject getExtProps() {
        return this.extProps;
    }

    public void setDatabaseCode(String databaseCode) {
        this.databaseCode = databaseCode;
    }

    public void setOsId(String osId) {
        this.osId = osId;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public void setDatabaseUrl(String databaseUrl) {
        this.databaseUrl = databaseUrl;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setDatabaseDesc(String databaseDesc) {
        this.databaseDesc = databaseDesc;
    }

    public void setLastModifyDate(Date lastModifyDate) {
        this.lastModifyDate = lastModifyDate;
    }

    public void setCreated(String created) {
        this.created = created;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public void setExtProps(JSONObject extProps) {
        this.extProps = extProps;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DatabaseInfo)) {
            return false;
        }
        DatabaseInfo other = (DatabaseInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$databaseCode = this.getDatabaseCode();
        String other$databaseCode = other.getDatabaseCode();
        if (this$databaseCode == null ? other$databaseCode != null : !this$databaseCode.equals(other$databaseCode)) {
            return false;
        }
        String this$osId = this.getOsId();
        String other$osId = other.getOsId();
        if (this$osId == null ? other$osId != null : !this$osId.equals(other$osId)) {
            return false;
        }
        String this$databaseName = this.getDatabaseName();
        String other$databaseName = other.getDatabaseName();
        if (this$databaseName == null ? other$databaseName != null : !this$databaseName.equals(other$databaseName)) {
            return false;
        }
        String this$databaseUrl = this.getDatabaseUrl();
        String other$databaseUrl = other.getDatabaseUrl();
        if (this$databaseUrl == null ? other$databaseUrl != null : !this$databaseUrl.equals(other$databaseUrl)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$databaseDesc = this.getDatabaseDesc();
        String other$databaseDesc = other.getDatabaseDesc();
        if (this$databaseDesc == null ? other$databaseDesc != null : !this$databaseDesc.equals(other$databaseDesc)) {
            return false;
        }
        Date this$lastModifyDate = this.getLastModifyDate();
        Date other$lastModifyDate = other.getLastModifyDate();
        if (this$lastModifyDate == null ? other$lastModifyDate != null : !((Object)this$lastModifyDate).equals(other$lastModifyDate)) {
            return false;
        }
        String this$created = this.getCreated();
        String other$created = other.getCreated();
        if (this$created == null ? other$created != null : !this$created.equals(other$created)) {
            return false;
        }
        Date this$createTime = this.getCreateTime();
        Date other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        JSONObject this$extProps = this.getExtProps();
        JSONObject other$extProps = other.getExtProps();
        return !(this$extProps == null ? other$extProps != null : !this$extProps.equals(other$extProps));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DatabaseInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $databaseCode = this.getDatabaseCode();
        result = result * 59 + ($databaseCode == null ? 43 : $databaseCode.hashCode());
        String $osId = this.getOsId();
        result = result * 59 + ($osId == null ? 43 : $osId.hashCode());
        String $databaseName = this.getDatabaseName();
        result = result * 59 + ($databaseName == null ? 43 : $databaseName.hashCode());
        String $databaseUrl = this.getDatabaseUrl();
        result = result * 59 + ($databaseUrl == null ? 43 : $databaseUrl.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $databaseDesc = this.getDatabaseDesc();
        result = result * 59 + ($databaseDesc == null ? 43 : $databaseDesc.hashCode());
        Date $lastModifyDate = this.getLastModifyDate();
        result = result * 59 + ($lastModifyDate == null ? 43 : ((Object)$lastModifyDate).hashCode());
        String $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : $created.hashCode());
        Date $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        JSONObject $extProps = this.getExtProps();
        result = result * 59 + ($extProps == null ? 43 : $extProps.hashCode());
        return result;
    }

    public String toString() {
        return "DatabaseInfo(databaseCode=" + this.getDatabaseCode() + ", osId=" + this.getOsId() + ", databaseName=" + this.getDatabaseName() + ", databaseUrl=" + this.getDatabaseUrl() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", databaseDesc=" + this.getDatabaseDesc() + ", lastModifyDate=" + this.getLastModifyDate() + ", created=" + this.getCreated() + ", createTime=" + this.getCreateTime() + ", extProps=" + this.getExtProps() + ")";
    }
}

