/*
 * Decompiled with CFR 0.152.
 */
package org.extremecomponents.tree;

import java.net.URLEncoder;
import java.util.Set;
import org.extremecomponents.table.core.TableModel;
import org.extremecomponents.util.HtmlBuilder;

public class TreeRegistryUtils {
    public static String getHiddenFields(TableModel model, String parameter) {
        HtmlBuilder html = new HtmlBuilder();
        Set keys = model.getRegistry().getParameterMap().keySet();
        for (String name : keys) {
            if ((parameter != null || name.startsWith(model.getTableHandler().prefixWithTableId())) && !name.startsWith(model.getTableHandler().prefixWithTableId() + parameter)) continue;
            String[] values = (String[])model.getRegistry().getParameterMap().get(name);
            if (values == null || values.length == 0) {
                html.newline();
                html.input("hidden").name(name).xclose();
                continue;
            }
            for (int i = 0; i < values.length; ++i) {
                html.newline();
                html.input("hidden").name(name).value(values[i]).xclose();
            }
        }
        return html.toString();
    }

    public static String getParameterString(TableModel model, String parameter) {
        HtmlBuilder html = new HtmlBuilder();
        Set keys = model.getRegistry().getParameterMap().keySet();
        for (String name : keys) {
            if ((parameter != null || name.startsWith(model.getTableHandler().prefixWithTableId())) && !name.startsWith(model.getTableHandler().prefixWithTableId() + parameter)) continue;
            String[] values = (String[])model.getRegistry().getParameterMap().get(name);
            if (values == null || values.length == 0) {
                html.ampersand().append(name).equals();
                continue;
            }
            for (int i = 0; i < values.length; ++i) {
                String encodedValue = URLEncoder.encode(values[i]);
                html.append("&amp;").append(name).equals().append(encodedValue);
            }
        }
        return html.toString();
    }

    public static String getURLParameterString(TableModel model, boolean filter, boolean sort, boolean page, boolean rowsDisplayed) {
        StringBuffer sb = new StringBuffer();
        if (filter) {
            sb.append(TreeRegistryUtils.getParameterString(model, "f_"));
        }
        if (sort) {
            sb.append(TreeRegistryUtils.getParameterString(model, "s_"));
        }
        if (page) {
            sb.append(TreeRegistryUtils.getParameterString(model, "p"));
        }
        if (rowsDisplayed) {
            sb.append(TreeRegistryUtils.getParameterString(model, "crd"));
        }
        sb.append(TreeRegistryUtils.getParameterString(model, null));
        return sb.toString();
    }

    public static String getFormHiddenFields(TableModel model, boolean filter, boolean sort, boolean page, boolean rowsDisplayed) {
        StringBuffer sb = new StringBuffer();
        if (filter) {
            sb.append(TreeRegistryUtils.getHiddenFields(model, "f_"));
        }
        if (sort) {
            sb.append(TreeRegistryUtils.getHiddenFields(model, "s_"));
        }
        if (page) {
            sb.append(TreeRegistryUtils.getHiddenFields(model, "p"));
        }
        if (rowsDisplayed) {
            sb.append(TreeRegistryUtils.getHiddenFields(model, "crd"));
        }
        sb.append(TreeRegistryUtils.getHiddenFields(model, null));
        return sb.toString();
    }
}

