/*
 * Decompiled with CFR 0.152.
 */
package org.extremecomponents.table.view.html;

import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.extremecomponents.table.bean.Column;
import org.extremecomponents.table.calc.CalcResult;
import org.extremecomponents.table.calc.CalcUtils;
import org.extremecomponents.table.core.TableModel;
import org.extremecomponents.util.ExtremeUtils;
import org.extremecomponents.util.HtmlBuilder;

public class CalcBuilder {
    private Log logger = LogFactory.getLog(CalcBuilder.class);
    private HtmlBuilder html;
    private TableModel model;

    public CalcBuilder(TableModel model) {
        this(new HtmlBuilder(), model);
    }

    public CalcBuilder(HtmlBuilder html, TableModel model) {
        this.html = html;
        this.model = model;
    }

    public HtmlBuilder getHtmlBuilder() {
        return this.html;
    }

    protected TableModel getTableModel() {
        return this.model;
    }

    public void defaultCalcLayout() {
        Column calcColumn = this.model.getColumnHandler().getFirstCalcColumn();
        if (calcColumn == null) {
            return;
        }
        String layout = this.model.getPreferences().getPreference("defaultCalcLayout");
        try {
            MethodUtils.invokeExactMethod((Object)this, (String)layout, null);
        }
        catch (Exception e) {
            this.logger.error((Object)("There is no method with the layout [" + layout + "]."), (Throwable)e);
        }
    }

    public void singleRowCalcResults() {
        this.html.tr(1).styleClass("calcRow").close();
        for (Column column : this.model.getColumnHandler().getColumns()) {
            int i;
            if (column.isFirstColumn()) {
                String[] calcTitle = CalcUtils.getFirstCalcColumnTitles(this.model);
                if (calcTitle == null || calcTitle.length <= 0) continue;
                this.html.td(2).styleClass("calcTitle").close();
                for (i = 0; i < calcTitle.length; ++i) {
                    String title = calcTitle[i];
                    this.html.append(title);
                    if (calcTitle.length <= 0 || i + 1 == calcTitle.length) continue;
                    this.html.append(" / ");
                }
                this.html.tdEnd();
                continue;
            }
            if (column.isCalculated()) {
                this.html.td(2).styleClass("calcResult").close();
                CalcResult[] calcResults = CalcUtils.getCalcResults(this.model, column);
                for (i = 0; i < calcResults.length; ++i) {
                    CalcResult calcResult = calcResults[i];
                    Number value = calcResult.getValue();
                    if (value == null) {
                        this.html.append(calcResult.getName());
                    } else {
                        this.html.append(ExtremeUtils.formatNumber(column.getFormat(), value, this.model.getLocale()));
                    }
                    if (calcResults.length <= 0 || i + 1 == calcResults.length) continue;
                    this.html.append(" / ");
                }
            } else {
                this.html.td(2).close();
                this.html.nbsp();
            }
            this.html.tdEnd();
        }
        this.html.trEnd(1);
    }

    public void multiRowCalcResults() {
        Column firstCalcColumn = this.model.getColumnHandler().getFirstCalcColumn();
        int rows = firstCalcColumn.getCalc().length;
        for (int i = 0; i < rows; ++i) {
            this.html.tr(1).styleClass("calcRow").close();
            for (Column column : this.model.getColumnHandler().getColumns()) {
                if (column.isFirstColumn()) {
                    String calcTitle = CalcUtils.getFirstCalcColumnTitleByPosition(this.model, i);
                    this.html.td(2).styleClass("calcTitle").close();
                    this.html.append(calcTitle);
                    this.html.tdEnd();
                    continue;
                }
                if (column.isCalculated()) {
                    this.html.td(2).styleClass("calcResult").close();
                    CalcResult calcResult = CalcUtils.getCalcResultsByPosition(this.model, column, i);
                    Number value = calcResult.getValue();
                    if (value == null) {
                        this.html.append(calcResult.getName());
                    } else {
                        this.html.append(ExtremeUtils.formatNumber(column.getFormat(), value, this.model.getLocale()));
                    }
                } else {
                    this.html.td(2).close();
                    this.html.nbsp();
                }
                this.html.tdEnd();
            }
            this.html.trEnd(1);
        }
    }

    public String toString() {
        return this.html.toString();
    }
}

