/*
 * Decompiled with CFR 0.152.
 */
package org.extremecomponents.table.tag;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.servlet.jsp.tagext.Tag;
import org.apache.commons.lang.StringUtils;
import org.apache.taglibs.standard.lang.support.ExpressionEvaluatorManager;
import org.extremecomponents.table.bean.Column;
import org.extremecomponents.table.core.TableModel;
import org.extremecomponents.table.core.TableModelUtils;
import org.extremecomponents.table.interceptor.ColumnInterceptor;
import org.extremecomponents.table.tag.TagUtils;
import org.extremecomponents.util.ExceptionUtils;

public class ColumnTag
extends BodyTagSupport
implements ColumnInterceptor {
    private String alias;
    private String calc;
    private String calcTitle;
    private String cell;
    private Object filterOptions;
    private String filterable;
    private String filterCell;
    private String filterClass;
    private String filterStyle;
    private String format;
    private String headerCell;
    private String headerClass;
    private String headerStyle;
    private String interceptor;
    private String parse;
    private String property;
    private String sortable;
    private String style;
    private String styleClass;
    private String title;
    private Object value;
    private String viewsAllowed;
    private String viewsDenied;
    private String width;
    private String escapeAutoFormat;

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setCalc(String calc) {
        this.calc = calc;
    }

    public void setCalcTitle(String totalTitle) {
        this.calcTitle = totalTitle;
    }

    public void setCell(String cell) {
        this.cell = cell;
    }

    public void setEscapeAutoFormat(String escapeAutoFormat) {
        this.escapeAutoFormat = escapeAutoFormat;
    }

    public void setFilterable(String filterable) {
        this.filterable = filterable;
    }

    public void setFilterCell(String filterCell) {
        this.filterCell = filterCell;
    }

    public void setFilterClass(String filterClass) {
        this.filterClass = filterClass;
    }

    public void setFilterOptions(Object filterOptions) {
        this.filterOptions = filterOptions;
    }

    public void setFilterStyle(String filterStyle) {
        this.filterStyle = filterStyle;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setHeaderCell(String headerCell) {
        this.headerCell = headerCell;
    }

    public void setHeaderClass(String headerClass) {
        this.headerClass = headerClass;
    }

    public void setHeaderStyle(String headerStyle) {
        this.headerStyle = headerStyle;
    }

    public void setInterceptor(String interceptor) {
        this.interceptor = interceptor;
    }

    public void setParse(String parse) {
        this.parse = parse;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public void setSortable(String sortable) {
        this.sortable = sortable;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public void setStyleClass(String styleClass) {
        this.styleClass = styleClass;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void setViewsAllowed(String viewsAllowed) {
        this.viewsAllowed = viewsAllowed;
    }

    public void setViewsDenied(String viewsDenied) {
        this.viewsDenied = viewsDenied;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    protected Object getColumnValue(Object propertyValue) throws JspException {
        Object result = this.value;
        if (result == null && this.bodyContent != null) {
            result = this.getBodyContent().getString();
        }
        if (result != null) {
            result = ExpressionEvaluatorManager.evaluate((String)"result", (String)result.toString(), Object.class, (Tag)this, (PageContext)this.pageContext);
        }
        if (result == null || result != null && result instanceof String && StringUtils.isBlank((String)result.toString())) {
            result = propertyValue;
        }
        return result;
    }

    public int doStartTag() throws JspException {
        if (!TagUtils.isIteratingBody((Tag)this)) {
            return 0;
        }
        return 2;
    }

    public int doEndTag() throws JspException {
        try {
            TableModel model = TagUtils.getModel((Tag)this);
            if (TagUtils.isIteratingBody((Tag)this)) {
                String alias = TagUtils.evaluateExpressionAsString("alias", this.alias, (Tag)this, this.pageContext);
                String property = TagUtils.evaluateExpressionAsString("property", this.property, (Tag)this, this.pageContext);
                Column column = model.getColumnHandler().getColumnByAlias(TableModelUtils.getAlias(alias, property));
                if (column != null) {
                    Object bean = TagUtils.getModel((Tag)this).getCurrentRowBean();
                    Object propertyValue = TableModelUtils.getColumnPropertyValue(bean, property);
                    column.setValue(this.getColumnValue(propertyValue));
                    column.setPropertyValue(propertyValue);
                    this.modifyColumnAttributes(model, column);
                    model.getColumnHandler().modifyColumnAttributes(column);
                    model.getViewHandler().addColumnValueToView(column);
                }
            } else {
                Column column = new Column(model);
                column.setAlias(TagUtils.evaluateExpressionAsString("alias", this.alias, (Tag)this, this.pageContext));
                column.setCalc(TagUtils.evaluateExpressionAsString("calc", this.calc, (Tag)this, this.pageContext));
                column.setCalcTitle(TagUtils.evaluateExpressionAsString("calcTitle", this.calcTitle, (Tag)this, this.pageContext));
                column.setCell(TagUtils.evaluateExpressionAsString("cell", this.cell, (Tag)this, this.pageContext));
                column.setEscapeAutoFormat(TagUtils.evaluateExpressionAsBoolean("escapeAutoFormat", this.escapeAutoFormat, (Tag)this, this.pageContext));
                column.setFilterable(TagUtils.evaluateExpressionAsBoolean("filterable", this.filterable, (Tag)this, this.pageContext));
                column.setFilterCell(TagUtils.evaluateExpressionAsString("filterCell", this.filterCell, (Tag)this, this.pageContext));
                column.setFilterClass(TagUtils.evaluateExpressionAsString("filterClass", this.filterClass, (Tag)this, this.pageContext));
                column.setFilterOptions(TagUtils.evaluateExpressionAsObject("filterOptions", this.filterOptions, (Tag)this, this.pageContext));
                column.setFilterStyle(TagUtils.evaluateExpressionAsString("filterStyle", this.filterStyle, (Tag)this, this.pageContext));
                column.setFormat(TagUtils.evaluateExpressionAsString("format", this.format, (Tag)this, this.pageContext));
                column.setHeaderCell(TagUtils.evaluateExpressionAsString("headerCell", this.headerCell, (Tag)this, this.pageContext));
                column.setHeaderClass(TagUtils.evaluateExpressionAsString("headerClass", this.headerClass, (Tag)this, this.pageContext));
                column.setHeaderStyle(TagUtils.evaluateExpressionAsString("headerStyle", this.headerStyle, (Tag)this, this.pageContext));
                column.setInterceptor(TagUtils.evaluateExpressionAsString("interceptor", this.interceptor, (Tag)this, this.pageContext));
                column.setParse(TagUtils.evaluateExpressionAsString("parse", this.parse, (Tag)this, this.pageContext));
                column.setProperty(TagUtils.evaluateExpressionAsString("property", this.property, (Tag)this, this.pageContext));
                column.setSortable(TagUtils.evaluateExpressionAsBoolean("sortable", this.sortable, (Tag)this, this.pageContext));
                column.setStyle(TagUtils.evaluateExpressionAsString("style", this.style, (Tag)this, this.pageContext));
                column.setStyleClass(TagUtils.evaluateExpressionAsString("styleClass", this.styleClass, (Tag)this, this.pageContext));
                column.setTitle(TagUtils.evaluateExpressionAsString("title", this.title, (Tag)this, this.pageContext));
                column.setViewsAllowed(TagUtils.evaluateExpressionAsString("viewsToAllow", this.viewsAllowed, (Tag)this, this.pageContext));
                column.setViewsDenied(TagUtils.evaluateExpressionAsString("viewsToDeny", this.viewsDenied, (Tag)this, this.pageContext));
                column.setWidth(TagUtils.evaluateExpressionAsString("width", this.width, (Tag)this, this.pageContext));
                this.addColumnAttributes(model, column);
                model.getColumnHandler().addColumn(column);
            }
            if (this.bodyContent != null) {
                this.bodyContent.clearBody();
            }
        }
        catch (Exception e) {
            throw new JspException("ColumnTag.doEndTag() Problem: " + ExceptionUtils.formatStackTrace(e));
        }
        return 6;
    }

    public void addColumnAttributes(TableModel model, Column column) {
    }

    public void modifyColumnAttributes(TableModel model, Column column) {
    }

    public void release() {
        this.alias = null;
        this.calc = null;
        this.calcTitle = null;
        this.cell = null;
        this.escapeAutoFormat = null;
        this.filterable = null;
        this.filterCell = null;
        this.filterClass = null;
        this.filterStyle = null;
        this.format = null;
        this.headerCell = null;
        this.headerClass = null;
        this.headerStyle = null;
        this.interceptor = null;
        this.parse = null;
        this.property = null;
        this.sortable = null;
        this.style = null;
        this.styleClass = null;
        this.title = null;
        this.value = null;
        this.viewsAllowed = null;
        this.viewsDenied = null;
        this.width = null;
        super.release();
    }
}

