/*
 * Decompiled with CFR 0.152.
 */
package org.extremecomponents.table.handler;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.extremecomponents.table.bean.Export;
import org.extremecomponents.table.core.TableCache;
import org.extremecomponents.table.core.TableModel;
import org.extremecomponents.table.core.TableModelUtils;

public class ExportHandler {
    private static Log logger = LogFactory.getLog(ExportHandler.class);
    private TableModel model;
    private List exports = new ArrayList();

    public ExportHandler(TableModel model) {
        this.model = model;
    }

    public void addExport(Export export) {
        this.exports.add(export);
        this.addExportAttributes(export);
        export.defaults();
    }

    public void addExportAttributes(Export export) {
        String interceptor = TableModelUtils.getInterceptPreference(this.model, export.getInterceptor(), "export.interceptor.");
        export.setInterceptor(interceptor);
        TableCache.getInstance().getExportInterceptor(interceptor).addExportAttributes(this.model, export);
    }

    public Export getExport(String view) {
        for (Export export : this.exports) {
            if (!export.getView().equals(view)) continue;
            return export;
        }
        return null;
    }

    public Export getCurrentExport() {
        String prefixWithTableId = this.model.getTableHandler().prefixWithTableId();
        String exportView = this.model.getRegistry().getParameter(prefixWithTableId + "ev");
        Export export = this.getExport(exportView);
        if (export == null) {
            String msg = "There is no export defined. This commonly happens if you do not declare the export (Export or ExportTag) before the row and columns.";
            logger.error((Object)msg);
            throw new IllegalStateException(msg);
        }
        return export;
    }

    public List getExports() {
        return this.exports;
    }

    public boolean isExported() {
        return this.model.getExportHandler().isExported();
    }

    public boolean showExports() {
        if (!this.model.getTableHandler().getTable().isShowExports()) {
            return false;
        }
        return this.getExports().size() > 0;
    }
}

