/*
 * Decompiled with CFR 0.152.
 */
package org.extremecomponents.table.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.extremecomponents.table.context.Context;
import org.extremecomponents.table.context.HttpServletRequestContext;
import org.extremecomponents.table.core.TableModelUtils;
import org.extremecomponents.table.core.TableProperties;
import org.extremecomponents.table.filter.ExportFilterUtils;
import org.extremecomponents.table.filter.ViewResolver;
import org.extremecomponents.util.MimeUtils;

public abstract class AbstractExportFilter
implements Filter {
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequestContext context = new HttpServletRequestContext((HttpServletRequest)request);
        boolean isExported = ExportFilterUtils.isExported(context);
        if (isExported) {
            String exportFileName = ExportFilterUtils.getExportFileName(context);
            this.doFilterInternal(request, response, chain, exportFileName);
            this.handleExport((HttpServletRequest)request, (HttpServletResponse)response, context);
        } else {
            chain.doFilter(request, response);
        }
    }

    protected void handleExport(HttpServletRequest request, HttpServletResponse response, Context context) {
        try {
            Object viewData = request.getAttribute("viewData");
            if (viewData != null) {
                TableProperties preferences = new TableProperties();
                preferences.init(null, TableModelUtils.getPreferencesLocation(context));
                String viewResolver = (String)request.getAttribute("viewResolver");
                Class<?> classDefinition = Class.forName(viewResolver);
                ViewResolver handleExportViewResolver = (ViewResolver)classDefinition.newInstance();
                handleExportViewResolver.resolveView((ServletRequest)request, (ServletResponse)response, preferences, viewData);
                response.getOutputStream().flush();
                response.getOutputStream().close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void setResponseHeaders(HttpServletResponse response, String exportFileName) {
        String mimeType = MimeUtils.getFileMimeType(exportFileName);
        if (StringUtils.isNotBlank((String)mimeType)) {
            response.setContentType(mimeType);
        }
        response.setHeader("Content-Disposition", "attachment;filename=\"" + exportFileName + "\"");
        response.setHeader("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
        response.setHeader("Pragma", "public");
        response.setDateHeader("Expires", System.currentTimeMillis() + 1000L);
    }

    protected abstract void doFilterInternal(ServletRequest var1, ServletResponse var2, FilterChain var3, String var4) throws IOException, ServletException;
}

