/*
 * Decompiled with CFR 0.152.
 */
package org.extremecomponents.table.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.extremecomponents.table.bean.Column;
import org.extremecomponents.table.bean.Export;
import org.extremecomponents.table.bean.Row;
import org.extremecomponents.table.bean.Table;
import org.extremecomponents.table.context.Context;
import org.extremecomponents.table.core.Messages;
import org.extremecomponents.table.core.Preferences;
import org.extremecomponents.table.core.Registry;
import org.extremecomponents.table.core.TableCache;
import org.extremecomponents.table.core.TableModel;
import org.extremecomponents.table.core.TableModelUtils;
import org.extremecomponents.table.core.TableProperties;
import org.extremecomponents.table.core.TableRegistry;
import org.extremecomponents.table.handler.ColumnHandler;
import org.extremecomponents.table.handler.ExportHandler;
import org.extremecomponents.table.handler.RowHandler;
import org.extremecomponents.table.handler.TableHandler;
import org.extremecomponents.table.handler.ViewHandler;
import org.extremecomponents.table.limit.Limit;
import org.extremecomponents.table.limit.ModelLimitFactory;
import org.extremecomponents.table.limit.TableLimit;

public final class TableModelImpl
implements TableModel {
    private static Log logger = LogFactory.getLog(TableModel.class);
    private Context context;
    private Preferences preferences;
    private Messages messages;
    private Registry registry;
    private TableHandler tableHandler = new TableHandler(this);
    private RowHandler rowHandler = new RowHandler(this);
    private ColumnHandler columnHandler = new ColumnHandler(this);
    private ViewHandler viewHandler = new ViewHandler(this);
    private ExportHandler exportHandler = new ExportHandler(this);
    private Object currentRowBean;
    private Collection collectionOfBeans;
    private Collection collectionOfFilteredBeans;
    private Collection collectionOfPageBeans;
    private Limit limit;
    private Locale locale;

    public TableModelImpl(Context context) {
        this(context, null);
    }

    public TableModelImpl(Context context, String locale) {
        this.context = context;
        TableProperties preferences = new TableProperties();
        preferences.init(context, TableModelUtils.getPreferencesLocation(context));
        this.preferences = preferences;
        this.locale = TableModelUtils.getLocale(context, preferences, locale);
        Messages messages = TableModelUtils.getMessages(this);
        messages.init(context, this.locale);
        this.messages = messages;
    }

    public Context getContext() {
        return this.context;
    }

    public Preferences getPreferences() {
        return this.preferences;
    }

    public Messages getMessages() {
        return this.messages;
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public Table getTableInstance() {
        return new Table(this);
    }

    public Export getExportInstance() {
        return new Export(this);
    }

    public Row getRowInstance() {
        return new Row(this);
    }

    public Column getColumnInstance() {
        return new Column(this);
    }

    public void addTable(Table table) {
        this.tableHandler.addTable(table);
        this.registry = new TableRegistry(this);
        ModelLimitFactory limitFactory = new ModelLimitFactory(this);
        this.limit = new TableLimit(limitFactory);
    }

    public void addExport(Export export) {
        this.exportHandler.addExport(export);
    }

    public void addRow(Row row) {
        this.rowHandler.addRow(row);
    }

    public void addColumn(Column column) {
        this.columnHandler.addAutoGenerateColumn(column);
    }

    public void addColumns(String autoGenerateColumns) {
        autoGenerateColumns = TableModelUtils.getAutoGenerateColumnsPreference(this, autoGenerateColumns);
        TableCache.getInstance().getAutoGenerateColumns(autoGenerateColumns).addColumns(this);
    }

    public void addParameter(String name, Object value) {
        this.registry.addParameter(name, value);
    }

    public TableHandler getTableHandler() {
        return this.tableHandler;
    }

    public RowHandler getRowHandler() {
        return this.rowHandler;
    }

    public ColumnHandler getColumnHandler() {
        return this.columnHandler;
    }

    public ViewHandler getViewHandler() {
        return this.viewHandler;
    }

    public ExportHandler getExportHandler() {
        return this.exportHandler;
    }

    public Object getCurrentRowBean() {
        return this.currentRowBean;
    }

    public void setCurrentRowBean(Object bean) {
        int rowcount = this.rowHandler.increaseRowCount();
        this.currentRowBean = bean;
        this.context.setPageAttribute("ROWCOUNT", String.valueOf(rowcount));
        this.context.setPageAttribute(this.tableHandler.getTable().getVar(), bean);
    }

    public Collection getCollectionOfBeans() {
        return this.collectionOfBeans;
    }

    public void setCollectionOfBeans(Collection collectionOfBeans) {
        this.collectionOfBeans = collectionOfBeans;
    }

    public Collection getCollectionOfFilteredBeans() {
        return this.collectionOfFilteredBeans;
    }

    public void setCollectionOfFilteredBeans(Collection collectionOfFilteredBeans) {
        this.collectionOfFilteredBeans = collectionOfFilteredBeans;
    }

    public Collection getCollectionOfPageBeans() {
        return this.collectionOfPageBeans;
    }

    public void setCollectionOfPageBeans(Collection collectionOfPageBeans) {
        this.collectionOfPageBeans = collectionOfPageBeans;
    }

    public Limit getLimit() {
        return this.limit;
    }

    public void setLimit(Limit limit) {
        this.limit = limit;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Collection execute() throws Exception {
        Collection rows = TableModelUtils.retrieveRows(this);
        rows = new ArrayList(rows);
        int rowsize = rows.size();
        this.collectionOfBeans = rows;
        rows = TableModelUtils.filterRows(this, rows);
        this.collectionOfFilteredBeans = rows = TableModelUtils.sortRows(this, rows);
        Integer totalRows = this.getTableHandler().getTotalRows();
        int defaultRowsDisplayed = this.getTableHandler().getTable().getRowsDisplayed();
        if (totalRows != null) {
            this.limit.setRowAttributes(totalRows, defaultRowsDisplayed);
        } else {
            this.limit.setRowAttributes(rows.size(), defaultRowsDisplayed);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)this.limit.toString());
        }
        this.collectionOfPageBeans = rows = TableModelUtils.getCurrentRows(this, rows);
        this.viewHandler.setView();
        return rows;
    }

    public void setColumnValues() throws Exception {
        List columns = this.columnHandler.getColumns();
        for (Column column : columns) {
            if (!"true".equals(column.getAttribute("isAutoGenerateColumn"))) continue;
            String property = column.getProperty();
            Object propertyValue = TableModelUtils.getColumnPropertyValue(this.currentRowBean, property);
            column.setValue(propertyValue);
            column.setPropertyValue(propertyValue);
            this.columnHandler.modifyColumnAttributes(column);
            this.viewHandler.addColumnValueToView(column);
        }
    }

    public Object getViewData() throws Exception {
        Object viewData = this.viewHandler.getView().afterBody(this);
        if (this.limit.isExported()) {
            this.context.setRequestAttribute("viewData", viewData);
            this.context.setRequestAttribute("viewResolver", this.exportHandler.getCurrentExport().getViewResolver());
            this.context.setRequestAttribute("efn", this.exportHandler.getCurrentExport().getFileName());
            return "";
        }
        return viewData;
    }

    public Object assemble() throws Exception {
        Iterator iterator;
        Iterator iter = iterator = this.execute().iterator();
        while (iter.hasNext()) {
            Object bean = iterator.next();
            this.setCurrentRowBean(bean);
            this.getRowHandler().modifyRowAttributes();
            this.setColumnValues();
        }
        return this.getViewData();
    }
}

