/*
 * Decompiled with CFR 0.152.
 */
package org.extremecomponents.table.bean;

import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.extremecomponents.table.bean.Column;
import org.extremecomponents.table.core.RetrievalUtils;
import org.extremecomponents.table.core.TableModel;
import org.extremecomponents.table.core.TableModelUtils;
import org.extremecomponents.util.ExtremeUtils;

final class ColumnDefaults {
    ColumnDefaults() {
    }

    static String getCell(TableModel model, String cell) {
        String result;
        if (StringUtils.isNotBlank((String)cell)) {
            result = model.getPreferences().getPreference("column.cell." + cell);
            if (StringUtils.isBlank((String)result)) {
                result = cell;
            }
        } else {
            result = model.getPreferences().getPreference("column.cell.display");
        }
        return result;
    }

    static String getFilterCell(TableModel model, String filterCell) {
        String result;
        if (StringUtils.isNotBlank((String)filterCell)) {
            result = model.getPreferences().getPreference("column.filterCell." + filterCell);
            if (StringUtils.isBlank((String)result)) {
                result = filterCell;
            }
        } else {
            result = model.getPreferences().getPreference("column.filterCell.filter");
        }
        return result;
    }

    static String getHeaderCell(TableModel model, String headerCell) {
        String result;
        if (StringUtils.isNotBlank((String)headerCell)) {
            result = model.getPreferences().getPreference("column.headerCell." + headerCell);
            if (StringUtils.isBlank((String)result)) {
                result = headerCell;
            }
        } else {
            result = model.getPreferences().getPreference("column.headerCell.header");
        }
        return result;
    }

    static String getParse(TableModel model, Column column, String parse) {
        if (StringUtils.isNotBlank((String)parse)) {
            return parse;
        }
        if (column.isDate()) {
            return model.getPreferences().getPreference("column.parse.date");
        }
        return parse;
    }

    static String getFormat(TableModel model, Column column, String format) {
        String result = ColumnDefaults.getFormatInResourceBundle(model, column, format);
        if (StringUtils.isBlank((String)result)) {
            result = ColumnDefaults.getFormatInProperties(model, column, format);
        }
        if (StringUtils.isNotBlank((String)result)) {
            return result;
        }
        return format;
    }

    static String getFormatInResourceBundle(TableModel model, Column column, String format) {
        if (StringUtils.isNotBlank((String)format) && ColumnDefaults.isNamedFormat(format)) {
            return model.getMessages().getMessage("column.format." + format);
        }
        if (StringUtils.isBlank((String)format)) {
            if (column.isCurrency()) {
                return model.getMessages().getMessage("column.format.currency");
            }
            if (column.isDate()) {
                return model.getMessages().getMessage("column.format.date");
            }
        }
        return null;
    }

    static String getFormatInProperties(TableModel model, Column column, String format) {
        if (StringUtils.isNotBlank((String)format) && ColumnDefaults.isNamedFormat(format)) {
            return model.getPreferences().getPreference("column.format." + format);
        }
        if (StringUtils.isBlank((String)format)) {
            if (column.isCurrency()) {
                return model.getPreferences().getPreference("column.format.currency");
            }
            if (column.isDate()) {
                return model.getPreferences().getPreference("column.format.date");
            }
        }
        return null;
    }

    static boolean isNamedFormat(String format) {
        char[] args = new char[]{'#', '/', '-'};
        return StringUtils.containsNone((String)format, (char[])args);
    }

    static Boolean isSortable(TableModel model, Boolean sortable) {
        if (sortable == null) {
            return new Boolean(model.getTableHandler().getTable().isSortable());
        }
        return sortable;
    }

    static Boolean isFilterable(TableModel model, Boolean filterable) {
        if (filterable == null) {
            return new Boolean(model.getTableHandler().getTable().isFilterable());
        }
        return filterable;
    }

    static String getTitle(TableModel model, String title, String property) {
        String resourceValue;
        if (StringUtils.isEmpty((String)title)) {
            return ExtremeUtils.camelCaseToWord(property);
        }
        if (TableModelUtils.isResourceBundleProperty(title) && (resourceValue = model.getMessages().getMessage(title)) != null) {
            return resourceValue;
        }
        return title;
    }

    static String getHeaderClass(TableModel model, String headerClass) {
        if (StringUtils.isBlank((String)headerClass)) {
            return model.getPreferences().getPreference("table.headerClass");
        }
        return headerClass;
    }

    static String getAlias(String alias, String property) {
        if (StringUtils.isBlank((String)alias) && StringUtils.isNotBlank((String)property)) {
            return property;
        }
        return alias;
    }

    public static String[] getCalcTitle(TableModel model, String[] calcTitle) {
        ArrayList<String> results = new ArrayList<String>();
        if (calcTitle == null) {
            return new String[0];
        }
        for (int i = 0; i < calcTitle.length; ++i) {
            String title = calcTitle[i];
            if (TableModelUtils.isResourceBundleProperty(title)) {
                String resourceValue = model.getMessages().getMessage(title);
                if (resourceValue == null) {
                    resourceValue = title;
                }
                if (!StringUtils.isNotBlank((String)resourceValue)) continue;
                results.add(resourceValue);
                continue;
            }
            results.add(title);
        }
        return results.toArray(new String[results.size()]);
    }

    static Boolean isEscapeAutoFormat(TableModel model, Boolean escapeAutoFormat) {
        if (escapeAutoFormat == null) {
            return Boolean.valueOf(model.getPreferences().getPreference("column.escapeAutoFormat"));
        }
        return escapeAutoFormat;
    }

    static Object getFilterOptions(TableModel model, Object filterOptions) {
        try {
            if (filterOptions != null) {
                return RetrievalUtils.retrieveCollection(model.getContext(), filterOptions);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

