/*
 * Decompiled with CFR 0.152.
 */
package org.extremecomponents.table.bean;

import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.extremecomponents.table.bean.Attributes;
import org.extremecomponents.table.bean.ColumnDefaults;
import org.extremecomponents.table.core.TableModel;

public class Column
extends Attributes {
    private TableModel model;
    private String alias;
    private String[] calc;
    private String[] calcTitle;
    private String cell;
    private String cellDisplay;
    private Object filterOptions;
    private Boolean escapeAutoFormat;
    private Boolean filterable;
    private String filterCell;
    private String filterClass;
    private String filterStyle;
    private String format;
    private String headerCell;
    private String headerClass;
    private String headerStyle;
    private String interceptor;
    private String parse;
    private String property;
    private Object propertyValue;
    private Boolean sortable;
    private String style;
    private String styleClass;
    private String title;
    private Object value;
    private String[] viewsAllowed;
    private String[] viewsDenied;
    private String width;
    private boolean isFirstColumn;
    private boolean isLastColumn;

    public Column(TableModel model) {
        this.model = model;
    }

    public void defaults() {
        this.cell = ColumnDefaults.getCell(this.model, this.cell);
        this.alias = ColumnDefaults.getAlias(this.alias, this.property);
        this.calcTitle = ColumnDefaults.getCalcTitle(this.model, this.calcTitle);
        this.escapeAutoFormat = ColumnDefaults.isEscapeAutoFormat(this.model, this.escapeAutoFormat);
        this.format = ColumnDefaults.getFormat(this.model, this, this.format);
        this.filterable = ColumnDefaults.isFilterable(this.model, this.filterable);
        this.filterCell = ColumnDefaults.getFilterCell(this.model, this.filterCell);
        this.filterOptions = ColumnDefaults.getFilterOptions(this.model, this.filterOptions);
        this.headerCell = ColumnDefaults.getHeaderCell(this.model, this.headerCell);
        this.headerClass = ColumnDefaults.getHeaderClass(this.model, this.headerClass);
        this.parse = ColumnDefaults.getParse(this.model, this, this.parse);
        this.sortable = ColumnDefaults.isSortable(this.model, this.sortable);
        this.title = ColumnDefaults.getTitle(this.model, this.title, this.alias);
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public boolean isCalculated() {
        return this.calc != null && this.calc.length > 0;
    }

    public String[] getCalc() {
        return this.calc;
    }

    public void setCalc(String calc) {
        if (calc != null) {
            this.calc = StringUtils.split((String)calc, (String)",");
        }
    }

    public String[] getCalcTitle() {
        return this.calcTitle;
    }

    public void setCalcTitle(String calcTitle) {
        if (calcTitle != null) {
            this.calcTitle = StringUtils.split((String)calcTitle, (String)",");
        }
    }

    public String getCell() {
        return this.cell;
    }

    public void setCell(String cell) {
        this.cell = cell;
    }

    public String getCellDisplay() {
        return this.cellDisplay;
    }

    public void setCellDisplay(String cellDisplay) {
        this.cellDisplay = cellDisplay;
    }

    public Collection getFilterOptions() {
        return (Collection)this.filterOptions;
    }

    public void setFilterOptions(Object filterOptions) {
        this.filterOptions = filterOptions;
    }

    public boolean isEscapeAutoFormat() {
        return this.escapeAutoFormat;
    }

    public void setEscapeAutoFormat(Boolean escapeAutoFormat) {
        this.escapeAutoFormat = escapeAutoFormat;
    }

    public boolean isFilterable() {
        return this.filterable;
    }

    public void setFilterable(Boolean filterable) {
        this.filterable = filterable;
    }

    public String getFilterCell() {
        return this.filterCell;
    }

    public void setFilterCell(String filterCell) {
        this.filterCell = filterCell;
    }

    public String getFilterClass() {
        return this.filterClass;
    }

    public void setFilterClass(String filterClass) {
        this.filterClass = filterClass;
    }

    public String getFilterStyle() {
        return this.filterStyle;
    }

    public void setFilterStyle(String filterStyle) {
        this.filterStyle = filterStyle;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getHeaderCell() {
        return this.headerCell;
    }

    public void setHeaderCell(String headerCell) {
        this.headerCell = headerCell;
    }

    public String getHeaderClass() {
        return this.headerClass;
    }

    public void setHeaderClass(String headerClass) {
        this.headerClass = headerClass;
    }

    public String getHeaderStyle() {
        return this.headerStyle;
    }

    public void setHeaderStyle(String headerStyle) {
        this.headerStyle = headerStyle;
    }

    public String getInterceptor() {
        return this.interceptor;
    }

    public void setInterceptor(String interceptor) {
        this.interceptor = interceptor;
    }

    public String getParse() {
        return this.parse;
    }

    public void setParse(String parse) {
        this.parse = parse;
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public Object getPropertyValue() {
        return this.propertyValue;
    }

    public String getPropertyValueAsString() {
        Object value = this.getPropertyValue();
        if (value != null) {
            return String.valueOf(value);
        }
        return "";
    }

    public void setPropertyValue(Object propertyValue) {
        this.propertyValue = propertyValue;
    }

    public boolean isSortable() {
        return this.sortable;
    }

    public void setSortable(Boolean sortable) {
        this.sortable = sortable;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String getStyleClass() {
        return this.styleClass;
    }

    public void setStyleClass(String styleClass) {
        this.styleClass = styleClass;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Object getValue() {
        return this.value;
    }

    public String getValueAsString() {
        Object value = this.getValue();
        if (value != null) {
            return String.valueOf(value);
        }
        return "";
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public String[] getViewsAllowed() {
        return this.viewsAllowed;
    }

    public void setViewsAllowed(String viewsAllowed) {
        if (viewsAllowed != null) {
            this.viewsAllowed = StringUtils.split((String)viewsAllowed, (String)",");
        }
    }

    public String[] getViewsDenied() {
        return this.viewsDenied;
    }

    public void setViewsDenied(String viewsDenied) {
        if (viewsDenied != null) {
            this.viewsDenied = StringUtils.split((String)viewsDenied, (String)",");
        }
    }

    public String getWidth() {
        return this.width;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public boolean isDate() {
        return StringUtils.isNotEmpty((String)this.getCell()) && this.getCell().equals(this.model.getPreferences().getPreference("column.cell.date"));
    }

    public boolean isCurrency() {
        return StringUtils.isNotBlank((String)this.getCell()) && this.getCell().equalsIgnoreCase(this.model.getPreferences().getPreference("column.cell.currency"));
    }

    public boolean isFirstColumn() {
        return this.isFirstColumn;
    }

    public void setFirstColumn(boolean isFirstColumn) {
        this.isFirstColumn = isFirstColumn;
    }

    public boolean isLastColumn() {
        return this.isLastColumn;
    }

    public void setLastColumn(boolean isLastColumn) {
        this.isLastColumn = isLastColumn;
    }
}

