/*
 * Decompiled with CFR 0.152.
 */
package com.centit.upload.util;

import com.centit.core.common.SysParametersUtils;
import java.io.File;

public class Configurations {
    private static final String REPOSITORY = System.getProperty("java.io.tmpdir", String.valueOf(File.separator) + "tmp" + File.separator + "upload-repository");

    public static String getConfig(String key) {
        return Configurations.getConfig(key, null);
    }

    public static String getConfig(String key, String defaultValue) {
        return SysParametersUtils.getStringValue((String)key, (String)defaultValue);
    }

    public static int getConfig(String key, int defaultValue) {
        return SysParametersUtils.getIntValue((String)key, (int)defaultValue);
    }

    public static String getFileRepository() {
        String val = Configurations.getConfig("STREAM_FILE_REPOSITORY");
        if (val == null || val.isEmpty()) {
            val = REPOSITORY;
        }
        return val;
    }

    public static String getCrossServer() {
        return Configurations.getConfig("STREAM_CROSS_SERVER");
    }

    public static String getCrossOrigins() {
        return Configurations.getConfig("STREAM_CROSS_ORIGIN");
    }

    public static boolean getBoolean(String key) {
        return Boolean.parseBoolean(Configurations.getConfig(key));
    }

    public static boolean isDeleteFinished() {
        return Configurations.getBoolean("STREAM_DELETE_FINISH");
    }

    public static boolean isCrossed() {
        return Configurations.getBoolean("STREAM_IS_CROSS");
    }
}

