/*
 * Decompiled with CFR 0.152.
 */
package com.centit.upload.controller;

import com.alibaba.fastjson.JSONObject;
import com.centit.core.controller.BaseController;
import com.centit.upload.po.FileGroup;
import com.centit.upload.po.FileStroeInfo;
import com.centit.upload.service.FileGroupManager;
import com.centit.upload.service.FileStoreInfoManager;
import com.centit.upload.util.IoUtil;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/fileList"})
public class FileListController
extends BaseController {
    @Resource
    private FileStoreInfoManager fileStoreInfoManager;
    @Resource
    private FileGroupManager fileGroupManager;

    @RequestMapping(value={"/{groupId}"}, method={RequestMethod.GET})
    public void list(@PathVariable(value="groupId") String groupId, HttpServletRequest request, HttpServletResponse response) {
        response.setContentType("application/javascript;charset=UTF-8");
        JSONObject json = new JSONObject();
        Map searchColumn = FileListController.convertSearchColumn((HttpServletRequest)request);
        searchColumn.put("isValid", "T");
        List infoList = this.fileStoreInfoManager.listObjects(searchColumn);
        json.put("data", (Object)infoList);
        try {
            response.getWriter().write("jsonpCallback(" + json.toString() + ")");
            IoUtil.close(response.getWriter());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @RequestMapping(method={RequestMethod.GET})
    public void createGroupId(HttpServletRequest request, HttpServletResponse response) {
        try {
            FileGroup group = new FileGroup();
            JSONObject json = new JSONObject();
            Serializable groupId = this.fileGroupManager.saveNewObject(group);
            json.put("groupId", (Object)groupId);
            response.getWriter().print("jsonpCallback(" + json.toString() + ")");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @RequestMapping(value={"/delete/{filedId}"}, method={RequestMethod.GET})
    public void deleteInfo(@PathVariable(value="filedId") String filedId, HttpServletRequest request, HttpServletResponse response) {
        try {
            FileStroeInfo originalFile = (FileStroeInfo)this.fileStoreInfoManager.getObjectById((Serializable)((Object)filedId));
            if (originalFile != null) {
                Map searchColumn = FileListController.convertSearchColumn((HttpServletRequest)request);
                searchColumn.put("relatedFileId", originalFile.getFileId());
                FileStroeInfo relatedFile = (FileStroeInfo)this.fileStoreInfoManager.getObjectById((Serializable)((Object)filedId));
                this.fileStoreInfoManager.deleteFile(originalFile, relatedFile);
                JSONObject json = new JSONObject();
                json.put("success", (Object)true);
                response.getWriter().print("jsonpCallback(" + json.toString() + ")");
            }
        }
        catch (Exception e) {
            System.out.println("\u6570\u5b57\u8f6c\u6362\u51fa\u9519\uff01");
            e.printStackTrace();
        }
    }
}

