/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.utils;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.MessageDigest;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StringBaseOpt {
    private static final Log log = LogFactory.getLog(StringBaseOpt.class);
    static final int GB_SP_DIFF = 160;
    static final int[] secPosvalueList = new int[]{1601, 1637, 1833, 2078, 2274, 2302, 2433, 2594, 2787, 3106, 3212, 3472, 3635, 3722, 3730, 3858, 4027, 4086, 4390, 4558, 4684, 4925, 5249, 5600};
    static final char[] firstLetter = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'w', 'x', 'y', 'z'};

    public static String encodePassword(String password, String algorithm) {
        byte[] unencodedPassword = password.getBytes();
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance(algorithm);
        }
        catch (Exception e) {
            log.error((Object)("Exception: " + e));
            return password;
        }
        md.reset();
        md.update(unencodedPassword);
        byte[] encodedPassword = md.digest();
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < encodedPassword.length) {
            if ((encodedPassword[i] & 0xFF) < 16) {
                buf.append("0");
            }
            buf.append(Long.toString(encodedPassword[i] & 0xFF, 16));
            ++i;
        }
        return buf.toString();
    }

    public static String encodeString(String str) {
        return new String(Base64.encodeBase64((byte[])str.getBytes()));
    }

    public static String decodeString(String str) {
        return new String(Base64.decodeBase64((byte[])str.getBytes()));
    }

    public static boolean contains(String[] strs, String str) {
        boolean in = false;
        if (strs == null) {
            return in;
        }
        int i = 0;
        while (i < strs.length) {
            if (strs[i].contains(str)) {
                in = true;
            }
            ++i;
        }
        return in;
    }

    public static String deleteStringByQuote(String str, String quote) {
        if (str == null || "".equals(str)) {
            return "";
        }
        return StringUtils.replace((String)str.trim(), (String)("_" + quote), (String)"");
    }

    public static int indexOf(String[] strs, String str) {
        int index = -1;
        if (strs != null) {
            int i = 0;
            while (i < strs.length) {
                if (strs[i].contains(str)) {
                    index = i;
                    break;
                }
                ++i;
            }
        }
        return index;
    }

    public static String nextCode(String sCode) {
        int nSL = sCode.length();
        String sRes = "";
        int i = nSL;
        while (i > 0) {
            char c;
            if ((c = sCode.charAt(--i)) == '9') {
                sRes = String.valueOf('0') + sRes;
                continue;
            }
            if (c == 'z') {
                sRes = String.valueOf('a') + sRes;
                continue;
            }
            if (c == 'Z') {
                sRes = String.valueOf('A') + sRes;
                continue;
            }
            c = (char)(c + '\u0001');
            sRes = String.valueOf(c) + sRes;
            break;
        }
        if (i > 0) {
            sRes = String.valueOf(sCode.substring(0, i)) + sRes;
        }
        return sRes;
    }

    static char convert(byte[] bytes) {
        char result = '-';
        int secPosvalue = 0;
        int i = 0;
        while (i < bytes.length) {
            int n = i++;
            bytes[n] = (byte)(bytes[n] - 160);
        }
        secPosvalue = bytes[0] * 100 + bytes[1];
        i = 0;
        while (i < 23) {
            if (secPosvalue >= secPosvalueList[i] && secPosvalue < secPosvalueList[i + 1]) {
                result = firstLetter[i];
                break;
            }
            ++i;
        }
        return result;
    }

    public static String getFirstLetter(String oriStr) {
        if (oriStr == null) {
            return "";
        }
        String str = oriStr.toLowerCase();
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < str.length()) {
            char ch = str.charAt(i);
            char[] temp = new char[]{ch};
            byte[] uniCode = new String(temp).getBytes();
            if (uniCode[0] < 128 && uniCode[0] > 0) {
                buffer.append(temp);
            } else {
                buffer.append(StringBaseOpt.convert(uniCode));
            }
            ++i;
        }
        return buffer.toString();
    }

    public static String getBaseUrl(String url) {
        int n = url.indexOf(63);
        if (n > 1) {
            return url.substring(0, n);
        }
        return url;
    }

    public static String readToBuffer(String sFileName) {
        try {
            FileInputStream in = new FileInputStream(sFileName);
            byte[] readBytes = new byte[in.available()];
            in.read(readBytes);
            in.close();
            return new String(readBytes);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String getParameterString(Object v) {
        if (v == null) {
            return null;
        }
        if (v instanceof String[]) {
            String[] strArr = (String[])v;
            if (strArr.length > 0) {
                return strArr[0];
            }
            return null;
        }
        if (v instanceof String) {
            return (String)v;
        }
        return v.toString();
    }

    public static void main(String[] args) {
        System.out.println(StringBaseOpt.getFirstLetter(args[0]));
    }
}

