/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.utils;

import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DatetimeOpt {
    private static Log log = LogFactory.getLog(DatetimeOpt.class);
    private static String defaultDatePattern = "yyyy-MM-dd";
    private static String timePattern = "HH:mm";

    public static String getDatePattern() {
        return defaultDatePattern;
    }

    public static String getDateTimePattern() {
        return String.valueOf(DatetimeOpt.getDatePattern()) + " HH:mm:ss.S";
    }

    public static final String getDate(Date aDate) {
        SimpleDateFormat df = null;
        String returnValue = "";
        if (aDate != null) {
            df = new SimpleDateFormat(DatetimeOpt.getDatePattern());
            returnValue = df.format(aDate);
        }
        return returnValue;
    }

    public static final Date convertStringToDate(String aMask, String strDate) throws ParseException {
        Date date;
        SimpleDateFormat df;
        block4: {
            df = null;
            date = null;
            df = new SimpleDateFormat(aMask);
            if (log.isDebugEnabled()) {
                log.debug((Object)("converting '" + strDate + "' to date with mask '" + aMask + "'"));
            }
            try {
                if (strDate != null && !strDate.equals("")) break block4;
                return null;
            }
            catch (ParseException pe) {
                throw new ParseException(pe.getMessage(), pe.getErrorOffset());
            }
        }
        date = df.parse(strDate);
        return date;
    }

    public static String getTimeNow(Date theTime) {
        return DatetimeOpt.getDateTime(timePattern, theTime);
    }

    public static String getTodayStr() {
        Date today = new Date();
        return DatetimeOpt.convertDateToString(today);
    }

    public static Calendar getToday() throws ParseException {
        Date today = new Date();
        SimpleDateFormat df = new SimpleDateFormat(DatetimeOpt.getDatePattern());
        String todayAsString = df.format(today);
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(DatetimeOpt.convertStringToDate(todayAsString));
        return cal;
    }

    public static final String getDateTime(String aMask, Date aDate) {
        SimpleDateFormat df = null;
        String returnValue = "";
        if (aDate == null) {
            log.error((Object)"aDate is null!");
        } else {
            df = new SimpleDateFormat(aMask);
            returnValue = df.format(aDate);
        }
        return returnValue;
    }

    public static final String convertDateToString(Date aDate) {
        return DatetimeOpt.getDateTime(DatetimeOpt.getDatePattern(), aDate);
    }

    public static final String getNowDateTime4String() {
        return DatetimeOpt.getDateTime(DatetimeOpt.getDateTimePattern(), new Date(System.currentTimeMillis()));
    }

    public static Date convertStringToDate(String strDate) throws ParseException {
        Date aDate = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("converting date with pattern: " + DatetimeOpt.getDatePattern()));
            }
            aDate = DatetimeOpt.convertStringToDate(DatetimeOpt.getDatePattern(), strDate);
        }
        catch (ParseException pe) {
            log.error((Object)("Could not convert '" + strDate + "' to a date, throwing exception"));
            pe.printStackTrace();
            throw new ParseException(pe.getMessage(), pe.getErrorOffset());
        }
        return aDate;
    }

    public static int dayOfMonth(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        return cal.get(5);
    }

    public static int dayOfWeek(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        return cal.get(7) - 1;
    }

    public static String dayOfWeekCN(Date date) {
        String[] weeklist = new String[]{"\u661f\u671f\u65e5", "\u661f\u671f\u4e00", "\u661f\u671f\u4e8c", "\u661f\u671f\u4e09", "\u661f\u671f\u56db", "\u661f\u671f\u4e94", "\u661f\u671f\u516d", ""};
        return weeklist[DatetimeOpt.dayOfWeek(date)];
    }

    public static String timeAsCH(String timeString) {
        String ret = "";
        if (timeString != null && !"".equals(timeString)) {
            StringBuffer timeCH = new StringBuffer();
            timeCH.append(timeString.substring(0, 2));
            timeCH.append("\u70b9");
            timeCH.append(timeString.substring(3, 5));
            timeCH.append("\u5206");
            ret = timeCH.toString();
        }
        return ret;
    }

    public static String convertDateString_CH(String dateString) throws UnsupportedEncodingException {
        try {
            String checkif_exsit = dateString.substring(4, 5);
            StringBuffer dateStringCH = null;
            if (checkif_exsit.equals("-")) {
                dateStringCH = new StringBuffer(String.valueOf(dateString.substring(5, 7)) + "\u6708");
                if (dateString.length() > 7) {
                    dateStringCH.append(String.valueOf(dateString.substring(8, 10)) + "\u65e5");
                }
            } else {
                dateStringCH = new StringBuffer(String.valueOf(dateString.substring(0, 4)) + "\u5e74");
                if (dateString.length() > 4) {
                    dateStringCH.append(String.valueOf(dateString.substring(4, 6)) + "\u6708");
                }
                if (dateString.length() > 6) {
                    dateStringCH.append(String.valueOf(dateString.substring(6, 8)) + "\u65e5");
                }
                if (dateString.length() > 9) {
                    dateStringCH.append(String.valueOf(dateString.substring(9, 11)) + "\u70b9");
                }
                if (dateString.length() > 12) {
                    dateStringCH.append(String.valueOf(dateString.substring(12, 14)) + "\u5206");
                }
            }
            return dateStringCH.toString();
        }
        catch (Exception e) {
            log.error((Object)("\u65e0\u6cd5\u8ba1\u7b97.convertDateString_CH\u51fd\u6570\u51fa\u9519\u3002" + e.getMessage()));
            return null;
        }
    }

    public static float difDate(String dateend, String datebegin, int nDays) {
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm");
            ParsePosition pos = new ParsePosition(0);
            ParsePosition pos1 = new ParsePosition(0);
            Date dt1 = formatter.parse(dateend, pos);
            Date dt2 = formatter.parse(datebegin, pos1);
            float l = Math.abs(dt1.getTime() - dt2.getTime());
            l = l / 8.64E7f / (float)nDays;
            return l;
        }
        catch (Exception e) {
            return 0.0f;
        }
    }

    public static float difDate(String dateend, String datebegin) {
        return DatetimeOpt.difDate(dateend, datebegin, 1);
    }

    public static String addDate(String datebegin, int LaterTime) {
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
            ParsePosition pos = new ParsePosition(0);
            String addDate = null;
            Date dt2 = new Date();
            Date dt1 = formatter.parse(datebegin, pos);
            dt2.setTime(dt1.getTime() + (long)LaterTime * 86400000L);
            addDate = formatter.format(dt2);
            return addDate;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String addYear(String datebegin, int LaterTime) {
        try {
            String addDate = datebegin.substring(0, 4);
            addDate = String.valueOf(String.valueOf(Integer.valueOf(addDate) + LaterTime)) + datebegin.substring(4);
            return addDate;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String moveMonthEnd(String datebegin) {
        try {
            int day;
            int year = Integer.valueOf(datebegin.substring(0, 4));
            int month = Integer.valueOf(datebegin.substring(5, 7));
            switch (month) {
                case 1: 
                case 3: 
                case 5: 
                case 7: 
                case 8: 
                case 10: 
                case 12: {
                    day = 31;
                    break;
                }
                case 2: {
                    if (year % 4 == 0 && year % 100 != 0) {
                        day = 29;
                        break;
                    }
                    day = 28;
                    break;
                }
                default: {
                    day = 30;
                }
            }
            String addDate = String.valueOf(datebegin.substring(0, 8)) + String.valueOf(day);
            return addDate;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String addMonth(String datebegin, int LaterTime) {
        try {
            int iday;
            String month = datebegin.substring(5, 7);
            String year = datebegin.substring(0, 4);
            String day = datebegin.substring(8, 10);
            int iMonth = Integer.valueOf(month);
            int iYear = Integer.valueOf(year);
            iMonth += LaterTime;
            while (iMonth <= 0) {
                iMonth += 12;
                --iYear;
            }
            while (iMonth > 12) {
                iMonth -= 12;
                ++iYear;
            }
            switch (iMonth) {
                case 1: 
                case 3: 
                case 5: 
                case 7: 
                case 8: 
                case 10: 
                case 12: {
                    iday = 31;
                    break;
                }
                case 2: {
                    if (iYear % 4 == 0 && iYear % 100 != 0) {
                        iday = 29;
                        break;
                    }
                    iday = 28;
                    break;
                }
                default: {
                    iday = 30;
                }
            }
            if (iday < Integer.valueOf(day)) {
                day = String.valueOf(iday);
            }
            year = String.valueOf(iYear);
            month = iMonth > 9 ? String.valueOf(iMonth) : "0" + String.valueOf(iMonth);
            String addDate = String.valueOf(year) + "-" + month + "-" + day;
            return addDate;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void addSubDate(String datebegin, int time1, int time2, String[] data) {
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
            ParsePosition pos = new ParsePosition(0);
            String addDate0 = null;
            String addDate1 = null;
            Date dt2 = new Date();
            Date dt3 = new Date();
            Date dt1 = formatter.parse(datebegin, pos);
            dt2.setTime(dt1.getTime() - (long)time1 * 86400000L);
            dt3.setTime(dt1.getTime() + (long)time2 * 86400000L);
            addDate0 = formatter.format(dt2);
            addDate1 = formatter.format(dt2);
            data[0] = addDate0;
            data[1] = addDate1;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String currentDate() {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        Date dt = new Date();
        dt.setTime(System.currentTimeMillis());
        String sCurDate = formatter.format(dt);
        return sCurDate;
    }

    public static long getQuot(String time1, String time2) {
        long quot = 0L;
        SimpleDateFormat ft = new SimpleDateFormat("yyyy-MM-dd");
        try {
            Date date1 = ft.parse(time1);
            Date date2 = ft.parse(time2);
            quot = date1.getTime() - date2.getTime();
            quot = quot / 1000L / 60L / 60L / 24L;
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return quot;
    }

    public static String currentTime() {
        SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
        Date dt = new Date();
        dt.setTime(System.currentTimeMillis());
        String sCurTime = formatter.format(dt);
        return sCurTime;
    }
}

