/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.office.commons;

import com.itextpdf.text.BadElementException;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfSignatureAppearance;
import java.awt.Color;
import java.awt.Image;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.Arrays;

public class SignatureInfo {
    private String reasonDesc;
    private String locationDesc;
    private String digestAlgorithm = "SHA-1";
    private com.itextpdf.text.Image signImage;
    private String fieldName;
    private Certificate[] chain;
    private PrivateKey pk;
    private int certificationLevel = 0;
    private PdfSignatureAppearance.RenderingMode renderingMode = PdfSignatureAppearance.RenderingMode.GRAPHIC;
    private Rectangle signRect;
    private int signPage;

    public SignatureInfo reason(String reasonString) {
        this.reasonDesc = reasonString;
        return this;
    }

    public SignatureInfo location(String locationDesc) {
        this.locationDesc = locationDesc;
        return this;
    }

    public SignatureInfo algorithm(String digestAlgorithm) {
        this.digestAlgorithm = digestAlgorithm;
        return this;
    }

    public SignatureInfo field(String fieldName) {
        this.fieldName = fieldName;
        return this;
    }

    public SignatureInfo certificate(Certificate[] chain) {
        this.chain = chain;
        return this;
    }

    public SignatureInfo privateKey(PrivateKey pk) {
        this.pk = pk;
        return this;
    }

    public SignatureInfo certificateLevel(int certificationLevel) {
        this.certificationLevel = certificationLevel;
        return this;
    }

    public SignatureInfo renderingMode(PdfSignatureAppearance.RenderingMode renderingMode) {
        this.renderingMode = renderingMode;
        return this;
    }

    public SignatureInfo image(com.itextpdf.text.Image image) {
        this.signImage = image;
        return this;
    }

    public SignatureInfo image(String imagePath) {
        try {
            this.signImage = com.itextpdf.text.Image.getInstance((String)imagePath);
        }
        catch (BadElementException | IOException e) {
            e.printStackTrace();
        }
        return this;
    }

    public SignatureInfo image(Image image) {
        try {
            this.signImage = com.itextpdf.text.Image.getInstance((Image)image, (Color)new Color(255, 255, 255));
        }
        catch (BadElementException | IOException e) {
            e.printStackTrace();
        }
        return this;
    }

    public SignatureInfo page(int signPage) {
        this.signPage = signPage;
        return this;
    }

    public SignatureInfo rect(Rectangle rectangle) {
        this.signRect = rectangle;
        return this;
    }

    public SignatureInfo rect(float llx, float lly, float urx, float ury) {
        this.signRect = new Rectangle(llx, lly, urx, ury);
        return this;
    }

    public String getReasonDesc() {
        return this.reasonDesc;
    }

    public String getLocationDesc() {
        return this.locationDesc;
    }

    public String getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public com.itextpdf.text.Image getSignImage() {
        return this.signImage;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public Certificate[] getChain() {
        return this.chain;
    }

    public PrivateKey getPk() {
        return this.pk;
    }

    public int getCertificationLevel() {
        return this.certificationLevel;
    }

    public PdfSignatureAppearance.RenderingMode getRenderingMode() {
        return this.renderingMode;
    }

    public Rectangle getSignRect() {
        return this.signRect;
    }

    public int getSignPage() {
        return this.signPage;
    }

    public void setReasonDesc(String reasonDesc) {
        this.reasonDesc = reasonDesc;
    }

    public void setLocationDesc(String locationDesc) {
        this.locationDesc = locationDesc;
    }

    public void setDigestAlgorithm(String digestAlgorithm) {
        this.digestAlgorithm = digestAlgorithm;
    }

    public void setSignImage(com.itextpdf.text.Image signImage) {
        this.signImage = signImage;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public void setChain(Certificate[] chain) {
        this.chain = chain;
    }

    public void setPk(PrivateKey pk) {
        this.pk = pk;
    }

    public void setCertificationLevel(int certificationLevel) {
        this.certificationLevel = certificationLevel;
    }

    public void setRenderingMode(PdfSignatureAppearance.RenderingMode renderingMode) {
        this.renderingMode = renderingMode;
    }

    public void setSignRect(Rectangle signRect) {
        this.signRect = signRect;
    }

    public void setSignPage(int signPage) {
        this.signPage = signPage;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SignatureInfo)) {
            return false;
        }
        SignatureInfo other = (SignatureInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$reasonDesc = this.getReasonDesc();
        String other$reasonDesc = other.getReasonDesc();
        if (this$reasonDesc == null ? other$reasonDesc != null : !this$reasonDesc.equals(other$reasonDesc)) {
            return false;
        }
        String this$locationDesc = this.getLocationDesc();
        String other$locationDesc = other.getLocationDesc();
        if (this$locationDesc == null ? other$locationDesc != null : !this$locationDesc.equals(other$locationDesc)) {
            return false;
        }
        String this$digestAlgorithm = this.getDigestAlgorithm();
        String other$digestAlgorithm = other.getDigestAlgorithm();
        if (this$digestAlgorithm == null ? other$digestAlgorithm != null : !this$digestAlgorithm.equals(other$digestAlgorithm)) {
            return false;
        }
        com.itextpdf.text.Image this$signImage = this.getSignImage();
        com.itextpdf.text.Image other$signImage = other.getSignImage();
        if (this$signImage == null ? other$signImage != null : !this$signImage.equals(other$signImage)) {
            return false;
        }
        String this$fieldName = this.getFieldName();
        String other$fieldName = other.getFieldName();
        if (this$fieldName == null ? other$fieldName != null : !this$fieldName.equals(other$fieldName)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getChain(), other.getChain())) {
            return false;
        }
        PrivateKey this$pk = this.getPk();
        PrivateKey other$pk = other.getPk();
        if (this$pk == null ? other$pk != null : !this$pk.equals(other$pk)) {
            return false;
        }
        if (this.getCertificationLevel() != other.getCertificationLevel()) {
            return false;
        }
        PdfSignatureAppearance.RenderingMode this$renderingMode = this.getRenderingMode();
        PdfSignatureAppearance.RenderingMode other$renderingMode = other.getRenderingMode();
        if (this$renderingMode == null ? other$renderingMode != null : !this$renderingMode.equals(other$renderingMode)) {
            return false;
        }
        Rectangle this$signRect = this.getSignRect();
        Rectangle other$signRect = other.getSignRect();
        if (this$signRect == null ? other$signRect != null : !this$signRect.equals(other$signRect)) {
            return false;
        }
        return this.getSignPage() == other.getSignPage();
    }

    protected boolean canEqual(Object other) {
        return other instanceof SignatureInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $reasonDesc = this.getReasonDesc();
        result = result * 59 + ($reasonDesc == null ? 43 : $reasonDesc.hashCode());
        String $locationDesc = this.getLocationDesc();
        result = result * 59 + ($locationDesc == null ? 43 : $locationDesc.hashCode());
        String $digestAlgorithm = this.getDigestAlgorithm();
        result = result * 59 + ($digestAlgorithm == null ? 43 : $digestAlgorithm.hashCode());
        com.itextpdf.text.Image $signImage = this.getSignImage();
        result = result * 59 + ($signImage == null ? 43 : $signImage.hashCode());
        String $fieldName = this.getFieldName();
        result = result * 59 + ($fieldName == null ? 43 : $fieldName.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getChain());
        PrivateKey $pk = this.getPk();
        result = result * 59 + ($pk == null ? 43 : $pk.hashCode());
        result = result * 59 + this.getCertificationLevel();
        PdfSignatureAppearance.RenderingMode $renderingMode = this.getRenderingMode();
        result = result * 59 + ($renderingMode == null ? 43 : $renderingMode.hashCode());
        Rectangle $signRect = this.getSignRect();
        result = result * 59 + ($signRect == null ? 43 : $signRect.hashCode());
        result = result * 59 + this.getSignPage();
        return result;
    }

    public String toString() {
        return "SignatureInfo(reasonDesc=" + this.getReasonDesc() + ", locationDesc=" + this.getLocationDesc() + ", digestAlgorithm=" + this.getDigestAlgorithm() + ", signImage=" + this.getSignImage() + ", fieldName=" + this.getFieldName() + ", chain=" + Arrays.deepToString(this.getChain()) + ", pk=" + this.getPk() + ", certificationLevel=" + this.getCertificationLevel() + ", renderingMode=" + this.getRenderingMode() + ", signRect=" + this.getSignRect() + ", signPage=" + this.getSignPage() + ")";
    }
}

