/*
 * Decompiled with CFR 0.152.
 */
package com.centit.search.service;

import com.centit.search.document.DocumentUtils;
import com.centit.search.service.ESServerConfig;
import com.centit.search.service.Impl.ESIndexer;
import com.centit.search.service.Impl.ESSearcher;
import com.centit.search.service.Impl.PooledTransportClientTactory;
import com.centit.search.service.Indexer;
import com.centit.search.service.Searcher;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.file.PropertiesReader;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.elasticsearch.client.transport.TransportClient;

public abstract class IndexerSearcherFactory {
    private static ConcurrentHashMap<String, Indexer> indexerMap = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, Searcher> searcherMap = new ConcurrentHashMap();
    private static ConcurrentHashMap<ESServerConfig, GenericObjectPool<TransportClient>> clientPoolMap = new ConcurrentHashMap();

    public static GenericObjectPool<TransportClient> obtainclientPool(ESServerConfig config) {
        GenericObjectPool clientPool = clientPoolMap.get(config);
        if (clientPool == null) {
            GenericObjectPoolConfig poolConfig = new GenericObjectPoolConfig();
            clientPool = new GenericObjectPool((PooledObjectFactory)new PooledTransportClientTactory(config), poolConfig);
            clientPoolMap.put(config, (GenericObjectPool<TransportClient>)clientPool);
        }
        return clientPool;
    }

    public static Indexer obtainIndexer(String indexName) {
        return indexerMap.get(indexName);
    }

    public static Indexer obtainIndexer(ESServerConfig config, Class<?> objType) {
        String indexName = DocumentUtils.obtainDocumentIndexName(objType);
        if (StringUtils.isBlank((CharSequence)indexName)) {
            return null;
        }
        Indexer index = indexerMap.get(indexName);
        if (index != null) {
            return index;
        }
        ESIndexer indexer = new ESIndexer(IndexerSearcherFactory.obtainclientPool(config), indexName);
        if (indexer.createIndexIfNotExist(indexName)) {
            indexer.initMappingType(indexName, objType);
        }
        indexerMap.put(indexName, indexer);
        return indexer;
    }

    public static Searcher obtainSearcher(String indexName) {
        return searcherMap.get(indexName);
    }

    public static Searcher obtainSearcher(ESServerConfig config, Class<?> objType) {
        String indexName = DocumentUtils.obtainDocumentIndexName(objType);
        if (indexName == null) {
            return null;
        }
        Searcher search = searcherMap.get(indexName);
        if (search != null) {
            return search;
        }
        ESSearcher searcher = new ESSearcher(config, IndexerSearcherFactory.obtainclientPool(config));
        searcher.initTypeFields(indexName, objType);
        searcher.setHightPreTags(new String[]{"<H1>"});
        searcher.setHightPostTags(new String[]{"</H1>"});
        searcherMap.put(indexName, searcher);
        return searcher;
    }

    public static ESServerConfig loadESServerConfigFormProperties(Properties properties) {
        ESServerConfig config = new ESServerConfig();
        config.setServerHostIp(properties.getProperty("elasticsearch.server.ip"));
        config.setServerHostPort(NumberBaseOpt.castObjectToInteger((Object)properties.getProperty("elasticsearch.server.port")));
        config.setClusterName(properties.getProperty("elasticsearch.server.cluster"));
        config.setOsId(properties.getProperty("elasticsearch.osId"));
        config.setMinScore(NumberBaseOpt.parseFloat((String)properties.getProperty("elasticsearch.filter.minScore"), (Float)Float.valueOf(0.5f)).floatValue());
        return config;
    }

    public static ESServerConfig loadESServerConfigFormProperties(String propertiesFile) {
        Properties properties = PropertiesReader.getClassPathProperties((String)propertiesFile);
        return IndexerSearcherFactory.loadESServerConfigFormProperties(properties);
    }
}

