/*
 * Decompiled with CFR 0.152.
 */
package com.centit.search.service.Impl;

import com.centit.search.document.DocumentUtils;
import com.centit.search.document.ESDocument;
import com.centit.search.service.Indexer;
import java.util.Map;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsRequest;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.Requests;
import org.elasticsearch.client.transport.TransportClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ESIndexer
implements Indexer {
    private static Logger logger = LoggerFactory.getLogger(ESIndexer.class);
    private GenericObjectPool<TransportClient> clientPool;
    private String indexName;

    public ESIndexer() {
    }

    public ESIndexer(GenericObjectPool<TransportClient> clientPool, String indexName) {
        this.clientPool = clientPool;
        this.indexName = indexName;
    }

    public void setClientPool(GenericObjectPool<TransportClient> clientPool) {
        this.clientPool = clientPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createIndexIfNotExist(String indexName) {
        TransportClient client = null;
        try {
            client = (TransportClient)this.clientPool.borrowObject();
            IndicesExistsResponse indicesExistsResponse = (IndicesExistsResponse)client.admin().indices().exists(new IndicesExistsRequest(new String[]{indexName})).actionGet();
            if (!indicesExistsResponse.isExists()) {
                client.admin().indices().prepareCreate(indexName).execute().actionGet();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (client != null) {
                this.clientPool.returnObject((Object)client);
            }
        }
    }

    public void initMappingType(Class<?> objType) {
        String indexName = DocumentUtils.obtainDocumentIndexName(objType);
        if (indexName != null) {
            this.initMappingType(indexName, objType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initMappingType(String indexName, Class<?> objType) {
        this.indexName = indexName;
        TransportClient client = null;
        try {
            client = (TransportClient)this.clientPool.borrowObject();
            String documentType = DocumentUtils.obtainDocumentType(objType);
            if (documentType != null) {
                PutMappingRequest putMappingRequest = Requests.putMappingRequest((String[])new String[]{indexName}).type(documentType).source((Map)DocumentUtils.obtainDocumentMapping(objType));
                client.admin().indices().putMapping(putMappingRequest).actionGet();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (client != null) {
                this.clientPool.returnObject((Object)client);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String saveNewDocument(ESDocument document) {
        TransportClient client = null;
        try {
            client = (TransportClient)this.clientPool.borrowObject();
            String type = document.obtainDocumentType();
            String docId = document.obtainDocumentId();
            IndexResponse indexResponse = (IndexResponse)client.prepareIndex(this.indexName, type, docId).setSource((Map)document.toJSONObject()).execute().actionGet();
            String string = indexResponse.getId();
            return string;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            if (client != null) {
                this.clientPool.returnObject((Object)client);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteDocument(ESDocument document) {
        TransportClient client = null;
        try {
            client = (TransportClient)this.clientPool.borrowObject();
            String type = document.obtainDocumentType();
            String docId = document.obtainDocumentId();
            DeleteResponse response = (DeleteResponse)client.prepareDelete(this.indexName, type, docId).get();
            boolean bl = response.status().getStatus() == 200;
            return bl;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (client != null) {
                this.clientPool.returnObject((Object)client);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteDocument(String docType, String docId) {
        TransportClient client = null;
        try {
            client = (TransportClient)this.clientPool.borrowObject();
            DeleteResponse response = (DeleteResponse)client.prepareDelete(this.indexName, docType, docId).execute().actionGet();
            boolean bl = response.status().getStatus() == 200;
            return bl;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (client != null) {
                this.clientPool.returnObject((Object)client);
            }
        }
    }

    @Override
    public int updateDocument(ESDocument document) {
        String docId = document.obtainDocumentId();
        return this.updateDocument(docId, document);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int updateDocument(String docId, ESDocument document) {
        TransportClient client = null;
        try {
            client = (TransportClient)this.clientPool.borrowObject();
            String type = document.obtainDocumentType();
            UpdateResponse response = (UpdateResponse)client.prepareUpdate(this.indexName, type, docId).setDoc((Map)document.toJSONObject()).get();
            int ret = response.status().getStatus();
            int n = ret == 200 ? 1 : 0;
            return n;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            int n = 0;
            return n;
        }
        finally {
            if (client != null) {
                this.clientPool.returnObject((Object)client);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String mergeDocument(ESDocument document) {
        TransportClient client = null;
        try {
            client = (TransportClient)this.clientPool.borrowObject();
            String type = document.obtainDocumentType();
            String docId = document.obtainDocumentId();
            GetResponse response = (GetResponse)client.prepareGet(this.indexName, type, docId).get();
            if (response.isExists()) {
                UpdateResponse updateResponse = (UpdateResponse)client.prepareUpdate(this.indexName, type, docId).setDoc((Map)document.toJSONObject()).get();
                int ret = updateResponse.status().getStatus();
                String string = ret == 200 ? updateResponse.getId() : null;
                return string;
            }
            IndexResponse indexResponse = (IndexResponse)client.prepareIndex(this.indexName, type, docId).setSource((Map)document.toJSONObject()).execute().actionGet();
            String string = indexResponse.getId();
            return string;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            if (client != null) {
                this.clientPool.returnObject((Object)client);
            }
        }
    }
}

