/*
 * Decompiled with CFR 0.152.
 */
package com.centit.search.document;

import com.alibaba.fastjson.JSONObject;
import com.centit.search.annotation.ESField;
import com.centit.search.annotation.ESType;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.json.JSONOpt;
import java.lang.reflect.Field;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public abstract class DocumentUtils {
    public static String obtainDocumentIndexName(Class<?> objType) {
        if (objType.isAnnotationPresent(ESType.class)) {
            ESType et = objType.getAnnotation(ESType.class);
            return et.indexName();
        }
        return null;
    }

    public static String obtainDocumentType(Class<?> objType) {
        if (!objType.isAnnotationPresent(ESType.class)) {
            return null;
        }
        ESType esType = objType.getAnnotation(ESType.class);
        return esType.type();
    }

    public static JSONObject obtainDocumentMapping(Class<?> objType) {
        String sobjType = DocumentUtils.obtainDocumentType(objType);
        if (sobjType == null) {
            return null;
        }
        Field[] objFields = objType.getDeclaredFields();
        JSONObject fieldsMap = new JSONObject();
        for (Field field : objFields) {
            if (!field.isAnnotationPresent(ESField.class)) continue;
            ESField esType = field.getAnnotation(ESField.class);
            Map fieldConfig = CollectionsOpt.createHashMap((Object[])new Object[]{"type", StringUtils.isBlank((CharSequence)esType.type()) ? field.getType().getSimpleName() : esType.type(), "index", esType.index(), "store", esType.store()});
            if (StringUtils.isNotBlank((CharSequence)esType.analyzer())) {
                fieldConfig.put("analyzer", esType.analyzer());
            }
            if (StringUtils.isNotBlank((CharSequence)esType.indexAnalyzer())) {
                fieldConfig.put("indexAnalyzer", esType.indexAnalyzer());
            }
            if (StringUtils.isNotBlank((CharSequence)esType.searchAnalyzer())) {
                fieldConfig.put("searchAnalyzer", esType.searchAnalyzer());
            }
            fieldsMap.put(field.getName(), (Object)fieldConfig);
        }
        JSONObject jsonObject = new JSONObject();
        JSONOpt.setAttribute((JSONObject)jsonObject, (String)(sobjType + ".properties"), (Object)fieldsMap);
        return jsonObject;
    }
}

