package com.centit.search.service.Impl;

import com.centit.search.service.ESServerConfig;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.network.InetAddresses;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.transport.client.PreBuiltTransportClient;


/**
 * Created by codefan on 17-6-27.
 */
public class PooledTransportClientTactory implements PooledObjectFactory<TransportClient> {


    private ESServerConfig config;
    public PooledTransportClientTactory(ESServerConfig config){
        this.config = config;
    }

    @Override
    public PooledObject<TransportClient> makeObject() throws Exception {
        Settings esSettings = Settings.builder()
                .put("cluster.name", config.getClusterName()) //设置ES实例的名称
                //.put("client.transport.sniff", true) //自动嗅探整个集群的状态，把集群中其他ES节点的ip添加到本地的客户端列表中
                .build();
        TransportClient client = new PreBuiltTransportClient(esSettings);//初始化client较老版本发生了变化，此方法有几个重载方法，初始化插件等。
        //此步骤添加IP，至少一个，其实一个就够了，因为添加了自动嗅探配置
        TransportAddress transportAddress =
                new TransportAddress(
                        InetAddresses.forString(config.getServerHostIp()),config.getServerHostPort());
        client.addTransportAddresses(transportAddress);
        //System.out.println("success connect");
        return new DefaultPooledObject<>(client);
    }

    @Override
    public void destroyObject(PooledObject<TransportClient> p) throws Exception {
        p.getObject().close();
    }

    @Override
    public boolean validateObject(PooledObject<TransportClient> p) {
        // TODO Auto-generated method stub
        return true;
    }

    @Override
    public void activateObject(PooledObject<TransportClient> p) throws Exception {
        // TODO Auto-generated method stub
    }

    @Override
    public void passivateObject(PooledObject<TransportClient> p) throws Exception {
        // TODO Auto-generated method stub
    }

    public void setConifg(ESServerConfig conifg) {
        this.config = conifg;
    }
}
