package com.centit.search.document;

import com.alibaba.fastjson.JSONObject;
import com.centit.search.annotation.ESField;
import com.centit.search.annotation.ESType;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.json.JSONOpt;
import org.apache.commons.lang3.StringUtils;

import java.lang.reflect.Field;
import java.util.Map;

/**
 * Created by codefan on 17-6-27.
 */
public abstract class DocumentUtils {

    public static String obtainDocumentIndexName(Class<?> objType){
        if(objType.isAnnotationPresent(ESType.class)){
            ESType et = objType.getAnnotation(ESType.class);
            return et.indexName();
        }
        return null;
    }

    public static String obtainDocumentType(Class<?> objType){
        if(!objType.isAnnotationPresent(ESType.class)){
            return null;
        }
        ESType esType =
                objType.getAnnotation(ESType.class);
        return esType.type();
    }

    public static JSONObject obtainDocumentMapping(Class<?> objType) {
        String sobjType = DocumentUtils.obtainDocumentType(objType);
        if(sobjType==null) {
            return null;
        }
        Field[] objFields = objType.getDeclaredFields();
        JSONObject fieldsMap = new JSONObject();

        for(Field field :objFields){
            if(field.isAnnotationPresent(ESField.class)){
                ESField esType =
                        field.getAnnotation(ESField.class);

                Map<String,Object> fieldConfig = CollectionsOpt.createHashMap(
                    "type",StringUtils.isBlank(esType.type())?
                                    field.getType().getSimpleName() : esType.type(),
                        "index",esType.index(),
                        "store",esType.store());

                if(StringUtils.isNotBlank(esType.analyzer())) {
                    fieldConfig.put("analyzer", esType.analyzer());
                }
                if(StringUtils.isNotBlank(esType.indexAnalyzer())) {
                    fieldConfig.put("indexAnalyzer", esType.indexAnalyzer());
                }
                if(StringUtils.isNotBlank(esType.searchAnalyzer())) {
                    fieldConfig.put("searchAnalyzer", esType.searchAnalyzer());
                }

                fieldsMap.put(field.getName(),fieldConfig);
            }
        }//end of for
        JSONObject jsonObject = new JSONObject();
        JSONOpt.setAttribute(jsonObject,sobjType+".properties",fieldsMap);
        return jsonObject;
    }

 }

