/*
 * Decompiled with CFR 0.152.
 */
package com.centit.fileserver.po;

import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.database.orm.GeneratorTime;
import com.centit.support.database.orm.GeneratorType;
import com.centit.support.database.orm.ValueGenerator;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

@Entity
@Table(name="FILE_ACCESS_LOG")
public class FileAccessLog
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @Column(name="ACCESS_TOKEN")
    @ValueGenerator(strategy=GeneratorType.UUID)
    private String accessToken;
    @Column(name="FILE_ID")
    private String fileId;
    @ValueGenerator(strategy=GeneratorType.FUNCTION, occasion=GeneratorTime.NEW, value="today()")
    @Column(name="AUTH_TIME")
    private Date authTime;
    @Column(name="ACCESS_USERCODE")
    private String accessUsercode;
    @Column(name="ACCESS_USENAME")
    private String accessUsename;
    @Column(name="ACCESS_RIGHT")
    private String accessRight;
    @Column(name="TOKEN_EXPIRE_TIME")
    private Date tokenExpireTime;
    @Column(name="ACCESS_TIMES")
    private Integer accessTimes;
    @Column(name="LAST_ACCESS_TIME")
    private Date lastAccessTime;
    @Column(name="LAST_ACCESS_HOST")
    private String lastAccessHost;

    public boolean checkValid(boolean getAttach) {
        if (!getAttach && "T".equals(this.accessRight)) {
            return false;
        }
        if (this.tokenExpireTime != null && DatetimeOpt.currentUtilDate().after(this.tokenExpireTime)) {
            return false;
        }
        return this.accessTimes == null || this.accessTimes > 0;
    }

    public Integer chargeAccessTimes() {
        if (this.accessTimes != null) {
            this.accessTimes = this.accessTimes - 1;
        }
        return this.accessTimes;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getFileId() {
        return this.fileId;
    }

    public Date getAuthTime() {
        return this.authTime;
    }

    public String getAccessUsercode() {
        return this.accessUsercode;
    }

    public String getAccessUsename() {
        return this.accessUsename;
    }

    public String getAccessRight() {
        return this.accessRight;
    }

    public Date getTokenExpireTime() {
        return this.tokenExpireTime;
    }

    public Integer getAccessTimes() {
        return this.accessTimes;
    }

    public Date getLastAccessTime() {
        return this.lastAccessTime;
    }

    public String getLastAccessHost() {
        return this.lastAccessHost;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public void setFileId(String fileId) {
        this.fileId = fileId;
    }

    public void setAuthTime(Date authTime) {
        this.authTime = authTime;
    }

    public void setAccessUsercode(String accessUsercode) {
        this.accessUsercode = accessUsercode;
    }

    public void setAccessUsename(String accessUsename) {
        this.accessUsename = accessUsename;
    }

    public void setAccessRight(String accessRight) {
        this.accessRight = accessRight;
    }

    public void setTokenExpireTime(Date tokenExpireTime) {
        this.tokenExpireTime = tokenExpireTime;
    }

    public void setAccessTimes(Integer accessTimes) {
        this.accessTimes = accessTimes;
    }

    public void setLastAccessTime(Date lastAccessTime) {
        this.lastAccessTime = lastAccessTime;
    }

    public void setLastAccessHost(String lastAccessHost) {
        this.lastAccessHost = lastAccessHost;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FileAccessLog)) {
            return false;
        }
        FileAccessLog other = (FileAccessLog)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$accessTimes = this.getAccessTimes();
        Integer other$accessTimes = other.getAccessTimes();
        if (this$accessTimes == null ? other$accessTimes != null : !((Object)this$accessTimes).equals(other$accessTimes)) {
            return false;
        }
        String this$accessToken = this.getAccessToken();
        String other$accessToken = other.getAccessToken();
        if (this$accessToken == null ? other$accessToken != null : !this$accessToken.equals(other$accessToken)) {
            return false;
        }
        String this$fileId = this.getFileId();
        String other$fileId = other.getFileId();
        if (this$fileId == null ? other$fileId != null : !this$fileId.equals(other$fileId)) {
            return false;
        }
        Date this$authTime = this.getAuthTime();
        Date other$authTime = other.getAuthTime();
        if (this$authTime == null ? other$authTime != null : !((Object)this$authTime).equals(other$authTime)) {
            return false;
        }
        String this$accessUsercode = this.getAccessUsercode();
        String other$accessUsercode = other.getAccessUsercode();
        if (this$accessUsercode == null ? other$accessUsercode != null : !this$accessUsercode.equals(other$accessUsercode)) {
            return false;
        }
        String this$accessUsename = this.getAccessUsename();
        String other$accessUsename = other.getAccessUsename();
        if (this$accessUsename == null ? other$accessUsename != null : !this$accessUsename.equals(other$accessUsename)) {
            return false;
        }
        String this$accessRight = this.getAccessRight();
        String other$accessRight = other.getAccessRight();
        if (this$accessRight == null ? other$accessRight != null : !this$accessRight.equals(other$accessRight)) {
            return false;
        }
        Date this$tokenExpireTime = this.getTokenExpireTime();
        Date other$tokenExpireTime = other.getTokenExpireTime();
        if (this$tokenExpireTime == null ? other$tokenExpireTime != null : !((Object)this$tokenExpireTime).equals(other$tokenExpireTime)) {
            return false;
        }
        Date this$lastAccessTime = this.getLastAccessTime();
        Date other$lastAccessTime = other.getLastAccessTime();
        if (this$lastAccessTime == null ? other$lastAccessTime != null : !((Object)this$lastAccessTime).equals(other$lastAccessTime)) {
            return false;
        }
        String this$lastAccessHost = this.getLastAccessHost();
        String other$lastAccessHost = other.getLastAccessHost();
        return !(this$lastAccessHost == null ? other$lastAccessHost != null : !this$lastAccessHost.equals(other$lastAccessHost));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FileAccessLog;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $accessTimes = this.getAccessTimes();
        result = result * 59 + ($accessTimes == null ? 43 : ((Object)$accessTimes).hashCode());
        String $accessToken = this.getAccessToken();
        result = result * 59 + ($accessToken == null ? 43 : $accessToken.hashCode());
        String $fileId = this.getFileId();
        result = result * 59 + ($fileId == null ? 43 : $fileId.hashCode());
        Date $authTime = this.getAuthTime();
        result = result * 59 + ($authTime == null ? 43 : ((Object)$authTime).hashCode());
        String $accessUsercode = this.getAccessUsercode();
        result = result * 59 + ($accessUsercode == null ? 43 : $accessUsercode.hashCode());
        String $accessUsename = this.getAccessUsename();
        result = result * 59 + ($accessUsename == null ? 43 : $accessUsename.hashCode());
        String $accessRight = this.getAccessRight();
        result = result * 59 + ($accessRight == null ? 43 : $accessRight.hashCode());
        Date $tokenExpireTime = this.getTokenExpireTime();
        result = result * 59 + ($tokenExpireTime == null ? 43 : ((Object)$tokenExpireTime).hashCode());
        Date $lastAccessTime = this.getLastAccessTime();
        result = result * 59 + ($lastAccessTime == null ? 43 : ((Object)$lastAccessTime).hashCode());
        String $lastAccessHost = this.getLastAccessHost();
        result = result * 59 + ($lastAccessHost == null ? 43 : $lastAccessHost.hashCode());
        return result;
    }

    public String toString() {
        return "FileAccessLog(accessToken=" + this.getAccessToken() + ", fileId=" + this.getFileId() + ", authTime=" + this.getAuthTime() + ", accessUsercode=" + this.getAccessUsercode() + ", accessUsename=" + this.getAccessUsename() + ", accessRight=" + this.getAccessRight() + ", tokenExpireTime=" + this.getTokenExpireTime() + ", accessTimes=" + this.getAccessTimes() + ", lastAccessTime=" + this.getLastAccessTime() + ", lastAccessHost=" + this.getLastAccessHost() + ")";
    }
}

