/*
 * Decompiled with CFR 0.152.
 */
package com.centit.fileserver.common;

import com.centit.fileserver.common.FileBaseInfo;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class FileTaskInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String taskType;
    private String fileId;
    private String fileMd5;
    private String fileName;
    private Long fileSize;
    private Map<String, Object> taskOptParams;

    public FileTaskInfo(String taskType) {
        this.taskType = taskType;
        this.taskOptParams = new HashMap<String, Object>();
    }

    public void putOptParam(String name, Object value) {
        if (value != null) {
            this.taskOptParams.put(name, value);
        }
    }

    public Object getOptParam(String name) {
        return this.taskOptParams.get(name);
    }

    public void copy(FileBaseInfo otherFile) {
        this.fileId = otherFile.getFileId();
        this.fileMd5 = otherFile.getFileMd5();
        this.fileName = otherFile.getFileName();
    }

    public String getTaskType() {
        return this.taskType;
    }

    public String getFileId() {
        return this.fileId;
    }

    public String getFileMd5() {
        return this.fileMd5;
    }

    public String getFileName() {
        return this.fileName;
    }

    public Long getFileSize() {
        return this.fileSize;
    }

    public Map<String, Object> getTaskOptParams() {
        return this.taskOptParams;
    }

    public void setTaskType(String taskType) {
        this.taskType = taskType;
    }

    public void setFileId(String fileId) {
        this.fileId = fileId;
    }

    public void setFileMd5(String fileMd5) {
        this.fileMd5 = fileMd5;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setFileSize(Long fileSize) {
        this.fileSize = fileSize;
    }

    public void setTaskOptParams(Map<String, Object> taskOptParams) {
        this.taskOptParams = taskOptParams;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FileTaskInfo)) {
            return false;
        }
        FileTaskInfo other = (FileTaskInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$fileSize = this.getFileSize();
        Long other$fileSize = other.getFileSize();
        if (this$fileSize == null ? other$fileSize != null : !((Object)this$fileSize).equals(other$fileSize)) {
            return false;
        }
        String this$taskType = this.getTaskType();
        String other$taskType = other.getTaskType();
        if (this$taskType == null ? other$taskType != null : !this$taskType.equals(other$taskType)) {
            return false;
        }
        String this$fileId = this.getFileId();
        String other$fileId = other.getFileId();
        if (this$fileId == null ? other$fileId != null : !this$fileId.equals(other$fileId)) {
            return false;
        }
        String this$fileMd5 = this.getFileMd5();
        String other$fileMd5 = other.getFileMd5();
        if (this$fileMd5 == null ? other$fileMd5 != null : !this$fileMd5.equals(other$fileMd5)) {
            return false;
        }
        String this$fileName = this.getFileName();
        String other$fileName = other.getFileName();
        if (this$fileName == null ? other$fileName != null : !this$fileName.equals(other$fileName)) {
            return false;
        }
        Map<String, Object> this$taskOptParams = this.getTaskOptParams();
        Map<String, Object> other$taskOptParams = other.getTaskOptParams();
        return !(this$taskOptParams == null ? other$taskOptParams != null : !((Object)this$taskOptParams).equals(other$taskOptParams));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FileTaskInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $fileSize = this.getFileSize();
        result = result * 59 + ($fileSize == null ? 43 : ((Object)$fileSize).hashCode());
        String $taskType = this.getTaskType();
        result = result * 59 + ($taskType == null ? 43 : $taskType.hashCode());
        String $fileId = this.getFileId();
        result = result * 59 + ($fileId == null ? 43 : $fileId.hashCode());
        String $fileMd5 = this.getFileMd5();
        result = result * 59 + ($fileMd5 == null ? 43 : $fileMd5.hashCode());
        String $fileName = this.getFileName();
        result = result * 59 + ($fileName == null ? 43 : $fileName.hashCode());
        Map<String, Object> $taskOptParams = this.getTaskOptParams();
        result = result * 59 + ($taskOptParams == null ? 43 : ((Object)$taskOptParams).hashCode());
        return result;
    }

    public String toString() {
        return "FileTaskInfo(taskType=" + this.getTaskType() + ", fileId=" + this.getFileId() + ", fileMd5=" + this.getFileMd5() + ", fileName=" + this.getFileName() + ", fileSize=" + this.getFileSize() + ", taskOptParams=" + this.getTaskOptParams() + ")";
    }
}

