/*
 * Decompiled with CFR 0.152.
 */
package com.centit.fileserver.common;

import com.centit.framework.model.basedata.WorkGroup;
import com.centit.support.database.orm.GeneratorCondition;
import com.centit.support.database.orm.GeneratorTime;
import com.centit.support.database.orm.GeneratorType;
import com.centit.support.database.orm.ValueGenerator;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;

@Entity
@Table(name="FILE_LIBRARY_INFO")
public class FileLibraryInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty(value="\u5e93id\uff0c\u65b0\u589e\u65f6\u4e0d\u4f20")
    @Id
    @Column(name="library_id")
    @ValueGenerator(strategy=GeneratorType.UUID, condition=GeneratorCondition.IFNULL)
    private String libraryId;
    @ApiModelProperty(value="\u5e93\u540d\u79f0", required=true)
    @Column(name="library_name")
    @NotNull(message="\u5e93\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotNull(message="\u5e93\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a") String libraryName;
    @ApiModelProperty(value="\u7c7b\u522b(\u4e2a\u4eba\u3001\u7ec4\u7ec7\u3001\u9879\u76ee)", required=true)
    @Column(name="library_type")
    private String libraryType;
    @Column(name="create_user")
    private String createUser;
    @Column(name="create_time")
    @ValueGenerator(strategy=GeneratorType.FUNCTION, value="today()")
    private Date createTime;
    @ApiModelProperty(value="\u6240\u5c5e\u673a\u6784", required=true)
    @Column(name="own_unit")
    private String ownUnit;
    @ApiModelProperty(value="\u6240\u5c5e\u4eba\u5458", required=true)
    @Column(name="own_user")
    private String ownUser;
    @Transient
    private String ownName;
    @ApiModelProperty(value="\u662f\u5426\u53ef\u4ee5\u521b\u5efa\u5b50\u76ee\u5f55", required=true)
    @Column(name="is_create_folder")
    private String isCreateFolder;
    @ApiModelProperty(value="\u662f\u5426\u53ef\u4ee5\u4e0a\u4f20\u6587\u4ef6", required=true)
    @Column(name="is_upload")
    private String isUpload;
    @Column(name="auth_code")
    private String authCode;
    @ApiModelProperty(value="\u4fee\u6539\u4eba")
    @Column(name="update_user")
    private String updateUser;
    @ApiModelProperty(value="\u4fee\u6539\u65f6\u95f4")
    @Column(name="update_time")
    @ValueGenerator(strategy=GeneratorType.FUNCTION, occasion=GeneratorTime.UPDATE, condition=GeneratorCondition.ALWAYS, value="today()")
    private Date updateTime;
    @ApiModelProperty(value="\u9879\u76ee\u5e93\u5bf9\u5e94\u6743\u9650")
    @OneToMany(mappedBy="fileLibraryInfo", orphanRemoval=true, cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @JoinColumn(name="library_id", referencedColumnName="group_id")
    private List<WorkGroup> workGroups;

    public void copyNotNull(FileLibraryInfo fileLibrary) {
        if (fileLibrary.getLibraryId() != null) {
            this.libraryId = fileLibrary.getLibraryId();
        }
        if (fileLibrary.getLibraryName() != null) {
            this.libraryName = fileLibrary.getLibraryName();
        }
        if (fileLibrary.getLibraryType() != null) {
            this.libraryType = fileLibrary.getLibraryType();
        }
        if (fileLibrary.getCreateUser() != null) {
            this.createUser = fileLibrary.getCreateUser();
        }
    }

    public String getLibraryId() {
        return this.libraryId;
    }

    public String getLibraryName() {
        return this.libraryName;
    }

    public String getLibraryType() {
        return this.libraryType;
    }

    public String getCreateUser() {
        return this.createUser;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public String getOwnUnit() {
        return this.ownUnit;
    }

    public String getOwnUser() {
        return this.ownUser;
    }

    public String getOwnName() {
        return this.ownName;
    }

    public String getIsCreateFolder() {
        return this.isCreateFolder;
    }

    public String getIsUpload() {
        return this.isUpload;
    }

    public String getAuthCode() {
        return this.authCode;
    }

    public String getUpdateUser() {
        return this.updateUser;
    }

    public Date getUpdateTime() {
        return this.updateTime;
    }

    public List<WorkGroup> getWorkGroups() {
        return this.workGroups;
    }

    public void setLibraryId(String libraryId) {
        this.libraryId = libraryId;
    }

    public void setLibraryName(String libraryName) {
        this.libraryName = libraryName;
    }

    public void setLibraryType(String libraryType) {
        this.libraryType = libraryType;
    }

    public void setCreateUser(String createUser) {
        this.createUser = createUser;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public void setOwnUnit(String ownUnit) {
        this.ownUnit = ownUnit;
    }

    public void setOwnUser(String ownUser) {
        this.ownUser = ownUser;
    }

    public void setOwnName(String ownName) {
        this.ownName = ownName;
    }

    public void setIsCreateFolder(String isCreateFolder) {
        this.isCreateFolder = isCreateFolder;
    }

    public void setIsUpload(String isUpload) {
        this.isUpload = isUpload;
    }

    public void setAuthCode(String authCode) {
        this.authCode = authCode;
    }

    public void setUpdateUser(String updateUser) {
        this.updateUser = updateUser;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public void setWorkGroups(List<WorkGroup> workGroups) {
        this.workGroups = workGroups;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FileLibraryInfo)) {
            return false;
        }
        FileLibraryInfo other = (FileLibraryInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$libraryId = this.getLibraryId();
        String other$libraryId = other.getLibraryId();
        if (this$libraryId == null ? other$libraryId != null : !this$libraryId.equals(other$libraryId)) {
            return false;
        }
        String this$libraryName = this.getLibraryName();
        String other$libraryName = other.getLibraryName();
        if (this$libraryName == null ? other$libraryName != null : !this$libraryName.equals(other$libraryName)) {
            return false;
        }
        String this$libraryType = this.getLibraryType();
        String other$libraryType = other.getLibraryType();
        if (this$libraryType == null ? other$libraryType != null : !this$libraryType.equals(other$libraryType)) {
            return false;
        }
        String this$createUser = this.getCreateUser();
        String other$createUser = other.getCreateUser();
        if (this$createUser == null ? other$createUser != null : !this$createUser.equals(other$createUser)) {
            return false;
        }
        Date this$createTime = this.getCreateTime();
        Date other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        String this$ownUnit = this.getOwnUnit();
        String other$ownUnit = other.getOwnUnit();
        if (this$ownUnit == null ? other$ownUnit != null : !this$ownUnit.equals(other$ownUnit)) {
            return false;
        }
        String this$ownUser = this.getOwnUser();
        String other$ownUser = other.getOwnUser();
        if (this$ownUser == null ? other$ownUser != null : !this$ownUser.equals(other$ownUser)) {
            return false;
        }
        String this$ownName = this.getOwnName();
        String other$ownName = other.getOwnName();
        if (this$ownName == null ? other$ownName != null : !this$ownName.equals(other$ownName)) {
            return false;
        }
        String this$isCreateFolder = this.getIsCreateFolder();
        String other$isCreateFolder = other.getIsCreateFolder();
        if (this$isCreateFolder == null ? other$isCreateFolder != null : !this$isCreateFolder.equals(other$isCreateFolder)) {
            return false;
        }
        String this$isUpload = this.getIsUpload();
        String other$isUpload = other.getIsUpload();
        if (this$isUpload == null ? other$isUpload != null : !this$isUpload.equals(other$isUpload)) {
            return false;
        }
        String this$authCode = this.getAuthCode();
        String other$authCode = other.getAuthCode();
        if (this$authCode == null ? other$authCode != null : !this$authCode.equals(other$authCode)) {
            return false;
        }
        String this$updateUser = this.getUpdateUser();
        String other$updateUser = other.getUpdateUser();
        if (this$updateUser == null ? other$updateUser != null : !this$updateUser.equals(other$updateUser)) {
            return false;
        }
        Date this$updateTime = this.getUpdateTime();
        Date other$updateTime = other.getUpdateTime();
        if (this$updateTime == null ? other$updateTime != null : !((Object)this$updateTime).equals(other$updateTime)) {
            return false;
        }
        List<WorkGroup> this$workGroups = this.getWorkGroups();
        List<WorkGroup> other$workGroups = other.getWorkGroups();
        return !(this$workGroups == null ? other$workGroups != null : !((Object)this$workGroups).equals(other$workGroups));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FileLibraryInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $libraryId = this.getLibraryId();
        result = result * 59 + ($libraryId == null ? 43 : $libraryId.hashCode());
        String $libraryName = this.getLibraryName();
        result = result * 59 + ($libraryName == null ? 43 : $libraryName.hashCode());
        String $libraryType = this.getLibraryType();
        result = result * 59 + ($libraryType == null ? 43 : $libraryType.hashCode());
        String $createUser = this.getCreateUser();
        result = result * 59 + ($createUser == null ? 43 : $createUser.hashCode());
        Date $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        String $ownUnit = this.getOwnUnit();
        result = result * 59 + ($ownUnit == null ? 43 : $ownUnit.hashCode());
        String $ownUser = this.getOwnUser();
        result = result * 59 + ($ownUser == null ? 43 : $ownUser.hashCode());
        String $ownName = this.getOwnName();
        result = result * 59 + ($ownName == null ? 43 : $ownName.hashCode());
        String $isCreateFolder = this.getIsCreateFolder();
        result = result * 59 + ($isCreateFolder == null ? 43 : $isCreateFolder.hashCode());
        String $isUpload = this.getIsUpload();
        result = result * 59 + ($isUpload == null ? 43 : $isUpload.hashCode());
        String $authCode = this.getAuthCode();
        result = result * 59 + ($authCode == null ? 43 : $authCode.hashCode());
        String $updateUser = this.getUpdateUser();
        result = result * 59 + ($updateUser == null ? 43 : $updateUser.hashCode());
        Date $updateTime = this.getUpdateTime();
        result = result * 59 + ($updateTime == null ? 43 : ((Object)$updateTime).hashCode());
        List<WorkGroup> $workGroups = this.getWorkGroups();
        result = result * 59 + ($workGroups == null ? 43 : ((Object)$workGroups).hashCode());
        return result;
    }

    public String toString() {
        return "FileLibraryInfo(libraryId=" + this.getLibraryId() + ", libraryName=" + this.getLibraryName() + ", libraryType=" + this.getLibraryType() + ", createUser=" + this.getCreateUser() + ", createTime=" + this.getCreateTime() + ", ownUnit=" + this.getOwnUnit() + ", ownUser=" + this.getOwnUser() + ", ownName=" + this.getOwnName() + ", isCreateFolder=" + this.getIsCreateFolder() + ", isUpload=" + this.getIsUpload() + ", authCode=" + this.getAuthCode() + ", updateUser=" + this.getUpdateUser() + ", updateTime=" + this.getUpdateTime() + ", workGroups=" + this.getWorkGroups() + ")";
    }
}

