/*
 * Decompiled with CFR 0.152.
 */
package com.centit.locode.platform.vo;

import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.centit.dde.adapter.DdeDubboTaskRun;
import com.centit.dde.adapter.po.DataPacket;
import com.centit.dde.adapter.po.DataPacketDraft;
import com.centit.dde.adapter.po.DataPacketParam;
import com.centit.dde.adapter.po.DataPacketParamDraft;
import com.centit.dde.core.DataSet;
import com.centit.fileserver.common.FileBaseInfo;
import com.centit.fileserver.common.FileInfoOpt;
import com.centit.fileserver.common.FileLibraryInfo;
import com.centit.fileserver.po.FileInfo;
import com.centit.framework.model.basedata.DataCatalog;
import com.centit.framework.model.basedata.DataDictionary;
import com.centit.framework.model.basedata.OptInfo;
import com.centit.framework.model.basedata.OptMethod;
import com.centit.framework.model.basedata.OsInfo;
import com.centit.framework.model.basedata.WorkGroup;
import com.centit.framework.model.basedata.WorkGroupParameter;
import com.centit.framework.model.security.CentitUserDetails;
import com.centit.locode.platform.po.ApplicationDictionary;
import com.centit.locode.platform.po.ApplicationResources;
import com.centit.locode.platform.vo.AppTableNames;
import com.centit.metaform.po.MetaFormModel;
import com.centit.metaform.po.MetaFormModelDraft;
import com.centit.product.metadata.po.MetaColumn;
import com.centit.product.metadata.po.MetaOptRelation;
import com.centit.product.metadata.po.MetaRelDetail;
import com.centit.product.metadata.po.MetaRelation;
import com.centit.product.metadata.po.MetaTable;
import com.centit.product.metadata.po.PendingMetaColumn;
import com.centit.product.metadata.po.PendingMetaTable;
import com.centit.product.metadata.po.SourceInfo;
import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.algorithm.GeneralAlgorithm;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.algorithm.UuidOpt;
import com.centit.support.algorithm.ZipCompressor;
import com.centit.support.common.JavaBeanMetaData;
import com.centit.support.common.ObjectException;
import com.centit.support.file.FileSystemOpt;
import com.centit.workflow.po.FlowInfo;
import com.centit.workflow.po.FlowTransition;
import com.centit.workflow.po.NodeInfo;
import com.centit.workflow.po.OptTeamRole;
import com.centit.workflow.po.OptVariableDefine;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class JsonAppVo {
    private static final String OS_ID = "osId";
    private static final String DATABASE_CODE = "databaseCode";
    private static final String TABLE_ID = "tableId";
    private static final String REFERENCE_DATA = "referenceData";
    private static final String RELATION_ID = "relationId";
    private static final String PARENT_TABLE_ID = "parentTableId";
    private static final String OPT_ID = "optId";
    private static final String ID = "id";
    private static final String PACKET_ID = "packetId";
    private static final String DATA_OPT_DESC_JSON = "dataOptDescJson";
    private static final String FLOW_XML_DESC = "flowXmlDesc";
    private static final String MODEL_ID = "modelId";
    private static final String FORM_TEMPLATE = "formTemplate";
    private static final String OPT_TEAM_ROLE_ID = "optTeamRoleId";
    private static final String OPT_VARIABLE_ID = "optVariableId";
    private static final String OPT_CODE = "optCode";
    private static final String CHILD_TABLE_ID = "childTableId";
    private static final String VERSION = "version";
    private static final String FLOW_CODE = "flowCode";
    private static final String NODE_ID = "nodeId";
    private static final String TRANS_ID = "transId";
    private static final String START_NODE_ID = "startNodeId";
    private static final String END_NODE_ID = "endNodeId";
    private static final String TOP_UNIT = "topUnit";
    private static final String NO_PUBLISH = "W";
    private static final String MAX_LENGTH = "maxLength";
    private static final String COLUMN_LENGTH = "columnLength";
    private static final String LIBRARY_ID = "libraryId";
    private static final String TOP_OPT_ID = "topOptId";
    private static final String PRE_OPT_ID = "preOptId";
    private static final String UPDATE_DATE = "updateDate";
    private static final String CREATE_TIME = "createTime";
    private static final String LAST_MODIFY_DATE = "lastModifyDate";
    private static final String UPDATE_TIME = "updateTime";
    private static final String RECORD_DATE = "recordDate";
    private static final String PUBLISH_DATE = "publishDate";
    private static final String MODIFY_TIME = "modifyTime";
    private static final String FLOW_PUBLISH_DATE = "flowPublishDate";
    private static final String REL_OPT_ID = "relOptId";
    private static final String CREATED = "created";
    private static final String CREATE_USER = "createUser";
    private static final String OWN_USER = "ownUser";
    private static final String RECORDER = "recorder";
    private static final String UPDATOR = "updator";
    private static final String CREATOR = "creator";
    private static final String CREATE_DATE = "createDate";
    private static final String TABLE_TYPE = "T";
    private static final String DEFAULT_DATABASE = "defaultDatabase";
    private static final String TABLE_NAME = "tableName";
    private static final String SOURCE_ID = "sourceId";
    private static final String DOC_ID = "docId";
    private static final String ROLE_CODE = "roleCode";
    private static final String VARIABLE_NAME = "variableName";
    private static final String OS_NAME = "osName";
    private static final String LIBRARY_NAME = "libraryName";
    private static final String FORM_CODE = "formCode";
    private static final String MOBILE_FORM_TEMPLATE = "mobileFormTemplate";
    private static final String STRUCTURE_FUNCTION = "structureFunction";
    private static final String DATABASE_ID = "databaseId";
    private static final String DICTIONARY_ID = "dictionaryId";
    private static final String DATABASE_ID_CLASS = "dataBaseId";
    private static final String PUSH_USER = "pushUser";
    private static final String PUSH_TIME = "pushTime";
    private static final String OPT_ROUTE = "optRoute";
    private static final String OPT_URL = "optUrl";
    private static final String API_ID = "apiId";
    private static final String DDE_RUN = "/dde/run/";
    private static final String CATALOG_CODE = "catalogCode";
    private static final String FIRST_NODE_ID = "firstNodeId";
    private static final String TASK_TYPE = "taskType";
    private static final String IS_VALID = "isValid";
    private JSONObject oldAppObject;
    private Map<String, List<Map<String, Object>>> mapJsonObject = new HashMap<String, List<Map<String, Object>>>();
    private String zipFilePath;
    private String appHome;
    private FileInfoOpt fileInfoOpt;
    private String userCode;
    private String topUnit;
    private String osId;
    private String defaultDatabase;
    private List<Object> appList = new ArrayList<Object>();
    private List<Object> metaObject = new ArrayList<Object>();
    private List<String> listDatabaseName = new ArrayList<String>();
    private Map<String, Object> databaseMap = new HashMap<String, Object>();
    private Map<String, Object> mdTableMap = new HashMap<String, Object>();
    private Map<String, Object> relationMap = new HashMap<String, Object>();
    private Map<String, Object> dataPacketMap = new HashMap<String, Object>();
    private Map<String, Object> metaFormMap = new HashMap<String, Object>();
    private Map<String, Object> flowDefineMap = new HashMap<String, Object>();
    private Map<String, Object> optInfoMap = new HashMap<String, Object>();
    private Map<String, Object> wfNodeMap = new HashMap<String, Object>();
    private Map<String, Object> dictionaryMap = new HashMap<String, Object>();
    private Map<String, Object> fileMap = new HashMap<String, Object>();
    private static final String MAP_DATA_CODE = "mapDataCode";

    public JsonAppVo() {
    }

    public JsonAppVo(JSONObject jsonObject, JSONObject oldObject, CentitUserDetails userDetails, String appHome, FileInfoOpt fileInfoOpt) {
        this.createMapJsonObject(jsonObject);
        this.oldAppObject = oldObject;
        this.userCode = userDetails == null ? "" : userDetails.getUserCode();
        this.topUnit = userDetails == null ? "" : userDetails.getTopUnitCode();
        this.appHome = appHome;
        this.fileInfoOpt = fileInfoOpt;
    }

    public void setTopUnit(CentitUserDetails userDetails) {
        this.topUnit = userDetails == null ? "" : userDetails.getTopUnitCode();
        this.userCode = userDetails.getUserCode();
    }

    public void prepareApp() {
        this.updatePrimary();
        this.createAppObject();
        this.setDatabaseName();
    }

    public void refreshCache(DdeDubboTaskRun ddeDubboTaskRun) {
        for (Object object : this.appList) {
            if (!(object instanceof DataPacket)) continue;
            ddeDubboTaskRun.refreshCache(((DataPacket)object).getPacketId());
        }
    }

    private void createMapJsonObject(JSONObject jsonObject) {
        for (Map.Entry entry : jsonObject.entrySet()) {
            if ("file".equals(entry.getKey())) {
                this.zipFilePath = StringBaseOpt.objectToString(entry.getValue());
                continue;
            }
            this.mapJsonObject.put((String)entry.getKey(), ((DataSet)new ObjectMapper().convertValue(entry.getValue(), DataSet.class)).getDataAsList());
        }
    }

    public void updatePrimary() {
        this.updateOsInfo().updateLibraryInfo().updateDatabase().updateApplicationResource().updateDataCatalog().updateDataDictionaryUseCatalog().updateApplicationDictionary().updateOsInfoUseDatabase().updateMdTable().updateMdColumn().updateMdRelation().updateRelationDetail().updateOptInfo().updateOptDef().updateTableRelation().uploadFiles().updatePacket().updateOptDefUsePacket().updatePacketParams().updateMetaForm().updateOptInfoUseMetaForm().updateWfDefineUseMetaFormWithPacket().updateWfNodeUseMetaFormWithPacket().updateWfOptTeamRole().updateWfOptVariable().updateWfDefine().updateWfNode().updateWfDefineUseWfNode().updateWfTransition().updatePacketUseWfDefine().updateMetaFormUseWfDefine();
    }

    public void createAppObject() {
        this.appList.clear();
        this.createOsInfo().createLibraryInfo().createApplicationResource().createDataCatalog().createDataDictionary().createApplicationDictionary().createMdTableWithColumnObject().createMdRelationWithDetailObject().createMetaFormObject().createDataPacketAndParamsObject().createWfOptTeamRole().createWfOptVariable().createOptInfo().createOptDef().createWfDefine().createWfNode().createWfTransition().createTableRelation();
    }

    public void setDatabaseName() {
        if (this.mapJsonObject.get(AppTableNames.F_DATABASE_INFO.name()) == null) {
            return;
        }
        List<Map<String, Object>> list = this.mapJsonObject.get(AppTableNames.F_DATABASE_INFO.name());
        list.stream().map(s -> (String)s.get(DATABASE_CODE)).forEach(this.listDatabaseName::add);
    }

    private JsonAppVo updateOsInfo() {
        if (this.mapJsonObject.get(AppTableNames.F_OS_INFO.name()) == null) {
            return this;
        }
        List<Map<String, Object>> list = this.mapJsonObject.get(AppTableNames.F_OS_INFO.name());
        List<OsInfo> oldList = this.convertJavaList(OsInfo.class, AppTableNames.F_OS_INFO.name());
        list.forEach(map -> {
            if (oldList != null) {
                this.osId = ((OsInfo)oldList.get(0)).getOsId();
                this.defaultDatabase = ((OsInfo)oldList.get(0)).getDefaultDatabase();
                map.put(DEFAULT_DATABASE, this.defaultDatabase);
                map.put(OS_NAME, ((OsInfo)oldList.get(0)).getOsName());
            } else {
                this.osId = UuidOpt.getUuidAsString();
            }
            map.put(OS_ID, this.osId);
            map.put(REL_OPT_ID, this.osId);
            map.put(CREATED, this.userCode);
            map.put(CREATE_TIME, new Date());
            map.put(LAST_MODIFY_DATE, new Date());
            map.remove(TOP_UNIT);
        });
        return this;
    }

    private JsonAppVo updateLibraryInfo() {
        if (this.mapJsonObject.get(AppTableNames.FILE_LIBRARY_INFO.name()) == null) {
            return this;
        }
        List<Map<String, Object>> list = this.mapJsonObject.get(AppTableNames.FILE_LIBRARY_INFO.name());
        List<FileLibraryInfo> oldList = this.convertJavaList(FileLibraryInfo.class, AppTableNames.FILE_LIBRARY_INFO.name());
        list.forEach(map -> {
            if (oldList != null) {
                map.put(LIBRARY_NAME, ((FileLibraryInfo)oldList.get(0)).getLibraryName());
            }
            map.put(LIBRARY_ID, this.osId);
            map.put(CREATE_USER, this.userCode);
            map.put(OWN_USER, this.userCode);
            map.put(CREATE_TIME, new Date());
            map.put(UPDATE_TIME, new Date());
        });
        return this;
    }

    private JsonAppVo updateDatabase() {
        if (this.mapJsonObject.get(AppTableNames.F_DATABASE_INFO.name()) == null) {
            return this;
        }
        List<Map<String, Object>> list = this.mapJsonObject.get(AppTableNames.F_DATABASE_INFO.name());
        List<SourceInfo> oldList = this.convertJavaList(SourceInfo.class, AppTableNames.F_DATABASE_INFO.name());
        list.forEach(map -> {
            String uuid;
            if (map.get(MAP_DATA_CODE) != null && !StringBaseOpt.isNvl((String)((String)map.get(MAP_DATA_CODE)))) {
                uuid = (String)map.get(MAP_DATA_CODE);
            } else if (!StringBaseOpt.isNvl((String)this.defaultDatabase)) {
                uuid = this.defaultDatabase;
            } else if (oldList != null) {
                uuid = ((SourceInfo)oldList.get(0)).getDatabaseCode();
            } else {
                throw new ObjectException(610, map.get("databaseName") + ":\u6ca1\u6709\u6307\u5b9a\u6570\u636e\u5e93");
            }
            for (SourceInfo sourceInfo : oldList) {
                if (!uuid.equals(sourceInfo.getDatabaseCode())) continue;
                map.put("databaseName", sourceInfo.getDatabaseName());
            }
            this.databaseMap.put(map.get(DATABASE_CODE).toString(), uuid);
            map.put(DATABASE_CODE, uuid);
            map.put(OS_ID, this.osId);
            map.put(CREATED, this.userCode);
            map.put(CREATE_TIME, new Date());
            map.put(LAST_MODIFY_DATE, new Date());
        });
        return this;
    }

    private JsonAppVo updateApplicationResource() {
        if (this.mapJsonObject.get(AppTableNames.M_APPLICATION_RESOURCES.name()) == null) {
            return this;
        }
        List<Map<String, Object>> list = this.mapJsonObject.get(AppTableNames.M_APPLICATION_RESOURCES.name());
        List<ApplicationResources> oldList = this.convertJavaList(ApplicationResources.class, AppTableNames.M_APPLICATION_RESOURCES.name());
        list.forEach(map -> {
            String uuid = "";
            this.databaseMap.keySet().stream().filter(key -> key.equals(map.get(DATABASE_ID))).findFirst().ifPresent(key -> map.put(DATABASE_ID, this.databaseMap.get(key)));
            if (oldList != null) {
                for (ApplicationResources oldMap : oldList) {
                    boolean equalsResource;
                    if (oldMap.getDataBaseId() == null || !(equalsResource = oldMap.getDataBaseId().equals(map.get(DATABASE_ID).toString()) && (oldMap.getOsId().equals(map.get(OS_ID).toString()) || oldMap.getOsId().equals(this.osId)))) continue;
                    uuid = oldMap.getId();
                    break;
                }
            }
            if (StringBaseOpt.isNvl((String)uuid)) {
                uuid = UuidOpt.getUuidAsString();
            }
            map.put(ID, uuid);
            map.put(OS_ID, this.osId);
            map.put(DATABASE_ID_CLASS, map.get(DATABASE_ID));
            map.put(PUSH_USER, this.userCode);
            map.put(PUSH_TIME, new Date());
        });
        return this;
    }

    private JsonAppVo updateDataCatalog() {
        if (this.mapJsonObject.get(AppTableNames.F_DATACATALOG.name()) == null) {
            return this;
        }
        List<Map<String, Object>> list = this.mapJsonObject.get(AppTableNames.F_DATACATALOG.name());
        List<DataCatalog> oldList = this.convertJavaList(DataCatalog.class, AppTableNames.F_DATACATALOG.name());
        list.forEach(map -> {
            map.put(SOURCE_ID, map.get(CATALOG_CODE));
            String uuid = "";
            if (oldList != null) {
                for (DataCatalog oldMap : oldList) {
                    boolean equalsResource;
                    if (oldMap.getSourceId() == null || !(equalsResource = oldMap.getSourceId().equals(map.get(SOURCE_ID).toString()))) continue;
                    uuid = oldMap.getSourceId();
                    break;
                }
                if (StringBaseOpt.isNvl((String)uuid)) {
                    for (DataCatalog oldMap : oldList) {
                        boolean findRepeatCatalog = map.get(CATALOG_CODE).toString().equals(oldMap.getCatalogCode()) && !this.osId.equals(oldMap.getOsId());
                        if (!findRepeatCatalog) continue;
                        uuid = UuidOpt.getUuidAsString();
                        break;
                    }
                }
            }
            if (StringBaseOpt.isNvl((String)uuid)) {
                uuid = map.get(CATALOG_CODE).toString();
            }
            this.dictionaryMap.put(map.get(CATALOG_CODE).toString(), uuid);
            map.put(CATALOG_CODE, uuid);
            map.put(OS_ID, this.osId);
            map.put(CREATOR, this.userCode);
            map.put(CREATE_DATE, new Date());
            map.put(UPDATOR, this.userCode);
            map.put(UPDATE_DATE, new Date());
            map.put(TOP_UNIT, this.topUnit);
        });
        return this;
    }

    private JsonAppVo updateDataDictionaryUseCatalog() {
        if (this.mapJsonObject.get(AppTableNames.F_DATADICTIONARY.name()) == null) {
            return this;
        }
        List<Map<String, Object>> list = this.mapJsonObject.get(AppTableNames.F_DATADICTIONARY.name());
        list.forEach(map -> this.dictionaryMap.keySet().stream().filter(key -> key.equals(map.get(CATALOG_CODE))).findFirst().ifPresent(key -> map.put(CATALOG_CODE, this.dictionaryMap.get(key))));
        return this;
    }

    private JsonAppVo updateApplicationDictionary() {
        if (this.mapJsonObject.get(AppTableNames.M_APPLICATION_DICTIONARY.name()) == null) {
            return this;
        }
        List<Map<String, Object>> list = this.mapJsonObject.get(AppTableNames.M_APPLICATION_DICTIONARY.name());
        List<ApplicationDictionary> oldList = this.convertJavaList(ApplicationDictionary.class, AppTableNames.M_APPLICATION_DICTIONARY.name());
        list.forEach(map -> {
            String uuid = "";
            this.dictionaryMap.keySet().stream().filter(key -> key.equals(map.get(DICTIONARY_ID))).findFirst().ifPresent(key -> map.put(DICTIONARY_ID, this.dictionaryMap.get(key)));
            if (oldList != null) {
                for (ApplicationDictionary oldMap : oldList) {
                    boolean equalsResource = oldMap.getDictionaryId().equals(map.get(DICTIONARY_ID).toString()) && (oldMap.getOsId().equals(map.get(OS_ID).toString()) || oldMap.getOsId().equals(this.osId));
                    if (!equalsResource) continue;
                    uuid = oldMap.getId();
                    break;
                }
            }
            if (StringBaseOpt.isNvl((String)uuid)) {
                uuid = UuidOpt.getUuidAsString();
            }
            map.put(ID, uuid);
            map.put(OS_ID, this.osId);
            map.put(DICTIONARY_ID, map.get(DICTIONARY_ID));
            map.put(PUSH_USER, this.userCode);
            map.put(PUSH_TIME, new Date());
        });
        return this;
    }

    private JsonAppVo updateOsInfoUseDatabase() {
        if (this.mapJsonObject.get(AppTableNames.F_OS_INFO.name()) == null) {
            return this;
        }
        List<Map<String, Object>> list = this.mapJsonObject.get(AppTableNames.F_OS_INFO.name());
        list.forEach(map -> this.databaseMap.keySet().stream().filter(key -> key.equals(map.get(DEFAULT_DATABASE))).findFirst().ifPresent(key -> map.put(DEFAULT_DATABASE, this.databaseMap.get(key))));
        return this;
    }

    private JsonAppVo updateMdTable() {
        if (this.mapJsonObject.get(AppTableNames.F_MD_TABLE.name()) == null) {
            return this;
        }
        List<Map<String, Object>> list = this.mapJsonObject.get(AppTableNames.F_MD_TABLE.name());
        List<MetaTable> finalOldList = this.convertJavaList(MetaTable.class, AppTableNames.F_MD_TABLE.name());
        list.forEach(map -> {
            String uuid = "";
            map.put(RECORDER, this.userCode);
            map.put(RECORD_DATE, new Date());
            this.databaseMap.keySet().stream().filter(key -> key.equals(map.get(DATABASE_CODE))).findFirst().ifPresent(key -> map.put(DATABASE_CODE, this.databaseMap.get(key)));
            if (finalOldList != null) {
                for (MetaTable oldMap : finalOldList) {
                    if (!oldMap.getTableName().equals(map.get(TABLE_NAME).toString()) || !oldMap.getDatabaseCode().equals(map.get(DATABASE_CODE).toString())) continue;
                    uuid = oldMap.getTableId();
                    break;
                }
            }
            if (StringBaseOpt.isNvl((String)uuid)) {
                uuid = UuidOpt.getUuidAsString();
            }
            this.mdTableMap.put(map.get(TABLE_ID).toString(), uuid);
            map.put(TABLE_ID, uuid);
        });
        return this;
    }

    private JsonAppVo updateMdColumn() {
        if (this.mapJsonObject.get(AppTableNames.F_MD_COLUMN.name()) == null) {
            return this;
        }
        List<Map<String, Object>> list = this.mapJsonObject.get(AppTableNames.F_MD_COLUMN.name());
        list.forEach(map -> {
            map.put(RECORDER, this.userCode);
            map.put(LAST_MODIFY_DATE, new Date());
            this.mdTableMap.keySet().stream().filter(key -> key.equals(map.get(TABLE_ID))).findFirst().ifPresent(key -> map.put(TABLE_ID, this.mdTableMap.get(key)));
            this.dictionaryMap.keySet().stream().filter(key -> key.equals(map.get(REFERENCE_DATA))).findFirst().ifPresent(key -> map.put(REFERENCE_DATA, this.dictionaryMap.get(key)));
        });
        return this;
    }

    private JsonAppVo updateMdRelation() {
        if (this.mapJsonObject.get(AppTableNames.F_MD_RELATION.name()) == null) {
            return this;
        }
        List<Map<String, Object>> list = this.mapJsonObject.get(AppTableNames.F_MD_RELATION.name());
        List<MetaRelation> finalOldList = this.convertJavaList(MetaRelation.class, AppTableNames.F_MD_RELATION.name());
        list.forEach(map -> {
            this.mdTableMap.keySet().stream().filter(key -> key.equals(map.get(PARENT_TABLE_ID))).findFirst().ifPresent(key -> map.put(PARENT_TABLE_ID, this.mdTableMap.get(key)));
            this.mdTableMap.keySet().stream().filter(key -> key.equals(map.get(CHILD_TABLE_ID))).findFirst().ifPresent(key -> map.put(CHILD_TABLE_ID, this.mdTableMap.get(key)));
            String uuid = "";
            if (finalOldList != null) {
                for (MetaRelation oldMap : finalOldList) {
                    if (!oldMap.getParentTableId().equals(map.get(PARENT_TABLE_ID).toString()) || !oldMap.getChildTableId().equals(map.get(CHILD_TABLE_ID).toString())) continue;
                    uuid = oldMap.getRelationId();
                    break;
                }
            }
            if (StringBaseOpt.isNvl((String)uuid)) {
                uuid = UuidOpt.getUuidAsString();
            }
            this.relationMap.put(map.get(RELATION_ID).toString(), uuid);
            map.put(RELATION_ID, uuid);
            map.put(RECORDER, this.userCode);
            map.put(LAST_MODIFY_DATE, new Date());
        });
        return this;
    }

    private JsonAppVo updateRelationDetail() {
        if (this.mapJsonObject.get(AppTableNames.F_MD_REL_DETAIL.name()) == null) {
            return this;
        }
        List<Map<String, Object>> list = this.mapJsonObject.get(AppTableNames.F_MD_REL_DETAIL.name());
        list.forEach(map -> this.relationMap.keySet().stream().filter(key -> key.equals(map.get(RELATION_ID))).findFirst().ifPresent(key -> map.put(RELATION_ID, this.relationMap.get(key))));
        return this;
    }

    private JsonAppVo updateOptInfo() {
        if (this.mapJsonObject.get(AppTableNames.F_OPTINFO.name()) == null) {
            return this;
        }
        List<Map<String, Object>> list = this.mapJsonObject.get(AppTableNames.F_OPTINFO.name());
        List<OptInfo> finalOldList = this.convertJavaList(OptInfo.class, AppTableNames.F_OPTINFO.name());
        list.forEach(map -> {
            map.put(DOC_ID, "");
            String uuid = "";
            if (map.get(OPT_ID).equals(map.get(TOP_OPT_ID))) {
                uuid = this.osId;
                boolean findRepeatOptId = false;
                for (OptInfo oldMap : finalOldList) {
                    findRepeatOptId = uuid.equals(oldMap.getOptId()) && uuid.equals(oldMap.getTopOptId());
                    if (!findRepeatOptId) continue;
                    map.put("optName", oldMap.getOptName());
                    break;
                }
            } else if ("C".equals(map.get(FORM_CODE)) || "A".equals(map.get(FORM_CODE))) {
                if (finalOldList != null) {
                    for (OptInfo oldMap : finalOldList) {
                        boolean findSameCode = this.osId.equals(oldMap.getTopOptId()) && (map.get(FORM_CODE).equals(oldMap.getFormCode()) || map.get(FORM_CODE).equals(oldMap.getFormCode()));
                        if (!findSameCode) continue;
                        uuid = oldMap.getOptId();
                        map.put(DOC_ID, oldMap.getDocId());
                        break;
                    }
                }
            } else if (finalOldList != null) {
                for (OptInfo oldMap : finalOldList) {
                    boolean canChangDocId = map.get(SOURCE_ID).toString().equals(oldMap.getSourceId()) && this.osId.equals(oldMap.getTopOptId());
                    if (!canChangDocId) continue;
                    uuid = oldMap.getOptId();
                    map.put(DOC_ID, oldMap.getDocId());
                    break;
                }
                if (StringBaseOpt.isNvl((String)uuid)) {
                    for (OptInfo oldMap : finalOldList) {
                        boolean findRepeatOptId = map.get(OPT_ID).toString().equals(oldMap.getOptId()) && !this.osId.equals(oldMap.getTopOptId());
                        if (!findRepeatOptId) continue;
                        uuid = UuidOpt.getUuidAsString();
                        map.put(DOC_ID, uuid);
                        break;
                    }
                }
            }
            if (StringBaseOpt.isNvl((String)uuid)) {
                uuid = map.get(OPT_ID).toString();
            }
            this.optInfoMap.put((String)map.get(OPT_ID), uuid);
            map.put(OPT_ID, uuid);
            map.put(TOP_OPT_ID, this.osId);
            map.put(OS_ID, this.osId);
            map.put(UPDATOR, this.userCode);
            map.put(UPDATE_DATE, new Date());
            map.put(CREATOR, this.userCode);
            map.put(CREATE_DATE, new Date());
        });
        list.forEach(map -> this.optInfoMap.keySet().stream().filter(key -> key.equals(map.get(PRE_OPT_ID))).findFirst().ifPresent(key -> map.put(PRE_OPT_ID, this.optInfoMap.get(key))));
        return this;
    }

    private JsonAppVo updateOptDef() {
        if (this.mapJsonObject.get(AppTableNames.F_OPTDEF.name()) == null) {
            return this;
        }
        List<Map<String, Object>> list = this.mapJsonObject.get(AppTableNames.F_OPTDEF.name());
        List<OptMethod> finalOldList = this.convertJavaList(OptMethod.class, AppTableNames.F_OPTDEF.name());
        list.forEach(map -> {
            String uuid = "";
            if (finalOldList != null) {
                for (OptMethod oldMap : finalOldList) {
                    if (!map.get(SOURCE_ID).toString().equals(oldMap.getSourceId()) || !this.osId.equals(oldMap.getTopOptId())) continue;
                    uuid = oldMap.getOptCode();
                    break;
                }
                if (StringBaseOpt.isNvl((String)uuid)) {
                    for (OptMethod oldMap : finalOldList) {
                        boolean findRepeatOptCode = map.get(OPT_CODE).toString().equals(oldMap.getOptCode()) && !this.osId.equals(oldMap.getTopOptId());
                        if (!findRepeatOptCode) continue;
                        uuid = UuidOpt.getUuidAsString();
                        break;
                    }
                }
            }
            if (StringBaseOpt.isNvl((String)uuid)) {
                uuid = map.get(OPT_CODE).toString();
            }
            map.put(OPT_CODE, uuid);
            map.put(UPDATOR, this.userCode);
            map.put(UPDATE_DATE, new Date());
            map.put(CREATOR, this.userCode);
            map.put(CREATE_DATE, new Date());
            this.optInfoMap.keySet().stream().filter(key -> key.equals(map.get(OPT_ID))).findFirst().ifPresent(key -> map.put(OPT_ID, this.optInfoMap.get(key)));
        });
        return this;
    }

    private JsonAppVo updateTableRelation() {
        if (this.mapJsonObject.get(AppTableNames.F_TABLE_OPT_RELATION.name()) == null) {
            return this;
        }
        List<Map<String, Object>> list = this.mapJsonObject.get(AppTableNames.F_TABLE_OPT_RELATION.name());
        List<MetaOptRelation> finalOldList = this.convertJavaList(MetaOptRelation.class, AppTableNames.F_TABLE_OPT_RELATION.name());
        list.forEach(map -> {
            this.mdTableMap.keySet().stream().filter(key -> key.equals(map.get(TABLE_ID))).findFirst().ifPresent(key -> map.put(TABLE_ID, this.mdTableMap.get(key)));
            this.optInfoMap.keySet().stream().filter(key -> key.equals(map.get(OPT_ID))).findFirst().ifPresent(key -> map.put(OPT_ID, this.optInfoMap.get(key)));
            String uuid = "";
            if (finalOldList != null) {
                for (MetaOptRelation oldMap : finalOldList) {
                    if (!map.get(TABLE_ID).toString().equals(oldMap.getTableId()) || !map.get(OPT_ID).toString().equals(oldMap.getOptId())) continue;
                    uuid = oldMap.getId();
                    break;
                }
            }
            if (StringBaseOpt.isNvl((String)uuid)) {
                uuid = UuidOpt.getUuidAsString();
            }
            map.put(ID, uuid);
            map.put(OS_ID, this.osId);
        });
        return this;
    }

    private JsonAppVo uploadFiles() {
        if (StringBaseOpt.isNvl((String)this.zipFilePath)) {
            return this;
        }
        List files = FileSystemOpt.findFiles((String)this.zipFilePath, (String)"file.zip");
        if (files == null || files.size() == 0) {
            return this;
        }
        String filePath = this.appHome + File.separator + "u" + DatetimeOpt.convertDateToString((Date)DatetimeOpt.currentUtilDate(), (String)"YYYYMMddHHmmss");
        ZipCompressor.release((File)((File)files.get(0)), (String)filePath);
        List zipFiles = FileSystemOpt.findFiles((String)filePath, (String)"*");
        zipFiles.forEach(file -> {
            FileInfo fileInfo = new FileInfo();
            String fileName = FileSystemOpt.extractFullFileName((String)file.getPath());
            fileInfo.setFileName(fileName);
            fileInfo.setFileShowPath("/-1");
            String oldFileId = fileName.substring(fileName.indexOf("(") + 1, fileName.indexOf(")"));
            fileInfo.setLibraryId(this.osId);
            fileInfo.setFileCatalog("A");
            String fileId = null;
            try {
                fileId = this.fileInfoOpt.saveFile((FileBaseInfo)fileInfo, -1L, (InputStream)new FileInputStream(file.getPath()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            fileInfo.setFileId(fileId);
            this.fileMap.put(oldFileId, fileId);
        });
        FileSystemOpt.deleteDirect((String)filePath);
        return this;
    }

    private JsonAppVo updatePacket() {
        if (this.mapJsonObject.get(AppTableNames.Q_DATA_PACKET.name()) == null) {
            return this;
        }
        List<Map<String, Object>> list = this.mapJsonObject.get(AppTableNames.Q_DATA_PACKET.name());
        List<DataPacket> finalOldList = this.convertJavaList(DataPacket.class, AppTableNames.Q_DATA_PACKET.name());
        list.forEach(map -> {
            String uuid = "";
            if (finalOldList != null) {
                for (DataPacket oldMap : finalOldList) {
                    boolean samePacketId = map.get(SOURCE_ID).toString().equals(oldMap.getSourceId()) && this.osId.equals(oldMap.getOsId());
                    if (!samePacketId) continue;
                    uuid = oldMap.getPacketId();
                    map.put(IS_VALID, oldMap.getIsValid());
                    break;
                }
                if (StringBaseOpt.isNvl((String)uuid)) {
                    for (DataPacket oldMap : finalOldList) {
                        boolean findRepeatPacketId = map.get(PACKET_ID).toString().equals(oldMap.getPacketId()) && !this.osId.equals(oldMap.getOsId());
                        if (!findRepeatPacketId) continue;
                        uuid = UuidOpt.getUuidAsString();
                        map.put(IS_VALID, false);
                        break;
                    }
                }
            }
            if (StringBaseOpt.isNvl((String)uuid)) {
                uuid = map.get(PACKET_ID).toString();
                if ("2".equals(map.get(TASK_TYPE).toString())) {
                    map.put(IS_VALID, false);
                }
            }
            this.dataPacketMap.put((String)map.get(PACKET_ID), uuid);
            map.put(PACKET_ID, uuid);
            map.put(OS_ID, this.osId);
            map.put(RECORD_DATE, new Date());
            map.put(UPDATE_DATE, new Date());
            map.put(PUBLISH_DATE, new Date());
            map.put(RECORDER, this.userCode);
            map.put(OPT_CODE, uuid);
            this.optInfoMap.keySet().stream().filter(key -> key.equals(map.get(OPT_ID))).findFirst().ifPresent(key -> map.put(OPT_ID, this.optInfoMap.get(key)));
        });
        list.forEach(map -> {
            String form = (String)map.get(DATA_OPT_DESC_JSON);
            for (String key : this.mdTableMap.keySet()) {
                form = StringUtils.replace((String)form, (String)key, (String)((String)this.mdTableMap.get(key)));
            }
            for (String key : this.databaseMap.keySet()) {
                form = StringUtils.replace((String)form, (String)key, (String)((String)this.databaseMap.get(key)));
            }
            for (String key : this.dataPacketMap.keySet()) {
                form = StringUtils.replace((String)form, (String)key, (String)((String)this.dataPacketMap.get(key)));
            }
            for (String key : this.dictionaryMap.keySet()) {
                form = StringUtils.replace((String)form, (String)key, (String)((String)this.dictionaryMap.get(key)));
            }
            for (String key : this.fileMap.keySet()) {
                form = StringUtils.replace((String)form, (String)key, (String)((String)this.fileMap.get(key)));
            }
            map.put(DATA_OPT_DESC_JSON, form);
        });
        return this;
    }

    private JsonAppVo updateOptDefUsePacket() {
        if (this.mapJsonObject.get(AppTableNames.F_OPTDEF.name()) == null) {
            return this;
        }
        List<Map<String, Object>> list = this.mapJsonObject.get(AppTableNames.F_OPTDEF.name());
        list.forEach(map -> {
            if (map.get(API_ID) != null) {
                this.dataPacketMap.keySet().stream().filter(key -> key.equals(map.get(API_ID))).findFirst().ifPresent(key -> map.put(API_ID, this.dataPacketMap.get(key)));
                map.put(OPT_URL, DDE_RUN + map.get(API_ID));
                map.put(OPT_CODE, map.get(API_ID));
            }
        });
        return this;
    }

    private JsonAppVo updatePacketParams() {
        if (this.mapJsonObject.get(AppTableNames.Q_DATA_PACKET_PARAM.name()) == null) {
            return this;
        }
        List<Map<String, Object>> list = this.mapJsonObject.get(AppTableNames.Q_DATA_PACKET_PARAM.name());
        list.forEach(map -> this.dataPacketMap.keySet().stream().filter(key -> key.equals(map.get(PACKET_ID))).findFirst().ifPresent(key -> map.put(PACKET_ID, this.dataPacketMap.get(key))));
        return this;
    }

    private JsonAppVo updateMetaForm() {
        if (this.mapJsonObject.get(AppTableNames.M_META_FORM_MODEL.name()) == null) {
            return this;
        }
        List<Map<String, Object>> list = this.mapJsonObject.get(AppTableNames.M_META_FORM_MODEL.name());
        List<MetaFormModel> finalOldList = this.convertJavaList(MetaFormModel.class, AppTableNames.M_META_FORM_MODEL.name());
        list.forEach(map -> {
            String uuid = "";
            if (finalOldList != null) {
                for (MetaFormModel oldMap : finalOldList) {
                    if (!map.get(SOURCE_ID).toString().equals(oldMap.getSourceId()) || !this.osId.equals(oldMap.getOsId())) continue;
                    uuid = oldMap.getModelId();
                    break;
                }
                if (StringBaseOpt.isNvl((String)uuid)) {
                    for (MetaFormModel oldMap : finalOldList) {
                        boolean findRepeatModelId = map.get(MODEL_ID).toString().equals(oldMap.getModelId()) && !this.osId.equals(oldMap.getOsId());
                        if (!findRepeatModelId) continue;
                        uuid = UuidOpt.getUuidAsString();
                        break;
                    }
                }
            }
            if (StringBaseOpt.isNvl((String)uuid)) {
                uuid = map.get(MODEL_ID).toString();
            }
            this.metaFormMap.put((String)map.get(MODEL_ID), uuid);
            map.put(MODEL_ID, uuid);
            map.put(OS_ID, this.osId);
            map.put(LAST_MODIFY_DATE, new Date());
            map.put(PUBLISH_DATE, new Date());
            map.put(RECORDER, this.userCode);
            this.optInfoMap.keySet().stream().filter(key -> key.equals(map.get(OPT_ID))).findFirst().ifPresent(key -> map.put(OPT_ID, this.optInfoMap.get(key)));
        });
        list.forEach(map -> {
            String form;
            if (map.get(FORM_TEMPLATE) != null) {
                form = (String)map.get(FORM_TEMPLATE);
                for (String key : this.metaFormMap.keySet()) {
                    form = StringUtils.replace((String)form, (String)key, (String)((String)this.metaFormMap.get(key)));
                }
                for (String key : this.dataPacketMap.keySet()) {
                    form = StringUtils.replace((String)form, (String)key, (String)((String)this.dataPacketMap.get(key)));
                }
                for (String key : this.dictionaryMap.keySet()) {
                    form = StringUtils.replace((String)form, (String)key, (String)((String)this.dictionaryMap.get(key)));
                }
                for (String key : this.fileMap.keySet()) {
                    form = StringUtils.replace((String)form, (String)key, (String)((String)this.fileMap.get(key)));
                }
                map.put(FORM_TEMPLATE, form);
            }
            if (map.get(MOBILE_FORM_TEMPLATE) != null) {
                form = (String)map.get(MOBILE_FORM_TEMPLATE);
                for (String key : this.metaFormMap.keySet()) {
                    form = StringUtils.replace((String)form, (String)key, (String)((String)this.metaFormMap.get(key)));
                }
                for (String key : this.dataPacketMap.keySet()) {
                    form = StringUtils.replace((String)form, (String)key, (String)((String)this.dataPacketMap.get(key)));
                }
                for (String key : this.dictionaryMap.keySet()) {
                    form = StringUtils.replace((String)form, (String)key, (String)((String)this.dictionaryMap.get(key)));
                }
                for (String key : this.fileMap.keySet()) {
                    form = StringUtils.replace((String)form, (String)key, (String)((String)this.fileMap.get(key)));
                }
                map.put(MOBILE_FORM_TEMPLATE, form);
            }
            if (map.get(STRUCTURE_FUNCTION) != null) {
                form = (String)map.get(STRUCTURE_FUNCTION);
                for (String key : this.metaFormMap.keySet()) {
                    form = StringUtils.replace((String)form, (String)key, (String)((String)this.metaFormMap.get(key)));
                }
                for (String key : this.dataPacketMap.keySet()) {
                    form = StringUtils.replace((String)form, (String)key, (String)((String)this.dataPacketMap.get(key)));
                }
                for (String key : this.dictionaryMap.keySet()) {
                    form = StringUtils.replace((String)form, (String)key, (String)((String)this.dictionaryMap.get(key)));
                }
                for (String key : this.fileMap.keySet()) {
                    form = StringUtils.replace((String)form, (String)key, (String)((String)this.fileMap.get(key)));
                }
                map.put(STRUCTURE_FUNCTION, form);
            }
        });
        return this;
    }

    private JsonAppVo updateOptInfoUseMetaForm() {
        if (this.mapJsonObject.get(AppTableNames.F_OPTINFO.name()) == null) {
            return this;
        }
        List<Map<String, Object>> list = this.mapJsonObject.get(AppTableNames.F_OPTINFO.name());
        list.forEach(map -> {
            this.metaFormMap.keySet().stream().filter(key -> key.equals(map.get(OPT_ROUTE))).findFirst().ifPresent(key -> map.put(OPT_ROUTE, this.metaFormMap.get(key)));
            if (map.get(OPT_URL) != null) {
                String form = (String)map.get(OPT_URL);
                for (String key2 : this.metaFormMap.keySet()) {
                    form = StringUtils.replace((String)form, (String)key2, (String)((String)this.metaFormMap.get(key2)));
                }
                map.put(OPT_URL, form);
            }
        });
        return this;
    }

    private JsonAppVo updateWfDefineUseMetaFormWithPacket() {
        if (this.mapJsonObject.get(AppTableNames.WF_FLOW_DEFINE.name()) == null) {
            return this;
        }
        List<Map<String, Object>> list = this.mapJsonObject.get(AppTableNames.WF_FLOW_DEFINE.name());
        list.forEach(map -> {
            if (map.get(FLOW_XML_DESC) != null) {
                String form = (String)map.get(FLOW_XML_DESC);
                for (String key : this.metaFormMap.keySet()) {
                    form = StringUtils.replace((String)form, (String)key, (String)((String)this.metaFormMap.get(key)));
                }
                for (String key : this.dataPacketMap.keySet()) {
                    form = StringUtils.replace((String)form, (String)key, (String)((String)this.dataPacketMap.get(key)));
                }
                for (String key : this.optInfoMap.keySet()) {
                    form = StringUtils.replace((String)form, (String)key, (String)((String)this.optInfoMap.get(key)));
                }
                map.put(FLOW_XML_DESC, form);
            }
        });
        return this;
    }

    private JsonAppVo updateWfNodeUseMetaFormWithPacket() {
        if (this.mapJsonObject.get(AppTableNames.WF_NODE.name()) == null) {
            return this;
        }
        List<Map<String, Object>> list = this.mapJsonObject.get(AppTableNames.WF_NODE.name());
        list.forEach(map -> {
            this.dataPacketMap.keySet().stream().filter(key -> key.equals(map.get(OPT_CODE))).findFirst().ifPresent(key -> map.put(OPT_CODE, this.dataPacketMap.get(key)));
            this.metaFormMap.keySet().stream().filter(key -> key.equals(map.get(OPT_CODE))).findFirst().ifPresent(key -> map.put(OPT_CODE, this.metaFormMap.get(key)));
            this.optInfoMap.keySet().stream().filter(key -> key.equals(map.get(OPT_ID))).findFirst().ifPresent(key -> map.put(OPT_ID, this.optInfoMap.get(key)));
        });
        return this;
    }

    private JsonAppVo updateWfOptTeamRole() {
        if (this.mapJsonObject.get(AppTableNames.WF_OPT_TEAM_ROLE.name()) == null) {
            return this;
        }
        List<Map<String, Object>> list = this.mapJsonObject.get(AppTableNames.WF_OPT_TEAM_ROLE.name());
        List<OptTeamRole> finalOldList = this.convertJavaList(OptTeamRole.class, AppTableNames.WF_OPT_TEAM_ROLE.name());
        list.forEach(map -> {
            this.optInfoMap.keySet().stream().filter(key -> key.equals(map.get(OPT_ID))).findFirst().ifPresent(key -> map.put(OPT_ID, this.optInfoMap.get(key)));
            String uuid = "";
            if (finalOldList != null) {
                for (OptTeamRole oldMap : finalOldList) {
                    if (!map.get(ROLE_CODE).toString().equals(oldMap.getRoleCode()) || !map.get(OPT_ID).toString().equals(oldMap.getOptId())) continue;
                    uuid = oldMap.getOptTeamRoleId();
                    break;
                }
            }
            if (StringBaseOpt.isNvl((String)uuid)) {
                uuid = UuidOpt.getUuidAsString();
            }
            map.put(OPT_TEAM_ROLE_ID, uuid);
            map.put(MODIFY_TIME, new Date());
        });
        return this;
    }

    private JsonAppVo updateWfOptVariable() {
        if (this.mapJsonObject.get(AppTableNames.WF_OPT_VARIABLE_DEFINE.name()) == null) {
            return this;
        }
        List<Map<String, Object>> list = this.mapJsonObject.get(AppTableNames.WF_OPT_VARIABLE_DEFINE.name());
        List<OptVariableDefine> finalOldList = this.convertJavaList(OptVariableDefine.class, AppTableNames.WF_OPT_VARIABLE_DEFINE.name());
        list.forEach(map -> {
            this.optInfoMap.keySet().stream().filter(key -> key.equals(map.get(OPT_ID))).findFirst().ifPresent(key -> map.put(OPT_ID, this.optInfoMap.get(key)));
            String uuid = "";
            if (finalOldList != null) {
                for (OptVariableDefine oldMap : finalOldList) {
                    if (!map.get(VARIABLE_NAME).toString().equals(oldMap.getVariableName()) || !map.get(OPT_ID).toString().equals(oldMap.getOptId())) continue;
                    uuid = oldMap.getOptVariableId();
                    break;
                }
            }
            if (StringBaseOpt.isNvl((String)uuid)) {
                uuid = UuidOpt.getUuidAsString();
            }
            map.put(OPT_VARIABLE_ID, uuid);
            map.put(MODIFY_TIME, new Date());
        });
        return this;
    }

    private JsonAppVo updateWfDefine() {
        if (this.mapJsonObject.get(AppTableNames.WF_FLOW_DEFINE.name()) == null) {
            return this;
        }
        List<Map<String, Object>> list = this.mapJsonObject.get(AppTableNames.WF_FLOW_DEFINE.name());
        list.sort((o1, o2) -> GeneralAlgorithm.compareTwoObject(o1.get(VERSION), o2.get(VERSION)));
        List<FlowInfo> finalOldList = this.convertJavaList(FlowInfo.class, AppTableNames.WF_FLOW_DEFINE.name());
        list.forEach(map -> {
            if (NumberBaseOpt.castObjectToInteger(map.get(VERSION), (Integer)-1) == 0) {
                String uuid = "";
                if (finalOldList != null) {
                    for (FlowInfo oldMap : finalOldList) {
                        if (!map.get(SOURCE_ID).toString().equals(oldMap.getSourceId()) || !this.osId.equals(oldMap.getOsId())) continue;
                        uuid = oldMap.getFlowCode();
                        break;
                    }
                    if (StringBaseOpt.isNvl((String)uuid)) {
                        for (FlowInfo oldMap : finalOldList) {
                            if (!map.get(FLOW_CODE).toString().equals(oldMap.getFlowCode()) || this.osId.equals(oldMap.getOsId())) continue;
                            uuid = UuidOpt.getUuidAsString();
                            break;
                        }
                    }
                }
                if (StringBaseOpt.isNvl((String)uuid)) {
                    uuid = map.get(FLOW_CODE).toString();
                }
                this.flowDefineMap.put((String)map.get(FLOW_CODE), uuid);
            }
            map.put(FLOW_PUBLISH_DATE, new Date());
            this.optInfoMap.keySet().stream().filter(key -> key.equals(map.get(OPT_ID))).findFirst().ifPresent(key -> map.put(OPT_ID, this.optInfoMap.get(key)));
            map.put(OS_ID, this.osId);
        });
        list.forEach(map -> this.flowDefineMap.keySet().stream().filter(key -> key.equals(map.get(FLOW_CODE))).findFirst().ifPresent(key -> map.put(FLOW_CODE, this.flowDefineMap.get(key))));
        return this;
    }

    private JsonAppVo updateWfNode() {
        if (this.mapJsonObject.get(AppTableNames.WF_NODE.name()) == null) {
            return this;
        }
        List<Map<String, Object>> list = this.mapJsonObject.get(AppTableNames.WF_NODE.name());
        List<NodeInfo> finalOldList = this.convertJavaList(NodeInfo.class, AppTableNames.WF_NODE.name());
        list.forEach(map -> {
            String uuid = "";
            if (finalOldList != null) {
                for (NodeInfo oldMap : finalOldList) {
                    if (!map.get(SOURCE_ID).toString().equals(oldMap.getSourceId()) || !this.osId.equals(oldMap.getOsId())) continue;
                    uuid = oldMap.getNodeId();
                    break;
                }
                if (StringBaseOpt.isNvl((String)uuid)) {
                    for (NodeInfo oldMap : finalOldList) {
                        if (!map.get(NODE_ID).toString().equals(oldMap.getNodeId()) || this.osId.equals(oldMap.getOsId())) continue;
                        uuid = UuidOpt.getUuidAsString();
                        break;
                    }
                }
            }
            if (StringBaseOpt.isNvl((String)uuid)) {
                uuid = map.get(NODE_ID).toString();
            }
            this.wfNodeMap.put((String)map.get(NODE_ID), uuid);
            map.put(NODE_ID, uuid);
            map.put(OS_ID, this.osId);
            this.flowDefineMap.keySet().stream().filter(key -> key.equals(map.get(FLOW_CODE))).findFirst().ifPresent(key -> map.put(FLOW_CODE, this.flowDefineMap.get(key)));
            this.metaFormMap.keySet().stream().filter(key -> key.equals(map.get(OPT_CODE))).findFirst().ifPresent(key -> map.put(OPT_CODE, this.metaFormMap.get(key)));
        });
        return this;
    }

    private JsonAppVo updateWfDefineUseWfNode() {
        if (this.mapJsonObject.get(AppTableNames.WF_FLOW_DEFINE.name()) == null) {
            return this;
        }
        List<Map<String, Object>> list = this.mapJsonObject.get(AppTableNames.WF_FLOW_DEFINE.name());
        list.forEach(map -> this.wfNodeMap.keySet().stream().filter(key -> key.equals(map.get(FIRST_NODE_ID))).findFirst().ifPresent(key -> map.put(FIRST_NODE_ID, this.wfNodeMap.get(key))));
        return this;
    }

    private JsonAppVo updateWfTransition() {
        if (this.mapJsonObject.get(AppTableNames.WF_TRANSITION.name()) == null) {
            return this;
        }
        List<Map<String, Object>> list = this.mapJsonObject.get(AppTableNames.WF_TRANSITION.name());
        List<FlowTransition> finalOldList = this.convertJavaList(FlowTransition.class, AppTableNames.WF_TRANSITION.name());
        list.forEach(map -> {
            this.flowDefineMap.keySet().stream().filter(key -> key.equals(map.get(FLOW_CODE))).findFirst().ifPresent(key -> map.put(FLOW_CODE, this.flowDefineMap.get(key)));
            this.wfNodeMap.keySet().stream().filter(key -> key.equals(map.get(START_NODE_ID))).findFirst().ifPresent(key -> map.put(START_NODE_ID, this.wfNodeMap.get(key)));
            this.wfNodeMap.keySet().stream().filter(key -> key.equals(map.get(END_NODE_ID))).findFirst().ifPresent(key -> map.put(END_NODE_ID, this.wfNodeMap.get(key)));
            String uuid = "";
            if (finalOldList != null) {
                for (FlowTransition oldMap : finalOldList) {
                    if (!map.get(FLOW_CODE).toString().equals(oldMap.getFlowCode()) || !map.get(START_NODE_ID).toString().equals(oldMap.getStartNodeId()) || !map.get(END_NODE_ID).toString().equals(oldMap.getEndNodeId())) continue;
                    uuid = oldMap.getTransId();
                    break;
                }
            }
            if (StringBaseOpt.isNvl((String)uuid)) {
                uuid = UuidOpt.getUuidAsString();
            }
            map.put(TRANS_ID, uuid);
        });
        return this;
    }

    private JsonAppVo updatePacketUseWfDefine() {
        if (this.mapJsonObject.get(AppTableNames.Q_DATA_PACKET.name()) == null) {
            return this;
        }
        List<Map<String, Object>> list = this.mapJsonObject.get(AppTableNames.Q_DATA_PACKET.name());
        list.forEach(map -> {
            String form = (String)map.get(DATA_OPT_DESC_JSON);
            for (String key : this.flowDefineMap.keySet()) {
                form = StringUtils.replace((String)form, (String)key, (String)((String)this.flowDefineMap.get(key)));
            }
            map.put(DATA_OPT_DESC_JSON, form);
        });
        return this;
    }

    private JsonAppVo updateMetaFormUseWfDefine() {
        if (this.mapJsonObject.get(AppTableNames.M_META_FORM_MODEL.name()) == null) {
            return this;
        }
        List<Map<String, Object>> list = this.mapJsonObject.get(AppTableNames.M_META_FORM_MODEL.name());
        list.forEach(map -> {
            String form;
            if (map.get(FORM_TEMPLATE) != null) {
                form = (String)map.get(FORM_TEMPLATE);
                for (String key : this.flowDefineMap.keySet()) {
                    form = StringUtils.replace((String)form, (String)key, (String)((String)this.flowDefineMap.get(key)));
                }
                map.put(FORM_TEMPLATE, form);
            }
            if (map.get(MOBILE_FORM_TEMPLATE) != null) {
                form = (String)map.get(MOBILE_FORM_TEMPLATE);
                for (String key : this.flowDefineMap.keySet()) {
                    form = StringUtils.replace((String)form, (String)key, (String)((String)this.flowDefineMap.get(key)));
                }
                map.put(MOBILE_FORM_TEMPLATE, form);
            }
            if (map.get(STRUCTURE_FUNCTION) != null) {
                form = (String)map.get(STRUCTURE_FUNCTION);
                for (String key : this.flowDefineMap.keySet()) {
                    form = StringUtils.replace((String)form, (String)key, (String)((String)this.flowDefineMap.get(key)));
                }
                map.put(STRUCTURE_FUNCTION, form);
            }
        });
        return this;
    }

    private <T> List<T> convertJavaList(Class<T> type, String className) {
        if (this.notHaveOldData(className)) {
            return null;
        }
        return this.oldAppObject.getJSONArray(className).toJavaList(type, new JSONReader.Feature[0]);
    }

    private boolean notHaveOldData(String dataName) {
        return this.oldAppObject.get(dataName) == null || this.oldAppObject.getJSONArray(dataName).size() == 0;
    }

    private JsonAppVo createOsInfo() {
        if (this.mapJsonObject.get(AppTableNames.F_OS_INFO.name()) == null) {
            return this;
        }
        List<Map<String, Object>> list = this.mapJsonObject.get(AppTableNames.F_OS_INFO.name());
        List<OsInfo> oldList = this.convertJavaList(OsInfo.class, AppTableNames.F_OS_INFO.name());
        if (oldList == null) {
            list.forEach(map -> map.put(TOP_UNIT, this.topUnit));
            this.appList.addAll(this.convertMap(OsInfo.class, list));
            WorkGroup teamUser = this.assembleWorkGroup((String)list.get(0).get(OS_ID));
            this.appList.add(teamUser);
        } else {
            this.appList.addAll(this.convertMap(OsInfo.class, list));
        }
        return this;
    }

    private WorkGroup assembleWorkGroup(String osId) {
        WorkGroup teamUser = new WorkGroup();
        WorkGroupParameter workGroupParameter = new WorkGroupParameter();
        workGroupParameter.setUserCode(this.userCode);
        workGroupParameter.setGroupId(osId);
        workGroupParameter.setRoleCode("\u7ec4\u957f");
        teamUser.setWorkGroupParameter(workGroupParameter);
        teamUser.setCreator(this.userCode);
        return teamUser;
    }

    private JsonAppVo createLibraryInfo() {
        if (this.mapJsonObject.get(AppTableNames.FILE_LIBRARY_INFO.name()) == null) {
            return this;
        }
        List<Map<String, Object>> list = this.mapJsonObject.get(AppTableNames.FILE_LIBRARY_INFO.name());
        List<FileLibraryInfo> oldList = this.convertJavaList(FileLibraryInfo.class, AppTableNames.FILE_LIBRARY_INFO.name());
        if (oldList == null) {
            this.appList.addAll(this.convertMap(FileLibraryInfo.class, list));
        }
        return this;
    }

    private JsonAppVo createApplicationResource() {
        if (this.mapJsonObject.get(AppTableNames.M_APPLICATION_RESOURCES.name()) == null) {
            return this;
        }
        List<Map<String, Object>> list = this.mapJsonObject.get(AppTableNames.M_APPLICATION_RESOURCES.name());
        this.appList.addAll(this.convertMap(ApplicationResources.class, list));
        return this;
    }

    private JsonAppVo createDataCatalog() {
        if (this.mapJsonObject.get(AppTableNames.F_DATACATALOG.name()) == null) {
            return this;
        }
        List<Map<String, Object>> list = this.mapJsonObject.get(AppTableNames.F_DATACATALOG.name());
        this.appList.addAll(this.convertMap(DataCatalog.class, list));
        return this;
    }

    private JsonAppVo createDataDictionary() {
        if (this.mapJsonObject.get(AppTableNames.F_DATADICTIONARY.name()) == null) {
            return this;
        }
        List<Map<String, Object>> list = this.mapJsonObject.get(AppTableNames.F_DATADICTIONARY.name());
        this.appList.addAll(this.convertMap(DataDictionary.class, list));
        return this;
    }

    private JsonAppVo createApplicationDictionary() {
        if (this.mapJsonObject.get(AppTableNames.M_APPLICATION_DICTIONARY.name()) == null) {
            return this;
        }
        List<Map<String, Object>> list = this.mapJsonObject.get(AppTableNames.M_APPLICATION_DICTIONARY.name());
        this.appList.addAll(this.convertMap(ApplicationDictionary.class, list));
        return this;
    }

    private JsonAppVo createMdTableWithColumnObject() {
        if (this.mapJsonObject.get(AppTableNames.F_MD_TABLE.name()) == null) {
            return this;
        }
        List<Map<String, Object>> list = this.mapJsonObject.get(AppTableNames.F_MD_TABLE.name());
        this.metaObject.addAll(this.convertMap(MetaTable.class, list));
        List<Object> objectList = this.convertMap(PendingMetaTable.class, list);
        objectList.forEach(map -> {
            if (TABLE_TYPE.equals(((PendingMetaTable)map).getTableType())) {
                ((PendingMetaTable)map).setTableState(NO_PUBLISH);
                this.appList.add(map);
            }
        });
        if (this.mapJsonObject.get(AppTableNames.F_MD_COLUMN.name()) == null) {
            return this;
        }
        list = this.mapJsonObject.get(AppTableNames.F_MD_COLUMN.name());
        this.metaObject.addAll(this.convertMap(MetaColumn.class, list));
        list.forEach(map -> map.put(MAX_LENGTH, map.get(COLUMN_LENGTH)));
        this.appList.addAll(this.convertMap(PendingMetaColumn.class, list));
        return this;
    }

    private JsonAppVo createMdRelationWithDetailObject() {
        if (this.mapJsonObject.get(AppTableNames.F_MD_RELATION.name()) == null) {
            return this;
        }
        List<Map<String, Object>> list = this.mapJsonObject.get(AppTableNames.F_MD_RELATION.name());
        this.metaObject.addAll(this.convertMap(MetaRelation.class, list));
        if (this.mapJsonObject.get(AppTableNames.F_MD_REL_DETAIL.name()) == null) {
            return this;
        }
        list = this.mapJsonObject.get(AppTableNames.F_MD_REL_DETAIL.name());
        this.appList.addAll(this.convertMap(MetaRelDetail.class, list));
        return this;
    }

    private JsonAppVo createMetaFormObject() {
        if (this.mapJsonObject.get(AppTableNames.M_META_FORM_MODEL.name()) == null) {
            return this;
        }
        List<Map<String, Object>> list = this.mapJsonObject.get(AppTableNames.M_META_FORM_MODEL.name());
        this.appList.addAll(this.convertMap(MetaFormModel.class, list));
        this.appList.addAll(this.convertMap(MetaFormModelDraft.class, list));
        return this;
    }

    private JsonAppVo createDataPacketAndParamsObject() {
        if (this.mapJsonObject.get(AppTableNames.Q_DATA_PACKET.name()) == null) {
            return this;
        }
        List<Map<String, Object>> list = this.mapJsonObject.get(AppTableNames.Q_DATA_PACKET.name());
        this.appList.addAll(this.convertMap(DataPacket.class, list));
        this.appList.addAll(this.convertMap(DataPacketDraft.class, list));
        if (this.mapJsonObject.get(AppTableNames.Q_DATA_PACKET_PARAM.name()) == null) {
            return this;
        }
        list = this.mapJsonObject.get(AppTableNames.Q_DATA_PACKET_PARAM.name());
        this.appList.addAll(this.convertMap(DataPacketParam.class, list));
        this.appList.addAll(this.convertMap(DataPacketParamDraft.class, list));
        return this;
    }

    private JsonAppVo createWfOptTeamRole() {
        if (this.mapJsonObject.get(AppTableNames.WF_OPT_TEAM_ROLE.name()) == null) {
            return this;
        }
        List<Map<String, Object>> list = this.mapJsonObject.get(AppTableNames.WF_OPT_TEAM_ROLE.name());
        this.appList.addAll(this.convertMap(OptTeamRole.class, list));
        return this;
    }

    private JsonAppVo createWfOptVariable() {
        if (this.mapJsonObject.get(AppTableNames.WF_OPT_VARIABLE_DEFINE.name()) == null) {
            return this;
        }
        List<Map<String, Object>> list = this.mapJsonObject.get(AppTableNames.WF_OPT_VARIABLE_DEFINE.name());
        this.appList.addAll(this.convertMap(OptVariableDefine.class, list));
        return this;
    }

    private JsonAppVo createOptInfo() {
        if (this.mapJsonObject.get(AppTableNames.F_OPTINFO.name()) == null) {
            return this;
        }
        List<Map<String, Object>> list = this.mapJsonObject.get(AppTableNames.F_OPTINFO.name());
        this.appList.addAll(this.convertMap(OptInfo.class, list));
        return this;
    }

    private JsonAppVo createOptDef() {
        if (this.mapJsonObject.get(AppTableNames.F_OPTDEF.name()) == null) {
            return this;
        }
        List<Map<String, Object>> list = this.mapJsonObject.get(AppTableNames.F_OPTDEF.name());
        this.appList.addAll(this.convertMap(OptMethod.class, list));
        return this;
    }

    private JsonAppVo createWfDefine() {
        if (this.mapJsonObject.get(AppTableNames.WF_FLOW_DEFINE.name()) == null) {
            return this;
        }
        List<Map<String, Object>> list = this.mapJsonObject.get(AppTableNames.WF_FLOW_DEFINE.name());
        this.appList.addAll(this.convertMap(FlowInfo.class, list));
        return this;
    }

    private JsonAppVo createWfNode() {
        if (this.mapJsonObject.get(AppTableNames.WF_NODE.name()) == null) {
            return this;
        }
        List<Map<String, Object>> list = this.mapJsonObject.get(AppTableNames.WF_NODE.name());
        this.appList.addAll(this.convertMap(NodeInfo.class, list));
        return this;
    }

    private JsonAppVo createWfTransition() {
        if (this.mapJsonObject.get(AppTableNames.WF_TRANSITION.name()) == null) {
            return this;
        }
        List<Map<String, Object>> list = this.mapJsonObject.get(AppTableNames.WF_TRANSITION.name());
        this.appList.addAll(this.convertMap(FlowTransition.class, list));
        return this;
    }

    private JsonAppVo createTableRelation() {
        if (this.mapJsonObject.get(AppTableNames.F_TABLE_OPT_RELATION.name()) == null) {
            return this;
        }
        List<Map<String, Object>> list = this.mapJsonObject.get(AppTableNames.F_TABLE_OPT_RELATION.name());
        this.appList.addAll(this.convertMap(MetaOptRelation.class, list));
        return this;
    }

    private List<Object> convertMap(Class type, List<Map<String, Object>> list) {
        ArrayList<Object> object = new ArrayList<Object>();
        try {
            JavaBeanMetaData javaBeanMetaData = JavaBeanMetaData.createBeanMetaDataFromType((Class)type);
            for (Map<String, Object> map : list) {
                object.add(javaBeanMetaData.createBeanObjectFromMap(map));
            }
            return object;
        }
        catch (Exception e) {
            return object;
        }
    }

    public JSONObject getOldAppObject() {
        return this.oldAppObject;
    }

    public void setOldAppObject(JSONObject oldAppObject) {
        this.oldAppObject = oldAppObject;
    }

    public Map<String, List<Map<String, Object>>> getMapJsonObject() {
        return this.mapJsonObject;
    }

    public String getUserCode() {
        return this.userCode;
    }

    public List<Object> getAppList() {
        return this.appList;
    }

    public List<Object> getMetaObject() {
        return this.metaObject;
    }

    public List<String> getListDatabaseName() {
        return this.listDatabaseName;
    }
}

