/*
 * Decompiled with CFR 0.152.
 */
package com.centit.locode.platform.service.impl;

import com.centit.locode.platform.dao.ApplicationResourcesDao;
import com.centit.locode.platform.po.ApplicationResources;
import com.centit.locode.platform.service.ApplicationResourcesService;
import com.centit.product.metadata.service.SourceInfoManager;
import com.centit.support.database.utils.PageDesc;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class ApplicationResourcesServiceImpl
implements ApplicationResourcesService {
    @Autowired
    ApplicationResourcesDao applicationResourcesDao;
    @Autowired
    private SourceInfoManager sourceInfoManager;

    @Override
    public void createApplicationResources(ApplicationResources applicationResources) {
        this.applicationResourcesDao.saveNewObject(applicationResources);
    }

    @Override
    public void updateApplicationResources(ApplicationResources applicationRescourse) {
        this.applicationResourcesDao.updateObject(applicationRescourse);
    }

    @Override
    public void deleteApplicationResources(String id) {
        this.applicationResourcesDao.deleteObjectById(id);
    }

    @Override
    public List<ApplicationResources> listApplicationResources(Map<String, Object> params, PageDesc pageDesc) {
        return this.applicationResourcesDao.listObjectsByProperties(params, pageDesc);
    }

    @Override
    public ApplicationResources getApplicationResources(String id) {
        return (ApplicationResources)this.applicationResourcesDao.getObjectById(id);
    }

    @Override
    public void deleteAppResources(String osId, String dataBaseId) {
        if (osId == null) {
            return;
        }
        HashMap<String, String> filterMap = new HashMap<String, String>();
        filterMap.put("osId", osId);
        if (StringUtils.isNotBlank((CharSequence)dataBaseId)) {
            filterMap.put("dataBaseId", dataBaseId);
        }
        this.applicationResourcesDao.deleteObjectsByProperties(filterMap);
    }

    @Override
    public List<ApplicationResources> listObjectsByProperty(Map<String, Object> propertiesMap) {
        return this.applicationResourcesDao.listObjectsByProperties(propertiesMap);
    }

    @Override
    public void deleteSourceInfo(String dataBaseId) {
        HashMap<String, String> filterMap = new HashMap<String, String>();
        if (StringUtils.isNotBlank((CharSequence)dataBaseId)) {
            filterMap.put("dataBaseId", dataBaseId);
        }
        this.applicationResourcesDao.deleteObjectsByProperties(filterMap);
        this.sourceInfoManager.deleteObjectById(dataBaseId);
    }
}

