/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.centit.framework.core.dao.DictionaryMapUtils;
import com.centit.framework.system.dao.UserQueryFilterDao;
import com.centit.framework.system.po.UserQueryFilter;
import com.centit.framework.system.service.UserQueryFilterManager;
import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.database.utils.PageDesc;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UserQueryFilterManagerImpl
implements UserQueryFilterManager {
    public static final Logger logger = LoggerFactory.getLogger(UserQueryFilterManager.class);
    @Autowired
    private UserQueryFilterDao userQueryFilterDao;

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public JSONArray listUserQueryFiltersAsJson(String[] fields, Map<String, Object> filterMap, PageDesc pageDesc) {
        return DictionaryMapUtils.objectsToJSONArray(this.listObjects(filterMap, pageDesc), (String[])fields);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public List<UserQueryFilter> listUserQueryFilterByModle(String userCode, String modelCode) {
        return this.userQueryFilterDao.listUserQueryFilterByModle(userCode, modelCode);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public Long getNextFilterKey() {
        return this.userQueryFilterDao.getNextKey();
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public Long saveUserDefaultFilter(UserQueryFilter userQueryFilter) {
        UserQueryFilter dbFilter;
        if (StringBaseOpt.isNvl((String)userQueryFilter.getUserCode()) || StringBaseOpt.isNvl((String)userQueryFilter.getModleCode())) {
            return null;
        }
        List<UserQueryFilter> filters = this.userQueryFilterDao.listUserDefaultFilterByModle(userQueryFilter.getUserCode(), userQueryFilter.getModleCode());
        if (filters == null || filters.size() < 1) {
            userQueryFilter.setFilterNo(this.getNextFilterKey());
            userQueryFilter.setIsDefault("T");
            userQueryFilter.setCreateDate(DatetimeOpt.currentUtilDate());
            this.userQueryFilterDao.saveNewObject(userQueryFilter);
            return userQueryFilter.getFilterNo();
        }
        for (int i = 1; i < filters.size(); ++i) {
            dbFilter = filters.get(i);
            dbFilter.setIsDefault("F");
            this.userQueryFilterDao.mergeUserFilter(dbFilter);
        }
        dbFilter = filters.get(0);
        dbFilter.setFilterName(userQueryFilter.getFilterName());
        dbFilter.setFilterValue(userQueryFilter.getFilterValue());
        userQueryFilter.setCreateDate(DatetimeOpt.currentUtilDate());
        this.userQueryFilterDao.mergeUserFilter(dbFilter);
        return dbFilter.getFilterNo();
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public UserQueryFilter getUserDefaultFilter(String userCode, String modelCode) {
        if (StringBaseOpt.isNvl((String)userCode) || StringBaseOpt.isNvl((String)modelCode)) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userCode", userCode);
        map.put("modelCode", modelCode);
        List<UserQueryFilter> filters = this.userQueryFilterDao.listUserDefaultFilterByModle(userCode, modelCode);
        if (filters == null || filters.size() < 1) {
            return null;
        }
        return filters.get(0);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public UserQueryFilter getUserQueryFilter(Long filterNo) {
        return this.userQueryFilterDao.getObjectById(filterNo);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public boolean deleteUserQueryFilter(Long filterNo) {
        UserQueryFilter uqf = this.userQueryFilterDao.getObjectById(filterNo);
        if (uqf == null) {
            return false;
        }
        if ("T".equals(uqf.getIsDefault())) {
            return false;
        }
        this.userQueryFilterDao.deleteObject(uqf);
        return true;
    }

    @Override
    public void mergeObject(UserQueryFilter userQueryFilter) {
        this.userQueryFilterDao.mergeUserFilter(userQueryFilter);
    }

    @Override
    public void saveNewObject(UserQueryFilter userQueryFilter) {
        this.userQueryFilterDao.saveNewObject(userQueryFilter);
    }

    @Override
    public List<UserQueryFilter> listObjects(Map<String, Object> filterMap, PageDesc pageDesc) {
        return this.userQueryFilterDao.listObjects(filterMap, pageDesc);
    }
}

