/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.service.impl;

import com.centit.framework.components.CodeRepositoryCache;
import com.centit.framework.system.dao.UnitInfoDao;
import com.centit.framework.system.dao.UserUnitDao;
import com.centit.framework.system.po.UnitInfo;
import com.centit.framework.system.po.UserInfo;
import com.centit.framework.system.service.SysUnitManager;
import com.centit.framework.system.service.impl.PersistenceUtils;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.database.utils.PageDesc;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="sysUnitManager")
@Transactional
public class SysUnitManagerImpl
implements SysUnitManager {
    public static Logger logger = LoggerFactory.getLogger(SysUnitManagerImpl.class);
    @Autowired
    @NotNull
    private UserUnitDao userUnitDao;
    @Autowired
    @NotNull
    protected UnitInfoDao unitInfoDao;
    @Value(value="${framework.unitinfo.id.generator:}")
    protected String unitIdFormat;

    @Override
    public List<UnitInfo> listObjectsAsSort(Map<String, Object> searchColumn) {
        List listObjects = this.unitInfoDao.listObjects(searchColumn);
        block0: for (UnitInfo unitInfo : listObjects) {
            if (StringBaseOpt.isNvl((String)unitInfo.getParentUnit()) || "0".equals(unitInfo.getParentUnit())) continue;
            for (UnitInfo opt : listObjects) {
                if (!opt.getUnitCode().equals(unitInfo.getParentUnit())) continue;
                opt.getSubUnits().add(unitInfo);
                continue block0;
            }
        }
        ArrayList<UnitInfo> parentUnit = new ArrayList<UnitInfo>();
        for (UnitInfo unitInfo : listObjects) {
            if (!StringBaseOpt.isNvl((String)unitInfo.getParentUnit()) && !"0".equals(unitInfo.getParentUnit())) continue;
            parentUnit.add(unitInfo);
        }
        return parentUnit;
    }

    public UnitInfo getObject(UnitInfo object) {
        UnitInfo newObj = this.unitInfoDao.getObjectById(object.getUnitCode());
        if (newObj == null) {
            newObj = object;
            newObj.setUnitCode(this.unitInfoDao.getNextKey());
            newObj.setIsValid("T");
        }
        return newObj;
    }

    @Override
    @Transactional
    public List<UserInfo> getUnitUsers(String unitCode) {
        return this.unitInfoDao.listUnitUsers(unitCode);
    }

    @Override
    public UnitInfo getUnitByName(String name) {
        return this.unitInfoDao.getUnitByName(name);
    }

    @Override
    @Transactional
    public void changeStatus(String unitCode, String isValid) {
        List<UnitInfo> allSubUnits = this.listAllSubUnits(unitCode);
        for (UnitInfo subUnit : allSubUnits) {
            subUnit.setIsValid(isValid);
            this.unitInfoDao.updateUnit(subUnit);
        }
        CodeRepositoryCache.evictCache((String)"UnitInfo");
    }

    @Override
    @Transactional
    public void deleteUnitInfo(UnitInfo unitinfo) {
        String oldUnitPath = unitinfo.getUnitPath();
        List<UnitInfo> subUnits = this.unitInfoDao.listSubUnitsByUnitPaht(oldUnitPath);
        for (UnitInfo ui : subUnits) {
            ui.setParentUnit(unitinfo.getParentUnit());
            ui.setUnitPath(unitinfo.getUnitPath());
            this.unitInfoDao.updateUnit(ui);
        }
        this.unitInfoDao.deleteObjectById(unitinfo.getUnitCode());
        CodeRepositoryCache.evictCache((String)"UnitInfo");
    }

    @Override
    @Transactional
    public String saveNewUnitInfo(UnitInfo unitinfo) {
        UnitInfo parentUnit;
        if (StringUtils.isBlank((CharSequence)unitinfo.getUnitCode()) && !"default".equals(this.unitIdFormat)) {
            String unitCode = PersistenceUtils.makeIdByFormat(this.unitInfoDao.getNextKey(), this.unitIdFormat, "D", 8, "0");
            unitinfo.setUnitCode(unitCode);
        }
        if ((parentUnit = this.unitInfoDao.getObjectById(unitinfo.getParentUnit())) == null) {
            unitinfo.setUnitPath("/" + unitinfo.getUnitWord());
        } else {
            unitinfo.setUnitPath(parentUnit.getUnitPath() + "/" + unitinfo.getUnitWord());
        }
        this.unitInfoDao.saveNewObject(unitinfo);
        CodeRepositoryCache.evictCache((String)"UnitInfo");
        return unitinfo.getUnitCode();
    }

    @Override
    @Transactional
    public boolean hasSameName(UnitInfo unitInfo) {
        return this.unitInfoDao.isUniqueName(unitInfo.getUnitName(), unitInfo.getParentUnit(), unitInfo.getUnitCode());
    }

    @Override
    @Transactional
    public boolean isUniqueOrder(UnitInfo unitInfo) {
        Integer exists = this.unitInfoDao.isExistsUnitByParentAndOrder(unitInfo.getParentUnit(), unitInfo.getUnitOrder());
        return exists == null || exists < 1;
    }

    @Override
    @Transactional
    public void updateUnitInfo(UnitInfo unitinfo) {
        UnitInfo dbUnitInfo = this.unitInfoDao.getObjectById(unitinfo.getUnitCode());
        String oldUnitPath = dbUnitInfo.getUnitPath();
        if (!StringUtils.equals((CharSequence)dbUnitInfo.getParentUnit(), (CharSequence)unitinfo.getParentUnit())) {
            UnitInfo parentUnit = this.unitInfoDao.getObjectById(unitinfo.getParentUnit());
            if (parentUnit == null) {
                unitinfo.setUnitPath("/" + unitinfo.getUnitCode());
            } else {
                unitinfo.setUnitPath(parentUnit.getUnitPath() + "/" + unitinfo.getUnitCode());
            }
            List<UnitInfo> subUnits = this.unitInfoDao.listSubUnitsByUnitPaht(oldUnitPath);
            int noupl = oldUnitPath.length();
            for (UnitInfo ui : subUnits) {
                ui.setUnitPath(unitinfo.getUnitPath() + ui.getUnitPath().substring(noupl));
                this.unitInfoDao.updateUnit(ui);
            }
        }
        this.unitInfoDao.updateUnit(unitinfo);
        CodeRepositoryCache.evictCache((String)"UnitInfo");
    }

    @Override
    @Transactional
    public List<UnitInfo> listAllSubObjectsAsSort(String primaryUnit) {
        List<UnitInfo> listObjects = this.listAllSubUnits(primaryUnit);
        block0: for (UnitInfo unitInfo : listObjects) {
            if (StringBaseOpt.isNvl((String)unitInfo.getParentUnit()) || "0".equals(unitInfo.getParentUnit())) continue;
            for (UnitInfo opt : listObjects) {
                if (!opt.getUnitCode().equals(unitInfo.getParentUnit())) continue;
                opt.getSubUnits().add(unitInfo);
                continue block0;
            }
        }
        ArrayList<UnitInfo> parentUnit = new ArrayList<UnitInfo>();
        for (UnitInfo unitInfo : listObjects) {
            if (!StringBaseOpt.isNvl((String)unitInfo.getParentUnit()) && !primaryUnit.equals(unitInfo.getUnitCode())) continue;
            parentUnit.add(unitInfo);
        }
        return parentUnit;
    }

    @Override
    @Transactional
    public List<UnitInfo> listObjects(Map<String, Object> filterMap) {
        return this.unitInfoDao.listObjects(filterMap);
    }

    @Override
    @Transactional
    public List<UnitInfo> listObjects(Map<String, Object> filterMap, PageDesc pageDesc) {
        return this.unitInfoDao.listObjects(filterMap, pageDesc);
    }

    @Override
    @Transactional
    public UnitInfo getObjectById(String unitCode) {
        UnitInfo unitInfo = this.unitInfoDao.getObjectById(unitCode);
        return unitInfo;
    }

    @Override
    @Transactional
    public void checkState(List<UnitInfo> listObjects) {
        List<String> objs = this.unitInfoDao.getAllParentUnit();
        if (objs != null && objs.size() > 0) {
            for (UnitInfo u : listObjects) {
                if (objs.contains(u.getUnitCode())) {
                    u.setState("closed");
                    continue;
                }
                u.setState("open");
            }
        } else {
            for (UnitInfo u : listObjects) {
                u.setState("open");
            }
        }
    }

    @Override
    @Transactional
    public List<UnitInfo> listValidSubUnit(String unitCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("parentUnit", unitCode);
        map.put("isValid", "T");
        return this.unitInfoDao.listObjects(map);
    }

    @Override
    @Transactional(readOnly=true)
    public List<UnitInfo> listAllSubUnits(String unitCode) {
        UnitInfo unitInfo = this.unitInfoDao.getObjectById(unitCode);
        HashMap<String, String> filterMap = new HashMap<String, String>(4);
        filterMap.put("unitPath", unitInfo.getUnitPath());
        return this.unitInfoDao.listObjects(filterMap);
    }

    @Override
    @Transactional(readOnly=true)
    public List<UnitInfo> listValidSubUnits(String unitCode) {
        HashMap<String, String> filterMap = new HashMap<String, String>(4);
        UnitInfo unitInfo = this.unitInfoDao.getObjectById(unitCode);
        filterMap.put("unitPath", unitInfo.getUnitPath());
        filterMap.put("isValid", "T");
        return this.unitInfoDao.listObjects(filterMap);
    }

    @Override
    public boolean isDepNoUnique(String depNo, String unitCode) {
        HashMap<String, String> filterMap = new HashMap<String, String>(2);
        filterMap.put("depNo", depNo);
        List list = this.unitInfoDao.listObjects(filterMap);
        return list == null || list.size() == 0 || unitCode != null && unitCode.equals(((UnitInfo)list.get(0)).getUnitCode());
    }

    @Override
    public boolean isUnitWordUnique(String unitWord, String unitCode) {
        HashMap<String, String> filterMap = new HashMap<String, String>(2);
        filterMap.put("unitWord", unitWord);
        List list = this.unitInfoDao.listObjects(filterMap);
        return list == null || list.size() == 0 || unitCode != null && unitCode.equals(((UnitInfo)list.get(0)).getUnitCode());
    }
}

