/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.centit.framework.components.CodeRepositoryCache;
import com.centit.framework.jdbc.service.BaseEntityManagerImpl;
import com.centit.framework.system.dao.OsInfoDao;
import com.centit.framework.system.po.OsInfo;
import com.centit.framework.system.service.OsInfoManager;
import com.centit.support.database.utils.PageDesc;
import com.centit.support.network.HttpExecutor;
import com.centit.support.network.HttpExecutorContext;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.impl.client.CloseableHttpClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="osInfoManager")
@Transactional
public class OsInfoManagerImpl
extends BaseEntityManagerImpl<OsInfo, String, OsInfoDao>
implements OsInfoManager,
CodeRepositoryCache.EvictCacheExtOpt {
    private String refreshUrl = "/system/environment/reload/refreshall";
    private String refreshByNameUrl = "/system/environment/reload/refresh/%s";

    @Autowired
    @Qualifier(value="osInfoDao")
    public void setBaseDao(OsInfoDao baseDao) {
        this.baseDao = baseDao;
    }

    @Override
    public List<OsInfo> listObjects(Map<String, Object> map) {
        return ((OsInfoDao)this.baseDao).listObjects(map);
    }

    @Override
    public List<OsInfo> listObjects(Map<String, Object> map, PageDesc pageDesc) {
        return ((OsInfoDao)this.baseDao).listObjectsByProperties(map, pageDesc);
    }

    @Override
    public JSONArray listOsInfoAsJson(Map<String, Object> filterMap, PageDesc pageDesc) {
        return ((OsInfoDao)this.baseDao).listObjectsAsJson(filterMap, pageDesc);
    }

    @Override
    public boolean refreshSingle(OsInfo osInfo) {
        boolean flag = true;
        try (CloseableHttpClient httpClient = HttpExecutor.createHttpClient();){
            HttpExecutor.simpleGet((HttpExecutorContext)HttpExecutorContext.create((CloseableHttpClient)httpClient), (String)(osInfo.getOsUrl() + this.refreshUrl));
        }
        catch (IOException e) {
            e.printStackTrace();
            flag = false;
        }
        return flag;
    }

    @Override
    public boolean refreshAll() {
        List<OsInfo> osInfoList = this.listObjects(new HashMap<String, Object>());
        if (osInfoList != null && osInfoList.isEmpty()) {
            return true;
        }
        boolean flag = true;
        for (OsInfo osInfo : osInfoList) {
            try {
                CloseableHttpClient httpClient = HttpExecutor.createHttpClient();
                Throwable throwable = null;
                try {
                    HttpExecutor.simpleGet((HttpExecutorContext)HttpExecutorContext.create((CloseableHttpClient)httpClient), (String)(osInfo.getOsUrl() + this.refreshUrl));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (httpClient == null) continue;
                    if (throwable != null) {
                        try {
                            httpClient.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    httpClient.close();
                }
            }
            catch (IOException e) {
                this.logger.error(e.getLocalizedMessage());
                flag = false;
                break;
            }
        }
        return flag;
    }

    public void evictCache(String cacheName, String mapKey) {
        this.evictCache(cacheName);
    }

    public void evictCache(String cacheName) {
        List<OsInfo> osInfoList = this.listObjects(new HashMap<String, Object>());
        if (osInfoList != null && osInfoList.isEmpty()) {
            return;
        }
        for (OsInfo osInfo : osInfoList) {
            try {
                CloseableHttpClient httpClient = HttpExecutor.createHttpClient();
                Throwable throwable = null;
                try {
                    HttpExecutor.simpleGet((HttpExecutorContext)HttpExecutorContext.create((CloseableHttpClient)httpClient), (String)(osInfo.getOsUrl() + String.format(this.refreshByNameUrl, cacheName)));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (httpClient == null) continue;
                    if (throwable != null) {
                        try {
                            httpClient.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    httpClient.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void evictAllCache() {
        this.refreshAll();
    }
}

