/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.po;

import com.centit.framework.core.dao.DictionaryMap;
import com.centit.framework.model.basedata.IOptInfo;
import com.centit.framework.system.po.OptDataScope;
import com.centit.framework.system.po.OptMethod;
import com.centit.support.database.orm.GeneratorCondition;
import com.centit.support.database.orm.GeneratorType;
import com.centit.support.database.orm.ValueGenerator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.Range;
import org.springframework.util.CollectionUtils;

@Entity
@Table(name="F_OPTINFO")
@ApiModel(value="\u4e1a\u52a1\u83dc\u5355\u5bf9\u8c61", description="\u4e1a\u52a1\u83dc\u5355\u5bf9\u8c61 OptInfo")
public class OptInfo
implements IOptInfo,
Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @Column(name="OPT_ID")
    @ValueGenerator(strategy=GeneratorType.UUID)
    @ApiModelProperty(value="\u4e1a\u52a1\u83dc\u5355\u7f16\u53f7", name="optId", required=true)
    private String optId;
    @OrderBy
    @Column(name="PRE_OPT_ID")
    @Length(max=32, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    private @Length(max=32, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String preOptId;
    @Column(name="OPT_NAME")
    @Length(max=100, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    @ApiModelProperty(value="\u4e1a\u52a1\u83dc\u5355\u540d\u79f0\uff0c\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e100", name="optName", required=true)
    private @Length(max=100, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String optName;
    @Column(name="OPT_TYPE")
    @Length(max=1, message="\u5b57\u6bb5\u957f\u5ea6\u5fc5\u987b\u4e3a{max}")
    @ApiModelProperty(value="\u4e1a\u52a1\u7c7b\u522b S:\u5b9e\u65bd\u4e1a\u52a1, O:\u666e\u901a\u4e1a\u52a1, W:\u6d41\u7a0b\u4e1a\u52a1, I:\u9879\u76ee\u4e1a\u52a1", name="optType")
    @DictionaryMap(fieldName={"optTypeText"}, value={"OptType"})
    private @Length(max=1, message="\u5b57\u6bb5\u957f\u5ea6\u5fc5\u987b\u4e3a{max}") String optType;
    @Column(name="FORM_CODE")
    @Length(max=32, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    private @Length(max=32, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String formCode;
    @Column(name="OPT_ROUTE")
    @Length(max=256, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    private @Length(max=256, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String optRoute;
    @Column(name="OPT_URL")
    @Length(max=256, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    private @Length(max=256, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String optUrl;
    @Column(name="IS_IN_TOOLBAR")
    private String isInToolbar;
    @Column(name="IMG_INDEX")
    @Range(max=100000L, message="\u6570\u503c\u4e0d\u80fd\u5927\u4e8e{max}")
    private @Range(max=100000L, message="\u6570\u503c\u4e0d\u80fd\u5927\u4e8e{max}") Long imgIndex;
    @Column(name="TOP_OPT_ID")
    @Length(max=32, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    @ValueGenerator(strategy=GeneratorType.FUNCTION, value="optId")
    private @Length(max=32, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String topOptId;
    @Column(name="PAGE_TYPE")
    @Length(max=1, message="\u5b57\u6bb5\u957f\u5ea6\u5fc5\u987b\u4e3a{max}")
    @ApiModelProperty(value="\u9875\u9762\u6253\u5f00\u65b9\u5f0f D: DIV I\uff1a iFrame", name="pageType", required=true)
    private @Length(max=1, message="\u5b57\u6bb5\u957f\u5ea6\u5fc5\u987b\u4e3a{max}") String pageType;
    @OrderBy
    @Column(name="ORDER_IND")
    @Range(max=100000L, message="\u6570\u503c\u4e0d\u80fd\u5927\u4e8e{max}")
    private @Range(max=100000L, message="\u6570\u503c\u4e0d\u80fd\u5927\u4e8e{max}") Long orderInd;
    @Column(name="ICON")
    @Length(max=512, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    private @Length(max=512, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String icon;
    @Column(name="HEIGHT")
    @Range(max=100000L, message="\u6570\u503c\u4e0d\u80fd\u5927\u4e8e{max}")
    private @Range(max=100000L, message="\u6570\u503c\u4e0d\u80fd\u5927\u4e8e{max}") Long height;
    @Column(name="WIDTH")
    @Range(max=100000L, message="\u6570\u503c\u4e0d\u80fd\u5927\u4e8e{max}")
    private @Range(max=100000L, message="\u6570\u503c\u4e0d\u80fd\u5927\u4e8e{max}") Long width;
    @Column(name="CREATE_DATE", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    protected Date createDate;
    @Column(name="CREATOR")
    @Length(max=32, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    private @Length(max=32, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String creator;
    @Column(name="UPDATOR")
    @Length(max=32, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    private @Length(max=32, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String updator;
    @Column(name="UPDATE_DATE")
    @ValueGenerator(strategy=GeneratorType.FUNCTION, condition=GeneratorCondition.ALWAYS, value="today()")
    private Date updateDate;
    @Transient
    private List<OptInfo> children;
    @Transient
    private String state;
    @Transient
    private List<OptMethod> optMethods;
    @Transient
    private List<OptDataScope> dataScopes;

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public List<OptDataScope> getDataScopes() {
        if (null == this.dataScopes) {
            this.dataScopes = new ArrayList<OptDataScope>();
        }
        return this.dataScopes;
    }

    public void setDataScopes(List<OptDataScope> dataScopes) {
        this.dataScopes = dataScopes;
    }

    public OptInfo() {
    }

    public OptInfo(String optid, String optname) {
        this.optId = optid;
        this.optName = optname;
    }

    public String getOptId() {
        return this.optId;
    }

    public void setOptId(String optid) {
        this.optId = optid;
    }

    public String getPreOptId() {
        return this.preOptId;
    }

    public void setPreOptId(String preoptid) {
        this.preOptId = preoptid;
    }

    public String toString() {
        return this.optName;
    }

    public String getOptName() {
        return this.optName;
    }

    public void setOptName(String optname) {
        this.optName = optname;
    }

    public String getFormCode() {
        return this.formCode;
    }

    public void setFormCode(String formcode) {
        this.formCode = formcode;
    }

    public String getOptUrl() {
        if (this.optUrl == null) {
            return "...";
        }
        return this.optUrl;
    }

    public void setOptUrl(String opturl) {
        this.optUrl = opturl;
    }

    public String getIsInToolbar() {
        return this.isInToolbar;
    }

    public void setIsInToolbar(String isintoolbar) {
        this.isInToolbar = isintoolbar;
    }

    public Long getImgIndex() {
        return this.imgIndex;
    }

    public void setImgIndex(Long imgindex) {
        this.imgIndex = imgindex;
    }

    public String getTopOptId() {
        return this.topOptId;
    }

    public void setTopOptId(String topoptid) {
        this.topOptId = topoptid;
    }

    public String getOptType() {
        return this.optType;
    }

    public void setOptType(String opttype) {
        this.optType = opttype;
    }

    public Long getOrderInd() {
        return this.orderInd;
    }

    public void setOrderInd(Long orderind) {
        this.orderInd = orderind;
    }

    public String getOptRoute() {
        return this.optRoute;
    }

    public void setOptRoute(String optRoute) {
        this.optRoute = optRoute;
    }

    public String getPageType() {
        return this.pageType;
    }

    public void setPageType(String pageType) {
        this.pageType = pageType;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public void copy(OptInfo other) {
        this.preOptId = other.getPreOptId();
        this.optName = other.getOptName();
        this.formCode = other.getFormCode();
        this.optUrl = other.getOptUrl();
        this.isInToolbar = other.getIsInToolbar();
        this.imgIndex = other.getImgIndex();
        this.topOptId = other.getTopOptId();
        this.optType = other.getOptType();
        this.orderInd = other.getOrderInd();
        this.pageType = other.getPageType();
        this.icon = other.getIcon();
        this.height = other.getHeight();
        this.width = other.getWidth();
        this.optRoute = other.getOptRoute();
        this.creator = other.creator;
        this.updator = other.updator;
        this.updateDate = other.updateDate;
        this.state = other.getState();
        this.createDate = other.getCreateDate();
    }

    public List<OptInfo> getChildren() {
        return this.children;
    }

    public void addChild(OptInfo child) {
        if (this.children == null) {
            this.children = new ArrayList<OptInfo>();
        }
        this.children.add(child);
    }

    public void setChildren(List<OptInfo> children) {
        this.children = children;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public Long getHeight() {
        return this.height;
    }

    public void setHeight(Long height) {
        this.height = height;
    }

    public Long getWidth() {
        return this.width;
    }

    public void setWidth(Long width) {
        this.width = width;
    }

    public List<OptMethod> getOptMethods() {
        if (null == this.optMethods) {
            this.optMethods = new ArrayList<OptMethod>();
        }
        return this.optMethods;
    }

    public void setOptMethods(List<OptMethod> optDefs) {
        this.optMethods = optDefs;
    }

    public OptInfo(String optId) {
        this.optId = optId;
    }

    public void addOptMethod(OptMethod optDef) {
        this.getOptMethods().add(optDef);
    }

    public void addAllOptMethods(List<OptMethod> optDefs) {
        this.getOptMethods().clear();
        if (CollectionUtils.isEmpty(optDefs)) {
            return;
        }
        for (OptMethod optDef : optDefs) {
            optDef.setOptId(this.optId);
        }
        this.getOptMethods().addAll(optDefs);
    }

    public void addAllDataScopes(List<OptDataScope> dataScopeByOptID) {
        this.getDataScopes().clear();
        if (CollectionUtils.isEmpty(dataScopeByOptID)) {
            return;
        }
        for (OptDataScope dataScope : dataScopeByOptID) {
            dataScope.setOptId(this.optId);
        }
        this.getDataScopes().addAll(dataScopeByOptID);
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public String getUpdator() {
        return this.updator;
    }

    public void setUpdator(String updator) {
        this.updator = updator;
    }

    public Date getUpdateDate() {
        return this.updateDate;
    }

    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }
}

