/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.dao;

import com.centit.framework.jdbc.dao.BaseDaoImpl;
import com.centit.framework.jdbc.dao.DatabaseOptUtils;
import com.centit.framework.system.po.UserUnit;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.database.jsonmaptable.GeneralJsonObjectDao;
import com.centit.support.database.orm.OrmDaoUtils;
import com.centit.support.database.utils.PageDesc;
import com.centit.support.database.utils.QueryAndNamedParams;
import com.centit.support.database.utils.QueryUtils;
import java.io.Serializable;
import java.sql.Connection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository(value="userUnitDao")
public class UserUnitDao
extends BaseDaoImpl<UserUnit, String> {
    public Map<String, String> getFilterField() {
        HashMap<String, String> filterField = new HashMap<String, String>(20);
        filterField.put("unitCode", "EQUAL");
        filterField.put("userStation", "EQUAL");
        filterField.put("userRank", "EQUAL");
        filterField.put("userCode", "EQUAL");
        filterField.put("isPrimary", "EQUAL");
        filterField.put("unitName", "LIKE");
        filterField.put("(like)userName", "userCode in (select us.USER_CODE from f_userinfo us where us.USER_NAME like :userName)");
        filterField.put("isValid", "userCode in (select us.USER_CODE from f_userinfo us where us.IS_VALID = :isValid)");
        filterField.put("userCode_isValid", "userCode in (select us.USER_CODE from f_userinfo us where us.IS_VALID = :userCode_isValid)");
        filterField.put("ORDER BY", "userOrder asc");
        return filterField;
    }

    public List<UserUnit> listObjectsAll() {
        return this.listObjects();
    }

    public UserUnit getObjectById(String userUnitId) {
        return (UserUnit)super.getObjectById((Object)userUnitId);
    }

    public void updateUserUnit(UserUnit userUnit) {
        super.updateObject((Serializable)userUnit);
    }

    @Transactional
    public void deleteObjectById(String userUnitId) {
        super.deleteObjectById((Object)userUnitId);
    }

    @Transactional
    public void deleteObjectForceById(String id) {
        super.deleteObjectForceById((Object)id);
    }

    @Transactional
    public List<UserUnit> listUserUnitsByUserCode(String userId) {
        List ls = this.listObjectsByProperty("userCode", userId);
        return ls;
    }

    @Transactional
    public List<UserUnit> listObjectByUserUnit(String userCode, String unitCode) {
        List ls = this.listObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"userCode", userCode, "unitCode", unitCode}));
        return ls;
    }

    @Transactional
    public String getNextKey() {
        return "s" + StringBaseOpt.fillZeroForString((String)String.valueOf(DatabaseOptUtils.getSequenceNextValue((BaseDaoImpl)this, (String)"S_USER_UNIT_ID")), (int)9);
    }

    @Transactional
    public void deleteUserUnitByUser(String userCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userCode", userCode);
        super.deleteObjectsByProperties(map);
    }

    @Transactional
    public void deleteUserUnitByUnit(String unitCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("unitCode", unitCode);
        super.deleteObjectsByProperties(map);
    }

    @Transactional
    public UserUnit getPrimaryUnitByUserId(String userId) {
        List list = super.listObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"userCode", userId, "isPrimary", "T"}));
        if (list != null && list.size() > 0) {
            return (UserUnit)list.get(0);
        }
        return null;
    }

    @Transactional
    public List<UserUnit> listUnitUsersByUnitCode(String unitCode) {
        return this.listObjectsByProperty("unitCode", unitCode);
    }

    @Transactional
    public List<UserUnit> listUserUnitsByRoleAndUnit(String roleType, String roleCode, String unitCode) {
        List ls = null;
        if (unitCode != null && !"".equals(unitCode)) {
            if ("gw".equals(roleType)) {
                ls = this.listObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"unitCode", unitCode, "userStation", roleCode}));
            } else if ("xz".equals(roleType)) {
                ls = this.listObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"unitCode", unitCode, "userRank", roleCode}));
            }
        } else if ("gw".equals(roleType)) {
            ls = this.listObjectsByProperty("userStation", roleCode);
        } else if ("xz".equals(roleType)) {
            ls = this.listObjectsByProperty("userRank", roleCode);
        }
        return ls;
    }

    public List<UserUnit> querySubUserUnits(Map<String, Object> filterDescMap, PageDesc pageDesc) {
        String sql = "select count(*) FROM F_USERUNIT WHERE 1=1 [:(STARTWITH)unitPath | and UNIT_CODE IN (select UNIT_CODE from f_unitinfo where UNIT_PATH like :unitPath)][:(like)userName | and USER_CODE in (select USER_CODE from f_userinfo where USER_NAME like :userName or LOGIN_NAME like :userName)][:userCode | and USER_CODE = :userCode][:unitIsValid | and UNIT_CODE IN (select UNIT_CODE from f_unitinfo where IS_VALID = :unitIsValid)]";
        QueryAndNamedParams qap = QueryUtils.translateQuery((String)sql, filterDescMap);
        Integer rowCount = (Integer)this.jdbcTemplate.execute(conn -> OrmDaoUtils.fetchObjectsCount((Connection)conn, (String)qap.getQuery(), (Map)qap.getParams()));
        pageDesc.setTotalRows(rowCount);
        sql = "select USER_UNIT_ID, UNIT_CODE, USER_CODE, IS_PRIMARY, USER_STATION, USER_RANK, RANK_MEMO, USER_ORDER, UPDATE_DATE, CREATE_DATE, CREATOR, UPDATOR FROM F_USERUNIT WHERE 1=1 [:(STARTWITH)unitPath | and UNIT_CODE IN (select UNIT_CODE from f_unitinfo where UNIT_PATH like :unitPath)][:(like)userName | and USER_CODE in (select USER_CODE from f_userinfo where USER_NAME like :userName or LOGIN_NAME like :userName)][:userCode | and USER_CODE = :userCode][:unitIsValid | and UNIT_CODE IN (select UNIT_CODE from f_unitinfo where IS_VALID = :unitIsValid)]";
        String selfOrderBy = GeneralJsonObjectDao.fetchSelfOrderSql((String)sql, filterDescMap);
        if (StringUtils.isNotBlank((CharSequence)selfOrderBy)) {
            sql = QueryUtils.removeOrderBy((String)sql) + " order by " + selfOrderBy;
        }
        QueryAndNamedParams qap2 = QueryUtils.translateQuery((String)sql, filterDescMap);
        return (List)this.jdbcTemplate.execute(conn -> OrmDaoUtils.queryObjectsByNamedParamsSql((Connection)conn, (String)qap2.getQuery(), (Map)qap2.getParams(), (Class)this.getPoClass(), (int)pageDesc.getRowStart(), (int)pageDesc.getPageSize()));
    }
}

