/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.dao;

import com.centit.framework.jdbc.dao.BaseDaoImpl;
import com.centit.framework.jdbc.dao.DatabaseOptUtils;
import com.centit.framework.system.po.FVUserOptList;
import com.centit.framework.system.po.UserInfo;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.database.orm.OrmDaoUtils;
import com.centit.support.database.utils.PageDesc;
import java.io.Serializable;
import java.sql.Connection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository(value="userInfoDao")
public class UserInfoDao
extends BaseDaoImpl<UserInfo, String> {
    private static String f_v_userroles_sql = "select b.ROLE_CODE, b.ROLE_NAME, b.IS_VALID, 'D' as OBTAIN_TYPE, b.ROLE_TYPE, b.UNIT_CODE,b.ROLE_DESC, b.CREATE_DATE, b.UPDATE_DATE ,a.USER_CODE, null as INHERITED_FROM from F_USERROLE a join F_ROLEINFO b on (a.ROLE_CODE=b.ROLE_CODE) where a.OBTAIN_DATE <= :currentDateTime  and (a.SECEDE_DATE is null or a.SECEDE_DATE > :currentDateTime ) and b.IS_VALID='T' and b.ROLE_CODE = :roleCode union select b.ROLE_CODE, b.ROLE_NAME, b.IS_VALID, 'I' as OBTAIN_TYPE, b.ROLE_TYPE, b.UNIT_CODE, b.ROLE_DESC, b.CREATE_DATE, b.UPDATE_DATE ,c.USER_CODE, a.UNIT_CODE as INHERITED_FROM from F_UNITROLE a join F_ROLEINFO b on (a.ROLE_CODE = b.ROLE_CODE) JOIN F_USERUNIT c on( a.UNIT_CODE = c.UNIT_CODE) where a.OBTAIN_DATE <= :currentDateTime  and (a.SECEDE_DATE is null or a.SECEDE_DATE > :currentDateTime ) and b.IS_VALID='T' and a.ROLE_CODE = :roleCode ";

    public Map<String, String> getFilterField() {
        HashMap<String, String> filterField = new HashMap<String, String>();
        filterField.put("userCode", "LIKE");
        filterField.put("USERCODE_EQ", "EQUAL");
        filterField.put("userName", "LIKE");
        filterField.put("isValid", "EQUAL");
        filterField.put("LOGINNAME", "LIKE");
        filterField.put("USERSTATE", "EQUAL");
        filterField.put("USERORDER", "EQUAL");
        filterField.put("USERTAG", "EQUAL");
        filterField.put("USERWORD", "EQUAL");
        filterField.put("(like)likeUserOrLoginName", "(User_Name LIKE :likeUserOrLoginName OR LOGIN_NAME LIKE :likeUserOrLoginName)");
        filterField.put("byUnderUnit", "userCode in (select us.USER_CODE from f_userunit us where us.UNIT_CODE = :byUnderUnit ) ");
        filterField.put("roleCode", "[(isNotEmpty(roleCode))(roleCode, currentDateTime) | and USER_CODE in (select v.USER_CODE from ( " + f_v_userroles_sql + " ) v where v.ROLE_CODE = :roleCode) ]");
        filterField.put("queryByUnit", "userCode in (select us.USER_CODE from f_userunit us where us.UNIT_CODE = :queryByUnit ) ");
        filterField.put("queryByGW", "userCode in (select us.USER_CODE from f_userunit us where us.User_Station = :queryByGW )");
        filterField.put("queryByXZ", "userCode in (select us.USER_CODE from f_userunit us where us.USER_RANK = :queryByXZ )");
        filterField.put("queryByRole", "userCode in (select r.USER_CODE from f_userrole r join f_roleinfo i on r.ROLE_CODE = i.ROLE_CODE where r.ROLE_CODE = :queryByRole and i.IS_VALID = 'T')");
        filterField.put("unitCode", "userCode in (select us.USER_CODE from f_userunit us where us.UNIT_CODE in (select un.UNIT_CODE from f_unitinfo un where un.UNIT_CODE = :unitCode or un.PARENT_UNIT = :unitCode))");
        filterField.put("(STARTWITH)unitPath", "userCode in (select us.USER_CODE from f_userunit us where us.UNIT_CODE in (select un.UNIT_CODE from f_unitinfo un where un.UNIT_PATH like :unitPath))");
        return filterField;
    }

    @Transactional
    public List<UserInfo> listObjects(Map<String, Object> filterMap) {
        filterMap.put("currentDateTime", DatetimeOpt.currentSqlDate());
        return super.listObjects(filterMap);
    }

    @Transactional
    public String getNextKey() {
        return StringBaseOpt.objectToString((Object)DatabaseOptUtils.getSequenceNextValue((BaseDaoImpl)this, (String)"S_USERCODE"));
    }

    @Transactional
    public List<FVUserOptList> getAllOptMethodByUser(String userCode) {
        String sql = "select USER_CODE,OPT_CODE,OPT_NAME,OPT_ID,OPT_METHOD from F_V_USEROPTLIST where USER_CODE=?";
        return (List)this.getJdbcTemplate().execute(conn -> OrmDaoUtils.queryObjectsByParamsSql((Connection)conn, (String)sql, (Object[])new Object[]{userCode}, FVUserOptList.class));
    }

    @Transactional
    public List<UserInfo> listUnderUnit(Map<String, Object> filterMap) {
        return this.listObjects(filterMap);
    }

    @Transactional
    public List<UserInfo> listUnderUnit(Map<String, Object> filterMap, PageDesc pageDesc) {
        return this.listObjectsByProperties(filterMap, pageDesc);
    }

    @Transactional
    public UserInfo getUserByCode(String userCode) {
        return (UserInfo)super.getObjectById((Object)userCode);
    }

    @Transactional
    public UserInfo getUserByLoginName(String loginName) {
        return (UserInfo)super.getObjectByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"loginName", loginName}));
    }

    @Transactional
    public UserInfo getUserByRegEmail(String regEmail) {
        return (UserInfo)super.getObjectByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"regEmail", regEmail}));
    }

    @Transactional
    public UserInfo getUserByRegCellPhone(String regCellPhone) {
        return (UserInfo)super.getObjectByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"regCellPhone", regCellPhone}));
    }

    @Transactional
    public UserInfo getUserByTag(String userTag) {
        return (UserInfo)super.getObjectByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"userTag", userTag}));
    }

    @Transactional
    public UserInfo getUserByUserWord(String userWord) {
        return (UserInfo)super.getObjectByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"userWord", userWord}));
    }

    @Transactional
    public UserInfo getUserByIdCardNo(String idCardNo) {
        return (UserInfo)super.getObjectByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"idCardNo", idCardNo}));
    }

    @Transactional
    public void deleteObjectById(String userCode) {
        super.deleteObjectById((Object)userCode);
    }

    public List<UserInfo> listUsersByRoleCode(String roleCode) {
        return super.listObjects(CollectionsOpt.createHashMap((Object[])new Object[]{"roleCode", roleCode, "currentDateTime", DatetimeOpt.currentSqlDate()}));
    }

    public int isLoginNameExist(String userCode, String loginName) {
        String sql = "select count(*) as usersCount from F_USERINFO t where t.USERCODE <> ? and t.LOGINNAME = ?";
        return NumberBaseOpt.castObjectToInteger((Object)DatabaseOptUtils.getScalarObjectQuery((BaseDaoImpl)this, (String)sql, (Object[])new Object[]{userCode, loginName}));
    }

    public int isCellPhoneExist(String userCode, String cellPhone) {
        String sql = "select count(*) as usersCount from F_USERINFO t where t.USERCODE <> ? and t.REGCELLPHONE = ?";
        return NumberBaseOpt.castObjectToInteger((Object)DatabaseOptUtils.getScalarObjectQuery((BaseDaoImpl)this, (String)sql, (Object[])new Object[]{userCode, cellPhone}));
    }

    public int isEmailExist(String userCode, String email) {
        String sql = "select count(*) as usersCount from F_USERINFO t where t.USERCODE <> ? and t.REGEMAIL = ?";
        return NumberBaseOpt.castObjectToInteger((Object)DatabaseOptUtils.getScalarObjectQuery((BaseDaoImpl)this, (String)sql, (Object[])new Object[]{userCode, email}));
    }

    public int isAnyOneExist(String userCode, String loginName, String regPhone, String regEmail) {
        String sql = "select count(*) as usersCount from F_USERINFO t where t.USER_CODE != ? and (t.LOGIN_NAME = ? or t.REG_CELL_PHONE= ? or t.Reg_Email = ?)";
        return NumberBaseOpt.castObjectToInteger((Object)DatabaseOptUtils.getScalarObjectQuery((BaseDaoImpl)this, (String)sql, (Object[])new Object[]{userCode, loginName, regPhone, regEmail}));
    }

    @Transactional
    public void updateUser(UserInfo userInfo) {
        super.updateObject((Serializable)userInfo);
    }
}

