/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.dao;

import com.centit.framework.jdbc.dao.BaseDaoImpl;
import com.centit.framework.system.po.RolePower;
import com.centit.framework.system.po.RolePowerId;
import com.centit.support.algorithm.CollectionsOpt;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Repository(value="rolePowerDao")
public class RolePowerDao
extends BaseDaoImpl<RolePower, RolePowerId> {
    public Map<String, String> getFilterField() {
        HashMap<String, String> filterField = new HashMap<String, String>();
        filterField.put("optCode", "EQUAL");
        filterField.put("roleCode", "EQUAL");
        return filterField;
    }

    @Transactional(propagation=Propagation.MANDATORY)
    public List<RolePower> listObjectsAll() {
        return super.listObjects();
    }

    @Transactional
    public void deleteRolePowersByRoleCode(String roleCode) {
        super.deleteObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"roleCode", roleCode}));
    }

    @Transactional
    public void deleteRolePowersByOptCode(String optCode) {
        super.deleteObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"optCode", optCode}));
    }

    @Transactional
    public List<RolePower> listRolePowersByRoleCode(String rolecode) {
        return this.listObjectsByProperty("roleCode", rolecode);
    }

    @Transactional
    public void mergeBatchObject(List<RolePower> rolePowers) {
        for (int i = 0; i < rolePowers.size(); ++i) {
            super.mergeObject((Serializable)rolePowers.get(i));
        }
    }

    @Transactional
    public void updateRolePower(RolePower rolePower) {
        super.updateObject((Serializable)rolePower);
    }

    @Transactional
    public void saveNewRolePower(RolePower rolePower) {
        super.saveNewObject((Serializable)rolePower);
    }

    @Transactional
    public void deleteObjectById(RolePowerId id) {
        super.deleteObjectById((Object)id);
    }
}

