/*
 * Decompiled with CFR 0.152.
 */
package com.centit.sys.service.impl;

import com.centit.core.dao.BaseDao;
import com.centit.core.service.BaseEntityManagerImpl;
import com.centit.core.utils.PageDesc;
import com.centit.support.utils.DatetimeOpt;
import com.centit.support.utils.StringBaseOpt;
import com.centit.sys.dao.OptFlowNoInfoDao;
import com.centit.sys.dao.OptFlowNoPoolDao;
import com.centit.sys.po.FDatadictionary;
import com.centit.sys.po.FUnitinfo;
import com.centit.sys.po.OptFlowNoInfo;
import com.centit.sys.po.OptFlowNoInfoId;
import com.centit.sys.po.OptFlowNoPool;
import com.centit.sys.po.OptFlowNoPoolId;
import com.centit.sys.service.CodeRepositoryUtil;
import com.centit.sys.service.OptFlowNoInfoManager;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptFlowNoInfoManagerImpl
extends BaseEntityManagerImpl<OptFlowNoInfo>
implements OptFlowNoInfoManager {
    private static final long serialVersionUID = 1L;
    public static final Log log = LogFactory.getLog(OptFlowNoInfoManager.class);
    private OptFlowNoInfoDao optFlowNoInfoDao;
    private OptFlowNoPoolDao optFlowNoPoolDao;

    public void setOptFlowNoInfoDao(OptFlowNoInfoDao baseDao) {
        this.optFlowNoInfoDao = baseDao;
        this.setBaseDao((BaseDao)this.optFlowNoInfoDao);
    }

    public void setOptFlowNoPoolDao(OptFlowNoPoolDao baseDao) {
        this.optFlowNoPoolDao = baseDao;
    }

    @Override
    public synchronized long newNextLsh(String ownerCode, String codeCode, Date codeBaseDate) {
        Date codeDate = codeBaseDate;
        OptFlowNoInfoId noId = new OptFlowNoInfoId(ownerCode, codeDate, codeCode);
        OptFlowNoInfo noInfo = (OptFlowNoInfo)this.optFlowNoInfoDao.getObjectById(noId);
        long nextCode = 1L;
        if (noInfo == null) {
            noInfo = new OptFlowNoInfo(noId, 1L, DatetimeOpt.currentUtilDate());
        } else {
            OptFlowNoPoolId poolId;
            OptFlowNoPool poolNo;
            nextCode = noInfo.getCurNo() + 1L;
            while ((poolNo = (OptFlowNoPool)this.optFlowNoPoolDao.getObjectById(poolId = new OptFlowNoPoolId(ownerCode, codeDate, codeCode, nextCode))) != null) {
                ++nextCode;
            }
            noInfo.setCurNo(nextCode);
            noInfo.setLastCodeDate(DatetimeOpt.currentUtilDate());
            noInfo.setCuryear(String.valueOf(DatetimeOpt.getYear((Date)DatetimeOpt.currentUtilDate())));
        }
        this.optFlowNoInfoDao.saveObject(noInfo);
        return nextCode;
    }

    @Override
    public long newNextLshBaseDay(String ownerCode, String codeCode, Date codeBaseDate) {
        return this.newNextLsh(ownerCode, codeCode, DatetimeOpt.truncateToDay((Date)codeBaseDate));
    }

    @Override
    public long newNextLshBaseMonth(String ownerCode, String codeCode, Date codeBaseDate) {
        return this.newNextLsh(ownerCode, codeCode, DatetimeOpt.truncateToMonth((Date)codeBaseDate));
    }

    @Override
    public long newNextLshBaseYear(String ownerCode, String codeCode, Date codeBaseDate) {
        return this.newNextLsh(ownerCode, codeCode, DatetimeOpt.truncateToYear((Date)codeBaseDate));
    }

    @Override
    public long newNextLsh(String codeCode) {
        return this.newNextLsh("noowner", codeCode, DefaultCodeDate);
    }

    @Override
    public long newNextLsh(String ownerCode, String codeCode) {
        return this.newNextLsh(ownerCode, codeCode, DefaultCodeDate);
    }

    @Override
    public long viewNextLsh(String ownerCode, String codeCode, Date codeBaseDate) {
        Date codeDate = codeBaseDate;
        OptFlowNoInfoId noId = new OptFlowNoInfoId(ownerCode, codeDate, codeCode);
        OptFlowNoInfo noInfo = (OptFlowNoInfo)this.optFlowNoInfoDao.getObjectById(noId);
        long nextCode = 1L;
        if (noInfo != null) {
            nextCode = noInfo.getCurNo() + 1L;
        }
        return nextCode;
    }

    @Override
    public long viewNextLshBaseDay(String ownerCode, String codeCode, Date codeBaseDate) {
        return this.viewNextLsh(ownerCode, codeCode, DatetimeOpt.truncateToDay((Date)codeBaseDate));
    }

    @Override
    public long viewNextLshBaseMonth(String ownerCode, String codeCode, Date codeBaseDate) {
        return this.viewNextLsh(ownerCode, codeCode, DatetimeOpt.truncateToMonth((Date)codeBaseDate));
    }

    @Override
    public long viewNextLshBaseYear(String ownerCode, String codeCode, Date codeBaseDate) {
        return this.viewNextLsh(ownerCode, codeCode, DatetimeOpt.truncateToYear((Date)codeBaseDate));
    }

    @Override
    public long viewNextLsh(String codeCode) {
        return this.viewNextLsh("noowner", codeCode, DefaultCodeDate);
    }

    @Override
    public long viewNextLsh(String ownerCode, String codeCode) {
        return this.viewNextLsh(ownerCode, codeCode, DefaultCodeDate);
    }

    @Override
    public synchronized void recordNextLsh(String ownerCode, String codeCode, Date codeBaseDate, long currCode) {
        Date codeDate = codeBaseDate;
        OptFlowNoPoolId poolId = new OptFlowNoPoolId(ownerCode, codeDate, codeCode, currCode);
        OptFlowNoPool poolNo = (OptFlowNoPool)this.optFlowNoPoolDao.getObjectById(poolId);
        if (poolNo != null) {
            this.optFlowNoPoolDao.deleteObject(poolNo);
            return;
        }
        OptFlowNoInfoId noId = new OptFlowNoInfoId(ownerCode, codeDate, codeCode);
        OptFlowNoInfo noInfo = (OptFlowNoInfo)this.optFlowNoInfoDao.getObjectById(noId);
        if (noInfo == null) {
            noInfo = new OptFlowNoInfo(noId, currCode, DatetimeOpt.currentUtilDate());
            this.optFlowNoInfoDao.saveObject(noInfo);
        } else if (noInfo.getCurNo() < currCode) {
            noInfo.setCurNo(currCode);
            noInfo.setLastCodeDate(DatetimeOpt.currentUtilDate());
            this.optFlowNoInfoDao.saveObject(noInfo);
        }
    }

    @Override
    public void recordNextLshBaseDay(String ownerCode, String codeCode, Date codeBaseDate, long currCode) {
        this.recordNextLsh(ownerCode, codeCode, DatetimeOpt.truncateToDay((Date)codeBaseDate), currCode);
    }

    @Override
    public void recordNextLshBaseMonth(String ownerCode, String codeCode, Date codeBaseDate, long currCode) {
        this.recordNextLsh(ownerCode, codeCode, DatetimeOpt.truncateToMonth((Date)codeBaseDate), currCode);
    }

    @Override
    public void recordNextLshBaseYear(String ownerCode, String codeCode, Date codeBaseDate, long currCode) {
        this.recordNextLsh(ownerCode, codeCode, DatetimeOpt.truncateToYear((Date)codeBaseDate), currCode);
    }

    @Override
    public void recordNextLsh(String codeCode, long currCode) {
        this.recordNextLsh("noowner", codeCode, DefaultCodeDate, currCode);
    }

    @Override
    public void recordNextLsh(String ownerCode, String codeCode, long currCode) {
        this.recordNextLsh(ownerCode, codeCode, DefaultCodeDate, currCode);
    }

    @Override
    public synchronized long assignNextLsh(String ownerCode, String codeCode, Date codeBaseDate) {
        long minPoolNo = this.optFlowNoPoolDao.fetchFirstLsh(ownerCode, codeCode, codeBaseDate);
        if (minPoolNo > 0L) {
            OptFlowNoPoolId obj = new OptFlowNoPoolId();
            obj.setOwnerCode(ownerCode);
            obj.setCodeDate(codeBaseDate);
            obj.setCodeCode(codeCode);
            obj.setCurNo(minPoolNo);
            this.optFlowNoPoolDao.deleteObjectById(obj);
            return minPoolNo;
        }
        return this.newNextLsh(ownerCode, codeCode, codeBaseDate);
    }

    @Override
    public long assignNextLshBaseDay(String ownerCode, String codeCode, Date codeBaseDate) {
        return this.assignNextLsh(ownerCode, codeCode, DatetimeOpt.truncateToDay((Date)codeBaseDate));
    }

    @Override
    public long assignNextLshBaseMonth(String ownerCode, String codeCode, Date codeBaseDate) {
        return this.assignNextLsh(ownerCode, codeCode, DatetimeOpt.truncateToMonth((Date)codeBaseDate));
    }

    @Override
    public long assignNextLshBaseYear(String ownerCode, String codeCode, Date codeBaseDate) {
        return this.assignNextLsh(ownerCode, codeCode, DatetimeOpt.truncateToYear((Date)codeBaseDate));
    }

    @Override
    public long assignNextLsh(String ownerCode, String codeCode) {
        return this.assignNextLsh(ownerCode, codeCode, DefaultCodeDate);
    }

    @Override
    public long assignNextLsh(String codeCode) {
        return this.assignNextLsh("noowner", codeCode, DefaultCodeDate);
    }

    @Override
    public void releaseLsh(String ownerCode, String codeCode, Date codeBaseDate, long currCode) {
        OptFlowNoPool obj = new OptFlowNoPool();
        obj.setOwnerCode(ownerCode);
        obj.setCodeDate(codeBaseDate);
        obj.setCodeCode(codeCode);
        obj.setCurNo(currCode);
        obj.setCreateDate(DatetimeOpt.currentUtilDate());
        this.optFlowNoPoolDao.saveObject(obj);
    }

    @Override
    public void releaseLshBaseDay(String ownerCode, String codeCode, Date codeBaseDate, long currCode) {
        this.releaseLsh(ownerCode, codeCode, DatetimeOpt.truncateToDay((Date)codeBaseDate), currCode);
    }

    @Override
    public void releaseLshBaseMonth(String ownerCode, String codeCode, Date codeBaseDate, long currCode) {
        this.releaseLsh(ownerCode, codeCode, DatetimeOpt.truncateToMonth((Date)codeBaseDate), currCode);
    }

    @Override
    public void releaseLshBaseYear(String ownerCode, String codeCode, Date codeBaseDate, long currCode) {
        this.releaseLsh(ownerCode, codeCode, DatetimeOpt.truncateToYear((Date)codeBaseDate), currCode);
    }

    @Override
    public void releaseLsh(String ownerCode, String codeCode, long currCode) {
        this.releaseLsh(ownerCode, codeCode, DefaultCodeDate, currCode);
    }

    @Override
    public void releaseLsh(String codeCode, long currCode) {
        this.releaseLsh("noowner", codeCode, DefaultCodeDate, currCode);
    }

    @Override
    public List<OptFlowNoPool> listLshInPool(String ownerCode, String codeCode, Date codeBaseDate, PageDesc pageDesc) {
        HashMap<String, Object> filterMap = new HashMap<String, Object>();
        filterMap.put("ownerCode", ownerCode);
        filterMap.put("codeDate", codeBaseDate);
        filterMap.put("codeCode", codeCode);
        return this.optFlowNoPoolDao.listObjects(filterMap, pageDesc);
    }

    @Override
    public List<OptFlowNoPool> listLshBaseDayInPool(String ownerCode, String codeCode, Date codeBaseDate, PageDesc pageDesc) {
        return this.listLshInPool(ownerCode, codeCode, DatetimeOpt.truncateToDay((Date)codeBaseDate), pageDesc);
    }

    @Override
    public List<OptFlowNoPool> listLshBaseMonthInPool(String ownerCode, String codeCode, Date codeBaseDate, PageDesc pageDesc) {
        return this.listLshInPool(ownerCode, codeCode, DatetimeOpt.truncateToMonth((Date)codeBaseDate), pageDesc);
    }

    @Override
    public List<OptFlowNoPool> listLshBaseYearInPool(String ownerCode, String codeCode, Date codeBaseDate, PageDesc pageDesc) {
        return this.listLshInPool(ownerCode, codeCode, DatetimeOpt.truncateToYear((Date)codeBaseDate), pageDesc);
    }

    @Override
    public List<OptFlowNoPool> listLshInPool(String ownerCode, String codeCode, PageDesc pageDesc) {
        return this.listLshInPool(ownerCode, codeCode, DefaultCodeDate, pageDesc);
    }

    @Override
    public List<OptFlowNoPool> listLshInPool(String codeCode, PageDesc pageDesc) {
        return this.listLshInPool("noowner", codeCode, DefaultCodeDate, pageDesc);
    }

    @Override
    public String genLsH(String zdx, String zdxVal, Date codeDate, String standard) {
        return this.genLsH(CodeRepositoryUtil.getDataPiece(zdx, zdxVal).getDatadesc(), codeDate, standard);
    }

    @Override
    public String genLsH(String codeCode, Date codeDate, String standard) {
        codeDate = null == codeDate ? DatetimeOpt.currentUtilDate() : codeDate;
        long lsh = 1L;
        lsh = "day".equalsIgnoreCase(standard) ? this.viewNextLshBaseDay("xtzwhgz", codeCode, codeDate) : ("month".equalsIgnoreCase(standard) ? this.viewNextLshBaseMonth("xtzwhgz", codeCode, codeDate) : this.viewNextLshBaseYear("xtzwhgz", codeCode, codeDate));
        return String.valueOf(lsh);
    }

    @Override
    public String genRecordLsH(String zdx, String zdxVal, Date codeDate, String standard) {
        return this.genRecordLsH(CodeRepositoryUtil.getDataPiece(zdx, zdxVal).getDatadesc(), codeDate, standard);
    }

    @Override
    public String genRecordLsH(String codeCode, Date codeDate, String standard) {
        codeDate = null == codeDate ? DatetimeOpt.currentUtilDate() : codeDate;
        long lsh = 1L;
        lsh = "day".equalsIgnoreCase(standard) ? this.newNextLshBaseDay("xtzwhgz", codeCode, codeDate) : ("month".equalsIgnoreCase(standard) ? this.newNextLshBaseMonth("xtzwhgz", codeCode, codeDate) : this.newNextLshBaseYear("xtzwhgz", codeCode, codeDate));
        return String.valueOf(lsh);
    }

    @Override
    public String genFWH(String zdx, String zdxVal, Date codeDate, String orgCode, String lsh) {
        FDatadictionary data = CodeRepositoryUtil.getDataPiece(zdx, zdxVal);
        return this.genFWH(data.getDatadesc(), codeDate, orgCode, lsh);
    }

    @Override
    public String genRecordFWH(String zdx, String zdxVal, Date codeDate, String orgCode) {
        FDatadictionary data = CodeRepositoryUtil.getDataPiece(zdx, zdxVal);
        return this.genFWH(data.getDatadesc(), codeDate, orgCode, "recordLsh");
    }

    @Override
    public String genRecordFWH(String codeCode, Date codeDate, String orgCode) {
        return this.genFWH(codeCode, codeDate, orgCode, "recordLsh");
    }

    @Override
    public String genFWH(String codeCode, Date codeDate, String orgCode, String lsh) {
        FDatadictionary zwhgzData = CodeRepositoryUtil.getDataPiece("ZWHGZ", codeCode);
        int lshLen = 0;
        try {
            lshLen = StringUtils.isBlank((String)zwhgzData.getExtracode()) ? 0 : Integer.valueOf(zwhgzData.getExtracode());
        }
        catch (Exception e) {
            log.info((Object)"ZWHGZ\u4e2d\u6587\u53f7\u9ed8\u8ba4\u957f\u5ea6\u4e3a\u4e0d\u53ef\u89e3\u6790\u7684\u6570\u5b57\uff01");
            log.error((Object)e);
        }
        Date date = codeDate = null == codeDate ? DatetimeOpt.currentUtilDate() : codeDate;
        if ("recordLsh".equals(lsh)) {
            lsh = this.genRecordLsH(codeCode, codeDate, "year");
        } else if (StringUtils.isBlank((String)lsh)) {
            lsh = this.genLsH(codeCode, codeDate, "year");
        }
        String sLsh = String.valueOf(lsh);
        if (sLsh.length() < lshLen) {
            sLsh = StringBaseOpt.fillZeroForString((String)sLsh, (int)lshLen);
        }
        FUnitinfo unit = CodeRepositoryUtil.getUnitInfoByCode(orgCode);
        String sfwh = zwhgzData.getDatavalue().replaceAll("%nh%", String.valueOf(DatetimeOpt.getYear((Date)codeDate))).replaceAll("%zt%", StringUtils.isBlank((String)unit.getPrefix()) ? " " : unit.getPrefix()).replaceAll("%H%", "\u51fd").replaceAll("%ls%", StringUtils.isBlank((String)sLsh) ? "" : sLsh);
        return sfwh;
    }
}

