/*
 * Decompiled with CFR 0.152.
 */
package com.centit.sys.service;

import com.centit.support.utils.StringRegularOpt;
import com.centit.sys.po.FUnitinfo;
import com.centit.sys.po.FUserunit;
import com.centit.sys.service.CodeRepositoryManager;
import com.centit.sys.service.CodeRepositoryUtil;
import com.centit.sys.service.ExpCalcContext;
import com.centit.sys.service.SysUnitFilterEngine;
import com.centit.sys.service.SysVariableTranslate;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SysUserFilterEngine
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(SysUserFilterEngine.class);

    public static Set<String> getUsersByRoleAndUnit(String roleType, String roleCode, String unitCode) {
        FUserunit uu;
        Iterator it;
        LinkedList<FUserunit> lsUserunit = new LinkedList<FUserunit>();
        if (unitCode != null && !"".equals(unitCode)) {
            FUnitinfo unit = CodeRepositoryUtil.getUnitInfoByCode(unitCode);
            if (unit != null) {
                lsUserunit.addAll(unit.getSubUserUnits());
            }
        } else {
            lsUserunit.addAll(CodeRepositoryManager.USERUNIT);
        }
        if ("gw".equals(roleType)) {
            it = lsUserunit.iterator();
            while (it.hasNext()) {
                uu = (FUserunit)it.next();
                if (roleCode.equals(uu.getUserstation())) continue;
                it.remove();
            }
        } else if ("xz".equals(roleType)) {
            it = lsUserunit.iterator();
            while (it.hasNext()) {
                uu = (FUserunit)it.next();
                if (roleCode.equals(uu.getUserrank())) continue;
                it.remove();
            }
        } else {
            lsUserunit.clear();
        }
        HashSet<String> users = new HashSet<String>();
        for (FUserunit uu2 : lsUserunit) {
            users.add(uu2.getUsercode());
        }
        return users;
    }

    private static Set<String> getUsersByFilter(RoleFilterGene rf) {
        FUserunit uu3;
        Iterator it;
        boolean hasFilter;
        boolean bl = hasFilter = rf.isHasGWFilter() || rf.isHasRankFilter() || rf.isHasUnitFilter() || rf.isHasUserFilter() || rf.isHasXZFilter();
        if (!hasFilter) {
            return new HashSet<String>();
        }
        if (rf.isHasUserFilter()) {
            return rf.getUsers();
        }
        LinkedList<FUserunit> lsUserunit = new LinkedList<FUserunit>();
        if (rf.isHasUnitFilter()) {
            for (String unitCode : rf.getUnits()) {
                FUnitinfo unit = CodeRepositoryUtil.getUnitInfoByCode(unitCode);
                if (unit == null) continue;
                lsUserunit.addAll(unit.getSubUserUnits());
            }
        } else {
            lsUserunit.addAll(CodeRepositoryManager.USERUNIT);
        }
        if (rf.isHasGWFilter()) {
            it = lsUserunit.iterator();
            while (it.hasNext()) {
                uu3 = (FUserunit)it.next();
                if (rf.getGwRoles().contains(uu3.getUserstation())) continue;
                it.remove();
            }
        }
        if (rf.isHasXZFilter()) {
            it = lsUserunit.iterator();
            while (it.hasNext()) {
                uu3 = (FUserunit)it.next();
                if (rf.getXzRoles().contains(uu3.getUserrank())) continue;
                it.remove();
            }
        }
        if (rf.isHasRankFilter()) {
            if (rf.isRankAllSub() || rf.isRankAllTop()) {
                it = lsUserunit.iterator();
                while (it.hasNext()) {
                    uu3 = (FUserunit)it.next();
                    if (rf.matchRank(uu3.getXzRank())) continue;
                    it.remove();
                }
            } else {
                Integer nR;
                HashMap<String, Integer> unitRank = new HashMap<String, Integer>();
                for (FUserunit uu2 : lsUserunit) {
                    if (!rf.matchRank(uu2.getXzRank())) continue;
                    nR = (Integer)unitRank.get(uu2.getUnitcode());
                    if (nR == null) {
                        unitRank.put(uu2.getUnitcode(), uu2.getXzRank());
                        continue;
                    }
                    if (rf.isRankPlus() && nR > uu2.getXzRank()) {
                        unitRank.put(uu2.getUnitcode(), uu2.getXzRank());
                        continue;
                    }
                    if (!rf.isRankMinus() || nR >= uu2.getXzRank()) continue;
                    unitRank.put(uu2.getUnitcode(), uu2.getXzRank());
                }
                Iterator it2 = lsUserunit.iterator();
                while (it2.hasNext()) {
                    FUserunit uu2;
                    uu2 = (FUserunit)it2.next();
                    nR = (Integer)unitRank.get(uu2.getUnitcode());
                    if (nR != null && nR.intValue() == uu2.getXzRank()) continue;
                    it2.remove();
                }
            }
        }
        rf.getUsers().clear();
        for (FUserunit uu3 : lsUserunit) {
            rf.addUser(uu3.getUsercode());
        }
        return rf.getUsers();
    }

    private static boolean calcUnits(ExpCalcContext ecc, RoleFilterGene gene) {
        String w = ecc.getAWord();
        if (!"(".equals(w)) {
            ecc.setLastErrMsg(w + " is unexpected, expect '(' ; calcRoleUnits begin .");
            return false;
        }
        Set<String> units = SysUnitFilterEngine.calcUnitsExp(ecc);
        if (units == null) {
            return false;
        }
        gene.addUnits(units);
        w = ecc.getAWord();
        return ")".equals(w);
    }

    private static boolean calcUsers(ExpCalcContext ecc, RoleFilterGene gene) {
        String w = ecc.getAWord();
        if (!"(".equals(w)) {
            ecc.setLastErrMsg(w + " is unexpected, expect '(' ; calcRoleUsers begin .");
            return false;
        }
        do {
            if ((w = ecc.getAWord()) == null || "".equals(w)) {
                return false;
            }
            if (")".equals(w)) {
                return true;
            }
            if (ExpCalcContext.isLabel((String)w)) {
                Set<String> users = ecc.getUserCode(w);
                if (users != null) {
                    gene.addUsers(users);
                }
            } else {
                String userCode = StringRegularOpt.trimString((String)w);
                if (CodeRepositoryUtil.getUserInfoByCode(userCode) != null) {
                    gene.addUser(userCode);
                }
            }
            w = ecc.getAWord();
            if (!")".equals(w)) continue;
            return true;
        } while (",".equals(w));
        ecc.setLastErrMsg(w + " is unexpected, expect ')' or ',' ; calcRoleUsers end .");
        return false;
    }

    private static boolean calcGwRoles(ExpCalcContext ecc, RoleFilterGene gene) {
        String w = ecc.getAWord();
        if (!"(".equals(w)) {
            ecc.setLastErrMsg(w + " is unexpected, expect '(' ; calcGwRoles begin .");
            return false;
        }
        do {
            if ((w = ecc.getAWord()) == null || "".equals(w)) {
                ecc.setLastErrMsg(w + " is unexpected, expect ')' ; calcGwRoles end .");
                return false;
            }
            if (")".equals(w)) {
                return true;
            }
            if (ExpCalcContext.isLabel((String)w)) {
                gene.addGwRole(w);
            } else if (StringRegularOpt.isString((String)w)) {
                String roleCode = StringRegularOpt.trimString((String)w);
                gene.addGwRole(roleCode);
            } else {
                ecc.setLastErrMsg(w + " is unexpected, expect label or string [rolecode]; calcGwRoles label . ");
                return false;
            }
            w = ecc.getAWord();
            if (!")".equals(w)) continue;
            return true;
        } while (",".equals(w));
        ecc.setLastErrMsg(w + " is unexpected, expect ')' or ','  ; calcGwRoles , .");
        return false;
    }

    private static boolean calcXzRoles(ExpCalcContext ecc, RoleFilterGene gene) {
        String w = ecc.getAWord();
        if (!"(".equals(w)) {
            ecc.setLastErrMsg(w + " is unexpected, expect '(' ; calcXzRoles begin . ");
            return false;
        }
        do {
            if ((w = ecc.getAWord()) == null || "".equals(w)) {
                ecc.setLastErrMsg(w + " is unexpected, expect ')'  ; calcXzRoles end .");
                return false;
            }
            if (")".equals(w)) {
                return true;
            }
            if (ExpCalcContext.isLabel((String)w)) {
                gene.addXzRole(w);
            } else if (StringRegularOpt.isString((String)w)) {
                String roleCode = StringRegularOpt.trimString((String)w);
                gene.addXzRole(roleCode);
            } else {
                ecc.setLastErrMsg(w + " is unexpected, expect label or string [rolecode]; calcXzRoles label . ");
                return false;
            }
            w = ecc.getAWord();
            if (!")".equals(w)) continue;
            return true;
        } while (",".equals(w));
        ecc.setLastErrMsg(w + " is unexpected, expect ')' or ',' ; calcXzRoles , .");
        return false;
    }

    private static boolean calcXzRank(ExpCalcContext ecc, RoleFilterGene gene) {
        String w = ecc.getAWord();
        if (!"(".equals(w)) {
            ecc.setLastErrMsg(w + " is unexpected, expect '(' ; calcXzRank begin . ");
            return false;
        }
        w = ecc.getAWord();
        if (w == null || "".equals(w)) {
            ecc.setLastErrMsg("endoffile is unexpected, expect ')' ; calcXzRank empty . ");
            return false;
        }
        if (")".equals(w)) {
            return true;
        }
        int rank = 0;
        if (ExpCalcContext.isLabel((String)w)) {
            rank = ecc.getRank(w);
        } else if (StringRegularOpt.isNumber((String)w)) {
            rank = Integer.valueOf(w);
        } else {
            ecc.setLastErrMsg(w + " is unexpected, expect label or number [rolerank]; calcXzRank label . ");
            return false;
        }
        w = ecc.getAWord();
        if ("+".equals(w)) {
            w = ecc.getAWord();
            gene.setRankPlus();
            if (!StringRegularOpt.isNumber((String)w)) {
                if (!")".equals(w)) {
                    ecc.setLastErrMsg(w + " is unexpected, expect number or ')' ; calcXzRank +  .");
                    return false;
                }
                ecc.setPreword(w);
            } else {
                rank += Integer.valueOf(w).intValue();
                w = ecc.getAWord();
            }
        } else if ("-".equals(w)) {
            w = ecc.getAWord();
            gene.setRankMinus();
            if (!StringRegularOpt.isNumber((String)w)) {
                if (!")".equals(w)) {
                    ecc.setLastErrMsg(w + " is unexpected, expect number or ')' ; calcXzRank -  .");
                    return false;
                }
                ecc.setPreword(w);
            } else {
                rank -= Integer.valueOf(w).intValue();
                w = ecc.getAWord();
            }
        } else if ("++".equals(w)) {
            gene.setRankAllSub();
        } else if ("--".equals(w)) {
            gene.setRankAllTop();
        }
        if (rank >= 0) {
            gene.setXzRank(rank);
        }
        if (")".equals(w)) {
            return true;
        }
        ecc.setLastErrMsg(w + " is unexpected, expect ')' ; calcXzRank end  .");
        return false;
    }

    private static Set<String> calcSimpleExp(ExpCalcContext ecc) {
        RoleFilterGene gene = new RoleFilterGene();
        String w = ecc.getAWord();
        while (w != null && !"".equals(w)) {
            if (",".equals(w) || ")".equals(w) || "!".equals(w) || "|".equals(w) || "||".equals(w) || "&".equals(w) || "&&".equals(w)) {
                ecc.setPreword(w);
                break;
            }
            if ("D".equalsIgnoreCase(w)) {
                if (!SysUserFilterEngine.calcUnits(ecc, gene)) {
                    return null;
                }
            } else if ("GW".equalsIgnoreCase(w)) {
                if (!SysUserFilterEngine.calcGwRoles(ecc, gene)) {
                    return null;
                }
            } else if ("XZ".equalsIgnoreCase(w)) {
                if (!SysUserFilterEngine.calcXzRoles(ecc, gene)) {
                    return null;
                }
            } else if ("R".equalsIgnoreCase(w)) {
                if (!SysUserFilterEngine.calcXzRank(ecc, gene)) {
                    return null;
                }
            } else if ("U".equalsIgnoreCase(w)) {
                if (!SysUserFilterEngine.calcUsers(ecc, gene)) {
                    return null;
                }
            } else {
                ecc.setLastErrMsg(w + " is unexpected, expect 'D','GW','XZ','R' or 'U' ; calcSimpleRole ");
                return null;
            }
            w = ecc.getAWord();
        }
        return SysUserFilterEngine.getUsersByFilter(gene);
    }

    private static Set<String> calcSingleExp(ExpCalcContext ecc) {
        String w = ecc.getAWord();
        if (!"(".equals(w)) {
            return null;
        }
        Set<String> users = SysUserFilterEngine.calcRolesExp(ecc);
        if (users == null) {
            return null;
        }
        while (users.size() == 0) {
            w = ecc.getAWord();
            if (")".equals(w)) {
                return users;
            }
            if (",".equals(w)) {
                users = SysUserFilterEngine.calcRolesExp(ecc);
                continue;
            }
            ecc.setLastErrMsg(w + " is unexpected, expect ',' or ')' ; calcSingleRoleExp");
            return null;
        }
        ecc.seekToRightBracket();
        return users;
    }

    private static Set<String> calcItemExp(ExpCalcContext ecc) {
        String w = ecc.getAWord();
        if (w == null || "".equals(w)) {
            ecc.setLastErrMsg("End of file is unexpected; calcItemRole begin ");
            return null;
        }
        if ("(".equals(w)) {
            Set<String> users = SysUserFilterEngine.calcRolesExp(ecc);
            w = ecc.getAWord();
            if (")".equals(w)) {
                return users;
            }
            ecc.setLastErrMsg(w + " is unexpected, expect ')' ; calcItemRole .");
            return null;
        }
        if ("S".equalsIgnoreCase(w)) {
            return SysUserFilterEngine.calcSingleExp(ecc);
        }
        ecc.setPreword(w);
        return SysUserFilterEngine.calcSimpleExp(ecc);
    }

    private static Set<String> calcRolesExp(ExpCalcContext ecc) {
        String w;
        Set<String> users = SysUserFilterEngine.calcItemExp(ecc);
        if (users == null) {
            return null;
        }
        while (true) {
            Set<String> users2;
            if ((w = ecc.getAWord()) == null || "".equals(w)) {
                return users;
            }
            if (",".equals(w) || ")".equals(w)) {
                ecc.setPreword(w);
                return users;
            }
            if ("|".equals(w) || "||".equals(w)) {
                users2 = SysUserFilterEngine.calcItemExp(ecc);
                if (users2 == null) {
                    return null;
                }
                users.addAll(users2);
                continue;
            }
            if ("&".equals(w) || "&&".equals(w)) {
                users2 = SysUserFilterEngine.calcItemExp(ecc);
                if (users2 == null) {
                    return null;
                }
                users.retainAll(users2);
                continue;
            }
            if (!"!".equals(w)) break;
            users2 = SysUserFilterEngine.calcItemExp(ecc);
            if (users2 == null) {
                return null;
            }
            users.removeAll(users2);
        }
        ecc.setLastErrMsg(w + " is unexpected, expect '||','&&','!',',' or ')' ; calcRoles .");
        return null;
    }

    public static Set<String> calcOptsByRoleExp(String roleExp, String lastSameNodeUnit, String userUnit, String previousNodeUnit, String nodeUnit, String flowUnit, String creatorCode, String userCode, SysVariableTranslate varTrans) {
        Set<String> sUsers;
        if (roleExp == null) {
            return null;
        }
        ExpCalcContext ecc = new ExpCalcContext();
        ecc.setFormula(roleExp);
        ecc.setVarTrans(varTrans);
        ecc.addUnitParam("L", lastSameNodeUnit);
        ecc.addUnitParam("U", userUnit);
        ecc.addUnitParam("P", previousNodeUnit);
        ecc.addUnitParam("N", nodeUnit);
        ecc.addUnitParam("F", flowUnit);
        ecc.addUserParam("C", creatorCode);
        ecc.addUserParam("O", userCode);
        Integer rank = CodeRepositoryUtil.getUserUnitXzRank(creatorCode, flowUnit);
        if (rank != null) {
            ecc.addRankParam("C", rank);
        }
        if ((rank = CodeRepositoryUtil.getUserUnitXzRank(userCode, userUnit)) != null) {
            ecc.addRankParam("O", rank);
        }
        if ((sUsers = SysUserFilterEngine.calcRolesExp(ecc)) == null || ecc.hasError()) {
            log.error((Object)ecc.getLastErrMsg());
        }
        return sUsers;
    }

    public static Set<String> calcOperators(String roleExp, String lastSameNodeUnit, String userUnit, String previousNodeUnit, String nodeUnit, String flowUnit, String creatorCode, String userCode, SysVariableTranslate varTrans) {
        return SysUserFilterEngine.calcOptsByRoleExp(roleExp, lastSameNodeUnit, userUnit, previousNodeUnit, nodeUnit, flowUnit, creatorCode, userCode, varTrans);
    }

    public static Set<String> calcOperators(String roleExp, String userUnit, String nodeUnit, String flowUnit, String creatorCode, String userCode, SysVariableTranslate varTrans) {
        return SysUserFilterEngine.calcOptsByRoleExp(roleExp, null, userUnit, null, nodeUnit, flowUnit, creatorCode, userCode, varTrans);
    }

    public static Set<String> calcOperators(String roleExp, String userUnit, String userCode, SysVariableTranslate varTrans) {
        return SysUserFilterEngine.calcOptsByRoleExp(roleExp, null, userUnit, null, null, null, null, userCode, varTrans);
    }

    public static Set<String> calcOperators(String roleExp, String nodeUnit, String flowUnit, String creatorCode, SysVariableTranslate varTrans) {
        return SysUserFilterEngine.calcOptsByRoleExp(roleExp, null, null, null, nodeUnit, flowUnit, creatorCode, null, varTrans);
    }

    public static String validateRolesExp(String rolesExp) {
        ExpCalcContext ecc = new ExpCalcContext();
        ecc.setFormula(rolesExp);
        SysUserFilterEngine.calcRolesExp(ecc);
        if (ecc.hasError()) {
            return ecc.getLastErrMsg();
        }
        return "T";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RoleFilterGene {
        private boolean hasUnitFilter = false;
        private boolean hasUserFilter = false;
        private boolean hasGWFilter = false;
        private boolean hasXZFilter = false;
        private boolean hasRankFilter = false;
        private Set<String> units = new HashSet<String>();
        private Set<String> users = new HashSet<String>();
        private Set<String> xzRoles = new HashSet<String>();
        private Set<String> gwRoles = new HashSet<String>();
        private int xzRank = 0;
        private boolean rankPlus = false;
        private boolean rankMinus = false;
        private boolean rankAllTop = false;
        private boolean rankAllSub = false;

        public Set<String> getUnits() {
            return this.units;
        }

        public Set<String> getUsers() {
            return this.users;
        }

        public Set<String> getXzRoles() {
            return this.xzRoles;
        }

        public Set<String> getGwRoles() {
            return this.gwRoles;
        }

        public void setXzRank(int r) {
            this.xzRank = r;
            this.hasRankFilter = true;
        }

        public boolean isHasUnitFilter() {
            return this.hasUnitFilter;
        }

        public boolean isHasUserFilter() {
            return this.hasUserFilter;
        }

        public boolean isHasGWFilter() {
            return this.hasGWFilter;
        }

        public boolean isHasXZFilter() {
            return this.hasXZFilter;
        }

        public boolean isHasRankFilter() {
            return this.hasRankFilter;
        }

        public boolean isRankMinus() {
            return this.rankMinus;
        }

        public void setRankMinus() {
            this.rankMinus = true;
            this.rankPlus = false;
        }

        public boolean isRankPlus() {
            return this.rankPlus;
        }

        public void setRankPlus() {
            this.rankPlus = true;
            this.rankMinus = false;
        }

        public boolean isRankAllTop() {
            return this.rankAllTop;
        }

        public void setRankAllTop() {
            this.rankAllTop = true;
            this.rankAllSub = false;
            --this.xzRank;
            this.setRankMinus();
        }

        public boolean isRankAllSub() {
            return this.rankAllSub;
        }

        public void setRankAllSub() {
            this.rankAllTop = false;
            this.rankAllSub = true;
            ++this.xzRank;
            this.setRankPlus();
        }

        public void addUnits(Set<String> sucs) {
            if (sucs != null && sucs.size() > 0) {
                this.units.addAll(sucs);
                this.hasUnitFilter = true;
            }
        }

        public void addUser(String suc) {
            this.users.add(suc);
            this.hasUserFilter = true;
        }

        public void addUsers(Set<String> sucs) {
            if (sucs != null && sucs.size() > 0) {
                this.users.addAll(sucs);
                this.hasUserFilter = true;
            }
        }

        public void addXzRole(String rc) {
            this.xzRoles.add(rc);
            this.hasXZFilter = true;
        }

        public void addGwRole(String rc) {
            this.gwRoles.add(rc);
            this.hasGWFilter = true;
        }

        public boolean matchRank(int nR) {
            return this.rankPlus ? nR >= this.xzRank : (this.rankMinus ? nR <= this.xzRank : nR == this.xzRank);
        }
    }
}

