package com.centit.sys.security;

import java.io.IOException;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

import org.springframework.security.access.SecurityMetadataSource;
import org.springframework.security.access.intercept.AbstractSecurityInterceptor;
import org.springframework.security.access.intercept.InterceptorStatusToken;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.access.intercept.FilterInvocationSecurityMetadataSource;

public class DaoFilterSecurityInterceptor extends AbstractSecurityInterceptor
        implements Filter {

    private FilterInvocationSecurityMetadataSource securityMetadataSource;

    // ~ Methods
    // ========================================================================================================

    /**
      * Method that is actually called by the filter chain. Simply delegates to
      * the {@link #invoke(FilterInvocation)} method.
      * 
      * @param request
      *             the servlet request
      * @param response
      *             the servlet response
      * @param chain
      *             the filter chain
      * 
      * @throws IOException
      *              if the filter chain fails
      * @throws ServletException
      *              if the filter chain fails
     */
    public void doFilter(ServletRequest request, ServletResponse response,
             FilterChain chain) throws IOException, ServletException {
         FilterInvocation fi = new FilterInvocation(request, response, chain);
         invoke(fi);
     }

    public FilterInvocationSecurityMetadataSource getSecurityMetadataSource() {
        return this.securityMetadataSource;
     }

    public Class<? extends Object> getSecureObjectClass() {
        return FilterInvocation.class;
     }

    public void invoke(FilterInvocation fi) throws IOException,
             ServletException {
         InterceptorStatusToken token = super.beforeInvocation(fi);
        try {
             fi.getChain().doFilter(fi.getRequest(), fi.getResponse());
         } finally {
            super.afterInvocation(token, null);
         }
     }

    public SecurityMetadataSource obtainSecurityMetadataSource() {
        return this.securityMetadataSource;
     }

    public void setSecurityMetadataSource(
             FilterInvocationSecurityMetadataSource newSource) {
        this.securityMetadataSource = newSource;
     }

	public void destroy() {
		// TODO Auto-generated method stub
		
	}

	public void init(FilterConfig arg0) throws ServletException {
		// TODO Auto-generated method stub
		
	}

}

