package com.centit.sys.action;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import net.sf.json.JSONObject;

import org.apache.commons.lang.StringUtils;
import org.extremecomponents.table.limit.Limit;

import com.centit.core.action.BaseAction;
import com.centit.core.utils.ExtremeTableUtils;
import com.centit.core.utils.PageDesc;
//import com.centit.dispatchdoc.po.CommonDocTask;
//import com.centit.dispatchdoc.po.IncomeDocTask;
//import com.centit.dispatchdoc.service.IODocTasksManager;
import com.centit.sys.po.FOptinfo;
import com.centit.sys.po.FUserinfo;
import com.centit.sys.po.Usersetting;
import com.centit.sys.security.FUserDetail;
import com.centit.sys.service.FunctionManager;
import com.centit.sys.service.SysUserManager;
import com.opensymphony.xwork2.ActionContext;


public class MainFrameAction extends BaseAction {
	private static final long serialVersionUID = 1L;
	private FunctionManager functionMgr;
	private String userFirstPage;
	private SysUserManager sysUserManager;
	private String superFunctionId;
//	private IODocTasksManager ioDocTasksManager;
//    public void setIoDocTasksManager(IODocTasksManager ioDocTasksManager) {
//        this.ioDocTasksManager = ioDocTasksManager;
//    }

    private String casHome;
    
    
    public String getCasHome() {
        return casHome;
    }

    public void setCasHome(String casHome) {
        this.casHome = casHome;
    }
	
	public void setSysUserManager(SysUserManager sysUserManager) {
        this.sysUserManager = sysUserManager;
    }
	//private String superFunctionId;
    public String getUserFirstPage() {
		return userFirstPage;
	}

	public void setUserFirstPage(String userFirstPage) {
		this.userFirstPage = userFirstPage;
	}

	public void setFunctionMgr(FunctionManager functionMgr) {
		this.functionMgr = functionMgr;
	}

    public String showMain() throws Exception {
       
        FUserDetail uinfo = ((FUserDetail)getLoginUser());
	    /*if (uinfo == null)
            return "login";
		if("noname".equals(uinfo.getUsercode())){
		    return loginError();
		}*/
    	Usersetting us = uinfo.getUserSetting();

		try {
			if(StringUtils.isEmpty(us.getMainpage()) ) {
				FOptinfo f = (FOptinfo) functionMgr.getFunctionsByUser(uinfo ).get(0);
				us.setMainpage(f.getOpturl());
			}
		} catch (Exception e) {
		}
    	
    	Map<String, Object> session = ActionContext.getContext().getSession();
        String stylePath = request.getContextPath()+"/styles/"+us.getPagestyle();
        session.put("STYLE_PATH", stylePath);
        userFirstPage =  '/'+us.getMainpage();
        request.setAttribute("firstPage", userFirstPage);
        session.put("LAYOUT", us.getFramelayout());
        // 当前用户所能获取菜单
        ActionContext.getContext().put("OA_MENUS",
                this.getFunctionsByUserCode(((FUserinfo) super.getLoginUser()).getUsercode()));
        
  
        /**
         * 公文待办数
         */
        Map<String, Object> filterMap = new HashMap();
        filterMap.put("userCode", uinfo.getUsercode());        
//        List<CommonDocTask> commonDocList = ioDocTasksManager.listCommonDocTask(filterMap);
//        if (commonDocList != null && commonDocList.size() > 0) {
//            int outWayNum = 0;
//            for (int i = 0; i < commonDocList.size(); i++) {
//                
//                CommonDocTask t =  commonDocList.get(i);
//                if (t.getTimeLimit() != null && t.getTimeLimit() <= 240 && t.getTimeLimit() > 0)
//                    outWayNum++;
//            }
//            request.setAttribute("gwOutWayNum", outWayNum);
//            String dbnumber = String.valueOf(commonDocList.size());
//            request.setAttribute("gwDbnumber", dbnumber);
//        } else {
            request.setAttribute("gwDbnumber", "0");
//        }
        
        /**
         * 办件待办数
         */
        Map<String, Object> bjMap = new HashMap();
        bjMap.put("userCode", uinfo.getUsercode());
        
        //bjMap.put("flowCode", "000490");

//        List<IncomeDocTask> incomeDocList = ioDocTasksManager.listIncomeDocTask(bjMap);
//        if (incomeDocList != null && incomeDocList.size() > 0) {
//            int outWayNum = 0;
//            for (int i = 0; i < incomeDocList.size(); i++) {
//                IncomeDocTask t = incomeDocList.get(i);
//                if (t.getTimeLimit() != null && t.getTimeLimit() <= 240 && t.getTimeLimit() > 0)
//                    outWayNum++;
//            }
//            request.setAttribute("bjOutWayNum", outWayNum);
//            String dbnumber = String.valueOf(incomeDocList.size());
//            request.setAttribute("bjDbnumber", dbnumber);
//        } else {
            request.setAttribute("bjDbnumber", "0");
//        }
        return "MainPage";        
	}
    /**
     * 通过Ajax请求获取当前菜单下所有子菜单
     * 
     * @param superFunctionId
     * @return
     */
    public String getSuperFunc() {
        String superFunctionId = this.request.getParameter("superFunctionId");
        if (!org.springframework.util.StringUtils.hasText(superFunctionId)) {
            return getMenuFunc(new ArrayList<FOptinfo>());
        }

        FUserinfo user = new FUserinfo();
        user.setUsercode(((FUserinfo) this.getLoginUser()).getUsercode());
        List<FOptinfo> menuFunsByUser = this.functionMgr.getMenuFuncByUserIDAndSuperFunctionId(user, superFunctionId);

        return getMenuFunc(menuFunsByUser);
    }

    private String getFunctionsByUserCode(String usercode) {
        FUserinfo user = new FUserinfo();
        
        List<FOptinfo> menuFunsByUser=null;
        if(StringUtils.isBlank(superFunctionId)){
          user.setUsercode(((FUserinfo) this.getLoginUser()).getUsercode());
          menuFunsByUser = this.functionMgr.getMenuFuncByUser(user);  
        }else{
            user.setUsercode(usercode);
            menuFunsByUser=this.functionMgr.getMenuFuncByUserIDAndSuperFunctionId(user, superFunctionId);
        }     
        return getMenuFunc(menuFunsByUser);
    }

    private static String getMenuFunc(List<FOptinfo> menuFunsByUser) {
        Map<String, List<Map<String, String>>> result = new HashMap<String, List<Map<String, String>>>();

        //List<Map<String, String>> menuHeader = new ArrayList<Map<String, String>>();
        List<Map<String, String>> menuList = new ArrayList<Map<String, String>>();


        for (FOptinfo fOptinfo : menuFunsByUser) {
            Map<String, String> menu = new HashMap<String, String>();
            /*if ("0".equals(fOptinfo.getPreoptid())) {
                // {"HID":"a","HText":"菜单一"}
                menu.put("HID", fOptinfo.getOptid());
                menu.put("HText", fOptinfo.getOptname());

	            //设置是否为默认显示菜单
                if("1".equals(CodeRepositoryUtil.getValue("DEFAULT_MENU", fOptinfo.getOptid()))) {
                    menu.put("DefaultMenu", "1");
                }else{
                    menu.put("DefaultMenu", "0");
                }

                menuHeader.add(menu);
            } else {
                // {"MID":"aa","MText":"一级子菜单1","ParentID":"a","MUrl":"","MType":"A"}
                menu.put("MID", fOptinfo.getOptid());
                menu.put("MText", fOptinfo.getOptname());
                menu.put("ParentID", fOptinfo.getPreoptid());
                menu.put("MUrl", fOptinfo.getOpturl());
                menu.put("MType", fOptinfo.getPageType());

                menuList.add(menu);
            }*/
            
            menu.put("MID", fOptinfo.getOptid());
            menu.put("MText", fOptinfo.getOptname());
            menu.put("ParentID", fOptinfo.getPreoptid());
            menu.put("MUrl", fOptinfo.getOpturl());
            menu.put("MType", fOptinfo.getPageType());

            menuList.add(menu);

        }
        //result.put("menuHeader", menuHeader);
        result.put("menuList", menuList);

        return JSONObject.fromObject(result).toString();
    }
    public String login(){  
        Map<String, Object> session = ActionContext.getContext().getSession();
        if(request.getParameter("inDialog")!=null){
            session.put("loginInDialog", "true");
            return "loginInDialog";
        }else{
            session.put("loginInDialog", "false");
            return "login";
        }
    }
    public String fgLogin(){  
        String loginName = request.getParameter("loginName");
        FUserDetail uinfo = null;
        try {
         uinfo = sysUserManager.loadUserByUsername(loginName);
        } catch (Exception e) {
            return "login";
        }
        Usersetting us = uinfo.getUserSetting();

        try {
            if(StringUtils.isEmpty(us.getMainpage()) ){
                FOptinfo f = (FOptinfo) functionMgr.getFunctionsByUser(uinfo ).get(0);
                us.setMainpage(f.getOpturl());
            }
        } catch (Exception e) {
        }
        
        Map<String, Object> session = ActionContext.getContext().getSession();
        String stylePath = request.getContextPath()+"/styles/"+us.getPagestyle();
        session.put("STYLE_PATH", stylePath);
        userFirstPage =  '/'+us.getMainpage();
        request.setAttribute("firstPage", userFirstPage);
        session.put("LAYOUT", us.getFramelayout());
        // 当前用户所能获取菜单
        ActionContext.getContext().put("OA_MENUS",
                this.getFunctionsByUserCode(((FUserinfo) super.getLoginUser()).getUsercode()));
        request.getSession().setAttribute("USERDETAIL", uinfo);
        return "MainPage";
    }
    
    public String loginError(){  
        Map<String, Object> session = ActionContext.getContext().getSession();
        String inDialog = (String)session.get("loginInDialog");
        if(inDialog!=null || "true".equals(inDialog)){
            saveError("用户名或密码错误！");
            return "loginResInDialog";
        }else{
            return "loginError"; 
        }
    }
    
    
    public String loginSuccess() throws Exception{ 
        
        Map<String, Object> session = ActionContext.getContext().getSession();
        String inDialog = (String)session.get("loginInDialog");
        if(inDialog!=null)
            session.remove("loginInDialog");
        if(inDialog!=null && "true".equals(inDialog)){
            saveMessage("登录成功");
            return "loginResInDialog";
        }else{
            return "loginSuccess"; 
        }
        
        /*模块分别登录功能
        Map<String, Object> session = ActionContext.getContext().getSession();
        String inDialog = (String)session.get("loginInDialog");
        //处理子系统S
        superFunctionId=(String) session.get("sysType");
        if(inDialog!=null)
            session.remove("loginInDialog");
        if(inDialog!=null && "true".equals(inDialog)){
            saveMessage("登录成功");
            return "loginResInDialog";
        }else{
            //return "loginSuccess";             
            return this.showMain();
        }
        */
    }
    

	public String logincas() throws Exception {
		return "lgoinSuccess";
	}
		
    public String dashboard() throws Exception {
        
        return "dashboard";
    }

    public String getSuperFunctionId() {
        return superFunctionId;
    }

    public void setSuperFunctionId(String superFunctionId) {
        this.superFunctionId = superFunctionId;
    }

}